/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.algorithm;

import gov.sandia.cognition.algorithm.ParallelAlgorithm;
import gov.sandia.cognition.algorithm.ParallelUtil;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AbstractParallelAlgorithm
extends AbstractCloneableSerializable
implements ParallelAlgorithm {
    private transient ThreadPoolExecutor threadPool;

    public AbstractParallelAlgorithm() {
        this(null);
    }

    public AbstractParallelAlgorithm(ThreadPoolExecutor threadPool) {
        this.setThreadPool(threadPool);
    }

    @Override
    public AbstractParallelAlgorithm clone() {
        AbstractParallelAlgorithm clone = (AbstractParallelAlgorithm)super.clone();
        if (this.getThreadPool() != null) {
            clone.setThreadPool(ParallelUtil.createThreadPool(this.getNumThreads()));
        }
        return clone;
    }

    @Override
    public int getNumThreads() {
        return ParallelUtil.getNumThreads(this);
    }

    @Override
    public ThreadPoolExecutor getThreadPool() {
        if (this.threadPool == null) {
            this.setThreadPool(ParallelUtil.createThreadPool());
        }
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }
}

