/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=true, comments={"Should this class be merged with CSVUtility?", "To a large extend, this class seems like a generalization of CSV.", "Please review."}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2008-02-18", moreChangesNeeded=false, comments={"No, its different enough that it could exist on its own."})})
public class ReaderTokenizer {
    private BufferedReader bufferedReader;
    private boolean valid;
    private int lastTokenNum;

    public ReaderTokenizer(Reader reader) {
        if (reader != null) {
            this.setBufferedReader(new BufferedReader(reader));
            this.setValid(true);
        } else {
            this.setBufferedReader(null);
            this.setValid(false);
        }
        this.setLastTokenNum(0);
    }

    public boolean isValid() {
        return this.valid;
    }

    public static ArrayList<String> tokenizeString(String data) {
        return ReaderTokenizer.tokenizeString(data, 1);
    }

    public static ArrayList<String> tokenizeString(String data, int expectedTokenNum) {
        ArrayList<String> tokens = new ArrayList<String>(expectedTokenNum);
        StringTokenizer parser = new StringTokenizer(data);
        while (parser.hasMoreElements()) {
            tokens.add(parser.nextToken());
        }
        return tokens;
    }

    public ArrayList<String> readNextLine() throws IOException {
        ArrayList<String> tokens;
        String nextLine = this.bufferedReader.readLine();
        if (nextLine == null) {
            this.setValid(false);
            tokens = null;
        } else {
            tokens = ReaderTokenizer.tokenizeString(nextLine, this.getLastTokenNum());
            this.setLastTokenNum(tokens.size());
        }
        return tokens;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    protected int getLastTokenNum() {
        return this.lastTokenNum;
    }

    protected void setLastTokenNum(int lastTokenNum) {
        this.lastTokenNum = lastTokenNum;
    }

    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }
}

