/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io;

import com.thoughtworks.xstream.XStream;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.annotation.SoftwareLicenseType;
import gov.sandia.cognition.annotation.SoftwareReference;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-12-02", changesNeeded=false, comments={"Minor cosmetic changes.", "Otherwise, this wrapper class is fine."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"Changed the read() method to close the stream it creates after reading.", "Minor formatting change, and fixed a few typos.", "Added PublicationReference for the Object Streams Tutorial.", "Otherwise, looks fine."})})
@PublicationReference(author={"XStream Documentation"}, title="Object Streams Tutorial", type=PublicationType.WebPage, year=2008, url="http://xstream.codehaus.org/objectstream.html")
@SoftwareReference(name="XStream", version="1.2.1", url="http://xstream.codehaus.org/", license=SoftwareLicenseType.BSD, licenseURL="http://xstream.codehaus.org/")
public class XStreamSerializationHandler {
    public static boolean write(OutputStream stream, Serializable object) throws IOException {
        return XStreamSerializationHandler.write(new OutputStreamWriter(stream), object);
    }

    public static boolean write(Writer writer, Serializable object) throws IOException {
        XStream xmlStream = new XStream();
        xmlStream.toXML((Object)object, writer);
        return true;
    }

    public static void writeToFile(String fileName, Serializable object) throws IOException {
        XStreamSerializationHandler.writeToFile(new File(fileName), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, Serializable object) throws IOException {
        if (file == null) {
            throw new IOException("file cannot be null");
        }
        if (object == null) {
            throw new IOException("object cannot be null");
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            XStreamSerializationHandler.write(out, object);
        }
        finally {
            out.close();
        }
    }

    public static Object readFromFile(String fileName) throws IOException {
        return XStreamSerializationHandler.readFromFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readFromFile(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        Object read = null;
        try {
            read = XStreamSerializationHandler.read(in);
        }
        finally {
            in.close();
        }
        return read;
    }

    public static Object read(InputStream stream) throws IOException {
        InputStreamReader in = new InputStreamReader(stream);
        Object retval = XStreamSerializationHandler.read(in);
        in.close();
        return retval;
    }

    public static Object read(Reader reader) throws IOException {
        XStream xmlStream = new XStream();
        Object object = null;
        try {
            object = xmlStream.fromXML(reader);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return object;
    }

    public static String convertToString(Serializable object) throws IOException {
        StringWriter out = new StringWriter();
        XStreamSerializationHandler.write(out, object);
        return out.toString();
    }

    public static Object convertFromString(String string) throws IOException {
        StringReader in = new StringReader(string);
        return XStreamSerializationHandler.read(in);
    }
}

