/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io.serialization;

import gov.sandia.cognition.io.serialization.AbstractFileSerializationHandler;
import gov.sandia.cognition.io.serialization.StreamSerializationHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class AbstractStreamSerializationHandler<SerializedType>
extends AbstractFileSerializationHandler<SerializedType>
implements StreamSerializationHandler<SerializedType> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(File file, SerializedType object) throws IOException {
        if (file == null) {
            throw new IOException("file cannot be null");
        }
        if (object == null) {
            throw new IOException("object cannot be null");
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            this.writeObject(out, object);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readFromFile(File file) throws IOException, ClassNotFoundException {
        Object read;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            read = this.readObject(in);
        }
        finally {
            in.close();
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertToBytes(SerializedType object) throws IOException {
        byte[] byteArray = null;
        if (object != null) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                this.writeObject(byteStream, object);
            }
            finally {
                byteStream.close();
            }
            byteArray = byteStream.toByteArray();
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convertFromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        Object read;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        try {
            read = this.readObject(byteStream);
        }
        finally {
            byteStream.close();
        }
        return read;
    }
}

