/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.mtj.Vector1;
import gov.sandia.cognition.util.CloneableSerializable;

public class MutableDouble
extends Number
implements CloneableSerializable,
Comparable<MutableDouble>,
Ring<MutableDouble>,
Vectorizable {
    private static final long serialVersionUID = 20110131L;
    public double value;

    public MutableDouble() {
        this(0.0);
    }

    public MutableDouble(double value) {
        this.value = value;
    }

    public MutableDouble(MutableDouble other) {
        this(other.value);
    }

    @Override
    public MutableDouble clone() {
        try {
            return (MutableDouble)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other == this || other instanceof MutableDouble && this.equals((MutableDouble)other);
    }

    public boolean equals(MutableDouble other) {
        return this.equals(other.value);
    }

    public boolean equals(double other) {
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other);
    }

    @Override
    public int compareTo(MutableDouble other) {
        return Double.compare(this.value, other.value);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public boolean equals(MutableDouble other, double effectiveZero) {
        return Math.abs(this.value - other.value) <= effectiveZero;
    }

    @Override
    public MutableDouble plus(MutableDouble other) {
        return new MutableDouble(this.value + other.value);
    }

    @Override
    public void plusEquals(MutableDouble other) {
        this.value += other.value;
    }

    @Override
    public MutableDouble minus(MutableDouble other) {
        return new MutableDouble(this.value - other.value);
    }

    @Override
    public void minusEquals(MutableDouble other) {
        this.value -= other.value;
    }

    @Override
    public MutableDouble dotTimes(MutableDouble other) {
        return new MutableDouble(this.value * other.value);
    }

    @Override
    public void dotTimesEquals(MutableDouble other) {
        this.value *= other.value;
    }

    @Override
    public MutableDouble scale(double scaleFactor) {
        return new MutableDouble(this.value * scaleFactor);
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        this.value *= scaleFactor;
    }

    @Override
    public MutableDouble negative() {
        return new MutableDouble(-this.value);
    }

    @Override
    public void negativeEquals() {
        this.value = -this.value;
    }

    @Override
    public void zero() {
        this.value = 0.0;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0 || this.value == -0.0;
    }

    @Override
    public boolean isZero(double effectiveZero) {
        return Math.abs(this.value) <= effectiveZero;
    }

    @Override
    public Vector1 convertToVector() {
        return new Vector1(this.value);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.value = parameters.getElement(0);
    }
}

