/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Summarizer;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-26", changesNeeded=false, comments={"Made some of the javadoc more descriptive", "Otherwise, looks good."})
public class NumberAverager
extends AbstractCloneableSerializable
implements Summarizer<Number, Double> {
    public static final NumberAverager INSTANCE = new NumberAverager();

    @Override
    public Double summarize(Collection<? extends Number> data) {
        double sum = 0.0;
        for (Number number : data) {
            sum += number.doubleValue();
        }
        Double mean = data.size() > 0 ? Double.valueOf(sum / (double)data.size()) : null;
        return mean;
    }
}

