/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj.decomposition;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.OperationNotConvergedException;
import gov.sandia.cognition.math.matrix.decomposition.AbstractEigenDecomposition;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.NotConvergedException;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-12-02", changesNeeded=false, comments={"Moved previous code review to annotation.", "Otherwise, class looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-07-27", changesNeeded=true, comments={"The constructor should be changed to a static method because it involves significant computation."}, response={@CodeReviewResponse(respondent="Kevin R. Dixon", date="2007-11-25", moreChangesNeeded=false, comments={"Added static create() method, made constructor private"})})})
public class EigenDecompositionRightMTJ
extends AbstractEigenDecomposition {
    private EigenDecompositionRightMTJ(DenseMatrix matrix) throws OperationNotConvergedException {
        super(null, null, null);
        boolean leftEVD = false;
        boolean rightEVD = true;
        EVD mtjEVD = new EVD(matrix.getNumRows(), leftEVD, rightEVD);
        try {
            mtjEVD.factor(new no.uib.cipr.matrix.DenseMatrix(matrix.getInternalMatrix()));
        }
        catch (NotConvergedException e) {
            throw new OperationNotConvergedException(e.getMessage());
        }
        int numEigenValues = matrix.getNumRows();
        ComplexNumber[] unsortedEigenValues = new ComplexNumber[numEigenValues];
        DenseMatrixFactoryMTJ matrixFactory = DenseMatrixFactoryMTJ.INSTANCE;
        DenseMatrix lapackEigenVectors = matrixFactory.createWrapper(mtjEVD.getRightEigenvectors());
        DenseMatrix eigenVectorsRealPart = matrixFactory.createMatrix(numEigenValues, numEigenValues);
        DenseMatrix eigenVectorsImaginaryPart = matrixFactory.createMatrix(numEigenValues, numEigenValues);
        double[] realEigenValues = mtjEVD.getRealEigenvalues();
        double[] imaginaryEigenValues = mtjEVD.getImaginaryEigenvalues();
        boolean firstComplexConjugateDone = false;
        ComplexNumber[] complexEigenVector = new ComplexNumber[numEigenValues];
        for (int j = 0; j < numEigenValues; ++j) {
            int i;
            unsortedEigenValues[j] = new ComplexNumber(realEigenValues[j], imaginaryEigenValues[j]);
            if (unsortedEigenValues[j].getImaginaryPart() != 0.0) {
                if (!firstComplexConjugateDone) {
                    firstComplexConjugateDone = true;
                    for (i = 0; i < numEigenValues; ++i) {
                        complexEigenVector[i] = new ComplexNumber(lapackEigenVectors.getElement(i, j), lapackEigenVectors.getElement(i, j + 1));
                    }
                } else {
                    firstComplexConjugateDone = false;
                    for (i = 0; i < numEigenValues; ++i) {
                        complexEigenVector[i] = new ComplexNumber(lapackEigenVectors.getElement(i, j - 1), -lapackEigenVectors.getElement(i, j));
                    }
                }
            } else {
                firstComplexConjugateDone = false;
                for (i = 0; i < numEigenValues; ++i) {
                    complexEigenVector[i] = new ComplexNumber(lapackEigenVectors.getElement(i, j), 0.0);
                }
            }
            for (i = 0; i < numEigenValues; ++i) {
                eigenVectorsRealPart.setElement(i, j, complexEigenVector[i].getRealPart());
                eigenVectorsImaginaryPart.setElement(i, j, complexEigenVector[i].getImaginaryPart());
            }
        }
        this.setEigenDecomposition(unsortedEigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart, true);
    }

    public static EigenDecompositionRightMTJ create(DenseMatrix matrix) throws OperationNotConvergedException {
        return new EigenDecompositionRightMTJ(matrix);
    }
}

