/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.signals;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.FiniteCapacityBuffer;
import gov.sandia.cognition.evaluator.AbstractStatefulEvaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.signals.DiscreteTimeFilter;
import gov.sandia.cognition.util.DefaultPair;

@PublicationReference(author={"Wikipedia"}, title="Infinite impulse response", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Infinite_impulse_response")
public class AutoRegressiveMovingAverageFilter
extends AbstractStatefulEvaluator<Double, Double, DefaultPair<FiniteCapacityBuffer<Double>, FiniteCapacityBuffer<Double>>>
implements DiscreteTimeFilter<DefaultPair<FiniteCapacityBuffer<Double>, FiniteCapacityBuffer<Double>>> {
    private Vector movingAverageCoefficients;
    private Vector autoRegressiveCoefficients;

    public AutoRegressiveMovingAverageFilter(int numAutoregressiveCoefficients, int numMovingAverageCoefficients) {
        this(VectorFactory.getDefault().createVector(numAutoregressiveCoefficients, 1.0 / (double)numAutoregressiveCoefficients), VectorFactory.getDefault().createVector(numMovingAverageCoefficients, 1.0 / (double)numMovingAverageCoefficients));
    }

    public AutoRegressiveMovingAverageFilter(double[] autoRegressiveCoefficients, double[] movingAverageCoefficients) {
        this(VectorFactory.getDefault().copyArray(autoRegressiveCoefficients), VectorFactory.getDefault().copyArray(movingAverageCoefficients));
    }

    public AutoRegressiveMovingAverageFilter(Vector autoRegressiveCoefficients, Vector movingAverageCoefficients) {
        this.setAutoregressiveCoefficients(autoRegressiveCoefficients);
        this.setMovingAverageCoefficients(movingAverageCoefficients);
    }

    @Override
    public DefaultPair<FiniteCapacityBuffer<Double>, FiniteCapacityBuffer<Double>> createDefaultState() {
        return DefaultPair.create(new FiniteCapacityBuffer(this.getNumMovingAverageCoefficients()), new FiniteCapacityBuffer(this.getNumAutoRegressiveCoefficients()));
    }

    @Override
    public Double evaluate(Double input) {
        double yn = 0.0;
        ((FiniteCapacityBuffer)((DefaultPair)this.getState()).getFirst()).addFirst(input);
        int n = 0;
        for (Double xn : (FiniteCapacityBuffer)((DefaultPair)this.getState()).getFirst()) {
            double bn = this.getMovingAverageCoefficients().getElement(n);
            yn += bn * xn;
            ++n;
        }
        n = 0;
        for (Double ynm1 : (FiniteCapacityBuffer)((DefaultPair)this.getState()).getSecond()) {
            double an = this.getAutoRegressiveCoefficients().getElement(n);
            yn -= an * ynm1;
            ++n;
        }
        ((FiniteCapacityBuffer)((DefaultPair)this.getState()).getSecond()).addFirst(yn);
        return yn;
    }

    @Override
    public AutoRegressiveMovingAverageFilter clone() {
        AutoRegressiveMovingAverageFilter clone = (AutoRegressiveMovingAverageFilter)super.clone();
        clone.setAutoregressiveCoefficients(this.getAutoRegressiveCoefficients().clone());
        clone.setMovingAverageCoefficients(this.getMovingAverageCoefficients().clone());
        return clone;
    }

    @Override
    public Vector convertToVector() {
        return this.getAutoRegressiveCoefficients().stack(this.getMovingAverageCoefficients());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        int N;
        int M = this.getNumAutoRegressiveCoefficients();
        if (M + (N = this.getNumMovingAverageCoefficients()) != parameters.getDimensionality()) {
            throw new IllegalArgumentException("Number of dimensions of the parameter Vector aren't equal to the number expected.");
        }
        this.setAutoregressiveCoefficients(parameters.subVector(0, M - 1));
        this.setMovingAverageCoefficients(parameters.subVector(M, N + M - 1));
    }

    public int getNumMovingAverageCoefficients() {
        return this.getMovingAverageCoefficients() == null ? 0 : this.getMovingAverageCoefficients().getDimensionality();
    }

    public Vector getMovingAverageCoefficients() {
        return this.movingAverageCoefficients;
    }

    public void setMovingAverageCoefficients(Vector movingAverageCoefficients) {
        this.movingAverageCoefficients = movingAverageCoefficients;
    }

    public int getNumAutoRegressiveCoefficients() {
        return this.getAutoRegressiveCoefficients() == null ? 0 : this.getAutoRegressiveCoefficients().getDimensionality();
    }

    public Vector getAutoRegressiveCoefficients() {
        return this.autoRegressiveCoefficients;
    }

    public void setAutoregressiveCoefficients(Vector autoRegressiveCoefficients) {
        this.autoRegressiveCoefficients = autoRegressiveCoefficients;
    }
}

