/*
 * Decompiled with CFR 0.152.
 */
package io.agora.common;

import io.agora.common.AgoraServiceJNI;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public class Logging {
    private static final int LOG_DEBUG = 2048;
    private static final int LOG_INFO = 1;
    private static final int LOG_WARN = 2;
    private static final int LOG_ERROR = 4;

    public static void log(int level, String tag, String message) {
        AgoraServiceJNI.nativeLog(level, "[" + tag + "] " + message);
    }

    public static void d(String message) {
        AgoraServiceJNI.nativeLog(2048, message);
    }

    public static void i(String message) {
        AgoraServiceJNI.nativeLog(1, message);
    }

    public static void e(String message) {
        AgoraServiceJNI.nativeLog(4, message);
    }

    public static void w(String message) {
        AgoraServiceJNI.nativeLog(2, message);
    }

    public static void d(String tag, String message) {
        Logging.log(2048, tag, message);
    }

    public static void i(String tag, String message) {
        Logging.log(1, tag, message);
    }

    public static void e(String tag, String message) {
        Logging.log(4, tag, message);
    }

    public static void w(String tag, String message) {
        Logging.log(2, tag, message);
    }

    public static void e(String tag, String message, Throwable e) {
        Logging.log(4, tag, message);
        Logging.log(4, tag, e.toString());
        Logging.log(4, tag, Logging.getStackTraceString(e));
    }

    static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

