/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.LruCache;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmChannel;
import io.agora.rtm.RtmChannelAttribute;
import io.agora.rtm.RtmChannelListener;
import io.agora.rtm.RtmChannelMember;
import io.agora.rtm.RtmMessage;
import io.agora.rtm.SendMessageOptions;
import io.agora.rtm.internal.RtmChannelMemberImpl;
import io.agora.rtm.internal.RtmClientImpl;
import io.agora.rtm.internal.RtmMessageImpl;
import io.agora.rtm.internal.RtmSdkContext;
import io.agora.rtm.jni.CHANNEL_MESSAGE_ERR_CODE;
import io.agora.rtm.jni.GET_MEMBERS_ERR;
import io.agora.rtm.jni.IChannel;
import io.agora.rtm.jni.IChannelEventHandler;
import io.agora.rtm.jni.IChannelMember;
import io.agora.rtm.jni.IMessage;
import io.agora.rtm.jni.IRtmChannelAttribute;
import io.agora.rtm.jni.ISendMessageOptions;
import io.agora.rtm.jni.JOIN_CHANNEL_ERR;
import io.agora.rtm.jni.LEAVE_CHANNEL_ERR;
import io.agora.rtm.jni.MESSAGE_TYPE;
import java.util.ArrayList;
import java.util.List;

class RtmChannelImpl
extends RtmChannel {
    private static final String TAG = RtmChannelImpl.class.getSimpleName();
    private String mChannelId;
    private RtmClientImpl mRtmClient;
    private RtmChannelListener mChannelListener;
    private IChannel mChannelNative;
    private ChannelEventHandlerNative mChannelListenerNative;
    private final byte[] mChannelLock = new byte[0];
    private final byte[] mChannelCallbackLock = new byte[0];
    private ResultCallback<Void> mJoinChannelCallback;
    private ResultCallback<Void> mLeaveChannelCallback;
    private final LruCache<Long, ResultCallback<Void>> mSendChannelMessageCallbacks = new LruCache(500);
    private ResultCallback<List<RtmChannelMember>> mGetMembersCallback;

    RtmChannelImpl(String channelId, RtmChannelListener channelListener) {
        this.mChannelId = channelId;
        this.mChannelListener = channelListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean attach(RtmClientImpl rtmClient) {
        byte[] byArray = this.mChannelLock;
        synchronized (this.mChannelLock) {
            this.mRtmClient = rtmClient;
            this.mChannelListenerNative = new ChannelEventHandlerNative();
            this.mChannelNative = rtmClient.mRtmServiceNative.createChannel(this.mChannelId, this.mChannelListenerNative);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mChannelNative != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        byte[] byArray = this.mChannelLock;
        synchronized (this.mChannelLock) {
            if (this.mChannelNative != null) {
                this.mChannelNative.release();
                this.mChannelNative = null;
            }
            if (this.mChannelListenerNative != null) {
                this.mChannelListenerNative.delete();
                this.mChannelListenerNative = null;
            }
            this.mRtmClient = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isChannelNativeReady() {
        byte[] byArray = this.mChannelLock;
        synchronized (this.mChannelLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.isNativeReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void join(ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "join channel: " + this.mChannelId);
        JOIN_CHANNEL_ERR apiErr = null;
        byte[] byArray = this.mChannelLock;
        // MONITORENTER : this.mChannelLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mChannelCallbackLock;
            // MONITORENTER : this.mChannelCallbackLock
            int ret = this.mChannelNative.join();
            Logging.i(TAG, "join channel " + this.mChannelId + " ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, JOIN_CHANNEL_ERR.class);
            if (apiErr == JOIN_CHANNEL_ERR.JOIN_CHANNEL_ERR_OK) {
                this.mJoinChannelCallback = resultCallback;
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == JOIN_CHANNEL_ERR.JOIN_CHANNEL_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = JOIN_CHANNEL_ERR.JOIN_CHANNEL_ERR_REJECTED;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void leave(ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "leave channel: " + this.mChannelId);
        LEAVE_CHANNEL_ERR apiErr = null;
        byte[] byArray = this.mChannelLock;
        // MONITORENTER : this.mChannelLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mChannelCallbackLock;
            // MONITORENTER : this.mChannelCallbackLock
            int ret = this.mChannelNative.leave();
            Logging.i(TAG, "leave channel " + this.mChannelId + " ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, LEAVE_CHANNEL_ERR.class);
            if (apiErr == LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_OK) {
                this.mLeaveChannelCallback = resultCallback;
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_REJECTED;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    @Override
    public void sendMessage(RtmMessage message, ResultCallback<Void> resultCallback) {
        this.sendMessage(message, null, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void sendMessage(RtmMessage message, SendMessageOptions options, ResultCallback<Void> resultCallback) {
        Logging.d(TAG, "send message to channel " + this.mChannelId + ", " + options);
        CHANNEL_MESSAGE_ERR_CODE apiErr = null;
        byte[] byArray = this.mChannelLock;
        // MONITORENTER : this.mChannelLock
        if (this.isNativeReady() && message != null) {
            IMessage nativeMessage = null;
            if (message.getMessageType() == 1) {
                nativeMessage = this.mRtmClient.mRtmServiceNative.createMessage(message.getText());
            } else if (message.getMessageType() == 2) {
                byte[] data = message.getRawMessage();
                nativeMessage = message.getText().isEmpty() ? this.mRtmClient.mRtmServiceNative.createMessage(data, data.length) : this.mRtmClient.mRtmServiceNative.createMessage(data, data.length, message.getText());
            }
            if (nativeMessage != null) {
                int ret;
                nativeMessage.setText(message.getText());
                byte[] byArray2 = this.mChannelCallbackLock;
                // MONITORENTER : this.mChannelCallbackLock
                if (options == null) {
                    ret = this.mChannelNative.sendMessage(nativeMessage);
                } else {
                    ISendMessageOptions internalOptions = new ISendMessageOptions();
                    internalOptions.setEnableOfflineMessaging(false);
                    internalOptions.setEnableHistoricalMessaging(options.enableHistoricalMessaging);
                    ret = this.mChannelNative.sendMessage(nativeMessage, internalOptions);
                }
                Logging.d(TAG, "send message to channel " + this.mChannelId + " ret: " + ret);
                apiErr = RtmSdkContext.swigValueToEnumSafe(ret, CHANNEL_MESSAGE_ERR_CODE.class);
                if (apiErr == CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_OK && resultCallback != null) {
                    this.mSendChannelMessageCallbacks.put(nativeMessage.getMessageId(), resultCallback);
                }
                // MONITOREXIT : byArray2
                nativeMessage.release();
            }
        }
        // MONITOREXIT : byArray
        if (apiErr == CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getMembers(ResultCallback<List<RtmChannelMember>> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        Logging.i(TAG, "get members of channel " + this.mChannelId);
        GET_MEMBERS_ERR apiErr = null;
        byte[] byArray = this.mChannelLock;
        // MONITORENTER : this.mChannelLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mChannelCallbackLock;
            // MONITORENTER : this.mChannelCallbackLock
            int ret = this.mChannelNative.getMembers();
            Logging.i(TAG, "get members of channel " + this.mChannelId + " ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, GET_MEMBERS_ERR.class);
            if (apiErr == GET_MEMBERS_ERR.GET_MEMBERS_ERR_OK) {
                this.mGetMembersCallback = resultCallback;
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == GET_MEMBERS_ERR.GET_MEMBERS_ERR_OK) return;
        if (apiErr == null) {
            apiErr = GET_MEMBERS_ERR.GET_MEMBERS_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    @Override
    public String getId() {
        return this.mChannelId;
    }

    @Override
    public void release() {
        Logging.i(TAG, "release");
        this.detach();
    }

    private boolean isNativeReady() {
        if (this.mChannelNative == null || this.mRtmClient == null || this.mRtmClient.mRtmServiceNative == null) {
            Logging.w(TAG, "rtm native not ready");
            return false;
        }
        return true;
    }

    private class ChannelEventHandlerNative
    extends IChannelEventHandler {
        private ChannelEventHandlerNative() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinSuccess() {
            Logging.i(TAG, "onJoinSuccess");
            ResultCallback pendingCallback = null;
            byte[] byArray = RtmChannelImpl.this.mChannelCallbackLock;
            synchronized (byArray) {
                if (RtmChannelImpl.this.mJoinChannelCallback != null) {
                    pendingCallback = RtmChannelImpl.this.mJoinChannelCallback;
                    RtmChannelImpl.this.mJoinChannelCallback = null;
                }
            }
            if (pendingCallback != null) {
                pendingCallback.onSuccess(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinFailure(JOIN_CHANNEL_ERR errorCode) {
            Logging.i(TAG, "onJoinFailure: " + errorCode);
            if (errorCode == null) {
                return;
            }
            ResultCallback pendingCallback = null;
            byte[] byArray = RtmChannelImpl.this.mChannelCallbackLock;
            synchronized (byArray) {
                if (RtmChannelImpl.this.mJoinChannelCallback != null) {
                    pendingCallback = RtmChannelImpl.this.mJoinChannelCallback;
                    RtmChannelImpl.this.mJoinChannelCallback = null;
                }
            }
            if (pendingCallback != null) {
                pendingCallback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeave(LEAVE_CHANNEL_ERR errorCode) {
            Logging.i(TAG, "onLeave: " + errorCode);
            if (errorCode == null) {
                return;
            }
            ResultCallback pendingCallback = null;
            byte[] byArray = RtmChannelImpl.this.mChannelCallbackLock;
            synchronized (byArray) {
                if (RtmChannelImpl.this.mLeaveChannelCallback != null) {
                    pendingCallback = RtmChannelImpl.this.mLeaveChannelCallback;
                    RtmChannelImpl.this.mLeaveChannelCallback = null;
                }
            }
            if (pendingCallback != null) {
                if (errorCode == LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_OK) {
                    pendingCallback.onSuccess(null);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
                }
            }
        }

        @Override
        public void onMessageReceived(String userId, IMessage message) {
            if (message == null || RtmChannelImpl.this.mChannelListener == null) {
                Logging.w(TAG, "empty message or channel listener");
                return;
            }
            Logging.d(TAG, "onMessageReceived from: " + userId);
            RtmMessageImpl rtmMessage = null;
            if (message.getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_TEXT) {
                rtmMessage = new RtmMessageImpl(message.getText());
            } else if (message.getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_RAW) {
                rtmMessage = new RtmMessageImpl(message.getRawMessageData(), message.getText());
            }
            RtmChannelMemberImpl channelMember = new RtmChannelMemberImpl(userId, RtmChannelImpl.this.mChannelId);
            RtmChannelImpl.this.mChannelListener.onMessageReceived(rtmMessage, channelMember);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendMessageResult(long messageId, CHANNEL_MESSAGE_ERR_CODE state) {
            ResultCallback callback;
            Logging.d(TAG, "onSendMessageResult id: " + messageId + " state: " + state);
            if (state == null) {
                return;
            }
            byte[] byArray = RtmChannelImpl.this.mChannelCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmChannelImpl.this.mSendChannelMessageCallbacks.remove(messageId);
            }
            if (callback != null) {
                if (state == CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_OK) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(new ErrorInfo(state.swigValue(), state.toString()));
                }
            }
        }

        @Override
        public void onMemberJoined(IChannelMember member) {
            if (member == null || RtmChannelImpl.this.mChannelListener == null) {
                Logging.w(TAG, "empty member or channel listener");
                return;
            }
            RtmChannelMemberImpl channelMember = new RtmChannelMemberImpl(member);
            Logging.d(TAG, "on member " + ((RtmChannelMember)channelMember).getUserId() + " joined " + ((RtmChannelMember)channelMember).getChannelId());
            RtmChannelImpl.this.mChannelListener.onMemberJoined(channelMember);
        }

        @Override
        public void onMemberLeft(IChannelMember member) {
            if (member == null || RtmChannelImpl.this.mChannelListener == null) {
                Logging.w(TAG, "empty member or channel listener");
                return;
            }
            RtmChannelMemberImpl channelMember = new RtmChannelMemberImpl(member);
            Logging.i(TAG, "on member " + ((RtmChannelMember)channelMember).getUserId() + " left " + ((RtmChannelMember)channelMember).getChannelId());
            RtmChannelImpl.this.mChannelListener.onMemberLeft(channelMember);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetMembers(List<IChannelMember> members, GET_MEMBERS_ERR errorCode) {
            Logging.i(TAG, "onGetMembers size: " + (members != null ? members.size() : 0) + " errorCode: " + errorCode);
            if (errorCode == null) {
                return;
            }
            ResultCallback pendingCallback = null;
            byte[] byArray = RtmChannelImpl.this.mChannelCallbackLock;
            synchronized (byArray) {
                if (RtmChannelImpl.this.mGetMembersCallback != null) {
                    pendingCallback = RtmChannelImpl.this.mGetMembersCallback;
                    RtmChannelImpl.this.mGetMembersCallback = null;
                }
            }
            if (pendingCallback == null) {
                return;
            }
            if (errorCode != GET_MEMBERS_ERR.GET_MEMBERS_ERR_OK) {
                pendingCallback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
            } else if (members == null) {
                pendingCallback.onFailure(new ErrorInfo(1));
            } else {
                ArrayList<RtmChannelMemberImpl> rtmChannelMembers = new ArrayList<RtmChannelMemberImpl>();
                for (IChannelMember member : members) {
                    rtmChannelMembers.add(new RtmChannelMemberImpl(member));
                }
                pendingCallback.onSuccess(rtmChannelMembers);
            }
        }

        @Override
        public void onAttributesUpdated(List<IRtmChannelAttribute> attributeList) {
            Logging.i(TAG, "onAttributesUpdated size: " + (attributeList != null ? attributeList.size() : 0));
            if (attributeList == null || RtmChannelImpl.this.mChannelListener == null) {
                Logging.w(TAG, "empty attribute or channel listener");
                return;
            }
            ArrayList<RtmChannelAttribute> rtmChannelAttribute = new ArrayList<RtmChannelAttribute>();
            for (IRtmChannelAttribute attribute : attributeList) {
                rtmChannelAttribute.add(new RtmChannelAttribute(attribute.getKey(), attribute.getValue(), attribute.getLastUpdateUserId(), attribute.getLastUpdateTs()));
            }
            RtmChannelImpl.this.mChannelListener.onAttributesUpdated(rtmChannelAttribute);
        }

        @Override
        public void onMemberCountUpdated(int memberCount) {
            Logging.i(TAG, "onMemberCountUpdated membercount: " + memberCount);
            RtmChannelImpl.this.mChannelListener.onMemberCountUpdated(memberCount);
        }
    }
}

