/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.jni;

import io.agora.rtm.jni.ATTRIBUTE_OPERATION_ERR;
import io.agora.rtm.jni.AgoraRtmServiceJNI;
import io.agora.rtm.jni.CONNECTION_CHANGE_REASON;
import io.agora.rtm.jni.CONNECTION_STATE;
import io.agora.rtm.jni.GET_CHANNEL_MEMBER_COUNT_ERR;
import io.agora.rtm.jni.IMessage;
import io.agora.rtm.jni.IRtmAttribute;
import io.agora.rtm.jni.IRtmChannelAttribute;
import io.agora.rtm.jni.IRtmChannelMemberCount;
import io.agora.rtm.jni.LOGIN_ERR_CODE;
import io.agora.rtm.jni.LOGOUT_ERR_CODE;
import io.agora.rtm.jni.PEER_MESSAGE_ERR_CODE;
import io.agora.rtm.jni.PEER_SUBSCRIPTION_STATUS_ERR;
import io.agora.rtm.jni.PeerOnlineStatus;
import io.agora.rtm.jni.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR;
import io.agora.rtm.jni.QUERY_PEERS_ONLINE_STATUS_ERR;
import io.agora.rtm.jni.RENEW_TOKEN_ERR_CODE;

public abstract class IRtmServiceEventHandler {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IRtmServiceEventHandler(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IRtmServiceEventHandler obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                AgoraRtmServiceJNI.delete_IRtmServiceEventHandler(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    public void swigReleaseOwnership() {
        this.swigCMemOwn = false;
        AgoraRtmServiceJNI.IRtmServiceEventHandler_change_ownership(this, this.swigCPtr, false);
    }

    public void swigTakeOwnership() {
        this.swigCMemOwn = true;
        AgoraRtmServiceJNI.IRtmServiceEventHandler_change_ownership(this, this.swigCPtr, true);
    }

    public IRtmServiceEventHandler() {
        this(AgoraRtmServiceJNI.new_IRtmServiceEventHandler(), true);
        AgoraRtmServiceJNI.IRtmServiceEventHandler_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    public abstract void onLoginSuccess();

    public abstract void onLoginFailure(LOGIN_ERR_CODE var1);

    public abstract void onLogout(LOGOUT_ERR_CODE var1);

    public abstract void onConnectionStateChanged(CONNECTION_STATE var1, CONNECTION_CHANGE_REASON var2);

    public abstract void onSendMessageResult(long var1, PEER_MESSAGE_ERR_CODE var3);

    public abstract void onMessageReceivedFromPeer(String var1, IMessage var2);

    public abstract void onQueryPeersOnlineStatusResult(long var1, PeerOnlineStatus[] var3, int var4, QUERY_PEERS_ONLINE_STATUS_ERR var5);

    public abstract void onSubscriptionRequestResult(long var1, PEER_SUBSCRIPTION_STATUS_ERR var3);

    public abstract void onQueryPeersBySubscriptionOptionResult(long var1, String[] var3, int var4, QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR var5);

    public abstract void onPeersOnlineStatusChanged(PeerOnlineStatus[] var1, int var2);

    public abstract void onRenewTokenResult(String var1, RENEW_TOKEN_ERR_CODE var2);

    public abstract void onTokenExpired();

    public abstract void onSetLocalUserAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onAddOrUpdateLocalUserAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onDeleteLocalUserAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onClearLocalUserAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onGetUserAttributesResult(long var1, String var3, IRtmAttribute[] var4, int var5, ATTRIBUTE_OPERATION_ERR var6);

    public abstract void onSetChannelAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onAddOrUpdateChannelAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onDeleteChannelAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onClearChannelAttributesResult(long var1, ATTRIBUTE_OPERATION_ERR var3);

    public abstract void onGetChannelAttributesResult(long var1, IRtmChannelAttribute[] var3, int var4, ATTRIBUTE_OPERATION_ERR var5);

    public abstract void onGetChannelMemberCountResult(long var1, IRtmChannelMemberCount[] var3, int var4, GET_CHANNEL_MEMBER_COUNT_ERR var5);
}

