/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.publisher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.test.publisher.TestPublisher;
import reactor.util.annotation.Nullable;

final class ColdTestPublisher<T>
extends TestPublisher<T> {
    private static final ColdTestPublisherSubscription[] EMPTY = new ColdTestPublisherSubscription[0];
    private static final ColdTestPublisherSubscription[] TERMINATED = new ColdTestPublisherSubscription[0];
    final List<T> values;
    boolean done;
    Throwable error;
    final boolean errorOnOverflow;
    final EnumSet<TestPublisher.Violation> violations;
    volatile boolean hasOverflown;
    volatile boolean wasRequested;
    volatile ColdTestPublisherSubscription<T>[] subscribers = EMPTY;
    static final AtomicReferenceFieldUpdater<ColdTestPublisher, ColdTestPublisherSubscription[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(ColdTestPublisher.class, ColdTestPublisherSubscription[].class, "subscribers");
    volatile int cancelCount;
    static final AtomicIntegerFieldUpdater<ColdTestPublisher> CANCEL_COUNT = AtomicIntegerFieldUpdater.newUpdater(ColdTestPublisher.class, "cancelCount");
    volatile long subscribeCount;
    static final AtomicLongFieldUpdater<ColdTestPublisher> SUBSCRIBED_COUNT = AtomicLongFieldUpdater.newUpdater(ColdTestPublisher.class, "subscribeCount");

    ColdTestPublisher(boolean errorOnOverflow, EnumSet<TestPublisher.Violation> violations) {
        this.errorOnOverflow = errorOnOverflow;
        this.values = Collections.synchronizedList(new ArrayList());
        this.violations = violations;
    }

    public void subscribe(Subscriber<? super T> s) {
        Objects.requireNonNull(s, "s");
        ColdTestPublisherSubscription<? super T> p = new ColdTestPublisherSubscription<T>(s, this);
        SUBSCRIBED_COUNT.incrementAndGet(this);
        if (!this.add(p)) {
            s.onSubscribe(p);
            if (p.cancelled) {
                return;
            }
            ((ColdTestPublisherSubscription)p).drain();
            return;
        }
        s.onSubscribe(p);
        ((ColdTestPublisherSubscription)p).drain();
    }

    boolean add(ColdTestPublisherSubscription<T> s) {
        ColdTestPublisherSubscription[] b;
        ColdTestPublisherSubscription<T>[] a;
        do {
            if ((a = this.subscribers) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new ColdTestPublisherSubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = s;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        return true;
    }

    void remove(ColdTestPublisherSubscription<T> s) {
        ColdTestPublisherSubscription[] b;
        ColdTestPublisherSubscription<T>[] a = this.subscribers;
        if (a == EMPTY || a == TERMINATED) {
            return;
        }
        do {
            if ((a = this.subscribers) == EMPTY || a == TERMINATED) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != s) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new ColdTestPublisherSubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
    }

    @Override
    public Flux<T> flux() {
        return Flux.from((Publisher)this);
    }

    @Override
    public boolean wasSubscribed() {
        return this.subscribeCount > 0L;
    }

    @Override
    public long subscribeCount() {
        return this.subscribeCount;
    }

    @Override
    public boolean wasCancelled() {
        return this.cancelCount > 0;
    }

    @Override
    public boolean wasRequested() {
        return this.wasRequested;
    }

    @Override
    public Mono<T> mono() {
        return Mono.from((Publisher)this);
    }

    @Override
    public ColdTestPublisher<T> assertMinRequested(long n) {
        ColdTestPublisherSubscription<T>[] subs = this.subscribers;
        long minRequest = Stream.of(subs).mapToLong(s -> s.requested).min().orElse(0L);
        if (minRequest < n) {
            throw new AssertionError((Object)("Expected smallest requested amount to be >= " + n + "; got " + minRequest));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertMaxRequested(long n) {
        ColdTestPublisherSubscription<T>[] subs = this.subscribers;
        long maxRequest = Stream.of(subs).mapToLong(s -> s.requested).max().orElse(0L);
        if (maxRequest > n) {
            throw new AssertionError((Object)("Expected largest requested amount to be <= " + n + "; got " + maxRequest));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertSubscribers() {
        ColdTestPublisherSubscription<T>[] s = this.subscribers;
        if (s == EMPTY) {
            throw new AssertionError((Object)"Expected subscribers");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertSubscribers(int n) {
        int sl = this.subscribers.length;
        if (sl != n) {
            throw new AssertionError((Object)("Expected " + n + " subscribers, got " + sl));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertNoSubscribers() {
        int sl = this.subscribers.length;
        if (sl != 0) {
            throw new AssertionError((Object)("Expected no subscribers, got " + sl));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertCancelled() {
        if (this.cancelCount == 0) {
            throw new AssertionError((Object)"Expected at least 1 cancellation");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertCancelled(int n) {
        int cc = this.cancelCount;
        if (cc != n) {
            throw new AssertionError((Object)("Expected " + n + " cancellations, got " + cc));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertNotCancelled() {
        if (this.cancelCount != 0) {
            throw new AssertionError((Object)"Expected no cancellation");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertRequestOverflow() {
        if (!this.hasOverflown) {
            throw new AssertionError((Object)"Expected some request overflow");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertNoRequestOverflow() {
        if (this.hasOverflown) {
            throw new AssertionError((Object)"Unexpected request overflow");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> next(@Nullable T t) {
        if (!this.violations.contains((Object)TestPublisher.Violation.ALLOW_NULL)) {
            Objects.requireNonNull(t, "emitted values must be non-null");
        }
        this.values.add(t);
        for (ColdTestPublisherSubscription<T> s : this.subscribers) {
            ((ColdTestPublisherSubscription)s).drain();
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> error(Throwable t) {
        ColdTestPublisherSubscription[] subs;
        Objects.requireNonNull(t, "t");
        this.error = t;
        this.done = true;
        for (ColdTestPublisherSubscription s : subs = SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s.drain();
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> complete() {
        ColdTestPublisherSubscription[] subs;
        this.done = true;
        this.error = null;
        for (ColdTestPublisherSubscription s : subs = SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s.drain();
        }
        return this;
    }

    static final class ColdTestPublisherSubscription<T>
    implements Subscription {
        final Subscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final ColdTestPublisher<T> parent;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<ColdTestPublisherSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(ColdTestPublisherSubscription.class, "requested");
        volatile long wip;
        static final AtomicLongFieldUpdater<ColdTestPublisherSubscription> WIP = AtomicLongFieldUpdater.newUpdater(ColdTestPublisherSubscription.class, "wip");
        int index;

        ColdTestPublisherSubscription(Subscriber<? super T> actual, ColdTestPublisher<T> parent) {
            this.actual = actual;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
            this.parent = parent;
        }

        public void request(long n) {
            if (Operators.validate((long)n)) {
                if (Operators.addCap(REQUESTED, (Object)this, (long)n) == 0L) {
                    this.parent.wasRequested = true;
                }
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                CANCEL_COUNT.incrementAndGet(this.parent);
                if (this.parent.violations.contains((Object)TestPublisher.Violation.DEFER_CANCELLATION) || this.parent.violations.contains((Object)TestPublisher.Violation.REQUEST_OVERFLOW)) {
                    return;
                }
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        private void drain() {
            if (WIP.getAndIncrement(this) > 0L) {
                return;
            }
            do {
                boolean hasMoreData;
                int i;
                long r = this.requested;
                int emitted = 0;
                if (this.cancelled) {
                    return;
                }
                int s = this.parent.values.size();
                for (i = this.index; i < s && ((long)emitted != r || this.parent.violations.contains((Object)TestPublisher.Violation.REQUEST_OVERFLOW)); ++i) {
                    Object t = this.parent.values.get(i);
                    if (t == null && !this.parent.violations.contains((Object)TestPublisher.Violation.ALLOW_NULL)) {
                        this.parent.remove(this);
                        this.actual.onError((Throwable)new NullPointerException("The " + i + "th element was null"));
                        return;
                    }
                    if (this.actualConditional != null) {
                        if (!this.actualConditional.tryOnNext(t)) continue;
                        ++emitted;
                        continue;
                    }
                    this.actual.onNext(t);
                    ++emitted;
                    if (!this.cancelled) continue;
                    return;
                }
                this.index = i;
                boolean bl = hasMoreData = i < s;
                if ((long)emitted > r) {
                    assert (this.parent.violations.contains((Object)TestPublisher.Violation.REQUEST_OVERFLOW));
                    this.parent.hasOverflown = true;
                }
                boolean hasMoreRequest = r != Long.MAX_VALUE ? REQUESTED.addAndGet(this, -emitted) > 0L : true;
                if (i == s && this.emitTerminalSignalIfAny()) {
                    return;
                }
                if (!hasMoreData || hasMoreRequest || !this.parent.errorOnOverflow) continue;
                this.parent.remove(this);
                this.actual.onError((Throwable)Exceptions.failWithOverflow((String)"Can't deliver value due to lack of requests"));
                return;
            } while (WIP.decrementAndGet(this) != 0L);
        }

        private boolean emitTerminalSignalIfAny() {
            if (this.parent.done && this.parent.values.size() == this.index) {
                this.parent.remove(this);
                Throwable t = this.parent.error;
                if (t != null) {
                    this.actual.onError(this.parent.error);
                } else {
                    this.actual.onComplete();
                }
                return true;
            }
            return false;
        }
    }
}

