/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;

public class BeanPropertyDefinitions {
    private BeanPropertyDefinitions() {
        throw new UnsupportedOperationException();
    }

    public static Function<BeanPropertyDefinition, String> beanPropertyByInternalName() {
        return new Function<BeanPropertyDefinition, String>(){

            public String apply(BeanPropertyDefinition input) {
                return input.getInternalName();
            }
        };
    }

    public static String name(BeanPropertyDefinition beanPropertyDefinition, boolean forSerialization, BeanPropertyNamingStrategy namingStrategy) {
        return forSerialization ? namingStrategy.nameForSerialization(beanPropertyDefinition) : namingStrategy.nameForDeserialization(beanPropertyDefinition);
    }

    public static Optional<BeanPropertyDefinition> jacksonPropertyWithSameInternalName(BeanDescription beanDescription, BeanPropertyDefinition propertyDefinition) {
        return FluentIterable.from((Iterable)beanDescription.findProperties()).firstMatch(BeanPropertyDefinitions.withSameInternalName(propertyDefinition));
    }

    public static Predicate<ModelProperty> ignorable(final ModelContext givenContext) {
        return new Predicate<ModelProperty>(){

            public boolean apply(ModelProperty input) {
                return givenContext.hasSeenBefore(input.getType());
            }
        };
    }

    public static Function<PropertyNamingStrategy, String> overTheWireName(final BeanPropertyDefinition beanProperty, final MapperConfig<?> config) {
        return new Function<PropertyNamingStrategy, String>(){

            public String apply(PropertyNamingStrategy strategy) {
                return BeanPropertyDefinitions.getName(strategy, beanProperty, config);
            }
        };
    }

    private static Predicate<BeanPropertyDefinition> withSameInternalName(final BeanPropertyDefinition propertyDefinition) {
        return new Predicate<BeanPropertyDefinition>(){

            public boolean apply(BeanPropertyDefinition input) {
                return input.getInternalName().equals(propertyDefinition.getInternalName());
            }
        };
    }

    private static String getName(PropertyNamingStrategy naming, BeanPropertyDefinition beanProperty, MapperConfig<?> config) {
        AnnotationIntrospector annotationIntrospector = config.isAnnotationProcessingEnabled() ? config.getAnnotationIntrospector() : null;
        POJOPropertyBuilder prop = new POJOPropertyBuilder(new PropertyName(beanProperty.getName()), annotationIntrospector, true);
        return naming.nameForField(config, prop.getField(), beanProperty.getName());
    }
}

