/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModelDependencies")
public class CachingModelDependencyProvider
implements ModelDependencyProvider {
    private final LoadingCache<ModelContext, Set<ResolvedType>> cache;
    private final ModelDependencyProvider delegate;

    @Autowired
    public CachingModelDependencyProvider(final @Qualifier(value="default") ModelDependencyProvider delegate) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ModelContext, Set<ResolvedType>>(){

            public Set<ResolvedType> load(ModelContext key) {
                return delegate.dependentModels(key);
            }
        });
    }

    @Override
    public Set<ResolvedType> dependentModels(ModelContext modelContext) {
        return (Set)this.cache.getUnchecked((Object)modelContext);
    }
}

