/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import org.springframework.web.util.UriComponentsBuilder;
import springfox.documentation.PathProvider;
import springfox.documentation.spring.web.Paths;

public abstract class AbstractPathProvider
implements PathProvider {
    protected abstract String applicationPath();

    protected abstract String getDocumentationPath();

    public String getApplicationBasePath() {
        return this.applicationPath();
    }

    public String getOperationPath(String operationPath) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"/");
        return Paths.sanitiseUrl(uriComponentsBuilder.path(operationPath).build().toString());
    }

    public String getResourceListingPath(String groupName, String apiDeclaration) {
        String candidate = this.agnosticUriComponentBuilder(this.getDocumentationPath()).pathSegment(new String[]{groupName, apiDeclaration}).build().toString();
        return Paths.sanitiseUrl(candidate);
    }

    private UriComponentsBuilder agnosticUriComponentBuilder(String url) {
        UriComponentsBuilder uriComponentsBuilder = url.startsWith("http") ? UriComponentsBuilder.fromHttpUrl((String)url) : UriComponentsBuilder.fromPath((String)url);
        return uriComponentsBuilder;
    }
}

