/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.HandlerMethodReturnTypes;

@Component
@Order(value=-2147483648)
public class OperationResponseClassReader
implements OperationBuilderPlugin {
    private static Logger log = LoggerFactory.getLogger(OperationResponseClassReader.class);
    private final TypeResolver typeResolver;
    private final TypeNameExtractor nameExtractor;

    @Autowired
    public OperationResponseClassReader(TypeResolver typeResolver, TypeNameExtractor nameExtractor) {
        this.typeResolver = typeResolver;
        this.nameExtractor = nameExtractor;
    }

    public void apply(OperationContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        ResolvedType returnType = HandlerMethodReturnTypes.handlerReturnType(this.typeResolver, handlerMethod);
        returnType = context.alternateFor(returnType);
        ModelContext modelContext = ModelContext.returnValue((Type)returnType, (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getDocumentationContext().getGenericsNamingStrategy());
        String responseTypeName = this.nameExtractor.typeName(modelContext);
        log.debug("Setting spring response class to:" + responseTypeName);
        context.operationBuilder().responseModel(this.modelRef(returnType, modelContext));
    }

    private ModelRef modelRef(ResolvedType type, ModelContext modelContext) {
        if (Collections.isContainerType((ResolvedType)type)) {
            ResolvedType collectionElementType = Collections.collectionElementType((ResolvedType)type);
            String elementTypeName = this.nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType));
            return new ModelRef(Collections.containerType((ResolvedType)type), elementTypeName);
        }
        if (Maps.isMapType((ResolvedType)type)) {
            String elementTypeName = this.nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)Maps.mapValueType((ResolvedType)type)));
            return new ModelRef("Map", elementTypeName, true);
        }
        String typeName = this.nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)type));
        return new ModelRef(typeName);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

