/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.annotations.ApiModel;
import io.swagger.util.PrimitiveType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class TypeNameResolver {
    public static final TypeNameResolver std = new TypeNameResolver();

    protected TypeNameResolver() {
    }

    public String nameForType(JavaType type) {
        if (type.hasGenericTypes()) {
            return this.nameForGenericType(type);
        }
        String name = this.findStdName(type);
        return name == null ? this.nameForClass(type) : name;
    }

    protected String nameForClass(JavaType type) {
        return this.nameForClass(type.getRawClass());
    }

    protected String nameForClass(Class<?> cls) {
        ApiModel model = cls.getAnnotation(ApiModel.class);
        String modelName = model == null ? null : StringUtils.trimToNull((String)model.value());
        return modelName == null ? cls.getSimpleName() : modelName;
    }

    protected String nameForGenericType(JavaType type) {
        StringBuilder generic = new StringBuilder(this.nameForClass(type));
        int count = type.containedTypeCount();
        for (int i = 0; i < count; ++i) {
            JavaType arg = type.containedType(i);
            String argName = PrimitiveType.fromType((Type)arg) != null ? this.nameForClass(arg) : this.nameForType(arg);
            generic.append(WordUtils.capitalize((String)argName));
        }
        return generic.toString();
    }

    protected String findStdName(JavaType type) {
        return PrimitiveType.getCommonName((Type)type);
    }
}

