/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.plugins.resources.MavenBuildTimestamp;
import org.apache.maven.plugins.resources.ResourceUtils;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.filtering.Resource;

@Mojo(name="resources", defaultPhase="process-resources", projectRequired=true)
public class ResourcesMojo
implements org.apache.maven.api.plugin.Mojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    protected String propertiesEncoding;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected Path outputDirectory;
    @Parameter
    private List<Resource> resources;
    @Inject
    protected Project project;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    protected List<String> buildFilters;
    @Parameter
    protected List<String> filters;
    @Parameter(defaultValue="true")
    protected boolean useBuildFilters;
    @Inject
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Inject
    protected Map<String, MavenResourcesFiltering> mavenResourcesFilteringMap;
    @Inject
    protected Session session;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="false")
    private boolean overwrite;
    @Parameter(defaultValue="false")
    protected boolean includeEmptyDirs;
    @Parameter
    protected List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="true")
    protected boolean escapeWindowsPaths;
    @Parameter
    protected LinkedHashSet<String> delimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter(defaultValue="true")
    protected boolean addDefaultExcludes;
    @Parameter
    private List<String> mavenFilteringHints;
    private List<MavenResourcesFiltering> mavenFilteringComponents = new ArrayList<MavenResourcesFiltering>();
    @Parameter(defaultValue="false")
    private boolean supportMultiLineFiltering;
    @Parameter(defaultValue="false")
    private boolean fileNameFiltering;
    @Parameter(property="maven.resources.skip", defaultValue="false")
    private boolean skip;
    @Inject
    private Log logger;

    public void execute() throws MojoException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping the execution.");
            return;
        }
        if (this.resources == null) {
            this.resources = ((ProjectManager)this.session.getService(ProjectManager.class)).getResources(this.project, ProjectScope.MAIN).stream().map(ResourceUtils::newResource).collect(Collectors.toList());
        }
        this.doExecute();
    }

    protected void doExecute() throws MojoException {
        if ((this.encoding == null || this.encoding.isEmpty()) && this.isFilteringEnabled(this.getResources())) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + System.getProperty("file.encoding") + ". Build is platform dependent!"));
            this.getLog().warn((CharSequence)"See https://maven.apache.org/general.html#encoding-warning");
        }
        try {
            List<String> combinedFilters = this.getCombinedFiltersList();
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(this.getResources(), this.getOutputDirectory(), this.project, this.encoding, combinedFilters, Collections.emptyList(), this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            mavenResourcesExecution.setInjectProjectBuildFilters(false);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setOverwrite(this.overwrite);
            mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
            mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            mavenResourcesExecution.setFilterFilenames(this.fileNameFiltering);
            mavenResourcesExecution.setAddDefaultExcludes(this.addDefaultExcludes);
            Properties additionalProperties = this.addSeveralSpecialProperties();
            mavenResourcesExecution.setAdditionalProperties(additionalProperties);
            mavenResourcesExecution.setDelimiters(this.delimiters, this.useDefaultDelimiters);
            mavenResourcesExecution.setPropertiesEncoding(this.propertiesEncoding);
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
            this.executeUserFilterComponents(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoException(e.getMessage(), (Throwable)e);
        }
    }

    private Properties addSeveralSpecialProperties() {
        String timeStamp = new MavenBuildTimestamp().formattedTimestamp();
        Properties additionalProperties = new Properties();
        additionalProperties.put("maven.build.timestamp", timeStamp);
        additionalProperties.put("project.baseUri", this.project.getBasedir().toAbsolutePath().toFile().toURI().toString());
        return additionalProperties;
    }

    protected void executeUserFilterComponents(MavenResourcesExecution mavenResourcesExecution) throws MojoException, MavenFilteringException {
        if (this.mavenFilteringHints != null) {
            for (String hint : this.mavenFilteringHints) {
                MavenResourcesFiltering userFilterComponent = this.mavenResourcesFilteringMap.get(hint);
                if (userFilterComponent != null) {
                    this.getLog().debug((CharSequence)("added user filter component with hint: " + hint));
                    this.mavenFilteringComponents.add(userFilterComponent);
                    continue;
                }
                throw new MojoException("User filter with hint `" + hint + "` requested, but not present. Discovered filters are: " + String.valueOf(this.mavenResourcesFilteringMap.keySet()));
            }
        } else {
            this.getLog().debug((CharSequence)"no user filter components");
        }
        if (this.mavenFilteringComponents != null && !this.mavenFilteringComponents.isEmpty()) {
            this.getLog().debug((CharSequence)"execute user filters");
            for (MavenResourcesFiltering filter : this.mavenFilteringComponents) {
                filter.filterResources(mavenResourcesExecution);
            }
        }
    }

    protected List<String> getCombinedFiltersList() {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.useBuildFilters ? this.buildFilters : null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.useBuildFilters && this.buildFilters != null && !this.buildFilters.isEmpty()) {
            result.addAll(this.buildFilters);
        }
        result.addAll(this.filters);
        return result;
    }

    private boolean isFilteringEnabled(Collection<Resource> theResources) {
        if (theResources != null) {
            for (Resource resource : theResources) {
                if (!resource.isFiltering()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public LinkedHashSet<String> getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(LinkedHashSet<String> delimiters) {
        this.delimiters = delimiters;
    }

    public boolean isUseDefaultDelimiters() {
        return this.useDefaultDelimiters;
    }

    public void setUseDefaultDelimiters(boolean useDefaultDelimiters) {
        this.useDefaultDelimiters = useDefaultDelimiters;
    }

    public boolean isSkip() {
        return this.skip;
    }

    protected Log getLog() {
        return this.logger;
    }
}

