/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.imageio.spi.IIORegistry;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.debugger.colorpane.CSArrayBased;
import org.apache.pdfbox.debugger.colorpane.CSDeviceN;
import org.apache.pdfbox.debugger.colorpane.CSIndexed;
import org.apache.pdfbox.debugger.colorpane.CSSeparation;
import org.apache.pdfbox.debugger.flagbitspane.FlagBitsPane;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingPaneController;
import org.apache.pdfbox.debugger.pagepane.PagePane;
import org.apache.pdfbox.debugger.streampane.StreamPane;
import org.apache.pdfbox.debugger.stringpane.StringPane;
import org.apache.pdfbox.debugger.treestatus.TreeStatus;
import org.apache.pdfbox.debugger.treestatus.TreeStatusPane;
import org.apache.pdfbox.debugger.ui.ArrayEntry;
import org.apache.pdfbox.debugger.ui.DocumentEntry;
import org.apache.pdfbox.debugger.ui.ErrorDialog;
import org.apache.pdfbox.debugger.ui.FileOpenSaveDialog;
import org.apache.pdfbox.debugger.ui.ImageTypeMenu;
import org.apache.pdfbox.debugger.ui.LogDialog;
import org.apache.pdfbox.debugger.ui.MapEntry;
import org.apache.pdfbox.debugger.ui.OSXAdapter;
import org.apache.pdfbox.debugger.ui.PDFTreeCellRenderer;
import org.apache.pdfbox.debugger.ui.PDFTreeModel;
import org.apache.pdfbox.debugger.ui.PageEntry;
import org.apache.pdfbox.debugger.ui.PrintDpiMenu;
import org.apache.pdfbox.debugger.ui.ReaderBottomPanel;
import org.apache.pdfbox.debugger.ui.RecentFiles;
import org.apache.pdfbox.debugger.ui.RenderDestinationMenu;
import org.apache.pdfbox.debugger.ui.RotationMenu;
import org.apache.pdfbox.debugger.ui.TextDialog;
import org.apache.pdfbox.debugger.ui.Tree;
import org.apache.pdfbox.debugger.ui.TreeViewMenu;
import org.apache.pdfbox.debugger.ui.ViewMenu;
import org.apache.pdfbox.debugger.ui.WindowPrefs;
import org.apache.pdfbox.debugger.ui.XrefEntries;
import org.apache.pdfbox.debugger.ui.XrefEntry;
import org.apache.pdfbox.debugger.ui.ZoomMenu;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDPageLabels;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPageable;
import picocli.CommandLine;

@CommandLine.Command(name="pdfdebugger", description={"Analyzes and inspects the internal structure of a PDF document"})
public class PDFDebugger
extends JFrame
implements Callable<Integer>,
HyperlinkListener {
    private static Log LOG;
    private static final Set<COSName> SPECIALCOLORSPACES;
    private static final Set<COSName> OTHERCOLORSPACES;
    private static final FileFilter PDF_FILTER;
    private int shortcutKeyMask;
    private static final String OS_NAME;
    private static final boolean IS_MAC_OS;
    private final JPanel documentPanel = new JPanel();
    private TreeStatusPane statusPane;
    private RecentFiles recentFiles;
    private WindowPrefs windowPrefs;
    private PDDocument document;
    private String currentFilePath;
    private JScrollPane jScrollPaneRight;
    private JSplitPane jSplitPane;
    private JTextPane jTextPane;
    private ReaderBottomPanel statusBar;
    private Tree tree;
    private JMenuItem saveAsMenuItem;
    private JMenu recentFilesMenu;
    private JMenuItem printMenuItem;
    private JMenu printDpiMenu;
    private JMenuItem reopenMenuItem;
    private JMenu findMenu;
    private JMenuItem findMenuItem;
    private JMenuItem findNextMenuItem;
    private JMenuItem findPreviousMenuItem;
    private String currentTreeViewMode = "Show pages";
    private final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-password"}, description={"password to decrypt the document"}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-viewstructure"}, description={"activate structure mode on startup"})
    private boolean viewstructure = false;
    @CommandLine.Parameters(paramLabel="inputfile", arity="0..1", description={"the PDF file to be loaded"})
    private File infile;
    public static final Properties configuration;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    public PDFDebugger() {
        if (this.viewstructure) {
            this.currentTreeViewMode = "Internal structure";
        }
    }

    public PDFDebugger(String initialViewMode) {
        if (TreeViewMenu.isValidViewMode(initialViewMode)) {
            this.currentTreeViewMode = initialViewMode;
        } else {
            this.SYSERR.println("Onknown view mode " + initialViewMode);
        }
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new PDFDebugger()).execute(args);
        if (exitCode > 0) {
            System.exit(exitCode);
        }
    }

    @Override
    public Integer call() {
        try {
            this.shortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (System.getProperty("apple.laf.useScreenMenuBar") == null) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> new ErrorDialog(throwable).setVisible(true));
            this.loadConfiguration();
            this.initComponents();
            LogDialog.init(this, this.statusBar.getLogLabel());
            System.setProperty("org.apache.commons.logging.Log", "org.apache.pdfbox.debugger.ui.DebugLog");
            LOG = LogFactory.getLog(PDFDebugger.class);
            TextDialog.init(this);
            PDDeviceCMYK.INSTANCE.toRGB(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
            PDDeviceRGB.INSTANCE.toRGB(new float[]{0.0f, 0.0f, 0.0f});
            IIORegistry.getDefaultInstance();
            FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
            if (this.infile != null && this.infile.exists()) {
                this.readPDFFile(this.infile, this.password);
            }
            this.setVisible(true);
        }
        catch (Exception ex) {
            this.SYSERR.println("Error viewing document: " + ex.getMessage());
            return 4;
        }
        return 0;
    }

    public String getTreeViewMode() {
        return this.currentTreeViewMode;
    }

    public void setTreeViewMode(String viewMode) {
        if (TreeViewMenu.isValidViewMode(viewMode)) {
            this.currentTreeViewMode = viewMode;
        }
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    private void loadConfiguration() {
        File file = new File("config.properties");
        if (file.exists()) {
            try (FileInputStream is = new FileInputStream(file);){
                configuration.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        JScrollPane jScrollPaneLeft = new JScrollPane();
        this.tree = new Tree();
        this.jScrollPaneRight = new JScrollPane();
        this.jTextPane = new JTextPane();
        this.tree.setCellRenderer(new PDFTreeCellRenderer());
        this.tree.setModel(null);
        this.setTitle("Apache PDFBox Debugger");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PDFDebugger.this.tree.requestFocusInWindow();
                super.windowOpened(windowEvent);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                PDFDebugger.this.exitMenuItemActionPerformed(null);
            }
        });
        this.windowPrefs = new WindowPrefs(this.getClass());
        jScrollPaneLeft.setBorder(new BevelBorder(0));
        this.jSplitPane.setDividerLocation(this.windowPrefs.getDividerLocation());
        this.tree.addTreeSelectionListener(this::jTree1ValueChanged);
        jScrollPaneLeft.setViewportView(this.tree);
        this.jSplitPane.setRightComponent(this.jScrollPaneRight);
        this.jSplitPane.setDividerSize(3);
        this.jScrollPaneRight.setViewportView(this.jTextPane);
        this.jSplitPane.setLeftComponent(jScrollPaneLeft);
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        this.statusPane = new TreeStatusPane(this.tree);
        this.statusPane.getPanel().setBorder(new BevelBorder(0));
        Dimension preferredTreePathSize = this.statusPane.getPanel().getPreferredSize();
        int treePathHeight = (int)Math.round(preferredTreePathSize.getHeight());
        preferredTreePathSize.height = treePathHeight = Integer.parseInt(configuration.getProperty("treePathHeight", Integer.toString(treePathHeight)));
        this.statusPane.getPanel().setPreferredSize(preferredTreePathSize);
        this.getContentPane().add((Component)this.statusPane.getPanel(), "First");
        this.getContentPane().add((Component)this.jSplitPane, "Center");
        this.statusBar = new ReaderBottomPanel();
        this.getContentPane().add((Component)this.statusBar, "South");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        ViewMenu viewMenu = ViewMenu.getInstance(this);
        menuBar.add(viewMenu.getMenu());
        this.setJMenuBar(menuBar);
        menuBar.add(Box.createHorizontalGlue());
        JMenu help = new JMenu("Help");
        help.setMnemonic(72);
        JMenuItem item = new JMenuItem("About PDFBox", 65);
        item.setActionCommand("about");
        item.addActionListener(actionEvent -> this.textDialog("About Apache PDFBox", PDFDebugger.class.getResource("about.html")));
        help.add(item);
        menuBar.add(help);
        this.setExtendedState(this.windowPrefs.getExtendedState());
        this.setBounds(this.windowPrefs.getBounds());
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                try {
                    Transferable transferable = transferSupport.getTransferable();
                    List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    PDFDebugger.this.readPDFFile((File)files.get(0), "");
                }
                catch (UnsupportedFlavorException e) {
                    new ErrorDialog(e).setVisible(true);
                    return false;
                }
                catch (Exception e) {
                    new ErrorDialog(e).setVisible(true);
                }
                return true;
            }
        });
        this.initGlobalEventHandlers();
    }

    protected void initGlobalEventHandlers() {
        if (IS_MAC_OS) {
            try {
                Method osxOpenFiles = this.getClass().getDeclaredMethod("osxOpenFiles", String.class);
                osxOpenFiles.setAccessible(true);
                OSXAdapter.setFileHandler(this, osxOpenFiles);
                Method osxQuit = this.getClass().getDeclaredMethod("osxQuit", new Class[0]);
                osxQuit.setAccessible(true);
                OSXAdapter.setQuitHandler(this, osxQuit);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private JMenu createFileMenu() {
        JMenuItem openMenuItem = new JMenuItem("Open...");
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, this.shortcutKeyMask));
        openMenuItem.addActionListener(this::openMenuItemActionPerformed);
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(openMenuItem);
        fileMenu.setMnemonic('F');
        JMenuItem openUrlMenuItem = new JMenuItem("Open URL...");
        openUrlMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, this.shortcutKeyMask));
        openUrlMenuItem.addActionListener(evt -> {
            String urlString = JOptionPane.showInputDialog("Enter an URL");
            if (urlString == null || urlString.isEmpty()) {
                return;
            }
            try {
                this.readPDFurl(urlString, "");
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
        fileMenu.add(openUrlMenuItem);
        this.reopenMenuItem = new JMenuItem("Reopen");
        this.reopenMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, this.shortcutKeyMask));
        this.reopenMenuItem.addActionListener(evt -> {
            try {
                if (this.currentFilePath.startsWith("http")) {
                    this.readPDFurl(this.currentFilePath, "");
                } else {
                    this.readPDFFile(this.currentFilePath, "");
                }
            }
            catch (IOException | URISyntaxException e) {
                new ErrorDialog(e).setVisible(true);
            }
        });
        this.reopenMenuItem.setEnabled(false);
        fileMenu.add(this.reopenMenuItem);
        this.recentFiles = new RecentFiles(this.getClass(), 5);
        this.recentFilesMenu = new JMenu("Open Recent");
        this.recentFilesMenu.setEnabled(false);
        this.addRecentFileItems();
        fileMenu.add(this.recentFilesMenu);
        this.saveAsMenuItem = new JMenuItem("Save as...");
        this.saveAsMenuItem.addActionListener(this::saveAsMenuItemActionPerformed);
        this.saveAsMenuItem.setEnabled(false);
        fileMenu.add(this.saveAsMenuItem);
        this.printMenuItem = new JMenuItem("Print");
        this.printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, this.shortcutKeyMask));
        this.printMenuItem.setEnabled(false);
        this.printMenuItem.addActionListener(this::printMenuItemActionPerformed);
        fileMenu.addSeparator();
        fileMenu.add(this.printMenuItem);
        this.printDpiMenu = PrintDpiMenu.getInstance().getMenu();
        this.printDpiMenu.setEnabled(false);
        fileMenu.add(this.printDpiMenu);
        if (!IS_MAC_OS) {
            JMenuItem exitMenuItem = new JMenuItem("Exit");
            exitMenuItem.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
            exitMenuItem.addActionListener(this::exitMenuItemActionPerformed);
            fileMenu.addSeparator();
            fileMenu.add(exitMenuItem);
        }
        return fileMenu;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenuItem cutMenuItem = new JMenuItem("Cut");
        cutMenuItem.setEnabled(false);
        editMenu.add(cutMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy");
        copyMenuItem.setEnabled(false);
        editMenu.add(copyMenuItem);
        JMenuItem pasteMenuItem = new JMenuItem("Paste");
        pasteMenuItem.setEnabled(false);
        editMenu.add(pasteMenuItem);
        JMenuItem deleteMenuItem = new JMenuItem("Delete");
        deleteMenuItem.setEnabled(false);
        editMenu.add(deleteMenuItem);
        editMenu.addSeparator();
        editMenu.add(this.createFindMenu());
        return editMenu;
    }

    private JMenu createFindMenu() {
        this.findMenu = new JMenu("Find");
        this.findMenu.setEnabled(false);
        this.findMenuItem = new JMenuItem("Find...");
        this.findMenuItem.setActionCommand("find");
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, this.shortcutKeyMask));
        this.findNextMenuItem = new JMenuItem("Find Next");
        if (IS_MAC_OS) {
            this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, this.shortcutKeyMask));
        } else {
            this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        }
        this.findPreviousMenuItem = new JMenuItem("Find Previous");
        if (IS_MAC_OS) {
            this.findPreviousMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, this.shortcutKeyMask | 0x40));
        } else {
            this.findPreviousMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 64));
        }
        this.findMenu.add(this.findMenuItem);
        this.findMenu.add(this.findNextMenuItem);
        this.findMenu.add(this.findPreviousMenuItem);
        return this.findMenu;
    }

    public JMenu getFindMenu() {
        return this.findMenu;
    }

    public JMenuItem getFindMenuItem() {
        return this.findMenuItem;
    }

    public JMenuItem getFindNextMenuItem() {
        return this.findNextMenuItem;
    }

    public JMenuItem getFindPreviousMenuItem() {
        return this.findPreviousMenuItem;
    }

    private void osxOpenFiles(String filename) {
        try {
            this.readPDFFile(filename, "");
        }
        catch (IOException | URISyntaxException e) {
            new ErrorDialog(e).setVisible(true);
        }
    }

    private void osxQuit() {
        this.exitMenuItemActionPerformed(null);
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (IS_MAC_OS) {
                FileDialog openDialog = new FileDialog((Frame)this, "Save", 1);
                openDialog.setFilenameFilter((dir, name) -> name.toLowerCase().endsWith(".pdf"));
                openDialog.setVisible(true);
                String file = openDialog.getFile();
                if (file != null) {
                    this.document.setAllSecurityToBeRemoved(true);
                    this.document.save(file);
                }
            } else {
                FileOpenSaveDialog saveAsDialog = new FileOpenSaveDialog(this, PDF_FILTER);
                saveAsDialog.saveDocument(this.document, "pdf");
            }
        }
        catch (IOException e) {
            new ErrorDialog(e).setVisible(true);
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (IS_MAC_OS) {
                FileDialog openDialog = new FileDialog((Frame)this, "Open");
                openDialog.setFilenameFilter((dir, name) -> name.toLowerCase().endsWith(".pdf"));
                openDialog.setVisible(true);
                if (openDialog.getFile() != null) {
                    this.readPDFFile(new File(openDialog.getDirectory(), openDialog.getFile()), "");
                }
            } else {
                FileOpenSaveDialog openDialog = new FileOpenSaveDialog(this, PDF_FILTER);
                File file = openDialog.openFile();
                if (file != null) {
                    this.readPDFFile(file, "");
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            new ErrorDialog(e).setVisible(true);
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            try {
                Object selectedNode = path.getLastPathComponent();
                this.statusBar.getStatusLabel().setText("");
                if (selectedNode instanceof XrefEntry) {
                    if (this.jSplitPane.getRightComponent() == null || !this.jSplitPane.getRightComponent().equals(this.jScrollPaneRight)) {
                        this.replaceRightComponent(this.jScrollPaneRight);
                    }
                    this.jTextPane.setText(this.convertToString(selectedNode));
                    return;
                }
                if (this.isPage(selectedNode)) {
                    this.showPage(selectedNode);
                    return;
                }
                if (this.isSpecialColorSpace(selectedNode) || this.isOtherColorSpace(selectedNode)) {
                    this.showColorPane(selectedNode);
                    return;
                }
                if (path.getParentPath() != null && this.isFlagNode(selectedNode, path.getParentPath().getLastPathComponent())) {
                    Object parentNode = path.getParentPath().getLastPathComponent();
                    this.showFlagPane(parentNode, selectedNode);
                    return;
                }
                if (this.isStream(selectedNode)) {
                    this.showStream((COSStream)this.getUnderneathObject(selectedNode), path);
                    return;
                }
                if (this.isFont(selectedNode)) {
                    this.showFont(selectedNode, path);
                    return;
                }
                if (this.isString(selectedNode)) {
                    this.showString(selectedNode);
                    return;
                }
                if (this.jSplitPane.getRightComponent() == null || !this.jSplitPane.getRightComponent().equals(this.jScrollPaneRight)) {
                    this.replaceRightComponent(this.jScrollPaneRight);
                }
                this.jTextPane.setText(this.convertToString(selectedNode));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isSpecialColorSpace(Object selectedNode) {
        COSBase arrayEntry;
        COSBase underneathObject = this.getUnderneathObject(selectedNode);
        if (underneathObject instanceof COSArray && ((COSArray)underneathObject).size() > 0 && (arrayEntry = ((COSArray)underneathObject).get(0)) instanceof COSName) {
            COSName name = (COSName)arrayEntry;
            return SPECIALCOLORSPACES.contains(name);
        }
        return false;
    }

    private boolean isOtherColorSpace(Object selectedNode) {
        COSBase arrayEntry;
        COSBase underneathObject = this.getUnderneathObject(selectedNode);
        if (underneathObject instanceof COSArray && ((COSArray)underneathObject).size() > 0 && (arrayEntry = ((COSArray)underneathObject).get(0)) instanceof COSName) {
            COSName name = (COSName)arrayEntry;
            return OTHERCOLORSPACES.contains(name);
        }
        return false;
    }

    private boolean isPage(Object selectedNode) {
        COSDictionary dict;
        COSBase typeItem;
        COSBase underneathObject = this.getUnderneathObject(selectedNode);
        return underneathObject instanceof COSDictionary && COSName.PAGE.equals((Object)(typeItem = (dict = (COSDictionary)underneathObject).getItem(COSName.TYPE)));
    }

    private boolean isFlagNode(Object selectedNode, Object parentNode) {
        if (selectedNode instanceof MapEntry) {
            COSName key = ((MapEntry)selectedNode).getKey();
            return COSName.FLAGS.equals((Object)key) && this.isFontDescriptor(parentNode) || COSName.F.equals((Object)key) && this.isAnnot(parentNode) || COSName.FF.equals((Object)key) || COSName.PANOSE.equals((Object)key) || COSName.SIG_FLAGS.equals((Object)key) || COSName.P.equals((Object)key) && this.isEncrypt(parentNode);
        }
        return false;
    }

    private boolean isEncrypt(Object obj) {
        if (obj instanceof MapEntry) {
            MapEntry entry = (MapEntry)obj;
            return COSName.ENCRYPT.equals((Object)entry.getKey()) && entry.getValue() instanceof COSDictionary;
        }
        return false;
    }

    private boolean isFontDescriptor(Object obj) {
        COSBase underneathObject = this.getUnderneathObject(obj);
        return underneathObject instanceof COSDictionary && COSName.FONT_DESC.equals((Object)((COSDictionary)underneathObject).getCOSName(COSName.TYPE));
    }

    private boolean isAnnot(Object obj) {
        COSBase underneathObject = this.getUnderneathObject(obj);
        return underneathObject instanceof COSDictionary && COSName.ANNOT.equals((Object)((COSDictionary)underneathObject).getCOSName(COSName.TYPE));
    }

    private boolean isStream(Object selectedNode) {
        return this.getUnderneathObject(selectedNode) instanceof COSStream;
    }

    private boolean isString(Object selectedNode) {
        return this.getUnderneathObject(selectedNode) instanceof COSString;
    }

    private boolean isFont(Object selectedNode) {
        COSBase underneathObject = this.getUnderneathObject(selectedNode);
        if (underneathObject instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)underneathObject;
            return COSName.FONT.equals((Object)dic.getCOSName(COSName.TYPE)) && !this.isCIDFont(dic);
        }
        return false;
    }

    private boolean isCIDFont(COSDictionary dic) {
        return COSName.CID_FONT_TYPE0.equals((Object)dic.getCOSName(COSName.SUBTYPE)) || COSName.CID_FONT_TYPE2.equals((Object)dic.getCOSName(COSName.SUBTYPE));
    }

    private void showColorPane(Object csNode) throws IOException {
        COSArray array;
        COSBase arrayEntry;
        COSBase underneathObject = this.getUnderneathObject(csNode);
        if (underneathObject instanceof COSArray && ((COSArray)underneathObject).size() > 0 && (arrayEntry = (array = (COSArray)underneathObject).get(0)) instanceof COSName) {
            COSName csName = (COSName)arrayEntry;
            if (csName.equals((Object)COSName.SEPARATION)) {
                this.replaceRightComponent(new CSSeparation(array).getPanel());
            } else if (csName.equals((Object)COSName.DEVICEN)) {
                this.replaceRightComponent(new CSDeviceN(array).getPanel());
            } else if (csName.equals((Object)COSName.INDEXED)) {
                this.replaceRightComponent(new CSIndexed(array).getPanel());
            } else if (OTHERCOLORSPACES.contains(csName)) {
                this.replaceRightComponent(new CSArrayBased(array).getPanel());
            }
        }
    }

    private void showPage(Object selectedNode) {
        COSDictionary page;
        COSBase typeItem;
        COSBase underneathObject = this.getUnderneathObject(selectedNode);
        if (underneathObject instanceof COSDictionary && COSName.PAGE.equals((Object)(typeItem = (page = (COSDictionary)underneathObject).getItem(COSName.TYPE)))) {
            PagePane pagePane = new PagePane(this.document, page, this.statusBar.getStatusLabel());
            this.replaceRightComponent(new JScrollPane(pagePane.getPanel()));
        }
    }

    private void showFlagPane(Object parentNode, Object selectedNode) {
        COSBase underneathParentObject = this.getUnderneathObject(parentNode);
        if (underneathParentObject instanceof COSDictionary) {
            COSName selectedNodeName = ((MapEntry)selectedNode).getKey();
            FlagBitsPane flagBitsPane = new FlagBitsPane(this.document, (COSDictionary)underneathParentObject, selectedNodeName);
            this.replaceRightComponent(flagBitsPane.getPane());
        }
    }

    private void showStream(COSStream stream, TreePath path) throws IOException {
        Object resourcesObj;
        Object pageObj;
        boolean isContentStream = false;
        boolean isThumb = false;
        COSName key = this.getNodeKey(path.getLastPathComponent());
        COSName parentKey = this.getNodeKey(path.getParentPath().getLastPathComponent());
        COSDictionary resourcesDic = null;
        if (COSName.CONTENTS.equals((Object)key)) {
            pageObj = path.getParentPath().getLastPathComponent();
            COSDictionary page = (COSDictionary)this.getUnderneathObject(pageObj);
            if (page != null) {
                resourcesDic = page.getCOSDictionary(COSName.RESOURCES);
            }
            isContentStream = true;
        } else if (COSName.CONTENTS.equals((Object)parentKey) || COSName.CHAR_PROCS.equals((Object)parentKey)) {
            pageObj = path.getParentPath().getParentPath().getLastPathComponent();
            COSDictionary page = (COSDictionary)this.getUnderneathObject(pageObj);
            if (page != null) {
                resourcesDic = page.getCOSDictionary(COSName.RESOURCES);
            }
            isContentStream = true;
        } else if (COSName.FORM.equals((Object)stream.getCOSName(COSName.SUBTYPE)) || COSName.PATTERN.equals((Object)stream.getCOSName(COSName.TYPE)) || stream.getInt(COSName.PATTERN_TYPE) == 1) {
            if (stream.containsKey(COSName.RESOURCES)) {
                resourcesDic = stream.getCOSDictionary(COSName.RESOURCES);
            }
            isContentStream = true;
        } else if (COSName.THUMB.equals((Object)key)) {
            isThumb = true;
        } else if (COSName.IMAGE.equals((Object)stream.getCOSName(COSName.SUBTYPE)) && !((resourcesObj = path.getParentPath().getParentPath().getLastPathComponent()) instanceof XrefEntries)) {
            resourcesDic = (COSDictionary)this.getUnderneathObject(resourcesObj);
        }
        StreamPane streamPane = new StreamPane(stream, isContentStream, isThumb, resourcesDic);
        this.replaceRightComponent(streamPane.getPanel());
    }

    private void showFont(Object selectedNode, TreePath path) {
        JPanel pane = null;
        COSName fontName = this.getNodeKey(selectedNode);
        if (fontName != null) {
            COSDictionary resourceDic = (COSDictionary)this.getUnderneathObject(path.getParentPath().getParentPath().getLastPathComponent());
            FontEncodingPaneController fontEncodingPaneController = new FontEncodingPaneController(fontName, resourceDic);
            pane = fontEncodingPaneController.getPane();
        }
        if (pane == null) {
            this.replaceRightComponent(this.jScrollPaneRight);
            return;
        }
        this.replaceRightComponent(pane);
    }

    private void replaceRightComponent(Component pane) {
        int div = this.jSplitPane.getDividerLocation();
        this.jSplitPane.setRightComponent(pane);
        this.jSplitPane.setDividerLocation(div);
    }

    private void showString(Object selectedNode) {
        COSString string = (COSString)this.getUnderneathObject(selectedNode);
        this.replaceRightComponent(new StringPane(string).getPane());
    }

    private COSName getNodeKey(Object selectedNode) {
        if (selectedNode instanceof MapEntry) {
            return ((MapEntry)selectedNode).getKey();
        }
        return null;
    }

    private COSBase getUnderneathObject(Object selectedNode) {
        if (selectedNode instanceof MapEntry) {
            return ((MapEntry)selectedNode).getValue();
        }
        if (selectedNode instanceof ArrayEntry) {
            return ((ArrayEntry)selectedNode).getValue();
        }
        if (selectedNode instanceof PageEntry) {
            return ((PageEntry)selectedNode).getDict();
        }
        if (selectedNode instanceof XrefEntry) {
            return ((XrefEntry)selectedNode).getCOSObject();
        }
        if (selectedNode instanceof COSObject) {
            return ((COSObject)selectedNode).getObject();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertToString(Object selectedNode) {
        if (selectedNode instanceof COSBoolean) {
            return Boolean.toString(((COSBoolean)selectedNode).getValue());
        }
        if (selectedNode instanceof COSFloat) {
            return Float.toString(((COSFloat)selectedNode).floatValue());
        }
        if (selectedNode instanceof COSNull) {
            return "null";
        }
        if (selectedNode instanceof COSInteger) {
            return Integer.toString(((COSInteger)selectedNode).intValue());
        }
        if (selectedNode instanceof COSName) {
            return ((COSName)selectedNode).getName();
        }
        if (!(selectedNode instanceof COSString)) {
            if (selectedNode instanceof COSStream) {
                try {
                    COSStream stream = (COSStream)selectedNode;
                    try (COSInputStream in = stream.createInputStream();){
                        String string = new String(IOUtils.toByteArray((InputStream)in));
                        return string;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (selectedNode instanceof COSDictionary) {
                return "COSDictionary";
            }
            if (selectedNode instanceof COSArray) {
                return "COSArray";
            }
            if (selectedNode instanceof MapEntry) {
                return this.convertToString(((MapEntry)selectedNode).getValue());
            }
            if (selectedNode instanceof ArrayEntry) {
                return this.convertToString(((ArrayEntry)selectedNode).getValue());
            }
            if (!(selectedNode instanceof XrefEntry)) return null;
            return selectedNode.toString();
        }
        String text = ((COSString)selectedNode).getString();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isISOControl(c)) {
                return "<" + ((COSString)selectedNode).toHexString() + ">";
            }
            ++n2;
        }
        return text;
    }

    private void exitMenuItemActionPerformed(ActionEvent ignored) {
        if (this.document != null) {
            try {
                this.document.close();
                if (!this.currentFilePath.startsWith("http")) {
                    this.recentFiles.addFile(this.currentFilePath);
                }
                this.recentFiles.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.windowPrefs.setExtendedState(this.getExtendedState());
        this.setExtendedState(0);
        this.windowPrefs.setBounds(this.getBounds());
        this.windowPrefs.setDividerLocation(this.jSplitPane.getDividerLocation());
        this.performApplicationExit();
    }

    protected void performApplicationExit() {
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMenuItemActionPerformed(ActionEvent evt) {
        block13: {
            if (this.document == null) {
                return;
            }
            AccessPermission ap = this.document.getCurrentAccessPermission();
            if (!ap.canPrint()) {
                JOptionPane.showMessageDialog(this, "You do not have permission to print");
                return;
            }
            try {
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPageable((Pageable)new PDFPageable(this.document, Orientation.AUTO, false, (float)PrintDpiMenu.getDpiSelection()));
                HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
                PDViewerPreferences vp = this.document.getDocumentCatalog().getViewerPreferences();
                if (vp != null && vp.getDuplex() != null) {
                    String dp = vp.getDuplex();
                    if (PDViewerPreferences.DUPLEX.DuplexFlipLongEdge.toString().equals(dp)) {
                        pras.add(Sides.TWO_SIDED_LONG_EDGE);
                    } else if (PDViewerPreferences.DUPLEX.DuplexFlipShortEdge.toString().equals(dp)) {
                        pras.add(Sides.TWO_SIDED_SHORT_EDGE);
                    } else if (PDViewerPreferences.DUPLEX.Simplex.toString().equals(dp)) {
                        pras.add(Sides.ONE_SIDED);
                    }
                }
                if (!job.printDialog(pras)) break block13;
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    long t0 = System.nanoTime();
                    job.print(pras);
                    long t1 = System.nanoTime();
                    long ms = TimeUnit.MILLISECONDS.convert(t1 - t0, TimeUnit.NANOSECONDS);
                    LOG.info((Object)("Printed in " + ms + " ms"));
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (PrinterException e) {
                new ErrorDialog(e).setVisible(true);
            }
        }
    }

    private void readPDFFile(String filePath, String password) throws IOException, URISyntaxException {
        File file = new File(filePath);
        this.readPDFFile(file, password);
    }

    private void readPDFFile(final File file, String password) throws IOException, URISyntaxException {
        if (this.document != null) {
            this.document.close();
            if (!this.currentFilePath.startsWith("http")) {
                this.recentFiles.addFile(this.currentFilePath);
            }
        }
        this.currentFilePath = file.getPath();
        this.recentFiles.removeFile(file.getPath());
        LogDialog.instance().clear();
        TextDialog.instance().setVisible(false);
        DocumentOpener documentOpener = new DocumentOpener(password){

            @Override
            PDDocument open() throws IOException {
                long t0 = System.nanoTime();
                PDDocument doc = Loader.loadPDF((File)file, (String)this.password);
                long t1 = System.nanoTime();
                long ms = TimeUnit.MILLISECONDS.convert(t1 - t0, TimeUnit.NANOSECONDS);
                LOG.info((Object)("Parsed in " + ms + " ms"));
                return doc;
            }
        };
        this.document = documentOpener.parse();
        this.printMenuItem.setEnabled(true);
        this.printDpiMenu.setEnabled(true);
        this.reopenMenuItem.setEnabled(true);
        this.saveAsMenuItem.setEnabled(true);
        this.initTree();
        if (IS_MAC_OS) {
            this.setTitle(file.getName());
            this.getRootPane().putClientProperty("Window.documentFile", file);
        } else {
            this.setTitle("PDF Debugger - " + file.getAbsolutePath());
        }
        this.addRecentFileItems();
    }

    private void readPDFurl(final String urlString, String password) throws IOException, URISyntaxException {
        if (this.document != null) {
            this.document.close();
            if (!this.currentFilePath.startsWith("http")) {
                this.recentFiles.addFile(this.currentFilePath);
            }
        }
        this.currentFilePath = urlString;
        LogDialog.instance().clear();
        TextDialog.instance().setVisible(false);
        DocumentOpener documentOpener = new DocumentOpener(password){

            @Override
            PDDocument open() throws IOException, URISyntaxException {
                long t0 = System.nanoTime();
                PDDocument doc = Loader.loadPDF((RandomAccessRead)RandomAccessReadBuffer.createBufferFromStream((InputStream)new URI(urlString).toURL().openStream()), (String)this.password);
                long t1 = System.nanoTime();
                long ms = TimeUnit.MILLISECONDS.convert(t1 - t0, TimeUnit.NANOSECONDS);
                LOG.info((Object)("Parsed in " + ms + " ms"));
                return doc;
            }
        };
        this.document = documentOpener.parse();
        this.printMenuItem.setEnabled(true);
        this.printDpiMenu.setEnabled(true);
        this.reopenMenuItem.setEnabled(true);
        this.saveAsMenuItem.setEnabled(true);
        this.initTree();
        if (IS_MAC_OS) {
            this.setTitle(urlString);
        } else {
            this.setTitle("PDF Debugger - " + urlString);
        }
        this.addRecentFileItems();
    }

    public void initTree() {
        TreeStatus treeStatus = new TreeStatus(this.document.getDocument().getTrailer());
        this.statusPane.updateTreeStatus(treeStatus);
        String treeViewMode = TreeViewMenu.getInstance().getTreeViewSelection();
        if ("Show pages".equals(treeViewMode)) {
            File file = new File(this.currentFilePath);
            DocumentEntry documentEntry = new DocumentEntry(this.document, file.getName());
            ZoomMenu.getInstance().resetZoom();
            RotationMenu.getInstance().setRotationSelection("0\u00b0");
            ImageTypeMenu.getInstance().setImageTypeSelection("RGB");
            RenderDestinationMenu.getInstance().setRenderDestinationSelection("Export");
            this.tree.setModel(new PDFTreeModel(documentEntry));
            this.tree.setSelectionPath(this.tree.getPathForRow(1));
        } else if ("Internal structure".equals(treeViewMode)) {
            this.tree.setModel(new PDFTreeModel(this.document));
            this.tree.setSelectionPath(treeStatus.getPathForString("Root"));
            this.tree.setSelectionPath(this.tree.getPathForRow(1));
        } else if ("Cross reference table".equals(treeViewMode)) {
            this.tree.setModel(new PDFTreeModel(new XrefEntries(this.document)));
            this.tree.setSelectionPath(treeStatus.getPathForString("CRT"));
            this.tree.setSelectionPath(this.tree.getPathForRow(1));
        }
    }

    private void addRecentFileItems() {
        AbstractAction recentMenuAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String filePath = (String)((JComponent)actionEvent.getSource()).getClientProperty("path");
                try {
                    PDFDebugger.this.readPDFFile(filePath, "");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        if (!this.recentFiles.isEmpty()) {
            this.recentFilesMenu.removeAll();
            List<String> files = this.recentFiles.getFiles();
            for (int i = files.size() - 1; i >= 0; --i) {
                String path = files.get(i);
                String name = new File(path).getName();
                JMenuItem recentFileMenuItem = new JMenuItem(name);
                recentFileMenuItem.putClientProperty("path", path);
                recentFileMenuItem.addActionListener(recentMenuAction);
                this.recentFilesMenu.add(recentFileMenuItem);
            }
            this.recentFilesMenu.setEnabled(true);
        }
    }

    public static String getPageLabel(PDDocument document, int pageIndex) {
        String[] labels;
        PDPageLabels pageLabels;
        try {
            pageLabels = document.getDocumentCatalog().getPageLabels();
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
        if (pageLabels != null && (labels = pageLabels.getLabelsByPageIndices())[pageIndex] != null) {
            return labels[pageIndex];
        }
        return null;
    }

    private void textDialog(String title, URL resource) {
        try {
            JDialog dialog = new JDialog(this, title, true);
            JEditorPane editor = new JEditorPane(resource);
            editor.setContentType("text/html");
            editor.setEditable(false);
            editor.setBackground(Color.WHITE);
            editor.setPreferredSize(new Dimension(400, 250));
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double screenWidth = screenSize.getWidth();
            double screenHeight = screenSize.getHeight();
            Rectangle parentBounds = this.getBounds();
            editor.addHyperlinkListener(this);
            dialog.add(editor);
            dialog.pack();
            int x = (int)(parentBounds.getX() + (parentBounds.getWidth() - (double)editor.getWidth()) / 2.0);
            int y = (int)(parentBounds.getY() + (parentBounds.getHeight() - (double)editor.getHeight()) / 2.0);
            x = (int)Math.min((double)x, screenWidth * 3.0 / 4.0);
            y = (int)Math.min((double)y, screenHeight * 3.0 / 4.0);
            x = Math.max(0, x);
            y = Math.max(0, y);
            dialog.setLocation(x, y);
            dialog.setVisible(true);
        }
        catch (IOException ex) {
            new ErrorDialog(ex).setVisible(true);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                URL url = he.getURL();
                try (InputStream stream = url.openStream();){
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)baos);
                    JEditorPane editor = new JEditorPane("text/plain", baos.toString(StandardCharsets.UTF_8.name()));
                    editor.setEditable(false);
                    editor.setBackground(Color.WHITE);
                    editor.setCaretPosition(0);
                    editor.setPreferredSize(new Dimension(600, 400));
                    String name = url.toString();
                    name = name.substring(name.lastIndexOf(47) + 1);
                    JDialog dialog = new JDialog(this, "Apache PDFBox: " + name, true);
                    dialog.add(new JScrollPane(editor));
                    dialog.pack();
                    dialog.setVisible(true);
                }
            }
            catch (IOException ex) {
                new ErrorDialog(ex).setVisible(true);
            }
        }
    }

    static {
        SPECIALCOLORSPACES = new HashSet<COSName>(Arrays.asList(COSName.INDEXED, COSName.SEPARATION, COSName.DEVICEN));
        OTHERCOLORSPACES = new HashSet<COSName>(Arrays.asList(COSName.ICCBASED, COSName.PATTERN, COSName.CALGRAY, COSName.CALRGB, COSName.LAB));
        PDF_FILTER = new FileNameExtensionFilter("PDF Files (*.pdf)", "pdf", "PDF");
        OS_NAME = System.getProperty("os.name").toLowerCase();
        IS_MAC_OS = OS_NAME.startsWith("mac os x");
        configuration = new Properties();
    }

    static abstract class DocumentOpener {
        String password;

        DocumentOpener(String password) {
            this.password = password;
        }

        abstract PDDocument open() throws IOException, URISyntaxException;

        final PDDocument parse() throws IOException, URISyntaxException {
            while (true) {
                try {
                    return this.open();
                }
                catch (InvalidPasswordException ipe) {
                    JPanel panel = new JPanel();
                    JLabel label = new JLabel("Password:");
                    JPasswordField pass = new JPasswordField(10);
                    panel.add(label);
                    panel.add(pass);
                    Object[] options = new String[]{"OK", "Cancel"};
                    int option = JOptionPane.showOptionDialog(null, panel, "Enter password", 1, -1, null, options, "");
                    if (option == 0) {
                        this.password = new String(pass.getPassword());
                        continue;
                    }
                    throw ipe;
                }
                break;
            }
        }
    }
}

