/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Registration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import jersey.repackaged.com.google.common.collect.Lists;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.servlet.init.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ServletContainerProviderFactory;
import org.glassfish.jersey.servlet.internal.Utils;
import org.glassfish.jersey.servlet.internal.spi.ServletContainerProvider;

@HandlesTypes(value={Path.class, Provider.class, Application.class, ApplicationPath.class})
public final class JerseyServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(JerseyServletContainerInitializer.class.getName());

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        ServletContainerProvider[] allServletContainerProviders = ServletContainerProviderFactory.getAllServletContainerProviders();
        if (classes == null) {
            classes = Collections.emptySet();
        }
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.preInit(servletContext, classes);
        }
        this.onStartupImpl(classes, servletContext);
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.postInit(servletContext, classes, JerseyServletContainerInitializer.findJerseyServletNames(servletContext));
        }
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.onRegister(servletContext, JerseyServletContainerInitializer.findJerseyServletNames(servletContext));
        }
    }

    private void onStartupImpl(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        for (Class<? extends Application> applicationClass : JerseyServletContainerInitializer.getApplicationClasses(classes)) {
            ServletRegistration servletRegistration = servletContext.getServletRegistration(applicationClass.getName());
            if (servletRegistration != null) {
                JerseyServletContainerInitializer.addServletWithExistingRegistration(servletContext, servletRegistration, applicationClass, classes);
                continue;
            }
            List<Registration> srs = JerseyServletContainerInitializer.getInitParamDeclaredRegistrations(servletContext, applicationClass);
            if (!srs.isEmpty()) {
                for (Registration sr : srs) {
                    if (!(sr instanceof ServletRegistration)) continue;
                    JerseyServletContainerInitializer.addServletWithExistingRegistration(servletContext, (ServletRegistration)sr, applicationClass, classes);
                }
                continue;
            }
            JerseyServletContainerInitializer.addServletWithApplication(servletContext, applicationClass, classes);
        }
        JerseyServletContainerInitializer.addServletWithDefaultConfiguration(servletContext, classes);
    }

    private static Set<String> findJerseyServletNames(ServletContext servletContext) {
        HashSet<String> jerseyServletNames = new HashSet<String>();
        for (ServletRegistration servletRegistration : servletContext.getServletRegistrations().values()) {
            if (!JerseyServletContainerInitializer.isJerseyServlet(servletRegistration.getClassName())) continue;
            jerseyServletNames.add(servletRegistration.getName());
        }
        return Collections.unmodifiableSet(jerseyServletNames);
    }

    private static boolean isJerseyServlet(String className) {
        return ServletContainer.class.getName().equals(className) || "org.glassfish.jersey.servlet.portability.PortableServletContainer".equals(className);
    }

    private static List<Registration> getInitParamDeclaredRegistrations(ServletContext context, Class<? extends Application> clazz) {
        ArrayList registrations = Lists.newArrayList();
        JerseyServletContainerInitializer.collectJaxRsRegistrations(context.getServletRegistrations(), registrations, clazz);
        JerseyServletContainerInitializer.collectJaxRsRegistrations(context.getFilterRegistrations(), registrations, clazz);
        return registrations;
    }

    private static void collectJaxRsRegistrations(Map<String, ? extends Registration> registrations, List<Registration> collected, Class<? extends Application> a) {
        for (Registration registration : registrations.values()) {
            Map ips = registration.getInitParameters();
            if (!ips.containsKey("javax.ws.rs.Application") || !((String)ips.get("javax.ws.rs.Application")).equals(a.getName())) continue;
            collected.add(registration);
        }
    }

    private static void addServletWithDefaultConfiguration(ServletContext context, Set<Class<?>> classes) throws ServletException {
        ServletRegistration registration = context.getServletRegistration(Application.class.getName());
        if (registration != null) {
            Set<Class<?>> appClasses = JerseyServletContainerInitializer.getRootResourceAndProviderClasses(classes);
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(ResourceConfig.class, appClasses).addProperties(JerseyServletContainerInitializer.getInitParams(registration)).addProperties(Utils.getContextParams((ServletContext)context));
            if (registration.getClassName() != null) {
                Utils.store((ResourceConfig)resourceConfig, (ServletContext)context);
            } else {
                ServletContainer servlet = new ServletContainer(resourceConfig);
                registration = context.addServlet(registration.getName(), (Servlet)servlet);
                ((ServletRegistration.Dynamic)registration).setLoadOnStartup(1);
                if (registration.getMappings().isEmpty()) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_NO_MAPPING(registration.getName()));
                } else {
                    LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_CLASSES(registration.getName(), appClasses));
                }
            }
        }
    }

    private static void addServletWithApplication(ServletContext context, Class<? extends Application> clazz, Set<Class<?>> defaultClasses) throws ServletException {
        ApplicationPath ap = clazz.getAnnotation(ApplicationPath.class);
        if (ap != null) {
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(clazz, defaultClasses);
            ServletContainer s = new ServletContainer(resourceConfig);
            ServletRegistration.Dynamic dsr = context.addServlet(clazz.getName(), (Servlet)s);
            dsr.setAsyncSupported(true);
            dsr.setLoadOnStartup(1);
            String mapping = JerseyServletContainerInitializer.createMappingPath(ap);
            if (!JerseyServletContainerInitializer.mappingExists(context, mapping)) {
                dsr.addMapping(new String[]{mapping});
                LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(clazz.getName(), mapping));
            } else {
                LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(clazz.getName(), mapping));
            }
        }
    }

    private static void addServletWithExistingRegistration(ServletContext context, ServletRegistration registration, Class<? extends Application> clazz, Set<Class<?>> classes) throws ServletException {
        ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(clazz, classes).addProperties(JerseyServletContainerInitializer.getInitParams(registration)).addProperties(Utils.getContextParams((ServletContext)context));
        if (registration.getClassName() != null) {
            Utils.store((ResourceConfig)resourceConfig, (ServletContext)context);
        } else {
            ServletContainer servlet = new ServletContainer(resourceConfig);
            ServletRegistration.Dynamic dynamicRegistration = context.addServlet(clazz.getName(), (Servlet)servlet);
            dynamicRegistration.setAsyncSupported(true);
            dynamicRegistration.setLoadOnStartup(1);
            if (dynamicRegistration.getMappings().isEmpty()) {
                ApplicationPath ap = clazz.getAnnotation(ApplicationPath.class);
                if (ap != null) {
                    String mapping = JerseyServletContainerInitializer.createMappingPath(ap);
                    if (!JerseyServletContainerInitializer.mappingExists(context, mapping)) {
                        dynamicRegistration.addMapping(new String[]{mapping});
                        LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(clazz.getName(), mapping));
                    } else {
                        LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(clazz.getName(), mapping));
                    }
                } else {
                    LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_NO_MAPPING_OR_ANNOTATION(clazz.getName(), ApplicationPath.class.getSimpleName()));
                }
            } else {
                LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_APPLICATION(clazz.getName()));
            }
        }
    }

    private static Map<String, Object> getInitParams(ServletRegistration sr) {
        HashMap initParams = Maps.newHashMap();
        for (Map.Entry entry : sr.getInitParameters().entrySet()) {
            initParams.put(entry.getKey(), entry.getValue());
        }
        return initParams;
    }

    private static boolean mappingExists(ServletContext sc, String mapping) {
        for (ServletRegistration sr : sc.getServletRegistrations().values()) {
            for (String declaredMapping : sr.getMappings()) {
                if (!mapping.equals(declaredMapping)) continue;
                return true;
            }
        }
        return false;
    }

    private static String createMappingPath(ApplicationPath ap) {
        String path = ap.value();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/*")) {
            path = path.endsWith("/") ? path + "*" : path + "/*";
        }
        return path;
    }

    private static Set<Class<? extends Application>> getApplicationClasses(Set<Class<?>> classes) {
        LinkedHashSet<Class<? extends Application>> s = new LinkedHashSet<Class<? extends Application>>();
        for (Class<?> c : classes) {
            if (Application.class == c || !Application.class.isAssignableFrom(c)) continue;
            s.add(c.asSubclass(Application.class));
        }
        return s;
    }

    private static Set<Class<?>> getRootResourceAndProviderClasses(Set<Class<?>> classes) {
        LinkedHashSet s = new LinkedHashSet();
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(Path.class) && !c.isAnnotationPresent(Provider.class)) continue;
            s.add(c);
        }
        return s;
    }
}

