/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.MongoCollectionUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicMongoPersistentEntity<T>
extends BasicPersistentEntity<T, MongoPersistentProperty>
implements MongoPersistentEntity<T>,
ApplicationContextAware {
    private static final String AMBIGUOUS_FIELD_MAPPING = "Ambiguous field mapping detected! Both %s and %s map to the same field name %s! Disambiguate using @Field annotation!";
    private final String collection;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final StandardEvaluationContext context = new StandardEvaluationContext();

    public BasicMongoPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation, (Comparator)MongoPersistentPropertyComparator.INSTANCE);
        Document d;
        Class rawType = typeInformation.getType();
        String fallback = MongoCollectionUtils.getPreferredCollectionName(rawType);
        this.collection = rawType.isAnnotationPresent(Document.class) ? (StringUtils.hasText((String)(d = rawType.getAnnotation(Document.class)).collection()) ? d.collection() : fallback) : fallback;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    @Override
    public String getCollection() {
        Expression expression = this.parser.parseExpression(this.collection, ParserContext.TEMPLATE_EXPRESSION);
        return (String)expression.getValue((EvaluationContext)this.context, String.class);
    }

    public void verify() {
        AssertFieldNameUniquenessHandler handler = new AssertFieldNameUniquenessHandler();
        this.doWithProperties(handler);
        this.doWithAssociations(handler);
    }

    protected MongoPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(MongoPersistentProperty property) {
        Assert.notNull((Object)property);
        if (!property.isIdProperty()) {
            return null;
        }
        MongoPersistentProperty currentIdProperty = (MongoPersistentProperty)this.getIdProperty();
        boolean currentIdPropertyIsSet = currentIdProperty != null;
        boolean currentIdPropertyIsExplicit = currentIdPropertyIsSet ? currentIdProperty.isExplicitIdProperty() : false;
        boolean newIdPropertyIsExplicit = property.isExplicitIdProperty();
        if (!currentIdPropertyIsSet) {
            return property;
        }
        Field currentIdPropertyField = currentIdProperty.getField();
        if (newIdPropertyIsExplicit && currentIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add explicit id property %s but already have an property %s registered as explicit id. Check your mapping configuration!", property.getField(), currentIdPropertyField));
        }
        if (newIdPropertyIsExplicit && !currentIdPropertyIsExplicit) {
            return property;
        }
        if (newIdPropertyIsExplicit || !currentIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add id property %s but already have an property %s registered as id. Check your mapping configuration!", property.getField(), currentIdPropertyField));
        }
        return null;
    }

    private static class AssertFieldNameUniquenessHandler
    implements PropertyHandler<MongoPersistentProperty>,
    AssociationHandler<MongoPersistentProperty> {
        private final Map<String, MongoPersistentProperty> properties = new HashMap<String, MongoPersistentProperty>();

        private AssertFieldNameUniquenessHandler() {
        }

        public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
            this.assertUniqueness(persistentProperty);
        }

        public void doWithAssociation(Association<MongoPersistentProperty> association) {
            this.assertUniqueness((MongoPersistentProperty)association.getInverse());
        }

        private void assertUniqueness(MongoPersistentProperty property) {
            String fieldName = property.getFieldName();
            MongoPersistentProperty existingProperty = this.properties.get(fieldName);
            if (existingProperty != null) {
                throw new MappingException(String.format(BasicMongoPersistentEntity.AMBIGUOUS_FIELD_MAPPING, property.toString(), existingProperty.toString(), fieldName));
            }
            this.properties.put(fieldName, property);
        }
    }

    static enum MongoPersistentPropertyComparator implements Comparator<MongoPersistentProperty>
    {
        INSTANCE;


        @Override
        public int compare(MongoPersistentProperty o1, MongoPersistentProperty o2) {
            if (o1.getFieldOrder() == Integer.MAX_VALUE) {
                return 1;
            }
            if (o2.getFieldOrder() == Integer.MAX_VALUE) {
                return -1;
            }
            return o1.getFieldOrder() - o2.getFieldOrder();
        }
    }
}

