/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.util.StringUtils;

public class StringBasedMongoQuery
extends AbstractMongoQuery {
    private static final String COUND_AND_DELETE = "Manually defined query for %s cannot be both a count and delete query at the same time!";
    private static final Logger LOG = LoggerFactory.getLogger(StringBasedMongoQuery.class);
    private static final ParameterBindingParser PARSER = ParameterBindingParser.INSTANCE;
    private final String query;
    private final String fieldSpec;
    private final boolean isCountQuery;
    private final boolean isDeleteQuery;
    private final List<ParameterBinding> queryParameterBindings;
    private final List<ParameterBinding> fieldSpecParameterBindings;

    public StringBasedMongoQuery(MongoQueryMethod method, MongoOperations mongoOperations) {
        this(method.getAnnotatedQuery(), method, mongoOperations);
    }

    public StringBasedMongoQuery(String query, MongoQueryMethod method, MongoOperations mongoOperations) {
        super(method, mongoOperations);
        this.query = query;
        this.queryParameterBindings = PARSER.parseParameterBindingsFrom(query);
        this.fieldSpec = method.getFieldSpecification();
        this.fieldSpecParameterBindings = PARSER.parseParameterBindingsFrom(method.getFieldSpecification());
        this.isCountQuery = method.hasAnnotatedQuery() ? method.getQueryAnnotation().count() : false;
        boolean bl = this.isDeleteQuery = method.hasAnnotatedQuery() ? method.getQueryAnnotation().delete() : false;
        if (this.isCountQuery && this.isDeleteQuery) {
            throw new IllegalArgumentException(String.format(COUND_AND_DELETE, new Object[]{method}));
        }
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        String queryString = this.replacePlaceholders(this.query, accessor, this.queryParameterBindings);
        BasicQuery query = null;
        if (this.fieldSpec != null) {
            String fieldString = this.replacePlaceholders(this.fieldSpec, accessor, this.fieldSpecParameterBindings);
            query = new BasicQuery(queryString, fieldString);
        } else {
            query = new BasicQuery(queryString);
        }
        query.with(accessor.getSort());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Created query %s", ((Query)query).getQueryObject()));
        }
        return query;
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.isDeleteQuery;
    }

    private String replacePlaceholders(String input, ConvertingParameterAccessor accessor, List<ParameterBinding> bindings) {
        if (bindings.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder(input);
        for (ParameterBinding binding : bindings) {
            String parameter = binding.getParameter();
            int idx = result.indexOf(parameter);
            if (idx == -1) continue;
            result.replace(idx, idx + parameter.length(), this.getParameterValueForBinding(accessor, binding));
        }
        return result.toString();
    }

    private String getParameterValueForBinding(ConvertingParameterAccessor accessor, ParameterBinding binding) {
        Object value = accessor.getBindableValue(binding.getParameterIndex());
        if (value instanceof String && binding.isQuoted()) {
            return (String)value;
        }
        return JSON.serialize((Object)value);
    }

    private static class ParameterBinding {
        private final int parameterIndex;
        private final boolean quoted;

        public ParameterBinding(int parameterIndex, boolean quoted) {
            this.parameterIndex = parameterIndex;
            this.quoted = quoted;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String getParameter() {
            return "?" + this.parameterIndex;
        }
    }

    private static enum ParameterBindingParser {
        INSTANCE;

        private static final String PARAMETER_PREFIX = "_param_";
        private static final String PARSEABLE_PARAMETER = "\"_param_$1\"";
        private static final Pattern PARAMETER_BINDING_PATTERN;
        private static final Pattern PARSEABLE_BINDING_PATTERN;
        private static final int PARAMETER_INDEX_GROUP = 1;

        public List<ParameterBinding> parseParameterBindingsFrom(String input) {
            if (!StringUtils.hasText((String)input)) {
                return Collections.emptyList();
            }
            ArrayList<ParameterBinding> bindings = new ArrayList<ParameterBinding>();
            String parseableInput = this.makeParameterReferencesParseable(input);
            this.collectParameterReferencesIntoBindings(bindings, JSON.parse((String)parseableInput));
            return bindings;
        }

        private String makeParameterReferencesParseable(String input) {
            Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(input);
            String parseableInput = matcher.replaceAll(PARSEABLE_PARAMETER);
            return parseableInput;
        }

        private void collectParameterReferencesIntoBindings(List<ParameterBinding> bindings, Object value) {
            block4: {
                block5: {
                    block3: {
                        if (!(value instanceof String)) break block3;
                        String string = ((String)value).trim();
                        Matcher valueMatcher = PARSEABLE_BINDING_PATTERN.matcher(string);
                        while (valueMatcher.find()) {
                            int paramIndex = Integer.parseInt(valueMatcher.group(1));
                            boolean quoted = string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"");
                            bindings.add(new ParameterBinding(paramIndex, quoted));
                        }
                        break block4;
                    }
                    if (!(value instanceof Pattern)) break block5;
                    String string = ((Pattern)value).toString().trim();
                    Matcher valueMatcher = PARSEABLE_BINDING_PATTERN.matcher(string);
                    while (valueMatcher.find()) {
                        int paramIndex = Integer.parseInt(valueMatcher.group(1));
                        boolean quoted = !string.equals(PARAMETER_PREFIX + paramIndex);
                        bindings.add(new ParameterBinding(paramIndex, quoted));
                    }
                    break block4;
                }
                if (!(value instanceof DBObject)) break block4;
                DBObject dbo = (DBObject)value;
                for (String field : dbo.keySet()) {
                    this.collectParameterReferencesIntoBindings(bindings, field);
                    this.collectParameterReferencesIntoBindings(bindings, dbo.get(field));
                }
            }
        }

        static {
            PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
            PARSEABLE_BINDING_PATTERN = Pattern.compile("\"?_param_(\\d+)\"?");
        }
    }
}

