/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.resource.ClientResources;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Deprecated
public class DefaultLettucePool
implements LettucePool,
InitializingBean {
    @Nullable
    private GenericObjectPool<StatefulConnection<byte[], byte[]>> internalPool;
    @Nullable
    private RedisClient client;
    private int dbIndex = 0;
    private GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
    private String hostName = "localhost";
    private int port = 6379;
    @Nullable
    private String password;
    private long timeout = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    @Nullable
    private RedisSentinelConfiguration sentinelConfiguration;
    @Nullable
    private ClientResources clientResources;

    public DefaultLettucePool() {
    }

    public DefaultLettucePool(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public DefaultLettucePool(RedisSentinelConfiguration sentinelConfiguration) {
        this.sentinelConfiguration = sentinelConfiguration;
    }

    public DefaultLettucePool(String hostName, int port, GenericObjectPoolConfig poolConfig) {
        this.hostName = hostName;
        this.port = port;
        this.poolConfig = poolConfig;
    }

    public boolean isRedisSentinelAware() {
        return this.sentinelConfiguration != null;
    }

    public void afterPropertiesSet() {
        this.client = this.clientResources != null ? RedisClient.create((ClientResources)this.clientResources, (RedisURI)this.getRedisURI()) : RedisClient.create((RedisURI)this.getRedisURI());
        this.client.setDefaultTimeout(this.timeout, TimeUnit.MILLISECONDS);
        this.internalPool = new GenericObjectPool((PooledObjectFactory)new LettuceFactory(this.client, this.dbIndex), this.poolConfig);
    }

    private RedisURI getRedisURI() {
        RedisURI redisUri;
        RedisURI redisURI = redisUri = this.isRedisSentinelAware() ? LettuceConverters.sentinelConfigurationToRedisURI(this.sentinelConfiguration) : this.createSimpleHostRedisURI();
        if (StringUtils.hasText((String)this.password)) {
            redisUri.setPassword(this.password);
        }
        return redisUri;
    }

    private RedisURI createSimpleHostRedisURI() {
        return RedisURI.Builder.redis((String)this.hostName, (int)this.port).withTimeout(this.timeout, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public StatefulConnection<byte[], byte[]> getResource() {
        try {
            return (StatefulConnection)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    @Override
    public void returnBrokenResource(StatefulConnection<byte[], byte[]> resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not invalidate the broken resource", e);
        }
    }

    @Override
    public void returnResource(StatefulConnection<byte[], byte[]> resource) {
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not return the resource to the pool", e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.client.shutdown();
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new PoolException("Could not destroy the pool", e);
        }
    }

    @Nullable
    public RedisClient getClient() {
        return this.client;
    }

    public GenericObjectPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public ClientResources getClientResources() {
        return this.clientResources;
    }

    public void setClientResources(ClientResources clientResources) {
        this.clientResources = clientResources;
    }

    private static class LettuceFactory
    extends BasePooledObjectFactory<StatefulConnection<byte[], byte[]>> {
        private final RedisClient client;
        private int dbIndex;

        public LettuceFactory(RedisClient client, int dbIndex) {
            this.client = client;
            this.dbIndex = dbIndex;
        }

        public void activateObject(PooledObject<StatefulConnection<byte[], byte[]>> pooledObject) throws Exception {
            if (pooledObject.getObject() instanceof StatefulRedisConnection) {
                ((StatefulRedisConnection)pooledObject.getObject()).sync().select(this.dbIndex);
            }
        }

        public void destroyObject(PooledObject<StatefulConnection<byte[], byte[]>> obj) throws Exception {
            try {
                ((StatefulConnection)obj.getObject()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean validateObject(PooledObject<StatefulConnection<byte[], byte[]>> obj) {
            try {
                if (obj.getObject() instanceof StatefulRedisConnection) {
                    ((StatefulRedisConnection)obj.getObject()).sync().ping();
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public StatefulConnection<byte[], byte[]> create() throws Exception {
            return this.client.connect(LettuceConnection.CODEC);
        }

        public PooledObject<StatefulConnection<byte[], byte[]>> wrap(StatefulConnection<byte[], byte[]> obj) {
            return new DefaultPooledObject(obj);
        }
    }
}

