/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public class Bloom {
    private static final int BYTES_LENGTH = 256;
    private final byte[] bytes = new byte[256];

    public static boolean test(byte[] bloomBytes, byte[] ... topics) {
        Bloom bloom = new Bloom(bloomBytes);
        if (topics == null) {
            throw new IllegalArgumentException("topics can not be null");
        }
        for (byte[] topic : topics) {
            if (bloom.test(topic)) continue;
            return false;
        }
        return true;
    }

    public static boolean test(String bloomBytes, String ... topics) {
        Bloom bloom = new Bloom(bloomBytes);
        if (topics == null) {
            throw new IllegalArgumentException("topics can not be null");
        }
        for (String topic : topics) {
            if (bloom.test(topic)) continue;
            return false;
        }
        return true;
    }

    public Bloom() {
    }

    public Bloom(String bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes can not be null");
        }
        this.setBytes(Numeric.hexStringToByteArray(bytes));
    }

    public Bloom(byte[] bytes) {
        this.setBytes(bytes);
    }

    public void add(String topic) {
        if (topic == null) {
            throw new IllegalArgumentException("topic can not be null");
        }
        this.add(Numeric.hexStringToByteArray(topic));
    }

    public void add(byte[] topic) {
        if (topic == null) {
            throw new IllegalArgumentException("topic can not be null");
        }
        BloomValues b = this.getBloomValues(topic);
        int n = b.index[0];
        this.bytes[n] = (byte)(this.bytes[n] | b.value[0]);
        int n2 = b.index[1];
        this.bytes[n2] = (byte)(this.bytes[n2] | b.value[1]);
        int n3 = b.index[2];
        this.bytes[n3] = (byte)(this.bytes[n3] | b.value[2]);
    }

    public boolean test(String topic) {
        if (topic == null) {
            throw new IllegalArgumentException("topic can not be null");
        }
        return this.test(Numeric.hexStringToByteArray(topic));
    }

    public boolean test(byte[] topic) {
        BloomValues b = this.getBloomValues(topic);
        return b.value[0] == (b.value[0] & this.bytes[b.index[0]]) && b.value[1] == (b.value[1] & this.bytes[b.index[1]]) && b.value[2] == (b.value[2] & this.bytes[b.index[2]]);
    }

    public String toString() {
        return this.getBytesHexString();
    }

    public String getBytesHexString() {
        return Numeric.toHexString(this.bytes);
    }

    public byte[] getBytes() {
        byte[] bytesCopy = new byte[256];
        System.arraycopy(this.bytes, 0, bytesCopy, 0, 256);
        return bytesCopy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bloom bloom = (Bloom)o;
        return Arrays.equals(this.bytes, bloom.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    private void setBytes(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes can not be null");
        }
        if (bytes.length != 256) {
            throw new IllegalArgumentException("bytes must be 256 in length");
        }
        System.arraycopy(bytes, 0, this.bytes, 0, 256);
    }

    private BloomValues getBloomValues(byte[] item) {
        byte[] hash = Hash.sha3(item);
        byte v1 = (byte)(1 << (hash[1] & 7));
        byte v2 = (byte)(1 << (hash[3] & 7));
        byte v3 = (byte)(1 << (hash[5] & 7));
        ByteBuffer byteBuffer = ByteBuffer.wrap(hash).order(ByteOrder.BIG_ENDIAN);
        int i1 = 256 - ((byteBuffer.getShort(0) & 0x7FF) >> 3) - 1;
        int i2 = 256 - ((byteBuffer.getShort(2) & 0x7FF) >> 3) - 1;
        int i3 = 256 - ((byteBuffer.getShort(4) & 0x7FF) >> 3) - 1;
        return new BloomValues(new byte[]{v1, v2, v3}, new int[]{i1, i2, i3});
    }

    private record BloomValues(byte[] value, int[] index) {
    }
}

