/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.example;

import java.util.Date;
import java.util.List;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.model.OOSpider;
import us.codecraft.webmagic.model.annotation.ExtractBy;
import us.codecraft.webmagic.model.annotation.TargetUrl;
import us.codecraft.webmagic.pipeline.JsonFilePageModelPipeline;

@TargetUrl(value={"http://my.oschina.net/flashsword/blog/\\d+"})
public class OschinaBlog {
    @ExtractBy(value="//title/text()")
    private String title;
    @ExtractBy(value="div.BlogContent", type=ExtractBy.Type.Css)
    private String content;
    @ExtractBy(value="//div[@class='BlogTags']/a/text()", multi=true)
    private List<String> tags;
    @ExtractBy(value="//div[@class='BlogStat']/regex('\\d+-\\d+-\\d+\\s+\\d+:\\d+')")
    private Date date;

    public static void main(String[] args) {
        OOSpider.create(Site.me(), new JsonFilePageModelPipeline("/data/webmagic/"), OschinaBlog.class).addUrl(new String[]{"http://my.oschina.net/flashsword/blog"}).run();
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Date getDate() {
        return this.date;
    }
}

