/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.model;

import java.util.ArrayList;
import java.util.List;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.model.ModelPageProcessor;
import us.codecraft.webmagic.model.ModelPipeline;
import us.codecraft.webmagic.model.PageModelCollectorPipeline;
import us.codecraft.webmagic.pipeline.CollectorPipeline;
import us.codecraft.webmagic.pipeline.PageModelPipeline;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

public class OOSpider<T>
extends Spider {
    private ModelPageProcessor modelPageProcessor;
    private ModelPipeline modelPipeline;
    private PageModelPipeline pageModelPipeline;
    private List<Class> pageModelClasses = new ArrayList<Class>();

    protected OOSpider(ModelPageProcessor modelPageProcessor) {
        super((PageProcessor)modelPageProcessor);
        this.modelPageProcessor = modelPageProcessor;
    }

    public OOSpider(PageProcessor pageProcessor) {
        super(pageProcessor);
    }

    public OOSpider(Site site, PageModelPipeline pageModelPipeline, Class ... pageModels) {
        this(ModelPageProcessor.create(site, pageModels));
        this.modelPipeline = new ModelPipeline();
        super.addPipeline((Pipeline)this.modelPipeline);
        for (Class pageModel : pageModels) {
            if (pageModelPipeline != null) {
                this.modelPipeline.put(pageModel, pageModelPipeline);
            }
            this.pageModelClasses.add(pageModel);
        }
    }

    protected CollectorPipeline getCollectorPipeline() {
        return new PageModelCollectorPipeline(this.pageModelClasses.get(0));
    }

    public static OOSpider create(Site site, Class ... pageModels) {
        return new OOSpider(site, null, pageModels);
    }

    public static OOSpider create(Site site, PageModelPipeline pageModelPipeline, Class ... pageModels) {
        return new OOSpider(site, pageModelPipeline, pageModels);
    }

    public OOSpider addPageModel(PageModelPipeline pageModelPipeline, Class ... pageModels) {
        for (Class pageModel : pageModels) {
            this.modelPageProcessor.addPageModel(pageModel);
            this.modelPipeline.put(pageModel, pageModelPipeline);
        }
        return this;
    }

    public OOSpider setIsExtractLinks(boolean isExtractLinks) {
        this.modelPageProcessor.setExtractLinks(isExtractLinks);
        return this;
    }
}

