/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j;

import cn.teaey.apns4j.ApnsHelper;
import cn.teaey.apns4j.keystore.KeyStoreGetter;
import cn.teaey.apns4j.keystore.KeyStoreType;
import cn.teaey.apns4j.network.ApnsChannelFactory;
import cn.teaey.apns4j.network.ApnsGateway;
import cn.teaey.apns4j.network.SecuritySocketFactory;
import cn.teaey.apns4j.protocol.ApnsPayload;
import java.io.File;
import java.io.InputStream;

public class Apns4j {
    public static final ApnsPayload newPayload() {
        return new ApnsPayload();
    }

    public static final ApnsChannelFactoryBuilder newChannelFactoryBuilder() {
        return new ApnsChannelFactoryBuilder();
    }

    public static final class ApnsChannelFactoryBuilder {
        private Object keyStoreMeta;
        private String keyStorePwd;
        private ApnsGateway apnsGateway = ApnsGateway.DEVELOPMENT;
        private KeyStoreType keyStoreType = KeyStoreType.PKCS12;

        public ApnsChannelFactoryBuilder keyStoreMeta(Object keyStoreMeta) {
            ApnsHelper.checkNullThrowException(keyStoreMeta, "keyStoreMeta");
            this.keyStoreMeta = keyStoreMeta;
            return this;
        }

        public ApnsChannelFactoryBuilder keyStorePwd(String keyStorePwd) {
            ApnsHelper.checkNullThrowException(keyStorePwd, "keyStorePwd");
            this.keyStorePwd = keyStorePwd;
            return this;
        }

        public ApnsChannelFactoryBuilder apnsGateway(ApnsGateway apnsGateway) {
            ApnsHelper.checkNullThrowException((Object)apnsGateway, "apnsGateway");
            this.apnsGateway = apnsGateway;
            return this;
        }

        public ApnsChannelFactoryBuilder keyStoreType(KeyStoreType keyStoreType) {
            ApnsHelper.checkNullThrowException((Object)keyStoreType, "keyStoreType");
            this.keyStoreType = keyStoreType;
            return this;
        }

        public ApnsChannelFactory build() {
            KeyStoreGetter keyStoreGetter = null;
            if (this.keyStoreMeta instanceof String) {
                keyStoreGetter = new KeyStoreGetter((String)this.keyStoreMeta, this.keyStorePwd, this.keyStoreType);
            } else if (this.keyStoreMeta instanceof File) {
                keyStoreGetter = new KeyStoreGetter((File)this.keyStoreMeta, this.keyStorePwd, this.keyStoreType);
            } else if (this.keyStoreMeta instanceof InputStream) {
                keyStoreGetter = new KeyStoreGetter((InputStream)this.keyStoreMeta, this.keyStorePwd, this.keyStoreType);
            }
            if (null == keyStoreGetter) {
                throw new IllegalArgumentException(this.keyStoreMeta.getClass().getName());
            }
            SecuritySocketFactory securitySocketFactory = new SecuritySocketFactory(this.apnsGateway.host(), this.apnsGateway.port(), keyStoreGetter.keyStore(), keyStoreGetter.keyStorePwd());
            return new ApnsChannelFactory(securitySocketFactory);
        }
    }
}

