/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.keystore;

import cn.teaey.apns4j.ApnsException;
import cn.teaey.apns4j.ApnsHelper;
import cn.teaey.apns4j.keystore.InvalidKeyStoreFormatException;
import cn.teaey.apns4j.keystore.InvalidKeyStorePasswordException;
import cn.teaey.apns4j.keystore.InvalidKeyStoreTypeException;
import cn.teaey.apns4j.keystore.KeyStoreType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;

public class KeyStoreGetter {
    private final InputStream keyStoreInputStream;
    private final String keyStorePwd;
    private final KeyStoreType keyStoreType;

    public KeyStoreGetter(InputStream keyStoreInputStream, String keyStorePwd, KeyStoreType keyStoreType) {
        ApnsHelper.checkNullThrowException(keyStoreInputStream, "keyStoreInputStream");
        ApnsHelper.checkNullThrowException((Object)keyStoreType, "keyStoreType");
        this.keyStoreInputStream = keyStoreInputStream;
        this.keyStorePwd = keyStorePwd;
        this.keyStoreType = keyStoreType;
    }

    public KeyStoreGetter(File keyStoreFile, String keyStorePwd, KeyStoreType keyStoreType) {
        ApnsHelper.checkNullThrowException(keyStoreFile, "keyStoreFile");
        ApnsHelper.checkNullThrowException((Object)keyStoreType, "keyStoreType");
        try {
            this.keyStoreInputStream = new FileInputStream(keyStoreFile);
        }
        catch (FileNotFoundException e) {
            throw new ApnsException(e);
        }
        this.keyStorePwd = keyStorePwd;
        this.keyStoreType = keyStoreType;
    }

    public KeyStoreGetter(String keyStoreFilePath, String keyStorePwd, KeyStoreType keyStoreType) {
        ApnsHelper.checkNullThrowException(keyStoreFilePath, "keyStoreFilePath");
        ApnsHelper.checkNullThrowException((Object)keyStoreType, "keyStoreType");
        try {
            this.keyStoreInputStream = new FileInputStream(keyStoreFilePath);
        }
        catch (FileNotFoundException e) {
            throw new ApnsException(e);
        }
        this.keyStorePwd = keyStorePwd;
        this.keyStoreType = keyStoreType;
    }

    public KeyStoreGetter(InputStream keyStoreInputStream, String keyStorePwd) {
        ApnsHelper.checkNullThrowException(keyStoreInputStream, "keyStoreInputStream");
        this.keyStoreInputStream = keyStoreInputStream;
        this.keyStorePwd = keyStorePwd;
        this.keyStoreType = KeyStoreType.PKCS12;
    }

    public KeyStoreGetter(File keyStoreFile, String keyStorePwd) {
        ApnsHelper.checkNullThrowException(keyStoreFile, "keyStoreFile");
        try {
            this.keyStoreInputStream = new FileInputStream(keyStoreFile);
        }
        catch (FileNotFoundException e) {
            throw new ApnsException(e);
        }
        this.keyStorePwd = keyStorePwd;
        this.keyStoreType = KeyStoreType.PKCS12;
    }

    public KeyStoreGetter(String keyStoreFilePath, String keyStorePwd) {
        ApnsHelper.checkNullThrowException(keyStoreFilePath, "keyStoreFilePath");
        try {
            this.keyStoreInputStream = new FileInputStream(keyStoreFilePath);
        }
        catch (FileNotFoundException e) {
            throw new ApnsException(e);
        }
        this.keyStorePwd = keyStorePwd;
        this.keyStoreType = KeyStoreType.PKCS12;
    }

    public KeyStore keyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreType.name());
            keyStore.load(this.keyStoreInputStream, null == this.keyStorePwd ? new char[]{} : this.keyStorePwd.toCharArray());
            return keyStore;
        }
        catch (KeyStoreException e) {
            if (e.getCause() instanceof NoSuchAlgorithmException || e.getCause() instanceof NoSuchProviderException) {
                throw new ApnsException(new InvalidKeyStoreTypeException("(" + (Object)((Object)this.keyStoreType) + ")", e));
            }
            throw new ApnsException(new InvalidKeyStoreTypeException(e));
        }
        catch (CertificateException e) {
            throw new ApnsException(new InvalidKeyStoreFormatException("cant load keystore", e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApnsException(new InvalidKeyStoreFormatException("cant load keystore", e));
        }
        catch (IOException e) {
            if (e.getCause() instanceof BadPaddingException) {
                throw new ApnsException(new InvalidKeyStorePasswordException("(" + this.keyStorePwd + ")", e));
            }
            throw new ApnsException(new InvalidKeyStoreFormatException(e));
        }
    }

    public String keyStorePwd() {
        return this.keyStorePwd;
    }
}

