/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.network.async;

import cn.teaey.apns4j.ApnsException;
import cn.teaey.apns4j.ApnsHelper;
import cn.teaey.apns4j.network.ApnsChannelFactory;
import cn.teaey.apns4j.network.async.ApnsFuture;
import cn.teaey.apns4j.network.async.AsyncServiceShutdownException;
import cn.teaey.apns4j.network.async.PayloadSender;
import cn.teaey.apns4j.protocol.ApnsPayload;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ApnsService
implements PayloadSender<ApnsPayload> {
    private static final int processors = Runtime.getRuntime().availableProcessors();
    private final int size;
    private final ApnsChannelFactory apnsChannelFactory;
    private final ExecutorService executorService;
    private final ExecutorService errorExecutor;
    private final AtomicBoolean START = new AtomicBoolean(true);
    private final int tryTimes;
    private final ThreadLocal<PayloadSender<ApnsPayload>> threadSelfConnection = new ThreadLocal(){

        protected PayloadSender<ApnsPayload> initialValue() {
            return ApnsService.this.apnsChannelFactory.newChannel();
        }
    };

    public ApnsService(int executorSize, ApnsChannelFactory apnsChannelFactory, int tryTimes) {
        this.size = executorSize > processors ? processors : executorSize;
        this.apnsChannelFactory = apnsChannelFactory;
        this.executorService = Executors.newFixedThreadPool(this.size);
        this.errorExecutor = Executors.newFixedThreadPool(1);
        this.tryTimes = tryTimes;
    }

    @Override
    public ApnsFuture send(String deviceToken, ApnsPayload payload) {
        return this.send(ApnsHelper.toByteArray(deviceToken), payload);
    }

    @Override
    public ApnsFuture send(byte[] deviceToken, ApnsPayload payload) {
        if (!this.START.get()) {
            throw new AsyncServiceShutdownException("AsynService has shutdown");
        }
        Future<Object> f = this.executorService.submit(new APNSAsynTask(deviceToken, payload));
        return new ApnsFuture(f, deviceToken, payload);
    }

    public void shutdown() {
        if (this.START.compareAndSet(true, false)) {
            this.executorService.shutdown();
        }
    }

    public void shutdownNow() {
        if (this.START.compareAndSet(true, false)) {
            this.executorService.shutdownNow();
        }
    }

    public void shutdown(long timeout, TimeUnit timeUnit) {
        if (this.START.compareAndSet(true, false)) {
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                throw new ApnsException(e);
            }
        }
    }

    class APNSAsynTask
    implements Callable<Object> {
        private final byte[] deviceToken;
        private final ApnsPayload payload;

        public APNSAsynTask(byte[] deviceToken, ApnsPayload payload) {
            this.deviceToken = deviceToken;
            this.payload = payload;
        }

        @Override
        public Object call() {
            try {
                return ((PayloadSender)ApnsService.this.threadSelfConnection.get()).send(this.deviceToken, this.payload);
            }
            catch (Exception e) {
                return e;
            }
        }
    }
}

