/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.protocol;

import cn.teaey.apns4j.protocol.InvalidErrorResponse;
import java.nio.ByteBuffer;

public class ErrorResp {
    private final byte command;
    private final Status status;
    private final int identifier;

    public ErrorResp(byte[] data) {
        if (null == data || data.length != 6) {
            throw new InvalidErrorResponse("");
        }
        ByteBuffer wrapper = ByteBuffer.wrap(data);
        this.command = wrapper.get();
        this.status = Status.resolove(wrapper.get());
        this.identifier = wrapper.getInt();
    }

    public ErrorResp(byte command, byte status, int identifier) {
        this.command = command;
        this.status = Status.resolove(status);
        this.identifier = identifier;
    }

    public byte getCommand() {
        return this.command;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return "ErrorResp{command=" + this.command + ", status=" + (Object)((Object)this.status) + ", identifier=" + this.identifier + '}';
    }

    public static enum Status {
        OK(0, "No errors encountered"),
        ERROR(Integer.MAX_VALUE, "Unknown"),
        ERROR1(1, "Processing error"),
        ERROR2(2, "Missing device token"),
        ERROR3(3, "Missing topic"),
        ERROR4(4, "Missing payload"),
        ERROR5(5, "Invalid token size"),
        ERROR6(6, "Invalid topic size"),
        ERROR7(7, "Invalid payload size"),
        ERROR8(8, "Invalid token"),
        ERROR10(10, "Shutdown"),
        ERROR255(255, "None (unknown)");

        int code;
        String desc;

        private Status(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static Status resolove(int code) {
            for (Status each : Status.values()) {
                if (each.code != code) continue;
                return each;
            }
            return ERROR;
        }
    }
}

