/*
 * Decompiled with CFR 0.152.
 */
package cn.teaey.apns4j.protocol;

import cn.teaey.apns4j.protocol.Protocal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private static final char DOUBLE_QUOTE = '\"';
    private static final char COLON = ':';
    private static final char BRACE_L = '{';
    private static final char BRACE_R = '}';
    private static final char BRACKETS_L = '[';
    private static final char BRACKETS_R = ']';
    private static final char COMMA = ',';

    public static byte[] toJsonBytes(Map<String, Object> root) {
        return JsonParser.toBytes(JsonParser.toJsonString(root));
    }

    public static byte[] toBytes(String jsonString) {
        return jsonString.getBytes(Protocal.DEF_CHARSET);
    }

    public static String toJsonString(Map<String, Object> root) {
        StringBuilder sb = new StringBuilder(32);
        JsonParser.append(sb, root);
        int deleteIndex = -1;
        while ((deleteIndex = sb.indexOf(",}")) != -1) {
            sb.deleteCharAt(deleteIndex);
        }
        String ret = sb.toString();
        return ret;
    }

    static void append(StringBuilder sb, Map<String, Object> jsonMeta) {
        sb.append('{');
        Iterator<String> iter = jsonMeta.keySet().iterator();
        while (iter.hasNext()) {
            String eachKey = iter.next();
            Object eachValue = jsonMeta.get(eachKey);
            sb.append('\"').append(eachKey).append('\"').append(':');
            if (eachValue instanceof Map) {
                JsonParser.append(sb, (Map)eachValue);
            } else if (eachValue instanceof List) {
                List list = (List)eachValue;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    Object value = list.get(i);
                    if (i == 0) {
                        sb.append('[');
                    }
                    sb.append(value.toString());
                    if (i == size - 1) {
                        sb.append(']');
                        continue;
                    }
                    sb.append(',');
                }
            } else if (eachValue instanceof String) {
                sb.append('\"').append(eachValue).append('\"');
            } else {
                sb.append(eachValue);
            }
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
    }
}

