/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.graphql;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.integration.graphql.DefaultFetchMapping;
import com.blazebit.persistence.integration.graphql.GraphQLCursor;
import com.blazebit.persistence.integration.graphql.GraphQLDefaultFetch;
import com.blazebit.persistence.integration.graphql.GraphQLEntityViewSupport;
import com.blazebit.persistence.integration.graphql.KotlinSupport;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.view.CreatableEntityView;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.UpdatableEntityView;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.metamodel.FlatViewType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.reflection.ReflectionUtils;
import graphql.language.Description;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class GraphQLEntityViewSupportFactory {
    private static final Map<Class<?>, String> BASIC_TYPES;
    private static final Map<Class<?>, String> SUPPORTED_TYPES;
    private static final String[] JAVA_TIME_SER_TYPES;
    private boolean defineNormalTypes;
    private boolean defineRelayTypes;
    private boolean defineNonInputTypesForUpdatableOrCreatableEntityViews;
    private Boolean implementRelayNode;
    private boolean defineRelayNodeIfNotExist;
    private boolean defineDedicatedRelayNodes;
    private Pattern typeFilterPattern;
    private Predicate<ManagedViewType<?>> typeInclusionPredicate;
    private Map<String, GraphQLScalarType> scalarTypeMap;
    private Set<String> registeredScalarTypeNames;
    private Set<String> additionalSerializableBasicTypes;

    public GraphQLEntityViewSupportFactory(boolean defineNormalTypes, boolean defineRelayTypes) {
        this.defineNormalTypes = defineNormalTypes;
        this.defineRelayTypes = defineRelayTypes;
    }

    public boolean isDefineNormalTypes() {
        return this.defineNormalTypes;
    }

    public void setDefineNormalTypes(boolean defineNormalTypes) {
        this.defineNormalTypes = defineNormalTypes;
    }

    public boolean isDefineRelayTypes() {
        return this.defineRelayTypes;
    }

    public void setDefineRelayTypes(boolean defineRelayTypes) {
        this.defineRelayTypes = defineRelayTypes;
    }

    public boolean isDefineNonInputTypesForUpdatableOrCreatableEntityViews() {
        return this.defineNonInputTypesForUpdatableOrCreatableEntityViews;
    }

    public void setDefineNonInputTypesForUpdatableOrCreatableEntityViews(boolean defineNonInputTypesForUpdatableOrCreatableEntityViews) {
        this.defineNonInputTypesForUpdatableOrCreatableEntityViews = defineNonInputTypesForUpdatableOrCreatableEntityViews;
    }

    public boolean isImplementRelayNode() {
        return this.implementRelayNode == null ? this.defineRelayNodeIfNotExist : this.implementRelayNode;
    }

    public void setImplementRelayNode(boolean implementRelayNode) {
        this.implementRelayNode = implementRelayNode;
    }

    public boolean isDefineRelayNodeIfNotExist() {
        return this.defineRelayNodeIfNotExist;
    }

    public void setDefineRelayNodeIfNotExist(boolean defineRelayNodeIfNotExist) {
        this.defineRelayNodeIfNotExist = defineRelayNodeIfNotExist;
    }

    public boolean isDefineDedicatedRelayNodes() {
        return this.defineDedicatedRelayNodes;
    }

    public void setDefineDedicatedRelayNodes(boolean defineDedicatedRelayNodes) {
        this.defineDedicatedRelayNodes = defineDedicatedRelayNodes;
    }

    public boolean isRegisterScalarTypeDefinitions() {
        return this.registeredScalarTypeNames != null;
    }

    public void setRegisterScalarTypeDefinitions(boolean registerScalarTypeDefinitions) {
        this.registeredScalarTypeNames = registerScalarTypeDefinitions ? new HashSet<String>() : null;
    }

    public Map<String, GraphQLScalarType> getScalarTypeMap() {
        return this.scalarTypeMap;
    }

    public void setScalarTypeMap(Map<String, GraphQLScalarType> scalarTypeMap) {
        this.scalarTypeMap = scalarTypeMap;
    }

    public Pattern getTypeFilterPattern() {
        return this.typeFilterPattern;
    }

    public void setTypeFilterPattern(Pattern typeFilterPattern) {
        this.typeFilterPattern = typeFilterPattern;
    }

    public Predicate<ManagedViewType<?>> getTypeInclusionPredicate() {
        return this.typeInclusionPredicate;
    }

    public void setTypeInclusionPredicate(Predicate<ManagedViewType<?>> typeInclusionPredicate) {
        this.typeInclusionPredicate = typeInclusionPredicate;
    }

    public Set<String> getAdditionalSerializableBasicTypes() {
        return this.additionalSerializableBasicTypes;
    }

    public void setAdditionalSerializableBasicTypes(Set<String> additionalSerializableBasicTypes) {
        this.additionalSerializableBasicTypes = additionalSerializableBasicTypes;
    }

    /*
     * Could not resolve type clashes
     */
    public GraphQLEntityViewSupport create(TypeDefinitionRegistry typeRegistry, EntityViewManager entityViewManager) {
        EntityMetamodel entityMetamodel = (EntityMetamodel)entityViewManager.getService(EntityMetamodel.class);
        HashMap typeNameToViewType = new HashMap();
        HashMap<String, Map<String, String>> typeNameToFieldMapping = new HashMap<String, Map<String, String>>();
        HashMap<String, Set<DefaultFetchMapping>> typeNameToDefaultFetchMappings = new HashMap<String, Set<DefaultFetchMapping>>();
        List<Object> defaultImplementsTypes = this.isImplementRelayNode() ? Collections.singletonList(new TypeName("Node")) : Collections.emptyList();
        HashMap<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph = this.determineViewsForSchema(entityViewManager);
        Set<ManagedViewType<?>> managedViews = usageGraph.keySet();
        for (ManagedViewType managedView : managedViews) {
            List<Object> implementsTypes;
            String fieldName;
            String typeName = this.getObjectTypeName(managedView);
            String inputTypeName = typeName + "Input";
            String description = this.getDescription(managedView.getJavaType());
            ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>(managedView.getAttributes().size());
            ArrayList<InputValueDefinition> valueDefinitions = new ArrayList<InputValueDefinition>(managedView.getAttributes().size());
            HashSet<String> fieldNames = new HashSet<String>();
            for (MethodAttribute attribute : managedView.getAttributes()) {
                Type inputType;
                Type type;
                if (this.isIgnored(attribute.getJavaMethod())) continue;
                if (attribute instanceof SingularAttribute) {
                    SingularAttribute singularAttribute = (SingularAttribute)attribute;
                    if (singularAttribute.isId() && !singularAttribute.isSubview()) {
                        type = this.getIdType(typeRegistry, singularAttribute);
                        inputType = this.getInputIdType(typeRegistry, singularAttribute);
                    } else {
                        type = this.getElementType(typeRegistry, singularAttribute, entityMetamodel);
                        inputType = this.getInputElementType(typeRegistry, singularAttribute, entityMetamodel);
                    }
                } else if (attribute instanceof MapAttribute) {
                    MapAttribute mapAttribute = (MapAttribute)attribute;
                    type = this.getEntryType(typeRegistry, attribute, this.getKeyType(typeRegistry, mapAttribute), this.getElementType(typeRegistry, (PluralAttribute<?, ?, ?>)mapAttribute));
                    inputType = this.getInputEntryType(typeRegistry, attribute, this.getInputKeyType(typeRegistry, mapAttribute), this.getInputElementType(typeRegistry, (PluralAttribute<?, ?, ?>)mapAttribute));
                } else {
                    type = this.makeNonNull((Type<?>)this.getListType(this.getElementType(typeRegistry, (PluralAttribute)attribute)));
                    inputType = this.getListType(this.getInputElementType(typeRegistry, (PluralAttribute)attribute));
                    if (inputType != null && this.isNotNull(attribute.getJavaMethod())) {
                        inputType = this.makeNonNull(inputType);
                    }
                }
                if (type == null) continue;
                fieldName = this.getFieldName(attribute);
                FieldDefinition fieldDefinition = new FieldDefinition(fieldName, type);
                fieldDefinitions.add(fieldDefinition);
                fieldNames.add(fieldName);
                this.addFieldMapping(typeNameToFieldMapping, typeNameToDefaultFetchMappings, managedViews, typeName, "", attribute, fieldName);
                if (this.isDefineRelayTypes() && this.isDefineDedicatedRelayNodes()) {
                    this.addFieldMapping(typeNameToFieldMapping, typeNameToDefaultFetchMappings, managedViews, typeName, "Node", attribute, fieldName);
                }
                if (!this.needsDefinitionInInputType(attribute)) continue;
                valueDefinitions.add(new InputValueDefinition(fieldName, inputType));
                this.addFieldMapping(typeNameToFieldMapping, typeNameToDefaultFetchMappings, managedViews, typeName, "Input", attribute, fieldName);
            }
            for (Method method : managedView.getJavaType().getMethods()) {
                Type inputType;
                Type type;
                Class[] typeArguments;
                if (this.isIgnored(method) || !this.isReadAccessor(method) || !fieldNames.add(fieldName = this.getFieldName(method))) continue;
                boolean isWritable = ReflectionUtils.getSetter((Class)managedView.getJavaType(), (String)fieldName) != null;
                Class fieldType = ReflectionUtils.resolveType((Class)managedView.getJavaType(), (java.lang.reflect.Type)method.getGenericReturnType());
                if (Map.class.isAssignableFrom(fieldType)) {
                    typeArguments = ReflectionUtils.resolveTypeArguments((Class)managedView.getJavaType(), (java.lang.reflect.Type)method.getGenericReturnType());
                    Class keyTypeClass = ReflectionUtils.resolveType((Class)managedView.getJavaType(), (java.lang.reflect.Type)typeArguments[0]);
                    Class elementTypeClass = ReflectionUtils.resolveType((Class)managedView.getJavaType(), (java.lang.reflect.Type)typeArguments[1]);
                    Type keyType = this.getKeyType(typeRegistry, entityViewManager, keyTypeClass);
                    Type inputKeyType = this.getInputKeyType(typeRegistry, entityViewManager, keyTypeClass);
                    Type elementType = this.getElementType(typeRegistry, entityViewManager, elementTypeClass);
                    Type inputElementType = this.getInputElementType(typeRegistry, entityViewManager, elementTypeClass);
                    AnnotatedParameterizedType annotatedReturnType = (AnnotatedParameterizedType)method.getAnnotatedReturnType();
                    if (this.isNotNull(annotatedReturnType.getAnnotatedActualTypeArguments()[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0)) {
                        keyType = this.makeNonNull(keyType);
                        inputKeyType = this.makeNonNull(inputKeyType);
                    }
                    if (this.isNotNull(annotatedReturnType.getAnnotatedActualTypeArguments()[1].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 1)) {
                        elementType = this.makeNonNull(elementType);
                        inputElementType = this.makeNonNull(inputElementType);
                    }
                    type = this.getEntryType(typeRegistry, typeName, fieldName, keyType, elementType);
                    inputType = this.getInputEntryType(typeRegistry, inputTypeName, fieldName, inputKeyType, inputElementType);
                } else if (Collection.class.isAssignableFrom(fieldType)) {
                    typeArguments = ReflectionUtils.resolveTypeArguments((Class)managedView.getJavaType(), (java.lang.reflect.Type)method.getGenericReturnType());
                    Class elementTypeClass = ReflectionUtils.resolveType((Class)managedView.getJavaType(), (java.lang.reflect.Type)typeArguments[0]);
                    Type elementType = this.getElementType(typeRegistry, entityViewManager, elementTypeClass);
                    Type inputElementType = this.getInputElementType(typeRegistry, entityViewManager, elementTypeClass);
                    AnnotatedParameterizedType annotatedReturnType = (AnnotatedParameterizedType)method.getAnnotatedReturnType();
                    if (this.isNotNull(annotatedReturnType.getAnnotatedActualTypeArguments()[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0)) {
                        elementType = this.makeNonNull(elementType);
                        inputElementType = this.makeNonNull(inputElementType);
                    }
                    type = this.makeNonNull((Type<?>)this.getListType(elementType));
                    inputType = this.getListType(inputElementType);
                } else {
                    type = this.getElementType(typeRegistry, entityViewManager, fieldType);
                    inputType = this.getInputElementType(typeRegistry, entityViewManager, fieldType);
                }
                if (type == null) continue;
                if (this.isNotNull(method)) {
                    type = this.makeNonNull(type);
                    inputType = this.makeNonNull(inputType);
                }
                FieldDefinition fieldDefinition = new FieldDefinition(fieldName, type);
                fieldDefinitions.add(fieldDefinition);
                if (!isWritable) continue;
                valueDefinitions.add(new InputValueDefinition(fieldName, inputType));
            }
            if (managedView.getInheritanceMapping() != null) {
                implementsTypes = new ArrayList(defaultImplementsTypes.size());
                implementsTypes.addAll(defaultImplementsTypes);
                for (ManagedViewType view : managedViews) {
                    if (view.getInheritanceSubtypes().size() <= 1 || !view.getInheritanceSubtypes().contains(managedView)) continue;
                    implementsTypes.add(new TypeName(this.getObjectTypeName(view)));
                }
            } else {
                implementsTypes = defaultImplementsTypes;
            }
            Object typeDefinition = managedView.getInheritanceSubtypes().size() > 1 ? this.newInterfaceTypeDefinition(typeName, implementsTypes, fieldDefinitions, description) : this.newObjectTypeDefinition(typeName, implementsTypes, fieldDefinitions, description);
            this.addObjectTypeDefinition(typeRegistry, (Map<String, ManagedViewType<?>>)typeNameToViewType, (Map<ManagedViewType<?>, Set<MethodAttribute<?, ?>>>)usageGraph, (ManagedViewType<?>)managedView, (ImplementingTypeDefinition<?>)typeDefinition, this.newInputObjectTypeDefinition(inputTypeName, valueDefinitions, description));
        }
        HashSet<String> serializableBasicTypes = new HashSet<String>(this.additionalSerializableBasicTypes == null ? Collections.emptySet() : this.additionalSerializableBasicTypes);
        for (jakarta.persistence.metamodel.Type basicType : entityMetamodel.getBasicTypes()) {
            for (Class superType : ReflectionUtils.getSuperTypes((Class)basicType.getJavaType())) {
                serializableBasicTypes.add(superType.getName());
            }
            serializableBasicTypes.add(basicType.getJavaType().getName());
        }
        serializableBasicTypes.add(Serializable[].class.getName());
        serializableBasicTypes.add(GraphQLCursor.class.getName());
        this.addSerializableBasicTypes(serializableBasicTypes);
        return new GraphQLEntityViewSupport(typeNameToViewType, typeNameToFieldMapping, typeNameToDefaultFetchMappings, serializableBasicTypes);
    }

    protected void addSerializableBasicTypes(Set<String> serializableBasicTypes) {
        for (String javaTimeSerType : JAVA_TIME_SER_TYPES) {
            if (!serializableBasicTypes.contains(javaTimeSerType)) continue;
            serializableBasicTypes.add("java.time.Ser");
            break;
        }
    }

    protected boolean isReadAccessor(Method method) {
        String methodName = method.getName();
        return !method.isSynthetic() && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0 && (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) || methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) || this.getExplicitFieldName(method) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphQLEntityViewSupport create(GraphQLSchema schema, EntityViewManager entityViewManager) {
        boolean defineNormalTypes = this.defineNormalTypes;
        boolean defineRelayTypes = this.defineRelayTypes;
        Boolean implementRelayNode = this.implementRelayNode;
        boolean defineRelayNodeIfNotExist = this.defineRelayNodeIfNotExist;
        try {
            this.defineNormalTypes = false;
            this.defineRelayTypes = false;
            this.implementRelayNode = false;
            this.defineRelayNodeIfNotExist = false;
            GraphQLEntityViewSupport graphQLEntityViewSupport = this.create((GraphQLSchema.Builder)null, entityViewManager);
            return graphQLEntityViewSupport;
        }
        finally {
            this.defineNormalTypes = defineNormalTypes;
            this.defineRelayTypes = defineRelayTypes;
            this.implementRelayNode = implementRelayNode;
            this.defineRelayNodeIfNotExist = defineRelayNodeIfNotExist;
        }
    }

    public GraphQLEntityViewSupport create(GraphQLSchema.Builder schemaBuilder, EntityViewManager entityViewManager) {
        Set<GraphQLType> additionalTypes = this.isDefineNormalTypes() ? this.getAndClearAdditionalTypes(schemaBuilder) : Collections.emptySet();
        EntityMetamodel entityMetamodel = (EntityMetamodel)entityViewManager.getService(EntityMetamodel.class);
        HashMap typeNameToViewType = new HashMap();
        HashMap<String, Map<String, String>> typeNameToFieldMapping = new HashMap<String, Map<String, String>>();
        HashMap<String, Set<DefaultFetchMapping>> typeNameToDefaultFetchMappings = new HashMap<String, Set<DefaultFetchMapping>>();
        HashMap registeredTypeNames = new HashMap();
        HashMap<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph = this.determineViewsForSchema(entityViewManager);
        Set<ManagedViewType<?>> managedViews = usageGraph.keySet();
        for (ManagedViewType managedViewType : managedViews) {
            GraphQLInterfaceType.Builder interfaceBuilder;
            GraphQLObjectType.Builder objectBuilder;
            String typeName = this.getObjectTypeName(managedViewType);
            String inputTypeName = this.getInputObjectTypeName(managedViewType);
            String description = this.getDescription(managedViewType.getJavaType());
            if (managedViewType.getInheritanceSubtypes().size() > 1) {
                objectBuilder = null;
                interfaceBuilder = GraphQLInterfaceType.newInterface().name(typeName);
            } else {
                objectBuilder = GraphQLObjectType.newObject().name(typeName);
                interfaceBuilder = null;
            }
            GraphQLInputObjectType.Builder inputBuilder = GraphQLInputObjectType.newInputObject().name(inputTypeName);
            if (this.isImplementRelayNode()) {
                GraphQLTypeReference nodeType = new GraphQLTypeReference("Node");
                if (objectBuilder == null) {
                    interfaceBuilder.withInterface(nodeType);
                } else {
                    objectBuilder.withInterface(nodeType);
                }
            }
            if (description != null) {
                if (objectBuilder == null) {
                    interfaceBuilder.description(description);
                } else {
                    objectBuilder.description(description);
                }
                inputBuilder.description(description);
            }
            for (MethodAttribute methodAttribute : managedViewType.getAttributes()) {
                GraphQLInputType inputType;
                GraphQLOutputType type;
                if (this.isIgnored(methodAttribute.getJavaMethod())) continue;
                GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition();
                String fieldName = this.getFieldName(methodAttribute);
                fieldBuilder.name(fieldName);
                if (methodAttribute instanceof SingularAttribute) {
                    SingularAttribute singularAttribute = (SingularAttribute)methodAttribute;
                    if (singularAttribute.isId() && !singularAttribute.isSubview()) {
                        type = this.getIdType(schemaBuilder, singularAttribute, registeredTypeNames);
                        inputType = this.getInputIdType(schemaBuilder, singularAttribute, registeredTypeNames);
                    } else {
                        type = this.getElementType(schemaBuilder, singularAttribute, registeredTypeNames, entityMetamodel);
                        inputType = this.getInputElementType(schemaBuilder, singularAttribute, registeredTypeNames, entityMetamodel);
                    }
                } else if (methodAttribute instanceof MapAttribute) {
                    MapAttribute mapAttribute = (MapAttribute)methodAttribute;
                    type = this.getEntryType(schemaBuilder, methodAttribute, this.getKeyType(schemaBuilder, mapAttribute, registeredTypeNames), this.getElementType(schemaBuilder, (PluralAttribute<?, ?, ?>)mapAttribute, registeredTypeNames));
                    inputType = this.getInputEntryType(schemaBuilder, methodAttribute, this.getInputKeyType(schemaBuilder, mapAttribute, registeredTypeNames), this.getInputElementType(schemaBuilder, (PluralAttribute<?, ?, ?>)mapAttribute, registeredTypeNames));
                } else {
                    type = this.makeNonNull((GraphQLType)this.getListType((GraphQLType)this.getElementType(schemaBuilder, (PluralAttribute)methodAttribute, registeredTypeNames)));
                    inputType = this.getListType((GraphQLType)this.getInputElementType(schemaBuilder, (PluralAttribute)methodAttribute, registeredTypeNames));
                    if (inputType != null && this.isNotNull(methodAttribute.getJavaMethod())) {
                        inputType = this.makeNonNull((GraphQLType)type);
                    }
                }
                if (type == null) continue;
                fieldBuilder.type(type);
                if (objectBuilder == null) {
                    interfaceBuilder.field(fieldBuilder);
                } else {
                    objectBuilder.field(fieldBuilder);
                }
                this.addFieldMapping(typeNameToFieldMapping, typeNameToDefaultFetchMappings, managedViews, typeName, "", methodAttribute, fieldName);
                if (this.isDefineRelayTypes() && this.isDefineDedicatedRelayNodes()) {
                    this.addFieldMapping(typeNameToFieldMapping, typeNameToDefaultFetchMappings, managedViews, typeName, "Node", methodAttribute, fieldName);
                }
                if (!this.needsDefinitionInInputType(methodAttribute)) continue;
                inputBuilder.field(GraphQLInputObjectField.newInputObjectField().name(fieldName).type(inputType).build());
                this.addFieldMapping(typeNameToFieldMapping, typeNameToDefaultFetchMappings, managedViews, typeName, "Input", methodAttribute, fieldName);
            }
            for (Method method : managedViewType.getJavaType().getMethods()) {
                GraphQLInputType inputType;
                GraphQLOutputType type;
                Class[] typeArguments;
                if (this.isIgnored(method) || !this.isReadAccessor(method)) continue;
                String fieldName = this.getFieldName(method);
                if (objectBuilder != null && objectBuilder.hasField(fieldName) || interfaceBuilder != null && interfaceBuilder.hasField(fieldName)) continue;
                boolean isWritable = ReflectionUtils.getSetter((Class)managedViewType.getJavaType(), (String)fieldName) != null;
                GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition();
                Class fieldType = ReflectionUtils.resolveType((Class)managedViewType.getJavaType(), (java.lang.reflect.Type)method.getGenericReturnType());
                fieldBuilder.name(fieldName);
                if (Map.class.isAssignableFrom(fieldType)) {
                    typeArguments = ReflectionUtils.resolveTypeArguments((Class)managedViewType.getJavaType(), (java.lang.reflect.Type)method.getGenericReturnType());
                    Class keyTypeClass = ReflectionUtils.resolveType((Class)managedViewType.getJavaType(), (java.lang.reflect.Type)typeArguments[0]);
                    Class elementTypeClass = ReflectionUtils.resolveType((Class)managedViewType.getJavaType(), (java.lang.reflect.Type)typeArguments[1]);
                    GraphQLOutputType keyType = this.getKeyType(schemaBuilder, entityViewManager, keyTypeClass, registeredTypeNames);
                    GraphQLInputType inputKeyType = this.getInputKeyType(schemaBuilder, entityViewManager, keyTypeClass, registeredTypeNames);
                    GraphQLOutputType elementType = this.getElementType(schemaBuilder, entityViewManager, elementTypeClass, registeredTypeNames);
                    GraphQLInputType inputElementType = this.getInputElementType(schemaBuilder, entityViewManager, elementTypeClass, registeredTypeNames);
                    AnnotatedParameterizedType annotatedReturnType = (AnnotatedParameterizedType)method.getAnnotatedReturnType();
                    if (this.isNotNull(annotatedReturnType.getAnnotatedActualTypeArguments()[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0)) {
                        keyType = this.makeNonNull((GraphQLType)keyType);
                        inputKeyType = this.makeNonNull((GraphQLType)inputKeyType);
                    }
                    if (this.isNotNull(annotatedReturnType.getAnnotatedActualTypeArguments()[1].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 1)) {
                        elementType = this.makeNonNull((GraphQLType)elementType);
                        inputElementType = this.makeNonNull((GraphQLType)inputElementType);
                    }
                    type = this.getEntryType(schemaBuilder, typeName, fieldName, keyType, elementType);
                    inputType = this.getInputEntryType(schemaBuilder, inputTypeName, fieldName, inputKeyType, inputElementType);
                } else if (Collection.class.isAssignableFrom(fieldType)) {
                    typeArguments = ReflectionUtils.resolveTypeArguments((Class)managedViewType.getJavaType(), (java.lang.reflect.Type)method.getGenericReturnType());
                    Class elementTypeClass = ReflectionUtils.resolveType((Class)managedViewType.getJavaType(), (java.lang.reflect.Type)typeArguments[0]);
                    GraphQLOutputType elementType = this.getElementType(schemaBuilder, entityViewManager, elementTypeClass, registeredTypeNames);
                    GraphQLInputType inputElementType = this.getInputElementType(schemaBuilder, entityViewManager, elementTypeClass, registeredTypeNames);
                    AnnotatedParameterizedType annotatedReturnType = (AnnotatedParameterizedType)method.getAnnotatedReturnType();
                    if (this.isNotNull(annotatedReturnType.getAnnotatedActualTypeArguments()[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0)) {
                        elementType = this.makeNonNull((GraphQLType)elementType);
                        inputElementType = this.makeNonNull((GraphQLType)inputElementType);
                    }
                    type = this.makeNonNull((GraphQLType)this.getListType((GraphQLType)elementType));
                    inputType = this.getListType((GraphQLType)inputElementType);
                } else {
                    type = this.getElementType(schemaBuilder, entityViewManager, fieldType, registeredTypeNames);
                    inputType = this.getInputElementType(schemaBuilder, entityViewManager, fieldType, registeredTypeNames);
                }
                if (type == null) continue;
                if (this.isNotNull(method)) {
                    type = this.makeNonNull((GraphQLType)type);
                    inputType = this.makeNonNull((GraphQLType)inputType);
                }
                fieldBuilder.type(type);
                if (objectBuilder == null) {
                    interfaceBuilder.field(fieldBuilder);
                } else {
                    objectBuilder.field(fieldBuilder);
                }
                if (!isWritable) continue;
                inputBuilder.field(GraphQLInputObjectField.newInputObjectField().name(fieldName).type(inputType).build());
            }
            if (managedViewType.getInheritanceMapping() != null) {
                for (ManagedViewType managedViewType2 : managedViews) {
                    if (managedViewType2.getInheritanceSubtypes().size() <= 1 || !managedViewType2.getInheritanceSubtypes().contains(managedViewType)) continue;
                    GraphQLTypeReference nodeType = new GraphQLTypeReference(this.getObjectTypeName(managedViewType2));
                    if (objectBuilder == null) {
                        interfaceBuilder.withInterface(nodeType);
                        continue;
                    }
                    objectBuilder.withInterface(nodeType);
                }
            }
            Object type = objectBuilder == null ? interfaceBuilder.build() : objectBuilder.build();
            this.addObjectTypeDefinition(schemaBuilder, typeNameToViewType, usageGraph, managedViewType, (GraphQLNamedType)type, inputBuilder.build());
        }
        HashSet<String> serializableBasicTypes = new HashSet<String>(this.additionalSerializableBasicTypes == null ? Collections.emptySet() : this.additionalSerializableBasicTypes);
        for (jakarta.persistence.metamodel.Type basicType : entityMetamodel.getBasicTypes()) {
            for (Class superType : ReflectionUtils.getSuperTypes((Class)basicType.getJavaType())) {
                serializableBasicTypes.add(superType.getName());
            }
            serializableBasicTypes.add(basicType.getJavaType().getName());
        }
        serializableBasicTypes.add(Serializable[].class.getName());
        serializableBasicTypes.add(GraphQLCursor.class.getName());
        this.addSerializableBasicTypes(serializableBasicTypes);
        for (GraphQLType additionalType : additionalTypes) {
            String typeName = additionalType instanceof GraphQLNamedType ? ((GraphQLNamedType)additionalType).getName() : null;
            if (typeName != null && typeNameToViewType.get(typeName) != null) continue;
            schemaBuilder.additionalType(additionalType);
        }
        return new GraphQLEntityViewSupport(typeNameToViewType, typeNameToFieldMapping, typeNameToDefaultFetchMappings, serializableBasicTypes);
    }

    private HashMap<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> determineViewsForSchema(EntityViewManager entityViewManager) {
        HashMap usageGraph = new HashMap();
        for (ManagedViewType managedView : entityViewManager.getMetamodel().getManagedViews()) {
            if (this.typeFilterPattern != null && !this.typeFilterPattern.matcher(managedView.getJavaType().getName()).matches() || this.typeInclusionPredicate != null && !this.typeInclusionPredicate.test(managedView) || this.isIgnored(managedView.getJavaType())) continue;
            GraphQLEntityViewSupportFactory.addUsage(managedView, usageGraph);
        }
        return usageGraph;
    }

    private static void addUsage(ManagedViewType<?> usedType, HashMap<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph) {
        if (usageGraph.containsKey(usedType)) {
            return;
        }
        usageGraph.put(usedType, new HashSet());
        for (MethodAttribute attribute : usedType.getAttributes()) {
            com.blazebit.persistence.view.metamodel.Type keyType;
            if (!attribute.isSubview()) continue;
            if (attribute instanceof SingularAttribute) {
                GraphQLEntityViewSupportFactory.addUsage(attribute, (ManagedViewType)((SingularAttribute)attribute).getType(), usageGraph);
                continue;
            }
            if (!(attribute instanceof PluralAttribute)) continue;
            GraphQLEntityViewSupportFactory.addUsage(attribute, (ManagedViewType)((PluralAttribute)attribute).getElementType(), usageGraph);
            if (!(attribute instanceof MapAttribute) || !((keyType = ((MapAttribute)attribute).getKeyType()) instanceof ManagedViewType)) continue;
            GraphQLEntityViewSupportFactory.addUsage(attribute, (ManagedViewType)keyType, usageGraph);
        }
    }

    private static void addUsage(MethodAttribute<?, ?> attribute, ManagedViewType<?> usedType, HashMap<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph) {
        GraphQLEntityViewSupportFactory.addUsage(usedType, usageGraph);
        usageGraph.get(usedType).add(attribute);
    }

    private GraphQLList getListType(GraphQLType elementType) {
        if (elementType == null) {
            return null;
        }
        return new GraphQLList(elementType);
    }

    private ListType getListType(Type<?> elementType) {
        if (elementType == null) {
            return null;
        }
        return new ListType(elementType);
    }

    private GraphQLNonNull makeNonNull(GraphQLType type) {
        if (type == null || type instanceof GraphQLNonNull) {
            return (GraphQLNonNull)type;
        }
        return new GraphQLNonNull(type);
    }

    private NonNullType makeNonNull(Type<?> type) {
        if (type == null || type instanceof NonNullType) {
            return (NonNullType)type;
        }
        return new NonNullType(type);
    }

    private void addFieldMapping(Map<String, Map<String, String>> typeNameToFieldMapping, Map<String, Set<DefaultFetchMapping>> typeNameToDefaultFetchMappings, Collection<ManagedViewType<?>> managedViews, String baseName, String suffix, MethodAttribute<?, ?> attribute, String fieldName) {
        DefaultFetchMapping[] defaultFetchMappings;
        String typeName = baseName + suffix;
        Map<String, String> fieldMapping = typeNameToFieldMapping.get(typeName);
        if (fieldMapping == null) {
            fieldMapping = new HashMap<String, String>();
            typeNameToFieldMapping.put(typeName, fieldMapping);
        }
        fieldMapping.put(fieldName, attribute.getName());
        for (DefaultFetchMapping defaultFetchMapping : defaultFetchMappings = this.determineDefaultFetchMappings(attribute)) {
            ArrayList<ManagedViewType<?>> superTypes = this.getInheritanceSuperTypes(managedViews, attribute.getDeclaringType());
            if (superTypes != null) {
                for (ManagedViewType<?> superType : superTypes) {
                    String superTypeName = this.getObjectTypeName(superType);
                    Set<DefaultFetchMapping> existingDefaultFetchMappings = typeNameToDefaultFetchMappings.get(superTypeName);
                    if (existingDefaultFetchMappings == null) {
                        existingDefaultFetchMappings = new HashSet<DefaultFetchMapping>();
                        typeNameToDefaultFetchMappings.put(superTypeName, existingDefaultFetchMappings);
                    }
                    existingDefaultFetchMappings.add(defaultFetchMapping);
                }
            }
            Set subtypes = attribute.getDeclaringType().getInheritanceSubtypes();
            for (ManagedViewType subtype : subtypes) {
                String subtypeName = this.getObjectTypeName(subtype);
                Set<DefaultFetchMapping> existingDefaultFetchMappings = typeNameToDefaultFetchMappings.get(subtypeName);
                if (existingDefaultFetchMappings == null) {
                    existingDefaultFetchMappings = new HashSet<DefaultFetchMapping>();
                    typeNameToDefaultFetchMappings.put(subtypeName, existingDefaultFetchMappings);
                }
                existingDefaultFetchMappings.add(defaultFetchMapping);
            }
        }
    }

    private ArrayList<ManagedViewType<?>> getInheritanceSuperTypes(Collection<ManagedViewType<?>> managedViews, ManagedViewType<?> subtype) {
        ArrayList list = null;
        for (ManagedViewType<?> managedView : managedViews) {
            if (managedView == subtype || !managedView.getInheritanceSubtypes().contains(subtype)) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(managedView);
        }
        return list;
    }

    protected DefaultFetchMapping[] determineDefaultFetchMappings(MethodAttribute<?, ?> attribute) {
        GraphQLDefaultFetch[] annotations = (GraphQLDefaultFetch[])attribute.getJavaMethod().getAnnotationsByType(GraphQLDefaultFetch.class);
        if (annotations.length != 0) {
            DefaultFetchMapping[] defaultFetchMappings = new DefaultFetchMapping[annotations.length];
            for (int i = 0; i < annotations.length; ++i) {
                defaultFetchMappings[i] = new DefaultFetchMappingImpl(attribute.getName(), annotations[i].ifFieldSelected());
            }
            return defaultFetchMappings;
        }
        return DefaultFetchMappingImpl.EMPTY;
    }

    private <T> T getAnnotationValue(Annotation annotation, String memberName) {
        try {
            return (T)annotation.annotationType().getMethod(memberName, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't access annotation member", e);
        }
    }

    private Set<GraphQLType> getAndClearAdditionalTypes(GraphQLSchema.Builder schemaBuilder) {
        try {
            Field f = GraphQLSchema.Builder.class.getDeclaredField("additionalTypes");
            f.setAccessible(true);
            Set graphQLTypes = (Set)f.get(schemaBuilder);
            HashSet<GraphQLType> copy = new HashSet<GraphQLType>(graphQLTypes);
            graphQLTypes.clear();
            return copy;
        }
        catch (Exception e) {
            try {
                GraphQLSchema intermediateSchema = schemaBuilder.build();
                Set graphQLTypes = intermediateSchema.getAdditionalTypes();
                Method m = GraphQLSchema.Builder.class.getMethod("clearAdditionalTypes", new Class[0]);
                m.invoke((Object)schemaBuilder, new Object[0]);
                return graphQLTypes;
            }
            catch (Exception e2) {
                RuntimeException runtimeException = new RuntimeException("Could not extract the additional types", e2);
                runtimeException.addSuppressed(e);
                throw runtimeException;
            }
        }
    }

    protected ObjectTypeDefinition newObjectTypeDefinition(String typeName, List<FieldDefinition> fieldDefinitions, String description) {
        return this.newObjectTypeDefinition(typeName, new ArrayList<Type>(0), fieldDefinitions, description);
    }

    protected ObjectTypeDefinition newObjectTypeDefinition(String typeName, List<Type> implementsTypes, List<FieldDefinition> fieldDefinitions, String description) {
        return ObjectTypeDefinition.newObjectTypeDefinition().name(typeName).description(new Description(description, null, false)).implementz(implementsTypes).fieldDefinitions(fieldDefinitions).build();
    }

    protected InterfaceTypeDefinition newInterfaceTypeDefinition(String typeName, List<Type> implementsTypes, List<FieldDefinition> fieldDefinitions, String description) {
        return InterfaceTypeDefinition.newInterfaceTypeDefinition().name(typeName).description(new Description(description, null, false)).implementz(implementsTypes).definitions(fieldDefinitions).build();
    }

    protected InputObjectTypeDefinition newInputObjectTypeDefinition(String typeName, List<InputValueDefinition> valueDefinitions, String description) {
        return InputObjectTypeDefinition.newInputObjectDefinition().name(typeName).description(new Description(description, null, false)).inputValueDefinitions(valueDefinitions).build();
    }

    protected InterfaceTypeDefinition newInterfaceTypeDefinition(String name, List<FieldDefinition> fieldDefinitions, String description) {
        return InterfaceTypeDefinition.newInterfaceTypeDefinition().name(name).description(new Description(description, null, false)).definitions(fieldDefinitions).build();
    }

    protected EnumTypeDefinition newEnumTypeDefinition(String typeName, List<EnumValueDefinition> enumValueDefinitions, String description) {
        return EnumTypeDefinition.newEnumTypeDefinition().name(typeName).description(new Description(description, null, false)).enumValueDefinitions(enumValueDefinitions).build();
    }

    @Deprecated
    protected void addObjectTypeDefinition(TypeDefinitionRegistry typeRegistry, Map<String, ManagedViewType<?>> typeNameToViewType, ManagedViewType<?> managedView, ImplementingTypeDefinition<?> objectTypeDefinition, InputObjectTypeDefinition inputObjectTypeDefinition) {
        this.addObjectTypeDefinition(typeRegistry, typeNameToViewType, null, managedView, objectTypeDefinition, inputObjectTypeDefinition);
    }

    protected void addObjectTypeDefinition(TypeDefinitionRegistry typeRegistry, Map<String, ManagedViewType<?>> typeNameToViewType, Map<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph, ManagedViewType<?> managedView, ImplementingTypeDefinition<?> objectTypeDefinition, InputObjectTypeDefinition inputObjectTypeDefinition) {
        ObjectTypeDefinition nodeType;
        String nodeTypeName;
        if (!managedView.isUpdatable() && !managedView.isCreatable() || this.isDefineNonInputTypesForUpdatableOrCreatableEntityViews() || this.needsNormalType(usageGraph, managedView)) {
            this.registerManagedViewType(typeRegistry, typeNameToViewType, managedView, (TypeDefinition<?>)objectTypeDefinition);
            if (this.isDefineNormalTypes()) {
                typeRegistry.add(objectTypeDefinition);
            }
        }
        if (this.needsInputType(usageGraph, managedView)) {
            this.registerManagedViewType(typeRegistry, typeNameToViewType, managedView, (TypeDefinition<?>)inputObjectTypeDefinition);
            if (this.isDefineNormalTypes()) {
                typeRegistry.add((SDLDefinition)inputObjectTypeDefinition);
            }
        }
        if ((managedView.isUpdatable() || managedView.isCreatable()) && !this.isDefineNonInputTypesForUpdatableOrCreatableEntityViews()) {
            return;
        }
        if (this.isDefineDedicatedRelayNodes()) {
            nodeTypeName = objectTypeDefinition.getName() + "Node";
            ArrayList<Type> implementTypes = new ArrayList<Type>(objectTypeDefinition.getImplements());
            implementTypes.add((Type)new TypeName("Node"));
            nodeType = this.newObjectTypeDefinition(nodeTypeName, implementTypes, objectTypeDefinition.getFieldDefinitions(), null);
        } else {
            nodeTypeName = objectTypeDefinition.getName();
            nodeType = null;
        }
        if (this.isDefineRelayTypes() && !typeRegistry.getType("Node").isPresent() && (this.isImplementRelayNode() || this.isDefineDedicatedRelayNodes()) && this.isDefineRelayNodeIfNotExist()) {
            ArrayList<FieldDefinition> nodeFields = new ArrayList<FieldDefinition>(4);
            nodeFields.add(new FieldDefinition("id", (Type)new NonNullType((Type)new TypeName("ID"))));
            typeRegistry.add((SDLDefinition)this.newInterfaceTypeDefinition("Node", nodeFields, null));
        }
        ArrayList<FieldDefinition> edgeFields = new ArrayList<FieldDefinition>(2);
        edgeFields.add(new FieldDefinition("node", (Type)new NonNullType((Type)new TypeName(nodeTypeName))));
        edgeFields.add(new FieldDefinition("cursor", (Type)new NonNullType((Type)new TypeName("String"))));
        ObjectTypeDefinition edgeType = this.newObjectTypeDefinition(objectTypeDefinition.getName() + "Edge", edgeFields, null);
        ArrayList<FieldDefinition> connectionFields = new ArrayList<FieldDefinition>(2);
        connectionFields.add(new FieldDefinition("edges", (Type)new ListType((Type)new TypeName(edgeType.getName()))));
        connectionFields.add(new FieldDefinition("pageInfo", (Type)new NonNullType((Type)new TypeName("PageInfo"))));
        connectionFields.add(new FieldDefinition("totalCount", (Type)new NonNullType((Type)new TypeName("Int"))));
        ObjectTypeDefinition connectionType = this.newObjectTypeDefinition(objectTypeDefinition.getName() + "Connection", connectionFields, null);
        if (this.isDefineRelayTypes() && !typeRegistry.getType("PageInfo").isPresent() && this.isDefineRelayNodeIfNotExist()) {
            ArrayList<FieldDefinition> pageInfoFields = new ArrayList<FieldDefinition>(4);
            pageInfoFields.add(new FieldDefinition("hasNextPage", (Type)new NonNullType((Type)new TypeName("Boolean"))));
            pageInfoFields.add(new FieldDefinition("hasPreviousPage", (Type)new NonNullType((Type)new TypeName("Boolean"))));
            pageInfoFields.add(new FieldDefinition("startCursor", (Type)new TypeName("String")));
            pageInfoFields.add(new FieldDefinition("endCursor", (Type)new TypeName("String")));
            typeRegistry.add((SDLDefinition)this.newObjectTypeDefinition("PageInfo", pageInfoFields, null));
        }
        if (nodeType != null) {
            this.registerManagedViewType(typeRegistry, typeNameToViewType, managedView, (TypeDefinition<?>)nodeType);
        }
        this.registerManagedViewType(typeRegistry, typeNameToViewType, managedView, (TypeDefinition<?>)edgeType);
        this.registerManagedViewType(typeRegistry, typeNameToViewType, managedView, (TypeDefinition<?>)connectionType);
        if (this.isDefineRelayTypes()) {
            if (nodeType != null) {
                typeRegistry.add((SDLDefinition)nodeType);
            }
            typeRegistry.add((SDLDefinition)edgeType);
            typeRegistry.add((SDLDefinition)connectionType);
        }
    }

    @Deprecated
    protected void addObjectTypeDefinition(GraphQLSchema.Builder schemaBuilder, Map<String, ManagedViewType<?>> typeNameToViewType, ManagedViewType<?> managedView, GraphQLNamedType objectType, GraphQLInputObjectType inputObjectType) {
        this.addObjectTypeDefinition(schemaBuilder, typeNameToViewType, null, managedView, objectType, inputObjectType);
    }

    protected void addObjectTypeDefinition(GraphQLSchema.Builder schemaBuilder, Map<String, ManagedViewType<?>> typeNameToViewType, Map<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph, ManagedViewType<?> managedView, GraphQLNamedType objectType, GraphQLInputObjectType inputObjectType) {
        String pageInfoTypeName;
        String connectionTypeName;
        String edgeTypeName;
        String nodeTypeName;
        if (!managedView.isUpdatable() && !managedView.isCreatable() || this.isDefineNonInputTypesForUpdatableOrCreatableEntityViews() || this.needsNormalType(usageGraph, managedView)) {
            typeNameToViewType.put(objectType.getName(), managedView);
            if (this.isDefineNormalTypes()) {
                schemaBuilder.additionalType((GraphQLType)objectType);
            }
        }
        if (this.needsInputType(usageGraph, managedView)) {
            typeNameToViewType.put(inputObjectType.getName(), managedView);
            if (this.isDefineNormalTypes()) {
                schemaBuilder.additionalType((GraphQLType)inputObjectType);
            }
        }
        if ((managedView.isUpdatable() || managedView.isCreatable()) && !this.isDefineNonInputTypesForUpdatableOrCreatableEntityViews()) {
            return;
        }
        if (this.scalarTypeMap == null) {
            nodeTypeName = this.isDefineDedicatedRelayNodes() ? objectType.getName() + "Node" : objectType.getName();
            edgeTypeName = objectType.getName() + "Edge";
            connectionTypeName = objectType.getName() + "Connection";
            pageInfoTypeName = "PageInfo";
            if (this.isDefineRelayTypes() && (this.isImplementRelayNode() || this.isDefineDedicatedRelayNodes())) {
                GraphQLObjectType.Builder nodeType = GraphQLObjectType.newObject().name(nodeTypeName);
                nodeType.fields(((GraphQLFieldsContainer)objectType).getFieldDefinitions());
                nodeType.withInterface(new GraphQLTypeReference("Node"));
                if (!typeNameToViewType.containsKey("Node") && this.isDefineRelayNodeIfNotExist()) {
                    GraphQLInterfaceType.Builder nodeInterfaceType = GraphQLInterfaceType.newInterface().name("Node").field(GraphQLFieldDefinition.newFieldDefinition().name("id").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)this.getScalarType("ID"))).build());
                    schemaBuilder.additionalType((GraphQLType)nodeInterfaceType.build());
                }
                schemaBuilder.additionalType((GraphQLType)nodeType.build());
            }
            typeNameToViewType.put(nodeTypeName, managedView);
        } else {
            nodeTypeName = objectType.getName();
            edgeTypeName = "GraphQLRelayEdge_" + objectType.getName();
            connectionTypeName = "GraphQLRelayConnection_" + objectType.getName();
            pageInfoTypeName = "GraphQLRelayPageInfo";
        }
        GraphQLObjectType.Builder edgeType = GraphQLObjectType.newObject().name(edgeTypeName);
        edgeType.field(GraphQLFieldDefinition.newFieldDefinition().name("node").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(nodeTypeName))).build());
        edgeType.field(GraphQLFieldDefinition.newFieldDefinition().name("cursor").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)this.getScalarType("String"))).build());
        GraphQLObjectType.Builder connectionType = GraphQLObjectType.newObject().name(connectionTypeName);
        connectionType.field(GraphQLFieldDefinition.newFieldDefinition().name("edges").type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(edgeTypeName))).build());
        connectionType.field(GraphQLFieldDefinition.newFieldDefinition().name("pageInfo").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(pageInfoTypeName))).build());
        connectionType.field(GraphQLFieldDefinition.newFieldDefinition().name("totalCount").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)this.getScalarType("Int"))).build());
        if (!typeNameToViewType.containsKey(pageInfoTypeName) && this.isDefineRelayNodeIfNotExist()) {
            GraphQLObjectType.Builder pageInfoType = GraphQLObjectType.newObject().name(pageInfoTypeName);
            pageInfoType.field(GraphQLFieldDefinition.newFieldDefinition().name("hasNextPage").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)this.getScalarType("Boolean"))).build());
            pageInfoType.field(GraphQLFieldDefinition.newFieldDefinition().name("hasPreviousPage").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)this.getScalarType("Boolean"))).build());
            pageInfoType.field(GraphQLFieldDefinition.newFieldDefinition().name("startCursor").type(this.getScalarType("String")).build());
            pageInfoType.field(GraphQLFieldDefinition.newFieldDefinition().name("endCursor").type(this.getScalarType("String")).build());
            schemaBuilder.additionalType((GraphQLType)pageInfoType.build());
        }
        typeNameToViewType.put(edgeTypeName, managedView);
        typeNameToViewType.put(connectionTypeName, managedView);
        typeNameToViewType.put(objectType.getName(), managedView);
        if (this.isDefineRelayTypes()) {
            schemaBuilder.additionalType((GraphQLType)edgeType.build());
            schemaBuilder.additionalType((GraphQLType)connectionType.build());
        }
    }

    private boolean needsInputType(Map<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph, ManagedViewType<?> managedView) {
        if (managedView.isUpdatable() || managedView.isCreatable() || usageGraph == null) {
            return true;
        }
        Set<MethodAttribute<?, ?>> usedInAttributes = usageGraph.get(managedView);
        if (usedInAttributes != null) {
            for (MethodAttribute<?, ?> attribute : usedInAttributes) {
                ManagedViewType declaringType = attribute.getDeclaringType();
                if (!declaringType.isCreatable() && !declaringType.isUpdatable() && !this.isPartOfUpdatableSubviewId(usageGraph, attribute)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean needsNormalType(Map<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph, ManagedViewType<?> managedView) {
        if (usageGraph == null) {
            return true;
        }
        Set<MethodAttribute<?, ?>> usedInAttributes = usageGraph.get(managedView);
        if (usedInAttributes != null) {
            for (MethodAttribute<?, ?> attribute : usedInAttributes) {
                ManagedViewType declaringType = attribute.getDeclaringType();
                if ((declaringType.isCreatable() || declaringType.isUpdatable()) && !this.needsInputType(usageGraph, declaringType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPartOfUpdatableSubviewId(Map<ManagedViewType<?>, Set<MethodAttribute<?, ?>>> usageGraph, MethodAttribute<?, ?> attribute) {
        block2: {
            Set<MethodAttribute<?, ?>> usedInAttributes;
            ManagedViewType declaringType;
            block3: {
                declaringType = attribute.getDeclaringType();
                if (!(attribute instanceof SingularAttribute) || (usedInAttributes = usageGraph.get(declaringType)) == null) break block2;
                if (!((SingularAttribute)attribute).isId()) break block3;
                for (MethodAttribute<?, ?> declaringTypeAttributeReferrer : usedInAttributes) {
                    ManagedViewType referrerDeclaringType = declaringTypeAttributeReferrer.getDeclaringType();
                    if (!declaringTypeAttributeReferrer.isUpdatable() || !referrerDeclaringType.isCreatable() && !referrerDeclaringType.isUpdatable()) continue;
                    return true;
                }
                break block2;
            }
            if (!(declaringType instanceof FlatViewType)) break block2;
            for (MethodAttribute<?, ?> declaringTypeAttributeReferrer : usedInAttributes) {
                if (!this.isPartOfUpdatableSubviewId(usageGraph, declaringTypeAttributeReferrer)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean needsDefinitionInInputType(MethodAttribute<?, ?> attribute) {
        return attribute.isUpdatable() || attribute.getDeclaringType() instanceof FlatViewType || attribute instanceof SingularAttribute && ((SingularAttribute)attribute).isId();
    }

    protected void registerManagedViewType(TypeDefinitionRegistry typeRegistry, Map<String, ManagedViewType<?>> typeNameToViewType, ManagedViewType<?> managedView, TypeDefinition<?> objectTypeDefinition) {
        ManagedViewType<?> old;
        if (this.isDefineNormalTypes()) {
            typeRegistry.add(objectTypeDefinition);
        }
        if ((old = typeNameToViewType.put(objectTypeDefinition.getName(), managedView)) != null) {
            throw new IllegalArgumentException("Type with name '" + objectTypeDefinition.getName() + "' is registered multiple times: [" + old.getEntityClass().getName() + ", " + managedView.getJavaType().getName() + "]!");
        }
    }

    protected Type getIdType(TypeDefinitionRegistry typeRegistry, SingularAttribute<?, ?> singularAttribute) {
        return new NonNullType((Type)new TypeName("ID"));
    }

    protected Type getInputIdType(TypeDefinitionRegistry typeRegistry, SingularAttribute<?, ?> singularAttribute) {
        return new TypeName("ID");
    }

    protected GraphQLOutputType getIdType(GraphQLSchema.Builder schemaBuilder, SingularAttribute<?, ?> singularAttribute, Map<Class<?>, String> registeredTypeNames) {
        if (this.scalarTypeMap != null) {
            return new GraphQLNonNull((GraphQLType)this.scalarTypeMap.get("ID"));
        }
        return new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("ID"));
    }

    protected GraphQLInputType getInputIdType(GraphQLSchema.Builder schemaBuilder, SingularAttribute<?, ?> singularAttribute, Map<Class<?>, String> registeredTypeNames) {
        if (this.scalarTypeMap != null) {
            return (GraphQLInputType)this.scalarTypeMap.get("ID");
        }
        return new GraphQLTypeReference("ID");
    }

    protected GraphQLOutputType getIdType(SingularAttribute<?, ?> singularAttribute) {
        if (this.scalarTypeMap != null) {
            return new GraphQLNonNull((GraphQLType)this.scalarTypeMap.get("ID"));
        }
        return new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("ID"));
    }

    protected GraphQLInputType getInputIdType(SingularAttribute<?, ?> singularAttribute) {
        if (this.scalarTypeMap != null) {
            return (GraphQLInputType)this.scalarTypeMap.get("ID");
        }
        return new GraphQLTypeReference("ID");
    }

    protected Type getEntryType(TypeDefinitionRegistry typeRegistry, MethodAttribute<?, ?> attribute, Type key, Type value) {
        if (key == null || value == null) {
            return null;
        }
        return this.getEntryType(typeRegistry, this.getObjectTypeName(attribute.getDeclaringType()), attribute.getName(), key, value);
    }

    protected Type getEntryType(TypeDefinitionRegistry typeRegistry, String typeName, String fieldName, Type key, Type value) {
        if (key == null || value == null) {
            return null;
        }
        String entryName = typeName + StringUtils.firstToUpper((CharSequence)fieldName) + "Entry";
        ArrayList<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        fields.add(new FieldDefinition("key", key));
        fields.add(new FieldDefinition("value", value));
        if (this.isDefineNormalTypes()) {
            typeRegistry.add((SDLDefinition)this.newObjectTypeDefinition(entryName, fields, null));
        }
        return new NonNullType((Type)new ListType((Type)new NonNullType((Type)new TypeName(entryName))));
    }

    protected Type getInputEntryType(TypeDefinitionRegistry typeRegistry, MethodAttribute<?, ?> attribute, Type key, Type value) {
        if (key == null || value == null) {
            return null;
        }
        Type type = this.getInputEntryType(typeRegistry, this.getObjectTypeName(attribute.getDeclaringType()), attribute.getName(), key, value);
        if (type != null && this.isNotNull(attribute.getJavaMethod())) {
            type = this.makeNonNull(type);
        }
        return type;
    }

    protected Type getInputEntryType(TypeDefinitionRegistry typeRegistry, String typeName, String fieldName, Type key, Type value) {
        if (key == null || value == null) {
            return null;
        }
        String entryName = typeName + StringUtils.firstToUpper((CharSequence)fieldName) + "EntryInput";
        ArrayList<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        fields.add(new FieldDefinition("key", key));
        fields.add(new FieldDefinition("value", value));
        if (this.isDefineNormalTypes()) {
            typeRegistry.add((SDLDefinition)this.newObjectTypeDefinition(entryName, fields, null));
        }
        return new ListType((Type)new NonNullType((Type)new TypeName(entryName)));
    }

    protected GraphQLOutputType getEntryType(GraphQLSchema.Builder schemaBuilder, MethodAttribute<?, ?> attribute, GraphQLOutputType key, GraphQLOutputType value) {
        if (key == null || value == null) {
            return null;
        }
        return this.getEntryType(schemaBuilder, this.getObjectTypeName(attribute.getDeclaringType()), attribute.getName(), key, value);
    }

    protected GraphQLOutputType getEntryType(GraphQLSchema.Builder schemaBuilder, String typeName, String fieldName, GraphQLOutputType key, GraphQLOutputType value) {
        if (key == null || value == null) {
            return null;
        }
        String entryName = typeName + StringUtils.firstToUpper((CharSequence)fieldName) + "Entry";
        GraphQLObjectType type = GraphQLObjectType.newObject().name(entryName).field(GraphQLFieldDefinition.newFieldDefinition().name("key").type(key)).field(GraphQLFieldDefinition.newFieldDefinition().name("value").type(value)).build();
        if (this.isDefineNormalTypes()) {
            schemaBuilder.additionalType((GraphQLType)type);
        }
        return new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(entryName))));
    }

    protected GraphQLInputType getInputEntryType(GraphQLSchema.Builder schemaBuilder, MethodAttribute<?, ?> attribute, GraphQLInputType key, GraphQLInputType value) {
        if (key == null || value == null) {
            return null;
        }
        GraphQLInputType type = this.getInputEntryType(schemaBuilder, this.getObjectTypeName(attribute.getDeclaringType()), attribute.getName(), key, value);
        if (type != null && this.isNotNull(attribute.getJavaMethod())) {
            type = this.makeNonNull((GraphQLType)type);
        }
        return type;
    }

    protected GraphQLInputType getInputEntryType(GraphQLSchema.Builder schemaBuilder, String typeName, String fieldName, GraphQLInputType key, GraphQLInputType value) {
        if (key == null || value == null) {
            return null;
        }
        String entryName = typeName + StringUtils.firstToUpper((CharSequence)fieldName) + "EntryInput";
        GraphQLInputObjectType type = GraphQLInputObjectType.newInputObject().name(entryName).field(GraphQLInputObjectField.newInputObjectField().name("key").type(key)).field(GraphQLInputObjectField.newInputObjectField().name("value").type(value)).build();
        if (this.isDefineNormalTypes()) {
            schemaBuilder.additionalType((GraphQLType)type);
        }
        return new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(entryName)));
    }

    protected String getObjectTypeName(ManagedViewType type) {
        return this.getObjectTypeName(type.getJavaType());
    }

    protected String getObjectTypeName(Class<?> javaType) {
        for (Annotation annotation : javaType.getAnnotations()) {
            switch (annotation.annotationType().getName()) {
                case "com.blazebit.persistence.integration.graphql.GraphQLName": 
                case "org.eclipse.microprofile.graphql.Name": 
                case "org.eclipse.microprofile.graphql.Type": {
                    return (String)this.getAnnotationValue(annotation, "value");
                }
                case "io.leangen.graphql.annotations.types.GraphQLType": 
                case "io.leangen.graphql.annotations.types.GraphQLInterface": 
                case "io.leangen.graphql.annotations.types.GraphQLUnion": {
                    return (String)this.getAnnotationValue(annotation, "name");
                }
            }
        }
        return javaType.getSimpleName();
    }

    protected String getInputObjectTypeName(ManagedViewType managedView) {
        String typeName = this.getObjectTypeName(managedView);
        if (Modifier.isAbstract(managedView.getJavaType().getModifiers()) && (managedView.isCreatable() || managedView.isUpdatable())) {
            return typeName;
        }
        return typeName + "Input";
    }

    protected String getInputObjectTypeName(Class<?> managedViewJavaType) {
        String typeName = this.getObjectTypeName(managedViewJavaType);
        if (Modifier.isAbstract(managedViewJavaType.getModifiers()) && (AnnotationUtils.findAnnotation(managedViewJavaType, CreatableEntityView.class) != null || AnnotationUtils.findAnnotation(managedViewJavaType, UpdatableEntityView.class) != null)) {
            return typeName;
        }
        return typeName + "Input";
    }

    protected String getTypeName(Class<?> type) {
        block14: for (Annotation annotation : type.getAnnotations()) {
            switch (annotation.annotationType().getName()) {
                case "com.blazebit.persistence.integration.graphql.GraphQLName": 
                case "org.eclipse.microprofile.graphql.Name": 
                case "org.eclipse.microprofile.graphql.Type": {
                    return (String)this.getAnnotationValue(annotation, "value");
                }
                case "io.leangen.graphql.annotations.types.GraphQLType": 
                case "io.leangen.graphql.annotations.types.GraphQLInterface": 
                case "io.leangen.graphql.annotations.types.GraphQLUnion": {
                    return (String)this.getAnnotationValue(annotation, "name");
                }
                case "org.eclipse.microprofile.graphql.Enum": {
                    if (!type.isEnum()) continue block14;
                    return (String)this.getAnnotationValue(annotation, "value");
                }
            }
        }
        return type.getSimpleName();
    }

    protected String getExplicitFieldName(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            switch (annotation.annotationType().getName()) {
                case "com.blazebit.persistence.integration.graphql.GraphQLName": 
                case "org.eclipse.microprofile.graphql.Query": 
                case "org.eclipse.microprofile.graphql.Name": {
                    return (String)this.getAnnotationValue(annotation, "value");
                }
                case "com.netflix.graphql.dgs.DgsData": {
                    return (String)this.getAnnotationValue(annotation, "field");
                }
                case "io.leangen.graphql.annotations.GraphQLQuery": {
                    return (String)this.getAnnotationValue(annotation, "name");
                }
            }
        }
        return null;
    }

    protected String getFieldName(Method method) {
        String explicitFieldName = this.getExplicitFieldName(method);
        if (explicitFieldName != null && !explicitFieldName.isEmpty()) {
            return explicitFieldName;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return methodName;
    }

    protected String getFieldName(MethodAttribute<?, ?> attribute) {
        String explicitFieldName = this.getExplicitFieldName(attribute.getJavaMethod());
        if (explicitFieldName != null && !explicitFieldName.isEmpty()) {
            return explicitFieldName;
        }
        return attribute.getName();
    }

    protected String getDescription(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            switch (annotation.annotationType().getName()) {
                case "org.eclipse.microprofile.graphql.Description": {
                    return (String)this.getAnnotationValue(annotation, "value");
                }
                case "io.leangen.graphql.annotations.types.GraphQLType": 
                case "io.leangen.graphql.annotations.types.GraphQLInterface": 
                case "io.leangen.graphql.annotations.types.GraphQLUnion": {
                    return (String)this.getAnnotationValue(annotation, "description");
                }
            }
        }
        return null;
    }

    protected boolean isIgnored(Class<?> javaType) {
        for (Annotation annotation : javaType.getAnnotations()) {
            switch (annotation.annotationType().getName()) {
                case "com.blazebit.persistence.integration.graphql.GraphQLIgnore": 
                case "io.leangen.graphql.annotations.GraphQLIgnore": {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isIgnored(Method javaMethod) {
        for (Annotation annotation : javaMethod.getAnnotations()) {
            switch (annotation.annotationType().getName()) {
                case "com.blazebit.persistence.integration.graphql.GraphQLIgnore": 
                case "org.eclipse.microprofile.graphql.Ignore": 
                case "io.leangen.graphql.annotations.GraphQLIgnore": {
                    return true;
                }
            }
        }
        return false;
    }

    protected Type getObjectType(ManagedViewType type) {
        if (this.isIgnored(type.getJavaType())) {
            return null;
        }
        return new TypeName(this.getObjectTypeName(type));
    }

    protected Type getInputObjectType(ManagedViewType type) {
        if (this.isIgnored(type.getJavaType())) {
            return null;
        }
        return new TypeName(this.getObjectTypeName(type) + "Input");
    }

    protected GraphQLOutputType getObjectTypeReference(ManagedViewType<?> type) {
        if (this.isIgnored(type.getJavaType())) {
            return null;
        }
        return new GraphQLTypeReference(this.getObjectTypeName(type));
    }

    protected GraphQLInputType getInputObjectTypeReference(ManagedViewType<?> type) {
        if (this.isIgnored(type.getJavaType())) {
            return null;
        }
        return new GraphQLTypeReference(this.getInputObjectTypeName(type));
    }

    protected Type getElementType(TypeDefinitionRegistry typeRegistry, SingularAttribute<?, ?> singularAttribute, EntityMetamodel entityMetamodel) {
        com.blazebit.persistence.view.metamodel.Type elementType = singularAttribute.getType();
        Type type = elementType.getMappingType() == Type.MappingType.BASIC ? (Collection.class.isAssignableFrom(elementType.getJavaType()) ? this.getScalarType(typeRegistry, singularAttribute.getDeclaringType().getJavaType(), ((MethodAttribute)singularAttribute).getJavaMethod().getGenericReturnType()) : this.getScalarType(typeRegistry, elementType.getJavaType())) : this.getObjectType((ManagedViewType)elementType);
        if (type != null && (singularAttribute.isId() || this.isNotNull(singularAttribute, entityMetamodel))) {
            type = this.makeNonNull(type);
        }
        return type;
    }

    protected Type getInputElementType(TypeDefinitionRegistry typeRegistry, SingularAttribute<?, ?> singularAttribute, EntityMetamodel entityMetamodel) {
        com.blazebit.persistence.view.metamodel.Type elementType = singularAttribute.getType();
        Type type = elementType.getMappingType() == Type.MappingType.BASIC ? (Collection.class.isAssignableFrom(elementType.getJavaType()) ? this.getScalarType(typeRegistry, singularAttribute.getDeclaringType().getJavaType(), ((MethodAttribute)singularAttribute).getJavaMethod().getGenericReturnType()) : this.getScalarType(typeRegistry, elementType.getJavaType())) : this.getInputObjectType((ManagedViewType)elementType);
        if (type != null && (singularAttribute.isId() || this.isNotNull(((MethodAttribute)singularAttribute).getJavaMethod()))) {
            type = this.makeNonNull(type);
        }
        return type;
    }

    protected Type getElementType(TypeDefinitionRegistry typeRegistry, PluralAttribute<?, ?, ?> pluralAttribute) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = pluralAttribute.getElementType();
        Type type = elementType.getMappingType() == Type.MappingType.BASIC ? this.getScalarType(typeRegistry, elementType.getJavaType()) : this.getObjectType((ManagedViewType)elementType);
        Method method = ((MethodAttribute)pluralAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[annotatedArgumentTypes.length - 1].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, annotatedArgumentTypes.length - 1))) {
            type = this.makeNonNull(type);
        }
        return type;
    }

    private static AnnotatedType[] getReturnTypeArgumentAnnotations(Method method) {
        AnnotatedType genericReturnType = method.getAnnotatedReturnType();
        if (genericReturnType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)genericReturnType;
            return parameterizedType.getAnnotatedActualTypeArguments();
        }
        return new AnnotatedType[0];
    }

    protected Type getElementType(TypeDefinitionRegistry typeRegistry, EntityViewManager evm, Class<?> elementType) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(elementType);
        if (managedViewType == null) {
            return this.getScalarType(typeRegistry, elementType);
        }
        return this.getObjectType(managedViewType);
    }

    protected Type getInputElementType(TypeDefinitionRegistry typeRegistry, PluralAttribute<?, ?, ?> pluralAttribute) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = pluralAttribute.getElementType();
        Type type = elementType.getMappingType() == Type.MappingType.BASIC ? this.getScalarType(typeRegistry, elementType.getJavaType()) : this.getInputObjectType((ManagedViewType)elementType);
        Method method = ((MethodAttribute)pluralAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[annotatedArgumentTypes.length - 1].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, annotatedArgumentTypes.length - 1))) {
            type = this.makeNonNull(type);
        }
        return type;
    }

    protected Type getInputElementType(TypeDefinitionRegistry typeRegistry, EntityViewManager evm, Class<?> elementType) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(elementType);
        if (managedViewType == null) {
            return this.getScalarType(typeRegistry, elementType);
        }
        return this.getInputObjectType(managedViewType);
    }

    protected GraphQLOutputType getElementType(GraphQLSchema.Builder schemaBuilder, SingularAttribute<?, ?> singularAttribute, Map<Class<?>, String> registeredTypeNames, EntityMetamodel entityMetamodel) {
        com.blazebit.persistence.view.metamodel.Type elementType = singularAttribute.getType();
        GraphQLOutputType type = elementType.getMappingType() == Type.MappingType.BASIC ? (Collection.class.isAssignableFrom(elementType.getJavaType()) ? this.getScalarType(schemaBuilder, singularAttribute.getDeclaringType().getJavaType(), ((MethodAttribute)singularAttribute).getJavaMethod().getGenericReturnType(), registeredTypeNames) : this.getScalarType(schemaBuilder, elementType.getJavaType(), registeredTypeNames)) : this.getObjectTypeReference((ManagedViewType)elementType);
        if (type != null && (singularAttribute.isId() || this.isNotNull(singularAttribute, entityMetamodel))) {
            type = this.makeNonNull((GraphQLType)type);
        }
        return type;
    }

    protected GraphQLInputType getInputElementType(GraphQLSchema.Builder schemaBuilder, SingularAttribute<?, ?> singularAttribute, Map<Class<?>, String> registeredTypeNames, EntityMetamodel entityMetamodel) {
        com.blazebit.persistence.view.metamodel.Type elementType = singularAttribute.getType();
        GraphQLInputType type = elementType.getMappingType() == Type.MappingType.BASIC ? (Collection.class.isAssignableFrom(elementType.getJavaType()) ? (GraphQLInputType)this.getScalarType(schemaBuilder, singularAttribute.getDeclaringType().getJavaType(), ((MethodAttribute)singularAttribute).getJavaMethod().getGenericReturnType(), registeredTypeNames) : (GraphQLInputType)this.getScalarType(schemaBuilder, elementType.getJavaType(), registeredTypeNames)) : this.getInputObjectTypeReference((ManagedViewType)elementType);
        if (type != null && (singularAttribute.isId() || this.isNotNull(((MethodAttribute)singularAttribute).getJavaMethod()))) {
            type = this.makeNonNull((GraphQLType)type);
        }
        return type;
    }

    protected GraphQLOutputType getElementType(GraphQLSchema.Builder schemaBuilder, PluralAttribute<?, ?, ?> pluralAttribute, Map<Class<?>, String> registeredTypeNames) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = pluralAttribute.getElementType();
        GraphQLOutputType type = elementType.getMappingType() == Type.MappingType.BASIC ? this.getScalarType(schemaBuilder, elementType.getJavaType(), registeredTypeNames) : this.getObjectTypeReference((ManagedViewType)elementType);
        Method method = ((MethodAttribute)pluralAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[annotatedArgumentTypes.length - 1].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, annotatedArgumentTypes.length - 1))) {
            type = this.makeNonNull((GraphQLType)type);
        }
        return type;
    }

    protected GraphQLOutputType getElementType(GraphQLSchema.Builder schemaBuilder, EntityViewManager evm, Class<?> elementType, Map<Class<?>, String> registeredTypeNames) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(elementType);
        if (managedViewType == null) {
            return this.getScalarType(schemaBuilder, elementType, registeredTypeNames);
        }
        return this.getObjectTypeReference(managedViewType);
    }

    protected GraphQLInputType getInputElementType(GraphQLSchema.Builder schemaBuilder, PluralAttribute<?, ?, ?> pluralAttribute, Map<Class<?>, String> registeredTypeNames) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = pluralAttribute.getElementType();
        GraphQLInputType type = elementType.getMappingType() == Type.MappingType.BASIC ? (GraphQLInputType)this.getScalarType(schemaBuilder, elementType.getJavaType(), registeredTypeNames) : this.getInputObjectTypeReference((ManagedViewType)elementType);
        Method method = ((MethodAttribute)pluralAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[annotatedArgumentTypes.length - 1].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, annotatedArgumentTypes.length - 1))) {
            type = this.makeNonNull((GraphQLType)type);
        }
        return type;
    }

    protected GraphQLInputType getInputElementType(GraphQLSchema.Builder schemaBuilder, EntityViewManager evm, Class<?> elementType, Map<Class<?>, String> registeredTypeNames) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(elementType);
        if (managedViewType == null) {
            return (GraphQLInputType)this.getScalarType(schemaBuilder, elementType, registeredTypeNames);
        }
        return this.getInputObjectTypeReference(managedViewType);
    }

    protected Type getKeyType(TypeDefinitionRegistry typeRegistry, MapAttribute<?, ?, ?> mapAttribute) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = mapAttribute.getKeyType();
        Type type = elementType.getMappingType() == Type.MappingType.BASIC ? this.getScalarType(typeRegistry, elementType.getJavaType()) : this.getObjectType((ManagedViewType)elementType);
        Method method = ((MethodAttribute)mapAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0))) {
            type = this.makeNonNull(type);
        }
        return type;
    }

    protected Type getKeyType(TypeDefinitionRegistry typeRegistry, EntityViewManager evm, Class<?> keyType) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(keyType);
        if (managedViewType == null) {
            return this.getScalarType(typeRegistry, keyType);
        }
        return this.getObjectType(managedViewType);
    }

    protected Type getInputKeyType(TypeDefinitionRegistry typeRegistry, MapAttribute<?, ?, ?> mapAttribute) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = mapAttribute.getKeyType();
        Type type = elementType.getMappingType() == Type.MappingType.BASIC ? this.getScalarType(typeRegistry, elementType.getJavaType()) : this.getInputObjectType((ManagedViewType)elementType);
        Method method = ((MethodAttribute)mapAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0))) {
            type = this.makeNonNull(type);
        }
        return type;
    }

    protected Type getInputKeyType(TypeDefinitionRegistry typeRegistry, EntityViewManager evm, Class<?> keyType) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(keyType);
        if (managedViewType == null) {
            return this.getScalarType(typeRegistry, keyType);
        }
        return this.getInputObjectType(managedViewType);
    }

    protected GraphQLOutputType getKeyType(GraphQLSchema.Builder schemaBuilder, MapAttribute<?, ?, ?> mapAttribute, Map<Class<?>, String> registeredTypeNames) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = mapAttribute.getKeyType();
        GraphQLOutputType type = elementType.getMappingType() == Type.MappingType.BASIC ? this.getScalarType(schemaBuilder, elementType.getJavaType(), registeredTypeNames) : this.getObjectTypeReference((ManagedViewType)elementType);
        Method method = ((MethodAttribute)mapAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0))) {
            type = this.makeNonNull((GraphQLType)type);
        }
        return type;
    }

    protected GraphQLOutputType getKeyType(GraphQLSchema.Builder schemaBuilder, EntityViewManager evm, Class<?> keyType, Map<Class<?>, String> registeredTypeNames) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(keyType);
        if (managedViewType == null) {
            return this.getScalarType(schemaBuilder, keyType, registeredTypeNames);
        }
        return this.getObjectTypeReference(managedViewType);
    }

    protected GraphQLInputType getInputKeyType(GraphQLSchema.Builder schemaBuilder, MapAttribute<?, ?, ?> mapAttribute, Map<Class<?>, String> registeredTypeNames) {
        AnnotatedType[] annotatedArgumentTypes;
        com.blazebit.persistence.view.metamodel.Type elementType = mapAttribute.getKeyType();
        GraphQLInputType type = elementType.getMappingType() == Type.MappingType.BASIC ? (GraphQLInputType)this.getScalarType(schemaBuilder, elementType.getJavaType(), registeredTypeNames) : this.getInputObjectTypeReference((ManagedViewType)elementType);
        Method method = ((MethodAttribute)mapAttribute).getJavaMethod();
        if (type != null && (annotatedArgumentTypes = GraphQLEntityViewSupportFactory.getReturnTypeArgumentAnnotations(method)).length != 0 && (this.isNotNull(annotatedArgumentTypes[0].getAnnotations()) || KotlinSupport.isKotlinTypeArgumentNotNull(method, 0))) {
            type = this.makeNonNull((GraphQLType)type);
        }
        return type;
    }

    protected GraphQLInputType getInputKeyType(GraphQLSchema.Builder schemaBuilder, EntityViewManager evm, Class<?> keyType, Map<Class<?>, String> registeredTypeNames) {
        ManagedViewType managedViewType = evm.getMetamodel().managedView(keyType);
        if (managedViewType == null) {
            return (GraphQLInputType)this.getScalarType(schemaBuilder, keyType, registeredTypeNames);
        }
        return this.getInputObjectTypeReference(managedViewType);
    }

    protected GraphQLOutputType getScalarType(String typeName) {
        GraphQLScalarType scalarType;
        if (this.scalarTypeMap != null && (scalarType = this.scalarTypeMap.get(typeName)) != null) {
            return scalarType;
        }
        return new GraphQLTypeReference(typeName);
    }

    protected Type getScalarType(TypeDefinitionRegistry typeRegistry, Class<?> ownerType, java.lang.reflect.Type javaType) {
        if (javaType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)javaType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawType)) {
                Class elementType = ReflectionUtils.resolveType(ownerType, (java.lang.reflect.Type)parameterizedType.getActualTypeArguments()[0]);
                return this.getListType(this.getScalarType(typeRegistry, elementType));
            }
            javaType = rawType;
        }
        if (javaType instanceof Class) {
            return this.getScalarType(typeRegistry, (Class)javaType);
        }
        throw new IllegalArgumentException("Unsupported scalar type: " + javaType);
    }

    protected Type getScalarType(TypeDefinitionRegistry typeRegistry, Class<?> javaType) {
        String typeName = SUPPORTED_TYPES.get(javaType);
        if (typeName == null) {
            if (javaType.isEnum()) {
                typeName = this.getTypeName(javaType);
                if (!typeRegistry.getType(typeName).isPresent()) {
                    ArrayList<EnumValueDefinition> enumValueDefinitions = new ArrayList<EnumValueDefinition>();
                    for (Enum enumConstant : (Enum[])javaType.getEnumConstants()) {
                        enumValueDefinitions.add(new EnumValueDefinition(enumConstant.name(), new ArrayList(0)));
                    }
                    if (this.isDefineNormalTypes()) {
                        typeRegistry.add((SDLDefinition)this.newEnumTypeDefinition(typeName, enumValueDefinitions, this.getDescription(javaType)));
                    }
                }
            } else {
                typeName = "String";
            }
        }
        if (!javaType.isEnum() && this.registeredScalarTypeNames != null && this.registeredScalarTypeNames.add(typeName)) {
            typeRegistry.add((SDLDefinition)new ScalarTypeDefinition(typeName));
        }
        return new TypeName(typeName);
    }

    protected GraphQLOutputType getScalarType(GraphQLSchema.Builder schemaBuilder, Class<?> ownerType, java.lang.reflect.Type javaType, Map<Class<?>, String> registeredTypeNames) {
        if (javaType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)javaType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawType)) {
                Class elementType = ReflectionUtils.resolveType(ownerType, (java.lang.reflect.Type)parameterizedType.getActualTypeArguments()[0]);
                return this.getListType((GraphQLType)this.getScalarType(schemaBuilder, elementType, registeredTypeNames));
            }
            javaType = rawType;
        }
        if (javaType instanceof Class) {
            return this.getScalarType(schemaBuilder, (Class)javaType, registeredTypeNames);
        }
        throw new IllegalArgumentException("Unsupported scalar type: " + javaType);
    }

    protected GraphQLOutputType getScalarType(GraphQLSchema.Builder schemaBuilder, Class<?> javaType, Map<Class<?>, String> registeredTypeNames) {
        GraphQLScalarType scalarType;
        if (this.scalarTypeMap != null && (scalarType = this.scalarTypeMap.get(javaType.getName())) != null) {
            return scalarType;
        }
        String typeName = SUPPORTED_TYPES.get(javaType);
        if (typeName == null) {
            if (javaType.isEnum()) {
                typeName = this.getTypeName(javaType);
                if (!registeredTypeNames.containsKey(javaType)) {
                    GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(typeName);
                    for (Enum enumConstant : (Enum[])javaType.getEnumConstants()) {
                        enumBuilder.value(enumConstant.name());
                    }
                    if (this.isDefineNormalTypes()) {
                        schemaBuilder.additionalType((GraphQLType)enumBuilder.build());
                    }
                    registeredTypeNames.put(javaType, typeName);
                }
            } else {
                typeName = "String";
            }
        }
        if (!javaType.isEnum() && this.registeredScalarTypeNames != null && this.registeredScalarTypeNames.add(typeName)) {
            schemaBuilder.additionalType((GraphQLType)GraphQLScalarType.newScalar().name(typeName).build());
        }
        return new GraphQLTypeReference(typeName);
    }

    protected boolean isNotNull(SingularAttribute<?, ?> attribute, EntityMetamodel entityMetamodel) {
        if (attribute instanceof MappingAttribute && !attribute.isQueryParameter()) {
            AbstractAttribute attr = (AbstractAttribute)attribute;
            Map<Object, Object> rootTypes = attr.getDeclaringType().getEntityViewRootTypes();
            if (rootTypes.isEmpty()) {
                rootTypes = Collections.singletonMap("this", attr.getDeclaringType().getJpaManagedType());
            } else {
                rootTypes = new HashMap(rootTypes);
                rootTypes.put("this", attr.getDeclaringType().getJpaManagedType());
            }
            if (!ExpressionUtils.isNullable((EntityMetamodel)entityMetamodel, rootTypes, (Expression)attr.getMappingExpression())) {
                return true;
            }
        }
        return this.isNotNull(((MethodAttribute)attribute).getJavaMethod());
    }

    protected boolean isNotNull(Method method) {
        return method.getReturnType().isPrimitive() || KotlinSupport.isKotlinNotNull(method) || this.isNotNull(method.getAnnotations());
    }

    protected boolean isNotNull(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            switch (annotation.annotationType().getName()) {
                case "org.eclipse.microprofile.graphql.NonNull": 
                case "com.blazebit.persistence.integration.graphql.GraphQLNonNull": 
                case "io.leangen.graphql.annotations.GraphQLNonNull": 
                case "jakarta.validation.constraints.NotNull": 
                case "jakarta.validation.constraints.NotNull": 
                case "org.springframework.lang.NonNull": 
                case "lombok.NonNull": {
                    return true;
                }
            }
        }
        return false;
    }

    static {
        JAVA_TIME_SER_TYPES = new String[]{Duration.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), ZonedDateTime.class.getName(), ZoneOffset.class.getName(), "java.time.ZoneRegion", OffsetTime.class.getName(), OffsetDateTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), MonthDay.class.getName(), Period.class.getName()};
        HashMap types = new HashMap();
        types.put(Boolean.TYPE, "Boolean");
        types.put(Boolean.class, "Boolean");
        types.put(Integer.TYPE, "Int");
        types.put(Integer.class, "Int");
        types.put(Float.TYPE, "Float");
        types.put(Float.class, "Float");
        types.put(Double.TYPE, "Float");
        types.put(Double.class, "Float");
        types.put(String.class, "String");
        BASIC_TYPES = types;
        HashMap extendedTypes = new HashMap();
        extendedTypes.put(Long.TYPE, "Long");
        extendedTypes.put(Long.class, "Long");
        extendedTypes.put(Short.TYPE, "Short");
        extendedTypes.put(Short.class, "Short");
        extendedTypes.put(Byte.TYPE, "Byte");
        extendedTypes.put(Byte.class, "Byte");
        extendedTypes.put(BigDecimal.class, "BigDecimal");
        extendedTypes.put(BigInteger.class, "BigInteger");
        extendedTypes.put(Character.TYPE, "Char");
        extendedTypes.put(Character.class, "Char");
        extendedTypes.put(LocalDate.class, "Date");
        extendedTypes.put(LocalTime.class, "Time");
        extendedTypes.put(OffsetTime.class, "Time");
        extendedTypes.put(LocalDateTime.class, "DateTime");
        extendedTypes.put(OffsetDateTime.class, "DateTime");
        extendedTypes.put(ZonedDateTime.class, "DateTime");
        extendedTypes.put(Locale.class, "Locale");
        extendedTypes.put(Currency.class, "Currency");
        extendedTypes.put(UUID.class, "UUID");
        extendedTypes.put(URL.class, "Url");
        HashMap supportedTypes = new HashMap(BASIC_TYPES.size() + extendedTypes.size());
        supportedTypes.putAll(BASIC_TYPES);
        try {
            Class.forName("graphql.scalars.ExtendedScalars");
            extendedTypes.put(Class.forName("graphql.scalars.country.code.CountryCode"), "CountryCode");
            supportedTypes.putAll(extendedTypes);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SUPPORTED_TYPES = supportedTypes;
    }

    private static final class DefaultFetchMappingImpl
    implements DefaultFetchMapping {
        private static final DefaultFetchMapping[] EMPTY = new DefaultFetchMapping[0];
        private final String attributeName;
        private final String ifFieldSelected;

        private DefaultFetchMappingImpl(String attributeName, String ifFieldSelected) {
            this.attributeName = attributeName;
            this.ifFieldSelected = ifFieldSelected;
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public String getIfFieldSelected() {
            return this.ifFieldSelected;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DefaultFetchMapping)) {
                return false;
            }
            DefaultFetchMapping that = (DefaultFetchMapping)o;
            return this.attributeName.equals(that.getAttributeName()) && this.ifFieldSelected.equals(that.getIfFieldSelected());
        }

        public int hashCode() {
            int result = this.attributeName.hashCode();
            result = 31 * result + this.ifFieldSelected.hashCode();
            return result;
        }
    }
}

