/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.graphql;

import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.integration.graphql.GraphQLCursor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class GraphQLRelayPageInfo
implements Serializable {
    public static final transient GraphQLRelayPageInfo EMPTY = new GraphQLRelayPageInfo();
    private final boolean hasNextPage;
    private final boolean hasPreviousPage;
    private final String startCursor;
    private final String endCursor;

    private GraphQLRelayPageInfo() {
        this.hasNextPage = true;
        this.hasPreviousPage = true;
        this.startCursor = null;
        this.endCursor = null;
    }

    public GraphQLRelayPageInfo(PagedList<?> data) {
        this.hasPreviousPage = data.getFirstResult() != 0;
        this.hasNextPage = data.size() >= data.getMaxResults() && (data.getTotalSize() == -1L || (long)(data.getFirstResult() + data.getMaxResults()) < data.getTotalSize());
        KeysetPage keysetPage = data.getKeysetPage();
        this.startCursor = keysetPage != null && keysetPage.getLowest() != null ? Base64.getEncoder().encodeToString(this.serialize(data.getFirstResult(), data.getMaxResults(), keysetPage.getLowest().getTuple())) : null;
        this.endCursor = keysetPage != null && keysetPage.getHighest() != null ? Base64.getEncoder().encodeToString(this.serialize(data.getFirstResult(), data.getMaxResults(), keysetPage.getHighest().getTuple())) : null;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public String getStartCursor() {
        return this.startCursor;
    }

    public String getEndCursor() {
        return this.endCursor;
    }

    protected byte[] serialize(GraphQLCursor cursor) {
        return GraphQLRelayPageInfo.serializeCursor(cursor.getOffset(), cursor.getPageSize(), cursor.getTuple());
    }

    protected byte[] serialize(int offset, int pageSize, Serializable[] tuple) {
        return GraphQLRelayPageInfo.serializeCursor(offset, pageSize, tuple);
    }

    protected static byte[] serializeCursor(int offset, int pageSize, Serializable[] tuple) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.write(offset);
            oos.write(pageSize);
            oos.writeObject(tuple);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

