/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.repository;

import com.blazebit.persistence.spring.data.base.query.EntityViewAwareRepositoryMetadata;
import com.blazebit.persistence.spring.data.base.repository.EntityViewAwareCrudMethodMetadata;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.reflection.ReflectionUtils;
import jakarta.persistence.LockModeType;
import jakarta.persistence.QueryHint;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class EntityViewAwareCrudMethodMetadataPostProcessor
implements RepositoryProxyPostProcessor,
BeanClassLoaderAware {
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? ClassUtils.getDefaultClassLoader() : classLoader;
    }

    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)new CrudMethodMetadataPopulatingMethodInterceptor(((EntityViewAwareRepositoryMetadata)repositoryInformation).getEntityViewManager()));
    }

    public EntityViewAwareCrudMethodMetadata getCrudMethodMetadata() {
        ProxyFactory factory = new ProxyFactory();
        factory.addInterface(EntityViewAwareCrudMethodMetadata.class);
        factory.setTargetSource((TargetSource)new ThreadBoundTargetSource());
        return (EntityViewAwareCrudMethodMetadata)factory.getProxy(this.classLoader);
    }

    private static final class CrudMethodMetadataPopulatingMethodInterceptor
    implements MethodInterceptor {
        private final ConcurrentMap<EntityViewMetadataCacheKey, EntityViewAwareCrudMethodMetadata> metadataCache = new ConcurrentHashMap<EntityViewMetadataCacheKey, EntityViewAwareCrudMethodMetadata>();
        private final EntityViewManager evm;

        private CrudMethodMetadataPopulatingMethodInterceptor(EntityViewManager evm) {
            this.evm = evm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            EntityViewAwareCrudMethodMetadata tmp;
            Method method = invocation.getMethod();
            EntityViewAwareCrudMethodMetadata metadata = (EntityViewAwareCrudMethodMetadata)TransactionSynchronizationManager.getResource((Object)method);
            if (metadata != null) {
                return invocation.proceed();
            }
            EntityViewMetadataCacheKey cacheKey = new EntityViewMetadataCacheKey(method, ((ProxyMethodInvocation)invocation).getProxy().getClass());
            EntityViewAwareCrudMethodMetadata methodMetadata = (EntityViewAwareCrudMethodMetadata)this.metadataCache.get(cacheKey);
            if (methodMetadata == null && (tmp = this.metadataCache.putIfAbsent(cacheKey, methodMetadata = new EntityViewAwareDefaultCrudMethodMetadata(cacheKey.proxyClass, method, this.evm))) != null) {
                methodMetadata = tmp;
            }
            TransactionSynchronizationManager.bindResource((Object)method, (Object)methodMetadata);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                TransactionSynchronizationManager.unbindResource((Object)method);
            }
        }
    }

    private static class ThreadBoundTargetSource
    implements TargetSource {
        private ThreadBoundTargetSource() {
        }

        public Class<?> getTargetClass() {
            return EntityViewAwareCrudMethodMetadata.class;
        }

        public boolean isStatic() {
            return false;
        }

        public Object getTarget() throws Exception {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            return TransactionSynchronizationManager.getResource((Object)invocation.getMethod());
        }

        public void releaseTarget(Object target) throws Exception {
        }
    }

    private static class EntityViewAwareDefaultCrudMethodMetadata
    implements EntityViewAwareCrudMethodMetadata {
        private final LockModeType lockModeType;
        private final Map<String, Object> queryHints;
        private final EntityGraph entityGraph;
        private final Class<?> entityViewClass;
        private final Method method;

        public EntityViewAwareDefaultCrudMethodMetadata(Class<?> repositoryClass, Method method, EntityViewManager evm) {
            Assert.notNull((Object)method, (String)"Method must not be null!");
            Method annotationTargetMethod = EntityViewAwareDefaultCrudMethodMetadata.findAnnotationTargetMethod(method);
            this.lockModeType = EntityViewAwareDefaultCrudMethodMetadata.findLockModeType(annotationTargetMethod);
            this.queryHints = EntityViewAwareDefaultCrudMethodMetadata.findQueryHints(annotationTargetMethod);
            this.entityGraph = EntityViewAwareDefaultCrudMethodMetadata.findEntityGraph(annotationTargetMethod);
            this.entityViewClass = EntityViewAwareDefaultCrudMethodMetadata.findEntityViewClass(repositoryClass, method, evm);
            this.method = method;
        }

        private static Method findAnnotationTargetMethod(Method method) {
            if (method.isBridge() || method.isSynthetic()) {
                try {
                    return method.getDeclaringClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            return method;
        }

        private static Class<?> findEntityViewClass(Class<?> repositoryClass, Method methodToAnalyze, EntityViewManager evm) {
            Class[] typeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments(repositoryClass, (Method)methodToAnalyze);
            Class entityViewClass = typeArguments.length == 0 ? ReflectionUtils.getResolvedMethodReturnType(repositoryClass, (Method)methodToAnalyze) : typeArguments[typeArguments.length - 1];
            ManagedViewType managedViewType = evm.getMetamodel().managedView(entityViewClass);
            if (managedViewType == null) {
                return null;
            }
            return managedViewType.getJavaType();
        }

        private static EntityGraph findEntityGraph(Method method) {
            return (EntityGraph)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EntityGraph.class);
        }

        private static LockModeType findLockModeType(Method method) {
            Lock annotation = (Lock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Lock.class);
            return annotation == null ? null : (LockModeType)AnnotationUtils.getValue((Annotation)annotation);
        }

        private static Map<String, Object> findQueryHints(Method method) {
            QueryHint queryHintAnnotation;
            HashMap<String, String> queryHints = new HashMap<String, String>();
            QueryHints queryHintsAnnotation = (QueryHints)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, QueryHints.class);
            if (queryHintsAnnotation != null) {
                for (QueryHint hint : queryHintsAnnotation.value()) {
                    queryHints.put(hint.name(), hint.value());
                }
            }
            if ((queryHintAnnotation = (QueryHint)AnnotationUtils.findAnnotation((Method)method, QueryHint.class)) != null) {
                queryHints.put(queryHintAnnotation.name(), queryHintAnnotation.value());
            }
            return Collections.unmodifiableMap(queryHints);
        }

        @Override
        public LockModeType getLockModeType() {
            return this.lockModeType;
        }

        @Override
        public Map<String, Object> getQueryHints() {
            return this.queryHints;
        }

        @Override
        public EntityGraph getEntityGraph() {
            return this.entityGraph;
        }

        @Override
        public Class<?> getEntityViewClass() {
            return this.entityViewClass;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }
    }

    private static class EntityViewMetadataCacheKey {
        private final Method method;
        private final Class<?> proxyClass;

        public EntityViewMetadataCacheKey(Method method, Class<?> proxyClass) {
            this.method = method;
            this.proxyClass = proxyClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntityViewMetadataCacheKey)) {
                return false;
            }
            EntityViewMetadataCacheKey that = (EntityViewMetadataCacheKey)o;
            return this.method.equals(that.method) && this.proxyClass.equals(that.proxyClass);
        }

        public int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + this.proxyClass.hashCode();
            return result;
        }
    }
}

