/* CCJSqlParser.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. CCJSqlParser.java */
/*
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2014 JSQLParser
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */

package net.sf.jsqlparser.parser;

import net.sf.jsqlparser.expression.*;
import net.sf.jsqlparser.expression.operators.arithmetic.*;
import net.sf.jsqlparser.expression.operators.conditional.*;
import net.sf.jsqlparser.expression.operators.relational.*;
import net.sf.jsqlparser.schema.*;
import net.sf.jsqlparser.statement.*;
import net.sf.jsqlparser.statement.alter.*;
import net.sf.jsqlparser.statement.create.index.*;
import net.sf.jsqlparser.statement.create.table.*;
import net.sf.jsqlparser.statement.create.view.*;
import net.sf.jsqlparser.statement.delete.*;
import net.sf.jsqlparser.statement.drop.*;
import net.sf.jsqlparser.statement.insert.*;
import net.sf.jsqlparser.statement.replace.*;
import net.sf.jsqlparser.statement.execute.*;
import net.sf.jsqlparser.statement.select.*;
import net.sf.jsqlparser.statement.truncate.*;
import net.sf.jsqlparser.statement.update.*;
import net.sf.jsqlparser.statement.merge.*;
import java.util.*;

/**
 * The parser generated by JavaCC
 */
public class CCJSqlParser/*@bgen(jjtree)*/implements CCJSqlParserTreeConstants, CCJSqlParserConstants {/*@bgen(jjtree)*/
  protected JJTCCJSqlParserState jjtree = new JJTCCJSqlParserState();int jdbcParameterIndex = 0;
    boolean errorRecovery = false;
    List<ParseException> parseErrors = new ArrayList<ParseException>();

    private void linkAST(ASTNodeAccess access, SimpleNode node) {
        access.setASTNode(node);
        node.jjtSetValue(access);
    }

    public Node getASTRoot() {
        return jjtree.rootNode();
    }

    public void setErrorRecovery(boolean errorRecovery) {
        this.errorRecovery = errorRecovery;
    }

    public List<ParseException> getParseErrors() {
        return parseErrors;
    }

  final public Statement Statement() throws ParseException {/*@bgen(jjtree) Statement */
  SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Statement stm;
    try {
      try {
        stm = SingleStatement();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          jj_consume_token(ST_SEMICOLON);
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          ;
        }
        jj_consume_token(0);
{if ("" != null) return stm;}
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  final public Statement SingleStatement() throws ParseException {Statement stm = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_SELECT:
      case 173:{
        stm = Select();
        break;
        }
      case K_UPDATE:{
        stm = Update();
        break;
        }
      case K_INSERT:{
        stm = Insert();
        break;
        }
      case K_DELETE:{
        stm = Delete();
        break;
        }
      case K_REPLACE:{
        stm = Replace();
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        if (jj_2_1(2)) {
          stm = AlterTable();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_MERGE:{
            stm = Merge();
            break;
            }
          default:
            jj_la1[2] = jj_gen;
            if (jj_2_2(2147483647)) {
              stm = CreateIndex();
            } else if (jj_2_3(2)) {
              stm = CreateTable();
            } else if (jj_2_4(2)) {
              stm = CreateView();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ALTER:{
                stm = AlterView();
                break;
                }
              case K_DROP:{
                stm = Drop();
                break;
                }
              case K_TRUNCATE:{
                stm = Truncate();
                break;
                }
              case K_EXEC:
              case K_EXECUTE:{
                stm = Execute();
                break;
                }
              case K_SET:{
                stm = Set();
                break;
                }
              default:
                jj_la1[3] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
    }
{if ("" != null) return stm;}
    throw new Error("Missing return statement in function");
}

  final public Statements Statements() throws ParseException {/*@bgen(jjtree) Statements */
  SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
  List<Statement> list = new ArrayList<Statement>();
  Statement stm;
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          break label_1;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        stm = SingleStatement();
list.add(stm);
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[5] = jj_gen;
            break label_2;
          }
          jj_consume_token(ST_SEMICOLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SET:
          case K_DROP:
          case K_WITH:
          case K_DELETE:
          case K_CREATE:
          case K_SELECT:
          case K_INSERT:
          case K_UPDATE:
          case K_REPLACE:
          case K_TRUNCATE:
          case K_ALTER:
          case K_EXEC:
          case K_EXECUTE:
          case K_MERGE:
          case 173:{
            stm = SingleStatement();
list.add(stm);
            break;
            }
          default:
            jj_la1[6] = jj_gen;
            ;
          }
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
stmts.setStatements(list);
        {if ("" != null) return stmts;}
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  void error_skipto(int kind) throws ParseException {ParseException e = generateParseException();
  System.out.println(e.toString());
  Token t;
  do {
    t = getNextToken();
  } while (t.kind != kind && t.kind != EOF);
  }

  final public SetStatement Set() throws ParseException {String name;
    Expression value;
    boolean useEqual = false;
    jj_consume_token(K_SET);
    name = RelObjectNameExt();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 171:{
      jj_consume_token(171);
useEqual=true;
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    value = SimpleExpression();
{if ("" != null) return new SetStatement(name,value).setUseEqual(useEqual);}
    throw new Error("Missing return statement in function");
}

  final public Update Update() throws ParseException {Update update = new Update();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    Expression where = null;
    Column tableColumn = null;
    List<Expression> expList = new ArrayList<Expression>();
    List<Column> columns = new ArrayList<Column>();
    Expression value = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    Select select = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean useColumnsBrackets = false;
    List<SelectExpressionItem> returning = null;
    jj_consume_token(K_UPDATE);
    table = TableWithAlias();
tables.add(table);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      jj_consume_token(172);
      table = TableWithAlias();
tables.add(table);
    }
    jj_consume_token(K_SET);
    if (jj_2_5(3)) {
      tableColumn = Column();
      jj_consume_token(171);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_4;
        }
        jj_consume_token(172);
        tableColumn = Column();
        jj_consume_token(171);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_PERCENT:
      case K_END:
      case K_OPEN:
      case K_TABLE:
      case K_XML:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_PRECISION:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 173:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 173:{
          jj_consume_token(173);
useColumnsBrackets = true;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          ;
        }
        tableColumn = Column();
columns.add(tableColumn);
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            break label_5;
          }
          jj_consume_token(172);
          tableColumn = Column();
columns.add(tableColumn);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 174:{
          jj_consume_token(174);
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          ;
        }
        jj_consume_token(171);
        jj_consume_token(173);
update.setUseSelect(true);
        select = Select();
        jj_consume_token(174);
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
update.setWhere(where);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
update.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
update.setLimit(limit);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 175:{
        jj_consume_token(175);
update.setReturningAllColumns(true);
        break;
        }
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        returning = ListExpressionItem();
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
update.setColumns(columns);
           update.setExpressions(expList);
           update.setTables(tables);
        update.setFromItem(fromItem);
        update.setJoins(joins);
        update.setSelect(select);
        update.setUseColumnsBrackets(useColumnsBrackets);
        update.setReturningExpressionList(returning);
        {if ("" != null) return update;}
    throw new Error("Missing return statement in function");
}

  final public Replace Replace() throws ParseException {Replace replace = new Replace();
    Table table = null;
    Column tableColumn = null;
    Expression value = null;

    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    jj_consume_token(K_REPLACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
replace.setUseIntoTables(true);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      tableColumn = Column();
      jj_consume_token(171);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          break label_6;
        }
        jj_consume_token(172);
        tableColumn = Column();
        jj_consume_token(171);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
replace.setExpressions(expList);
      break;
      }
    case K_WITH:
    case K_VALUE:
    case K_SELECT:
    case K_VALUES:
    case 173:{
      if (jj_2_6(2)) {
        jj_consume_token(173);
        tableColumn = Column();
columns.add(tableColumn);
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[22] = jj_gen;
            break label_7;
          }
          jj_consume_token(172);
          tableColumn = Column();
columns.add(tableColumn);
        }
        jj_consume_token(174);
      } else {
        ;
      }
      if (jj_2_7(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUE:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_VALUES:{
            jj_consume_token(K_VALUES);
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          ;
        }
        jj_consume_token(173);
        exp = PrimaryExpression();
expList.add(exp);
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[25] = jj_gen;
            break label_8;
          }
          jj_consume_token(172);
          exp = PrimaryExpression();
expList.add(exp);
        }
        jj_consume_token(174);
itemsList = new ExpressionList(expList);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:
        case K_SELECT:
        case 173:{
replace.setUseValues(false);
          itemsList = SubSelect();
((SubSelect)itemsList).setUseBrackets(false);
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
replace.setItemsList(itemsList);
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (columns.size() > 0)
               replace.setColumns(columns);
           replace.setTable(table);
        {if ("" != null) return replace;}
    throw new Error("Missing return statement in function");
}

  final public List<SelectExpressionItem> ListExpressionItem() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = SelectExpressionItem();
retval.add(item);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_9;
      }
      jj_consume_token(172);
      item = SelectExpressionItem();
retval.add(item);
    }
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Insert Insert() throws ParseException {Insert insert = new Insert();
    Table table = null;
    Column tableColumn = null;
     List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    InsertModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LOW_PRIORITY:
    case K_DELAYED:
    case K_HIGH_PRIORITY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOW_PRIORITY:{
        tk = jj_consume_token(K_LOW_PRIORITY);
        break;
        }
      case K_DELAYED:{
        tk = jj_consume_token(K_DELAYED);
        break;
        }
      case K_HIGH_PRIORITY:{
        tk = jj_consume_token(K_HIGH_PRIORITY);
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (tk!=null)
        modifierPriority = InsertModifierPriority.valueOf(tk.image.toUpperCase());
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    table = Table();
    if (jj_2_8(2)) {
      jj_consume_token(173);
      tableColumn = Column();
columns.add(tableColumn);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          break label_10;
        }
        jj_consume_token(172);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(174);
    } else {
      ;
    }
    if (jj_2_10(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      jj_consume_token(173);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[36] = jj_gen;
          break label_11;
        }
        jj_consume_token(172);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(174);
itemsList = new ExpressionList(primaryExpList);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_12;
        }
        jj_consume_token(172);
        jj_consume_token(173);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[38] = jj_gen;
            break label_13;
          }
          jj_consume_token(172);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(174);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_SELECT:
      case 173:{
        if (jj_2_9(2)) {
          jj_consume_token(173);
useSelectBrackets = true;
insert.setUseValues(false);
          select = Select();
          jj_consume_token(174);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WITH:
          case K_SELECT:
          case 173:{
insert.setUseValues(false);
            select = Select();
            break;
            }
          default:
            jj_la1[39] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(171);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          break label_14;
        }
        jj_consume_token(172);
        tableColumn = Column();
        jj_consume_token(171);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 175:{
        jj_consume_token(175);
insert.setReturningAllColumns(true);
        break;
        }
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        returning = ListExpressionItem();
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      ;
    }
insert.setItemsList(itemsList);
        insert.setUseSelectBrackets(useSelectBrackets);
        insert.setSelect(select);
        insert.setTable(table);
        if (columns.size() > 0)
            insert.setColumns(columns);
        insert.setUseDuplicate(useDuplicate);
        insert.setDuplicateUpdateColumns(duplicateUpdateColumns);
        insert.setDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
        insert.setReturningExpressionList(returning);
        insert.setModifierPriority(modifierPriority);
        insert.setModifierIgnore(modifierIgnore);
        {if ("" != null) return insert;}
    throw new Error("Missing return statement in function");
}

  final public Delete Delete() throws ParseException {Delete delete = new Delete();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    List<Join> joins = null;
    Expression where = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    jj_consume_token(K_DELETE);
    if (jj_2_11(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_PERCENT:
      case K_END:
      case K_OPEN:
      case K_TABLE:
      case K_XML:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_PRECISION:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        table = TableWithAlias();
tables.add(table);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[45] = jj_gen;
            break label_15;
          }
          jj_consume_token(172);
          table = TableWithAlias();
tables.add(table);
        }
        jj_consume_token(K_FROM);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      table = TableWithAlias();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
delete.setWhere(where);
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
delete.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
delete.setLimit(limit);
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
delete.setTables(tables);
        if (joins != null && joins.size() > 0)
            delete.setJoins(joins);
        delete.setTable(table);
        {if ("" != null) return delete;}
    throw new Error("Missing return statement in function");
}

  final public Statement Merge() throws ParseException {Merge merge = new Merge();
    Table table;
    SubSelect select;
    Alias alias;
    Expression condition;
    MergeUpdate update;
    MergeInsert insert;
    jj_consume_token(K_MERGE);
    jj_consume_token(K_INTO);
    table = TableWithAlias();
merge.setTable(table);
    jj_consume_token(K_USING);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      table = Table();
merge.setUsingTable(table);
      break;
      }
    case 173:{
      jj_consume_token(173);
      select = SubSelect();
merge.setUsingSelect(select);
      jj_consume_token(174);
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
merge.setUsingAlias(alias);
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    jj_consume_token(K_ON);
    jj_consume_token(173);
    condition = Expression();
merge.setOnCondition(condition);
    jj_consume_token(174);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHEN:{
      if (jj_2_12(2)) {
        update = MergeUpdateClause();
merge.setMergeUpdate(update);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert);
          break;
          }
        default:
          jj_la1[53] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert); merge.setInsertFirst(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            update = MergeUpdateClause();
merge.setMergeUpdate(update);
            break;
            }
          default:
            jj_la1[54] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      ;
    }
{if ("" != null) return merge;}
    throw new Error("Missing return statement in function");
}

  final public MergeUpdate MergeUpdateClause() throws ParseException {MergeUpdate mu = new MergeUpdate();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_UPDATE);
    jj_consume_token(K_SET);
    col = Column();
    jj_consume_token(171);
    exp = SimpleExpression();
columns.add(col); expList.add(exp);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        break label_16;
      }
      jj_consume_token(172);
      col = Column();
      jj_consume_token(171);
      exp = SimpleExpression();
columns.add(col); expList.add(exp);
    }
mu.setColumns(columns); mu.setValues(expList);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELETE:{
      jj_consume_token(K_DELETE);
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setDeleteWhereCondition(condition);
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
{if ("" != null) return mu;}
    throw new Error("Missing return statement in function");
}

  final public MergeInsert MergeInsertClause() throws ParseException {MergeInsert mi = new MergeInsert();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_NOT);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_INSERT);
    jj_consume_token(173);
    col = Column();
columns.add(col);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_17;
      }
      jj_consume_token(172);
      col = Column();
columns.add(col);
    }
    jj_consume_token(174);
    jj_consume_token(K_VALUES);
    jj_consume_token(173);
    exp = SimpleExpression();
expList.add(exp);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        break label_18;
      }
      jj_consume_token(172);
      exp = SimpleExpression();
expList.add(exp);
    }
    jj_consume_token(174);
mi.setColumns(columns);
        mi.setValues(expList);
        {if ("" != null) return mi;}
    throw new Error("Missing return statement in function");
}

// See: http://technet.microsoft.com/en-us/library/ms187879%28v=sql.105%29.aspx
  final public 
Column Column() throws ParseException {/*@bgen(jjtree) Column */
    SimpleNode jjtn000 = new SimpleNode(JJTCOLUMN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));String databaseName = null, schemaName = null, tableName = null, columnName = null;
    try {
      if (jj_2_13(7)) {
        databaseName = RelObjectName();
        jj_consume_token(176);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_PERCENT:
        case K_END:
        case K_OPEN:
        case K_TABLE:
        case K_XML:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_PRECISION:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          schemaName = RelObjectName();
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          ;
        }
        jj_consume_token(176);
        tableName = RelObjectName();
        jj_consume_token(176);
        columnName = RelObjectName();
      } else if (jj_2_14(5)) {
        schemaName = RelObjectName();
        jj_consume_token(176);
        tableName = RelObjectName();
        jj_consume_token(176);
        columnName = RelObjectName();
      } else if (jj_2_15(3)) {
        tableName = RelObjectName();
        jj_consume_token(176);
        columnName = RelObjectName();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_PERCENT:
        case K_END:
        case K_OPEN:
        case K_TABLE:
        case K_XML:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_PRECISION:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          columnName = RelObjectName();
          break;
          }
        default:
          jj_la1[63] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
final Database database = new Database(databaseName);
        final Table table = new Table(database, schemaName, tableName);
        Column col = new Column(table, columnName);
        linkAST(col,jjtn000);
        {if ("" != null) return col;}
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  final public String RelObjectName() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    case K_CAST:{
      tk = jj_consume_token(K_CAST);
      break;
      }
    case K_DO:{
      tk = jj_consume_token(K_DO);
      break;
      }
    case K_EXTRACT:{
      tk = jj_consume_token(K_EXTRACT);
      break;
      }
    case K_FIRST:{
      tk = jj_consume_token(K_FIRST);
      break;
      }
    case K_FOLLOWING:{
      tk = jj_consume_token(K_FOLLOWING);
      break;
      }
    case K_LAST:{
      tk = jj_consume_token(K_LAST);
      break;
      }
    case K_MATERIALIZED:{
      tk = jj_consume_token(K_MATERIALIZED);
      break;
      }
    case K_NULLS:{
      tk = jj_consume_token(K_NULLS);
      break;
      }
    case K_PARTITION:{
      tk = jj_consume_token(K_PARTITION);
      break;
      }
    case K_RANGE:{
      tk = jj_consume_token(K_RANGE);
      break;
      }
    case K_ROW:{
      tk = jj_consume_token(K_ROW);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
      break;
      }
    case K_SIBLINGS:{
      tk = jj_consume_token(K_SIBLINGS);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_XML:{
      tk = jj_consume_token(K_XML);
      break;
      }
    case K_COLUMN:{
      tk = jj_consume_token(K_COLUMN);
      break;
      }
    case K_REPLACE:{
      tk = jj_consume_token(K_REPLACE);
      break;
      }
    case K_TRUNCATE:{
      tk = jj_consume_token(K_TRUNCATE);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
      break;
      }
    case K_ANY:{
      tk = jj_consume_token(K_ANY);
      break;
      }
    case K_OPEN:{
      tk = jj_consume_token(K_OPEN);
      break;
      }
    case K_OVER:{
      tk = jj_consume_token(K_OVER);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_PERCENT:{
      tk = jj_consume_token(K_PERCENT);
      break;
      }
    case K_PRIOR:{
      tk = jj_consume_token(K_PRIOR);
      break;
      }
    case K_SEPARATOR:{
      tk = jj_consume_token(K_SEPARATOR);
      break;
      }
    case K_NO:{
      tk = jj_consume_token(K_NO);
      break;
      }
    case K_ACTION:{
      tk = jj_consume_token(K_ACTION);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
      break;
      }
    case K_END:{
      tk = jj_consume_token(K_END);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_DATETIMELITERAL:{
      tk = jj_consume_token(K_DATETIMELITERAL);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
      break;
      }
    case K_PRECISION:{
      tk = jj_consume_token(K_PRECISION);
      break;
      }
    case K_INSERT:{
      tk = jj_consume_token(K_INSERT);
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return tk.image;}
    throw new Error("Missing return statement in function");
}

/*
Extended usage of object names.
*/
  final public String RelObjectNameExt() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectName();
      break;
      }
    case K_LEFT:{
      tk = jj_consume_token(K_LEFT);
      break;
      }
    case K_RIGHT:{
      tk = jj_consume_token(K_RIGHT);
      break;
      }
    case K_SET:{
      tk = jj_consume_token(K_SET);
      break;
      }
    case K_DOUBLE:{
      jj_consume_token(K_DOUBLE);
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

/*
Extended usage of object names - part 2.
*/
  final public String RelObjectNameExt2() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_SET:
    case K_PERCENT:
    case K_END:
    case K_LEFT:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_RIGHT:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_DOUBLE:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameExt();
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Table Table() throws ParseException {/*@bgen(jjtree) Table */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));String serverName = null, databaseName = null, schemaName = null, tableName = null;
    try {
      if (jj_2_16(7)) {
        serverName = RelObjectName();
        jj_consume_token(176);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_PERCENT:
        case K_END:
        case K_OPEN:
        case K_TABLE:
        case K_XML:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_PRECISION:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          databaseName = RelObjectName();
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          ;
        }
        jj_consume_token(176);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_PERCENT:
        case K_END:
        case K_OPEN:
        case K_TABLE:
        case K_XML:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_PRECISION:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          schemaName = RelObjectName();
          break;
          }
        default:
          jj_la1[68] = jj_gen;
          ;
        }
        jj_consume_token(176);
        tableName = RelObjectName();
      } else if (jj_2_17(5)) {
        databaseName = RelObjectName();
        jj_consume_token(176);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_PERCENT:
        case K_END:
        case K_OPEN:
        case K_TABLE:
        case K_XML:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_PRECISION:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          schemaName = RelObjectName();
          break;
          }
        default:
          jj_la1[69] = jj_gen;
          ;
        }
        jj_consume_token(176);
        tableName = RelObjectName();
      } else if (jj_2_18(3)) {
        schemaName = RelObjectName();
        jj_consume_token(176);
        tableName = RelObjectName();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_PERCENT:
        case K_END:
        case K_OPEN:
        case K_TABLE:
        case K_XML:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_PRECISION:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          tableName = RelObjectName();
          break;
          }
        default:
          jj_la1[70] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
final Server server = new Server(serverName);
        final Database database = new Database(server, databaseName);
        Table table = new Table(database, schemaName, tableName);
        linkAST(table,jjtn000);
        {if ("" != null) return table;}
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  final public Table TableWithAlias() throws ParseException {Table table = null;
    Alias alias = null;
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
table.setAlias(alias);
      break;
      }
    default:
      jj_la1[71] = jj_gen;
      ;
    }
{if ("" != null) return table;}
    throw new Error("Missing return statement in function");
}

  final public Select Select() throws ParseException {Select select = new Select();
    SelectBody selectBody = null;
    List<WithItem> with = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      with = WithList();

      break;
      }
    default:
      jj_la1[72] = jj_gen;
      ;
    }
    selectBody = SelectBody();
select.setWithItemsList(with);
        select.setSelectBody(selectBody);
        {if ("" != null) return select;}
    throw new Error("Missing return statement in function");
}

  final public SelectBody SelectBody() throws ParseException {SelectBody selectBody = null;
    selectBody = SetOperationList();
{if ("" != null) return selectBody;}
    throw new Error("Missing return statement in function");
}

  final public PlainSelect PlainSelect() throws ParseException {PlainSelect plainSelect = new PlainSelect();
    List<SelectItem> selectItems = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    List<SelectItem> distinctOn = null;
    Expression where = null;
    List<OrderByElement> orderByElements;
    List<Expression> groupByColumnReferences = null;
    Expression having = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    Top top = null;
        Skip skip = null;
        First first = null;
    OracleHierarchicalExpression oracleHierarchicalQueryClause = null;
    List<Table> intoTables = null;
    Table updateTable = null;
    Wait wait = null;
    jj_consume_token(K_SELECT);
plainSelect.setOracleHint(getOracleHint());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SKIP:{
      skip = Skip();
plainSelect.setSkip(skip);
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    if (jj_2_19(2)) {
      first = First();
plainSelect.setFirst(first);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALL:
    case K_DISTINCT:
    case K_UNIQUE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALL:{
        jj_consume_token(K_ALL);
        break;
        }
      case K_DISTINCT:{
        jj_consume_token(K_DISTINCT);
Distinct distinct = new Distinct(); plainSelect.setDistinct(distinct);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:{
          jj_consume_token(K_ON);
          jj_consume_token(173);
          distinctOn = SelectItemsList();
plainSelect.getDistinct().setOnSelectItems(distinctOn);
          jj_consume_token(174);
          break;
          }
        default:
          jj_la1[74] = jj_gen;
          ;
        }
        break;
        }
      case K_UNIQUE:{
        jj_consume_token(K_UNIQUE);
Distinct distinct = new Distinct(true); plainSelect.setDistinct(distinct);
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TOP:{
      top = Top();
plainSelect.setTop(top);
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    selectItems = SelectItemsList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      intoTables = IntoClause();
plainSelect.setIntoTables(intoTables);
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
plainSelect.setWhere(where);
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:
    case K_CONNECT:{
      oracleHierarchicalQueryClause = OracleHierarchicalQueryClause();
plainSelect.setOracleHierarchical(oracleHierarchicalQueryClause);
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GROUP:{
      groupByColumnReferences = GroupByColumnReferences();
plainSelect.setGroupByColumnReferences(groupByColumnReferences);
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_HAVING:{
      having = Having();
plainSelect.setHaving(having);
      break;
      }
    default:
      jj_la1[83] = jj_gen;
      ;
    }
    if (jj_2_20(2147483647)) {
      orderByElements = OrderByElements();
plainSelect.setOracleSiblings(true); plainSelect.setOrderByElements(orderByElements);
    } else {
      ;
    }
    if (jj_2_21(2147483647)) {
      orderByElements = OrderByElements();
plainSelect.setOrderByElements(orderByElements);
    } else {
      ;
    }
    if (jj_2_22(2147483647)) {
      limit = LimitWithOffset();
plainSelect.setLimit(limit);
    } else {
      ;
    }
    if (jj_2_23(2147483647)) {
      offset = Offset();
plainSelect.setOffset(offset);
    } else {
      ;
    }
    if (jj_2_24(2147483647)) {
      fetch = Fetch();
plainSelect.setFetch(fetch);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FOR:{
      jj_consume_token(K_FOR);
      jj_consume_token(K_UPDATE);
plainSelect.setForUpdate(true);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_OF:{
        jj_consume_token(K_OF);
        updateTable = Table();
plainSelect.setForUpdateTable(updateTable);
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        ;
      }
      if (jj_2_25(2147483647)) {
        wait = Wait();
plainSelect.setWait(wait);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      ;
    }
plainSelect.setSelectItems(selectItems);
        plainSelect.setFromItem(fromItem);
        if (joins != null && joins.size() > 0)
            plainSelect.setJoins(joins);
        {if ("" != null) return plainSelect;}
    throw new Error("Missing return statement in function");
}

  final public SelectBody SetOperationList() throws ParseException {SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    SelectBody select = null;
    List<SelectBody> selects = new ArrayList<SelectBody>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    List<Boolean> brackets = new ArrayList<Boolean>();
    boolean bracket;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 173:{
      jj_consume_token(173);
      select = SelectBody();
      jj_consume_token(174);
bracket=true;
      break;
      }
    case K_SELECT:{
      select = PlainSelect();
bracket=false;
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
selects.add(select);brackets.add(bracket);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_UNION:
      case K_INTERSECT:
      case K_EXCEPT:
      case K_MINUS:{
        ;
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        break label_19;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_UNION:{
        jj_consume_token(K_UNION);
UnionOp union = new UnionOp();operations.add(union);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:
        case K_DISTINCT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:{
            jj_consume_token(K_ALL);
union.setAll(true);
            break;
            }
          case K_DISTINCT:{
            jj_consume_token(K_DISTINCT);
union.setDistinct(true);
            break;
            }
          default:
            jj_la1[88] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[89] = jj_gen;
          ;
        }
        break;
        }
      case K_INTERSECT:{
        jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
        break;
        }
      case K_MINUS:{
        jj_consume_token(K_MINUS);
operations.add(new MinusOp());
        break;
        }
      case K_EXCEPT:{
        jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 173:{
        jj_consume_token(173);
        select = SelectBody();
        jj_consume_token(174);
bracket=true;
        break;
        }
      case K_SELECT:{
        select = PlainSelect();
bracket=false;
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
selects.add(select);brackets.add(bracket);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
list.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    if (jj_2_26(2147483647)) {
      limit = LimitWithOffset();
list.setLimit(limit);
    } else {
      ;
    }
    if (jj_2_27(2147483647)) {
      offset = Offset();
list.setOffset(offset);
    } else {
      ;
    }
    if (jj_2_28(2147483647)) {
      fetch = Fetch();
list.setFetch(fetch);
    } else {
      ;
    }
if (selects.size()==1 && selects.get(0) instanceof PlainSelect) {
            if (brackets.get(0))
                ((PlainSelect)selects.get(0)).setUseBrackets(true);
            {if ("" != null) return selects.get(0);}
        } else {
            list.setBracketsOpsAndSelects(brackets,selects,operations);
            {if ("" != null) return list;}
        }
    throw new Error("Missing return statement in function");
}

  final public List<WithItem> WithList() throws ParseException {List<WithItem> withItemsList = new ArrayList<WithItem>();
    WithItem with = null;
    jj_consume_token(K_WITH);
    with = WithItem();
withItemsList.add(with);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        break label_20;
      }
      jj_consume_token(172);
      with = WithItem();
withItemsList.add(with);
    }
{if ("" != null) return withItemsList;}
    throw new Error("Missing return statement in function");
}

  final public WithItem WithItem() throws ParseException {/*@bgen(jjtree) WithItem */
    SimpleNode jjtn000 = new SimpleNode(JJTWITHITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));WithItem with = new WithItem();
    String name = null;
    List<SelectItem> selectItems = null;
    SelectBody selectBody = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RECURSIVE:{
        jj_consume_token(K_RECURSIVE);
with.setRecursive(true);
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      name = RelObjectName();
with.setName(name);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 173:{
        jj_consume_token(173);
        selectItems = SelectItemsList();
        jj_consume_token(174);
with.setWithItemList(selectItems);
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        ;
      }
      jj_consume_token(K_AS);
      jj_consume_token(173);
      selectBody = SelectBody();
with.setSelectBody(selectBody);
      jj_consume_token(174);
jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       jjtn000.jjtSetLastToken(getToken(0));
{if ("" != null) return with;}
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new Error("Missing return statement in function");
}

  final public List<SelectItem> SelectItemsList() throws ParseException {List<SelectItem> selectItemsList = new ArrayList<SelectItem>();
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList.add(selectItem);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        break label_21;
      }
      jj_consume_token(172);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
{if ("" != null) return selectItemsList;}
    throw new Error("Missing return statement in function");
}

  final public SelectExpressionItem SelectExpressionItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = SimpleExpression();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      ;
    }
{if ("" != null) return selectExpressionItem;}
    throw new Error("Missing return statement in function");
}

  final public SelectItem SelectItem() throws ParseException {SelectItem selectItem = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 175:{
      jj_consume_token(175);
selectItem = new AllColumns();
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      if (jj_2_29(2147483647)) {
        selectItem = AllTableColumns();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_SET:
        case K_PERCENT:
        case K_END:
        case K_NULL:
        case K_LEFT:
        case K_OPEN:
        case K_CASE:
        case K_TABLE:
        case K_XML:
        case K_RIGHT:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_INTERVAL:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_GROUP_CONCAT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_TIME_KEY_EXPR:
        case K_DOUBLE:
        case K_PRECISION:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 173:
        case 177:
        case 178:
        case 179:
        case 182:
        case 192:
        case 199:
        case 201:
        case 202:
        case 204:
        case 209:{
          selectItem = SelectExpressionItem();
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return selectItem;}
    throw new Error("Missing return statement in function");
}

  final public AllTableColumns AllTableColumns() throws ParseException {Table table = null;
    table = Table();
    jj_consume_token(176);
    jj_consume_token(175);
{if ("" != null) return new AllTableColumns(table);}
    throw new Error("Missing return statement in function");
}

  final public Alias Alias() throws ParseException {String name = null;
  boolean useAs = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
useAs = true;
      break;
      }
    default:
      jj_la1[100] = jj_gen;
      ;
    }
    name = RelObjectName();
{if ("" != null) return new Alias(name,useAs);}
    throw new Error("Missing return statement in function");
}

  final public FunctionItem FunctionItem() throws ParseException {Alias alias = null;
    Function function;
    FunctionItem functionItem;
    function = Function();
functionItem = new FunctionItem(); functionItem.setFunction(function);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
functionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      ;
    }
{if ("" != null) return functionItem;}
    throw new Error("Missing return statement in function");
}

  final public List<Column> PivotForColumns() throws ParseException {List<Column> columns = new ArrayList<Column>();
    Column column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 173:{
      jj_consume_token(173);
      column = Column();
columns.add(column);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[102] = jj_gen;
          break label_22;
        }
        jj_consume_token(172);
        column = Column();
columns.add(column);
      }
      jj_consume_token(174);
      break;
      }
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      column = Column();
columns.add(column);
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return columns;}
    throw new Error("Missing return statement in function");
}

  final public List<FunctionItem> PivotFunctionItems() throws ParseException {List<FunctionItem> functionItems = new ArrayList<FunctionItem>();
    FunctionItem item;
    item = FunctionItem();
functionItems.add(item);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        break label_23;
      }
      jj_consume_token(172);
      item = FunctionItem();
functionItems.add(item);
    }
{if ("" != null) return functionItems;}
    throw new Error("Missing return statement in function");
}

  final public List<SelectExpressionItem> PivotSingleInItems() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = SelectExpressionItem();
retval.add(item);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[105] = jj_gen;
        break label_24;
      }
      jj_consume_token(172);
      item = SelectExpressionItem();
retval.add(item);
    }
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionListItem ExpressionListItem() throws ParseException {ExpressionListItem expressionListItem = null;
    ExpressionList expressionList = null;
    Alias alias = null;
    jj_consume_token(173);
    expressionList = SimpleExpressionList();
expressionListItem = new ExpressionListItem(); expressionListItem.setExpressionList(expressionList);
    jj_consume_token(174);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
expressionListItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      ;
    }
{if ("" != null) return expressionListItem;}
    throw new Error("Missing return statement in function");
}

  final public List<ExpressionListItem> PivotMultiInItems() throws ParseException {List<ExpressionListItem> retval = new ArrayList<ExpressionListItem>();
   ExpressionListItem item;
    item = ExpressionListItem();
retval.add(item);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[107] = jj_gen;
        break label_25;
      }
      jj_consume_token(172);
      item = ExpressionListItem();
retval.add(item);
    }
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Pivot Pivot() throws ParseException {Pivot retval = new Pivot();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(173);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(173);
    if (jj_2_30(3)) {
      singleInItems = PivotSingleInItems();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 173:{
        multiInItems = PivotMultiInItems();
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(174);
    jj_consume_token(174);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public PivotXml PivotXml() throws ParseException {PivotXml retval = new PivotXml();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    SelectBody inSelect = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(K_XML);
    jj_consume_token(173);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(173);
    if (jj_2_31(2)) {
      jj_consume_token(K_ANY);
retval.setInAny(true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case 173:{
        inSelect = SelectBody();
        break;
        }
      default:
        jj_la1[109] = jj_gen;
        if (jj_2_32(2)) {
          singleInItems = PivotSingleInItems();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 173:{
            multiInItems = PivotMultiInItems();
            break;
            }
          default:
            jj_la1[110] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(174);
    jj_consume_token(174);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setInSelect(inSelect);
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public List<Table> IntoClause() throws ParseException {List<Table> tables = new ArrayList<Table>();
    Table table;
    jj_consume_token(K_INTO);
    table = Table();
tables.add(table);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        break label_26;
      }
      jj_consume_token(172);
      table = Table();
tables.add(table);
    }
{if ("" != null) return tables;}
    throw new Error("Missing return statement in function");
}

  final public FromItem FromItem() throws ParseException {FromItem fromItem = null;
    Pivot pivot = null;
    Alias alias = null;
    if (jj_2_36(2147483647)) {
      fromItem = ValuesList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_LEFT:
      case K_OPEN:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_LATERAL:
      case K_MATERIALIZED:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_DOUBLE:
      case K_PRECISION:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 209:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 173:{
          jj_consume_token(173);
          if (jj_2_33(2147483647)) {
            fromItem = SubJoin();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_WITH:
            case K_SELECT:
            case 173:{
              fromItem = SubSelect();
              break;
              }
            default:
              jj_la1[112] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(174);
          break;
          }
        default:
          jj_la1[113] = jj_gen;
          if (jj_2_34(2147483647)) {
            fromItem = TableFunction();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DO:
            case K_ANY:
            case K_KEY:
            case K_PERCENT:
            case K_END:
            case K_OPEN:
            case K_TABLE:
            case K_XML:
            case K_VALUE:
            case K_INSERT:
            case K_VALUES:
            case K_REPLACE:
            case K_TRUNCATE:
            case K_CAST:
            case K_OVER:
            case K_PARTITION:
            case K_EXTRACT:
            case K_MATERIALIZED:
            case K_PRIOR:
            case K_SIBLINGS:
            case K_COLUMN:
            case K_NULLS:
            case K_FIRST:
            case K_LAST:
            case K_ROWS:
            case K_RANGE:
            case K_FOLLOWING:
            case K_ROW:
            case K_COMMIT:
            case K_SEPARATOR:
            case K_CASCADE:
            case K_NO:
            case K_ACTION:
            case K_DATETIMELITERAL:
            case K_PRECISION:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              fromItem = Table();
              break;
              }
            case K_LATERAL:{
              fromItem = LateralSubSelect();
              break;
              }
            default:
              jj_la1[114] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PIVOT:{
          if (jj_2_35(2)) {
            pivot = PivotXml();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_PIVOT:{
              pivot = Pivot();
              break;
              }
            default:
              jj_la1[115] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
fromItem.setPivot(pivot);
          break;
          }
        default:
          jj_la1[116] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_AS:
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_PERCENT:
        case K_END:
        case K_OPEN:
        case K_TABLE:
        case K_XML:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_PRECISION:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          alias = Alias();
fromItem.setAlias(alias);
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return fromItem;}
    throw new Error("Missing return statement in function");
}

  final public FromItem ValuesList() throws ParseException {MultiExpressionList exprList = new MultiExpressionList();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ValuesList valuesList = new ValuesList();
    Expression exp = null;
    List<String> colNames = null;
    String colName;
    Alias alias;
    jj_consume_token(173);
    jj_consume_token(K_VALUES);
    if (jj_2_37(3)) {
      jj_consume_token(173);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          break label_27;
        }
        jj_consume_token(172);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(174);
exprList.addExpressionList(primaryExpList);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          ;
          break;
          }
        default:
          jj_la1[120] = jj_gen;
          break label_28;
        }
        jj_consume_token(172);
        jj_consume_token(173);
        exp = SimpleExpression();
primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_29:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[121] = jj_gen;
            break label_29;
          }
          jj_consume_token(172);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(174);
exprList.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        exp = SimpleExpression();
exprList.addExpressionList(exp); valuesList.setNoBrackets(true);
        label_30:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[122] = jj_gen;
            break label_30;
          }
          jj_consume_token(172);
          exp = SimpleExpression();
exprList.addExpressionList(exp);
        }
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(174);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_PERCENT:
    case K_END:
    case K_OPEN:
    case K_TABLE:
    case K_XML:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_PRECISION:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
valuesList.setAlias(alias);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 173:{
        jj_consume_token(173);
        colName = RelObjectName();
colNames = new ArrayList<String>(); colNames.add(colName);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[124] = jj_gen;
            break label_31;
          }
          jj_consume_token(172);
          colName = RelObjectName();
colNames.add(colName);
        }
        jj_consume_token(174);
valuesList.setColumnNames(colNames);
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[126] = jj_gen;
      ;
    }
valuesList.setMultiExpressionList(exprList);
        {if ("" != null) return valuesList;}
    throw new Error("Missing return statement in function");
}

  final public LateralSubSelect LateralSubSelect() throws ParseException {LateralSubSelect lateralSubSelect = new LateralSubSelect();
    SubSelect subSelect = null;
    jj_consume_token(K_LATERAL);
    jj_consume_token(173);
    subSelect = SubSelect();
    jj_consume_token(174);
lateralSubSelect.setSubSelect(subSelect);
        {if ("" != null) return lateralSubSelect;}
    throw new Error("Missing return statement in function");
}

  final public FromItem SubJoin() throws ParseException {FromItem fromItem = null;
    Join join = null;
    SubJoin subJoin = new SubJoin();
    fromItem = FromItem();
subJoin.setLeft(fromItem);
    join = JoinerExpression();
subJoin.setJoin(join);
{if ("" != null) return subJoin;}
    throw new Error("Missing return statement in function");
}

  final public List JoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_JOIN:
      case K_LEFT:
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_RIGHT:
      case K_NATURAL:
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        break label_32;
      }
      join = JoinerExpression();
joinsList.add(join);
    }
{if ("" != null) return joinsList;}
    throw new Error("Missing return statement in function");
}

  final public Join JoinerExpression() throws ParseException {Join join = new Join();
    FromItem right = null;
    Expression onExpression = null;
    Column tableColumn;
    List<Column> columns = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LEFT:
    case K_CROSS:
    case K_FULL:
    case K_INNER:
    case K_RIGHT:
    case K_NATURAL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LEFT:{
        jj_consume_token(K_LEFT);
join.setLeft(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTER:
        case K_SEMI:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SEMI:{
            jj_consume_token(K_SEMI);
join.setSemi(true);
            break;
            }
          case K_OUTER:{
            jj_consume_token(K_OUTER);
join.setOuter(true);
            break;
            }
          default:
            jj_la1[128] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[129] = jj_gen;
          ;
        }
        break;
        }
      case K_FULL:
      case K_RIGHT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_RIGHT:{
          jj_consume_token(K_RIGHT);
join.setRight(true);
          break;
          }
        case K_FULL:{
          jj_consume_token(K_FULL);
join.setFull(true);
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          ;
        }
        break;
        }
      case K_INNER:{
        jj_consume_token(K_INNER);
join.setInner(true);
        break;
        }
      case K_NATURAL:{
        jj_consume_token(K_NATURAL);
join.setNatural(true);
        break;
        }
      case K_CROSS:{
        jj_consume_token(K_CROSS);
join.setCross(true);
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JOIN:{
      jj_consume_token(K_JOIN);
      break;
      }
    case 172:{
      jj_consume_token(172);
join.setSimple(true);
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    right = FromItem();
    if (jj_2_38(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:{
        jj_consume_token(K_ON);
        onExpression = Expression();
join.setOnExpression(onExpression);
        break;
        }
      case K_USING:{
        jj_consume_token(K_USING);
        jj_consume_token(173);
        tableColumn = Column();
columns = new ArrayList(); columns.add(tableColumn);
        label_33:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[135] = jj_gen;
            break label_33;
          }
          jj_consume_token(172);
          tableColumn = Column();
columns.add(tableColumn);
        }
        jj_consume_token(174);
join.setUsingColumns(columns);
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
join.setRightItem(right);
    {if ("" != null) return join;}
    throw new Error("Missing return statement in function");
}

  final public Expression WhereClause() throws ParseException {Expression retval = null;
    jj_consume_token(K_WHERE);
    retval = Expression();
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public OracleHierarchicalExpression OracleHierarchicalQueryClause() throws ParseException {OracleHierarchicalExpression result = new OracleHierarchicalExpression();
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:{
      jj_consume_token(K_START);
      jj_consume_token(K_WITH);
      expr = AndExpression();
result.setStartExpression(expr);
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
      break;
      }
    case K_CONNECT:{
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
                    result.setConnectFirst(true);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        expr = AndExpression();
result.setStartExpression(expr);
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public List<Expression> GroupByColumnReferences() throws ParseException {Expression columnReference = null;
    List<Expression> columnReferences = new ArrayList<Expression>();
    jj_consume_token(K_GROUP);
    jj_consume_token(K_BY);
    columnReference = SimpleExpression();
columnReferences.add(columnReference);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        break label_34;
      }
      jj_consume_token(172);
      columnReference = SimpleExpression();
columnReferences.add(columnReference);
    }
{if ("" != null) return columnReferences;}
    throw new Error("Missing return statement in function");
}

  final public Expression Having() throws ParseException {Expression having = null;
    jj_consume_token(K_HAVING);
    having = Expression();
{if ("" != null) return having;}
    throw new Error("Missing return statement in function");
}

  final public List<OrderByElement> OrderByElements() throws ParseException {List<OrderByElement> orderByList = new ArrayList<OrderByElement>();
    OrderByElement orderByElement = null;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SIBLINGS:{
      jj_consume_token(K_SIBLINGS);
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    jj_consume_token(K_BY);
    orderByElement = OrderByElement();
orderByList.add(orderByElement);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        break label_35;
      }
      jj_consume_token(172);
      orderByElement = OrderByElement();
orderByList.add(orderByElement);
    }
{if ("" != null) return orderByList;}
    throw new Error("Missing return statement in function");
}

  final public OrderByElement OrderByElement() throws ParseException {OrderByElement orderByElement = new OrderByElement();
    Expression columnReference = null;
    columnReference = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
orderByElement.setAsc(false);
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
orderByElement.setAscDescPresent(true);
      break;
      }
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NULLS:{
      jj_consume_token(K_NULLS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FIRST:
      case K_LAST:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
          break;
          }
        case K_LAST:{
          jj_consume_token(K_LAST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
          break;
          }
        default:
          jj_la1[146] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[147] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      ;
    }
orderByElement.setExpression(columnReference);
        {if ("" != null) return orderByElement;}
    throw new Error("Missing return statement in function");
}

  final public Limit LimitWithOffset() throws ParseException {Limit limit = new Limit();
    Token token = null;
    if (jj_2_43(5)) {
      jj_consume_token(K_LIMIT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        token = jj_consume_token(S_LONG);
limit.setOffset(new LongValue(token.image));
        break;
        }
      case 177:{
        jj_consume_token(177);
limit.setOffset(new JdbcParameter(++jdbcParameterIndex, false));
        if (jj_2_39(2)) {
          token = jj_consume_token(S_LONG);
((JdbcParameter)limit.getOffset()).setUseFixedIndex(true); ((JdbcParameter)limit.getOffset()).setIndex(Integer.valueOf(token.image));
        } else {
          ;
        }
        break;
        }
      case 178:{
        jj_consume_token(178);
limit.setOffset(new JdbcNamedParameter());
        if (jj_2_40(2)) {
          token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)limit.getOffset()).setName(token.image);
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(172);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
        break;
        }
      case 177:{
        jj_consume_token(177);
limit.setRowCount(new JdbcParameter(++jdbcParameterIndex, false));
        if (jj_2_41(2)) {
          token = jj_consume_token(S_LONG);
((JdbcParameter)limit.getRowCount()).setUseFixedIndex(true); ((JdbcParameter)limit.getRowCount()).setIndex(Integer.valueOf(token.image));
        } else {
          ;
        }
        break;
        }
      case 178:{
        jj_consume_token(178);
limit.setRowCount(new JdbcNamedParameter());
        if (jj_2_42(2)) {
          token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)limit.getRowCount()).setName(token.image);
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIMIT:{
        limit = PlainLimit();
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return limit;}
    throw new Error("Missing return statement in function");
}

  final public Limit PlainLimit() throws ParseException {Limit limit = new Limit();
    Token token = null;
    jj_consume_token(K_LIMIT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
      break;
      }
    case 177:{
      jj_consume_token(177);
limit.setRowCount(new JdbcParameter(++jdbcParameterIndex, false));
      if (jj_2_44(2)) {
        token = jj_consume_token(S_LONG);
((JdbcParameter)limit.getRowCount()).setUseFixedIndex(true); ((JdbcParameter)limit.getRowCount()).setIndex(Integer.valueOf(token.image));
      } else {
        ;
      }
      break;
      }
    case 178:{
      jj_consume_token(178);
limit.setRowCount(new JdbcNamedParameter());
      if (jj_2_45(2)) {
        token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)limit.getRowCount()).setName(token.image);
      } else {
        ;
      }
      break;
      }
    case K_ALL:{
      jj_consume_token(K_ALL);
limit.setLimitAll(true);
      break;
      }
    case K_NULL:{
      jj_consume_token(K_NULL);
limit.setLimitNull(true);
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return limit;}
    throw new Error("Missing return statement in function");
}

  final public Offset Offset() throws ParseException {Offset offset = new Offset();
    Token token = null;
    jj_consume_token(K_OFFSET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
offset.setOffset(Long.parseLong(token.image));
      break;
      }
    case 177:{
      jj_consume_token(177);
offset.setOffsetJdbcParameter(true);
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:
    case K_ROW:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
offset.setOffsetParam("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
offset.setOffsetParam("ROW");
        break;
        }
      default:
        jj_la1[154] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[155] = jj_gen;
      ;
    }
{if ("" != null) return offset;}
    throw new Error("Missing return statement in function");
}

  final public Fetch Fetch() throws ParseException {Fetch fetch = new Fetch();
    Token token = null;
    jj_consume_token(K_FETCH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
      break;
      }
    case K_NEXT:{
      jj_consume_token(K_NEXT);
      break;
      }
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
fetch.setRowCount(Long.parseLong(token.image));
      break;
      }
    case 177:{
      jj_consume_token(177);
fetch.setFetchJdbcParameter(true);
      break;
      }
    default:
      jj_la1[157] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
fetch.setFetchParam("ROWS");
      break;
      }
    case K_ROW:{
      jj_consume_token(K_ROW);
      break;
      }
    default:
      jj_la1[158] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ONLY);
{if ("" != null) return fetch;}
    throw new Error("Missing return statement in function");
}

// according to http://technet.microsoft.com/en-us/library/ms189463.aspx
  final public Top Top() throws ParseException {Top top = new Top();
    Token token = null;
    Expression expr = null;
    jj_consume_token(K_TOP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
top.setExpression(new LongValue(token.image));
      break;
      }
    case 177:{
      jj_consume_token(177);
top.setExpression(new JdbcParameter(++jdbcParameterIndex, false));
      if (jj_2_46(2)) {
        token = jj_consume_token(S_LONG);
((JdbcParameter)(top.getExpression())).setUseFixedIndex(true); ((JdbcParameter)(top.getExpression())).setIndex(Integer.valueOf(token.image));
      } else {
        ;
      }
      break;
      }
    case 178:{
      jj_consume_token(178);
top.setExpression(new JdbcNamedParameter());
      if (jj_2_47(2)) {
        token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)top.getExpression()).setName(token.image);
      } else {
        ;
      }
      break;
      }
    case 173:{
      jj_consume_token(173);
      expr = AdditiveExpression();
top.setExpression(expr);
top.setParenthesis(true);
      jj_consume_token(174);
      break;
      }
    default:
      jj_la1[159] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_48(2)) {
      jj_consume_token(K_PERCENT);
top.setPercentage(true);
    } else {
      ;
    }
{if ("" != null) return top;}
    throw new Error("Missing return statement in function");
}

// according to http://www-01.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.sqls.doc/ids_sqs_0156.htm
  final public Skip Skip() throws ParseException {Skip skip = new Skip();
    Token token = null;
    jj_consume_token(K_SKIP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
skip.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
skip.setVariable(token.image);
      break;
      }
    case 177:{
      jj_consume_token(177);
skip.setJdbcParameter(new JdbcParameter(++jdbcParameterIndex, false));
      if (jj_2_49(2)) {
        token = jj_consume_token(S_LONG);
skip.getJdbcParameter().setUseFixedIndex(true); skip.getJdbcParameter().setIndex(Integer.valueOf(token.image));
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[160] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return skip;}
    throw new Error("Missing return statement in function");
}

  OracleHint getOracleHint() throws ParseException {OracleHint hint = null;
  Token tok = getToken(1);
  // Retrieve first comment (if any) prior next token
  if (tok.specialToken != null) {
    tok = tok.specialToken;
    while (tok.specialToken != null) tok = tok.specialToken;
    // Check if it matches Hint pattern?
    if (OracleHint.isHintMatch(tok.image)) {
      hint = new OracleHint();
      hint.setComment(tok.image);
    }
  }
  return hint;
  }

  final public First First() throws ParseException {First first = new First();
    Token token = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
first.setKeyword(First.Keyword.FIRST);
      break;
      }
    case K_LIMIT:{
      jj_consume_token(K_LIMIT);
first.setKeyword(First.Keyword.LIMIT);
      break;
      }
    default:
      jj_la1[161] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
first.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
first.setVariable(token.image);
      break;
      }
    case 177:{
      jj_consume_token(177);
first.setJdbcParameter(new JdbcParameter(++jdbcParameterIndex, false));
      if (jj_2_50(2)) {
        token = jj_consume_token(S_LONG);
first.getJdbcParameter().setUseFixedIndex(true); first.getJdbcParameter().setIndex(Integer.valueOf(token.image));
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return first;}
    throw new Error("Missing return statement in function");
}

  final public Expression Expression() throws ParseException {/*@bgen(jjtree) Expression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    try {
      retval = OrExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
{if ("" != null) return retval;}
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  final public Expression OrExpression() throws ParseException {Expression left, right, result;
    left = AndExpression();
result = left;
    label_36:
    while (true) {
      if (jj_2_51(2147483647)) {
        ;
      } else {
        break label_36;
      }
      jj_consume_token(K_OR);
      right = AndExpression();
result = new OrExpression(left, right);
                left = result;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression AndExpression() throws ParseException {Expression left, right, result;
    boolean not = false;
    if (jj_2_52(2147483647)) {
      left = Condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 173:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
not = true;
          break;
          }
        default:
          jj_la1[163] = jj_gen;
          ;
        }
        jj_consume_token(173);
        left = OrExpression();
        jj_consume_token(174);
left = new Parenthesis(left); if (not) { ((Parenthesis)left).setNot(); not = false; }
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
result = left;
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        ;
        break;
        }
      default:
        jj_la1[165] = jj_gen;
        break label_37;
      }
      jj_consume_token(K_AND);
      if (jj_2_53(2147483647)) {
        right = Condition();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 173:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not = true;
            break;
            }
          default:
            jj_la1[166] = jj_gen;
            ;
          }
          jj_consume_token(173);
          right = OrExpression();
          jj_consume_token(174);
right = new Parenthesis(right); if (not) { ((Parenthesis)right).setNot(); not = false; }
          break;
          }
        default:
          jj_la1[167] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
result = new AndExpression(left, right);
            left = result;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression Condition() throws ParseException {Expression result;
    Token token;
    if (jj_2_54(2147483647)) {
      result = SQLCondition();
    } else if (jj_2_55(2147483647)) {
      result = RegularCondition();
    } else if (jj_2_56(2147483647)) {
      result = Function();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
        result = Column();
result = new NotExpression(result);
        break;
        }
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_PERCENT:
      case K_END:
      case K_OPEN:
      case K_TABLE:
      case K_XML:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_PRECISION:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        result = Column();
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        if ("0".equals(getToken(1).image) || "1".equals(getToken(1).image)) {
          token = jj_consume_token(S_LONG);
result = new LongValue(token.image);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression RegularCondition() throws ParseException {Expression result = null;
    Expression leftExpression;
    Expression rightExpression;
    boolean not = false;
    int oracleJoin=EqualsTo.NO_ORACLE_JOIN;
    int oraclePrior=EqualsTo.NO_ORACLE_PRIOR;
    boolean binary = false;
    if (jj_2_57(2)) {
      jj_consume_token(K_PRIOR);
oraclePrior = EqualsTo.ORACLE_PRIOR_START;
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
not = true;
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      ;
    }
    leftExpression = ComparisonItem();
result = leftExpression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 173:{
      jj_consume_token(173);
      jj_consume_token(179);
      jj_consume_token(174);
oracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    if (jj_2_58(2)) {
      jj_consume_token(180);
result = new GreaterThan();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 181:{
        jj_consume_token(181);
result = new MinorThan();
        break;
        }
      case 171:{
        jj_consume_token(171);
result = new EqualsTo();
        break;
        }
      case OP_GREATERTHANEQUALS:{
        token = jj_consume_token(OP_GREATERTHANEQUALS);
result = new GreaterThanEquals(token.image);
        break;
        }
      case OP_MINORTHANEQUALS:{
        token = jj_consume_token(OP_MINORTHANEQUALS);
result = new MinorThanEquals(token.image);
        break;
        }
      case OP_NOTEQUALSSTANDARD:{
        token = jj_consume_token(OP_NOTEQUALSSTANDARD);
result = new NotEqualsTo(token.image);
        break;
        }
      case OP_NOTEQUALSBANG:{
        token = jj_consume_token(OP_NOTEQUALSBANG);
result = new NotEqualsTo(token.image);
        break;
        }
      case 182:{
        jj_consume_token(182);
result = new Matches();
        break;
        }
      case 183:{
        jj_consume_token(183);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASESENSITIVE);
        break;
        }
      case K_REGEXP:{
        jj_consume_token(K_REGEXP);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_BINARY:{
          jj_consume_token(K_BINARY);
binary=true;
          break;
          }
        default:
          jj_la1[171] = jj_gen;
          ;
        }
result = new RegExpMySQLOperator(binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
        break;
        }
      case 184:{
        jj_consume_token(184);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
        break;
        }
      case 185:{
        jj_consume_token(185);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASESENSITIVE);
        break;
        }
      case 186:{
        jj_consume_token(186);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
        break;
        }
      case 187:{
        jj_consume_token(187);
result = new JsonOperator("@>");
        break;
        }
      case 188:{
        jj_consume_token(188);
result = new JsonOperator("<@");
        break;
        }
      case 177:{
        jj_consume_token(177);
result = new JsonOperator("?");
        break;
        }
      case 189:{
        jj_consume_token(189);
result = new JsonOperator("?|");
        break;
        }
      case 190:{
        jj_consume_token(190);
result = new JsonOperator("?&");
        break;
        }
      case 191:{
        jj_consume_token(191);
result = new JsonOperator("||");
        break;
        }
      case 192:{
        jj_consume_token(192);
result = new JsonOperator("-");
        break;
        }
      case 193:{
        jj_consume_token(193);
result = new JsonOperator("-#");
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_59(2)) {
      jj_consume_token(K_PRIOR);
      rightExpression = ComparisonItem();
oraclePrior = EqualsTo.ORACLE_PRIOR_END;
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ALL:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_SOME:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        rightExpression = ComparisonItem();
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 173:{
      jj_consume_token(173);
      jj_consume_token(179);
      jj_consume_token(174);
oracleJoin=EqualsTo.ORACLE_JOIN_LEFT;
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      ;
    }
BinaryExpression regCond = (BinaryExpression) result;
        regCond.setLeftExpression(leftExpression);
        regCond.setRightExpression(rightExpression);
        if (not)
            regCond.setNot();

        if (oracleJoin>0)
            ((SupportsOldOracleJoinSyntax)result).setOldOracleJoinSyntax(oracleJoin);

        if (oraclePrior!=EqualsTo.NO_ORACLE_PRIOR)
            ((SupportsOldOracleJoinSyntax)result).setOraclePriorPosition(oraclePrior);
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression SQLCondition() throws ParseException {Expression result;
    if (jj_2_60(2147483647)) {
      result = InExpression();
    } else if (jj_2_61(2147483647)) {
      result = Between();
    } else if (jj_2_62(2147483647)) {
      result = IsNullExpression();
    } else if (jj_2_63(2147483647)) {
      result = ExistsExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        result = LikeExpression();
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression InExpression() throws ParseException {InExpression result = new InExpression();
    ItemsList leftItemsList = null;
    ItemsList rightItemsList = null;
    Expression leftExpression = null;
    if (jj_2_65(3)) {
      jj_consume_token(173);
      if (jj_2_64(2147483647)) {
        leftItemsList = SimpleExpressionList();
result.setLeftItemsList(leftItemsList);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_SET:
        case K_PERCENT:
        case K_END:
        case K_NULL:
        case K_LEFT:
        case K_OPEN:
        case K_CASE:
        case K_TABLE:
        case K_XML:
        case K_RIGHT:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_INTERVAL:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_GROUP_CONCAT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_TIME_KEY_EXPR:
        case K_DOUBLE:
        case K_PRECISION:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 173:
        case 177:
        case 178:
        case 179:
        case 182:
        case 192:
        case 199:
        case 201:
        case 202:
        case 204:
        case 209:{
          leftExpression = SimpleExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 173:{
            jj_consume_token(173);
            jj_consume_token(179);
            jj_consume_token(174);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
            break;
            }
          default:
            jj_la1[176] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[177] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(174);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        leftExpression = SimpleExpression();
result.setLeftExpression(leftExpression);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 173:{
          jj_consume_token(173);
          jj_consume_token(179);
          jj_consume_token(174);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
          break;
          }
        default:
          jj_la1[178] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      ;
    }
    jj_consume_token(K_IN);
    jj_consume_token(173);
    if (jj_2_66(3)) {
      rightItemsList = SubSelect();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        rightItemsList = SimpleExpressionList();
        break;
        }
      default:
        jj_la1[181] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(174);
result.setRightItemsList(rightItemsList);
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression Between() throws ParseException {Between result = new Between();
    Expression leftExpression = null;
    Expression betweenExpressionStart = null;
    Expression betweenExpressionEnd = null;
    leftExpression = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[182] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    betweenExpressionStart = SimpleExpression();
    jj_consume_token(K_AND);
    betweenExpressionEnd = SimpleExpression();
result.setLeftExpression(leftExpression);
        result.setBetweenExpressionStart(betweenExpressionStart);
        result.setBetweenExpressionEnd(betweenExpressionEnd);
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression LikeExpression() throws ParseException {LikeExpression result = new LikeExpression();
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:{
      jj_consume_token(K_LIKE);
      break;
      }
    case K_ILIKE:{
      jj_consume_token(K_ILIKE);
result.setCaseInsensitive(true);
      break;
      }
    default:
      jj_la1[184] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    rightExpression = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ESCAPE:{
      jj_consume_token(K_ESCAPE);
      token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      ;
    }
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression IsNullExpression() throws ParseException {IsNullExpression result = new IsNullExpression();
    Expression leftExpression = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      leftExpression = SimpleExpression();
      jj_consume_token(K_IS);
      jj_consume_token(K_NULL);
      break;
      }
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_SET:
    case K_PERCENT:
    case K_END:
    case K_NULL:
    case K_LEFT:
    case K_OPEN:
    case K_CASE:
    case K_TABLE:
    case K_XML:
    case K_RIGHT:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_INTERVAL:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_GROUP_CONCAT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_TIME_KEY_EXPR:
    case K_DOUBLE:
    case K_PRECISION:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 173:
    case 177:
    case 178:
    case 179:
    case 182:
    case 192:
    case 199:
    case 201:
    case 202:
    case 204:
    case 209:{
      leftExpression = SimpleExpression();
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        ;
      }
      jj_consume_token(K_NULL);
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression ExistsExpression() throws ParseException {ExistsExpression result = new ExistsExpression();
    Expression rightExpression = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[188] = jj_gen;
      ;
    }
    jj_consume_token(K_EXISTS);
    rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionList SQLExpressionList() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = Expression();
expressions.add(expr);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[189] = jj_gen;
        break label_38;
      }
      jj_consume_token(172);
      expr = Expression();
expressions.add(expr);
    }
retval.setExpressions(expressions);
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionList SimpleExpressionList() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = SimpleExpression();
expressions.add(expr);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        break label_39;
      }
      jj_consume_token(172);
      expr = SimpleExpression();
expressions.add(expr);
    }
retval.setExpressions(expressions);
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionList SimpleExpressionListAtLeastTwoItems() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = SimpleExpression();
expressions.add(expr);
    label_40:
    while (true) {
      jj_consume_token(172);
      expr = SimpleExpression();
expressions.add(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[191] = jj_gen;
        break label_40;
      }
    }
retval.setExpressions(expressions);
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Expression ComparisonItem() throws ParseException {Expression retval = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALL:{
      retval = AllComparisonExpression();
      break;
      }
    default:
      jj_la1[192] = jj_gen;
      if (jj_2_67(3)) {
        retval = AnyComparisonExpression();
      } else if (jj_2_68(3)) {
        retval = SimpleExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ROW:
        case 173:{
          retval = RowConstructor();
          break;
          }
        default:
          jj_la1[193] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Expression AllComparisonExpression() throws ParseException {AllComparisonExpression retval = null;
    SubSelect subselect = null;
    jj_consume_token(K_ALL);
    jj_consume_token(173);
    subselect = SubSelect();
    jj_consume_token(174);
retval = new AllComparisonExpression(subselect);
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Expression AnyComparisonExpression() throws ParseException {AnyComparisonExpression retval = null;
    AnyType anyType;
    SubSelect subselect = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ANY:{
      jj_consume_token(K_ANY);
anyType = AnyType.ANY;
      break;
      }
    case K_SOME:{
      jj_consume_token(K_SOME);
anyType = AnyType.SOME;
      break;
      }
    default:
      jj_la1[194] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(173);
    subselect = SubSelect();
    jj_consume_token(174);
retval = new AnyComparisonExpression(anyType, subselect);
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Expression SimpleExpression() throws ParseException {Expression retval = null;
    retval = BitwiseAndOr();
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Expression ConcatExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = AdditiveExpression();
result = leftExpression;
    label_41:
    while (true) {
      if (jj_2_69(2)) {
        ;
      } else {
        break label_41;
      }
      jj_consume_token(191);
      rightExpression = AdditiveExpression();
Concat binExp = new Concat();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression BitwiseAndOr() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = ConcatExpression();
result = leftExpression;
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 194:
      case 195:{
        ;
        break;
        }
      default:
        jj_la1[195] = jj_gen;
        break label_42;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 194:{
        jj_consume_token(194);
result = new BitwiseOr();
        break;
        }
      case 195:{
        jj_consume_token(195);
result = new BitwiseAnd();
        break;
        }
      default:
        jj_la1[196] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = ConcatExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression AdditiveExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = MultiplicativeExpression();
result = leftExpression;
    label_43:
    while (true) {
      if (jj_2_70(2)) {
        ;
      } else {
        break label_43;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 179:{
        jj_consume_token(179);
result = new Addition();
        break;
        }
      case 192:{
        jj_consume_token(192);
result = new Subtraction();
        break;
        }
      default:
        jj_la1[197] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = MultiplicativeExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseXor();
result = leftExpression;
    label_44:
    while (true) {
      if (jj_2_71(2)) {
        ;
      } else {
        break label_44;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 175:{
        jj_consume_token(175);
result = new Multiplication();
        break;
        }
      case 196:{
        jj_consume_token(196);
result = new Division();
        break;
        }
      case 197:{
        jj_consume_token(197);
result = new Modulo();
        break;
        }
      default:
        jj_la1[198] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = BitwiseXor();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression BitwiseXor() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = PrimaryExpression();
result = leftExpression;
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 198:{
        ;
        break;
        }
      default:
        jj_la1[199] = jj_gen;
        break label_45;
      }
      jj_consume_token(198);
      rightExpression = PrimaryExpression();
BitwiseXor binExp = new BitwiseXor();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Expression PrimaryExpression() throws ParseException {Expression retval = null;
    CastExpression castExpr = null;
    Token token = null;
    Token sign = null;
    String tmp = "";
    ColDataType type = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NULL:{
      jj_consume_token(K_NULL);
retval = new NullValue();
      break;
      }
    case K_CASE:{
      retval = CaseWhenExpression();
      break;
      }
    default:
      jj_la1[226] = jj_gen;
      if (jj_2_73(3)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 179:
        case 192:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 179:{
            sign = jj_consume_token(179);
            break;
            }
          case 192:{
            sign = jj_consume_token(192);
            break;
            }
          default:
            jj_la1[200] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[201] = jj_gen;
          ;
        }
        jj_consume_token(177);
retval = new JdbcParameter(++jdbcParameterIndex, false);
        if (jj_2_72(2)) {
          token = jj_consume_token(S_LONG);
((JdbcParameter)retval).setUseFixedIndex(true); ((JdbcParameter)retval).setIndex(Integer.valueOf(token.image));
        } else {
          ;
        }
      } else if (jj_2_74(3)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 179:
        case 192:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 179:{
            sign = jj_consume_token(179);
            break;
            }
          case 192:{
            sign = jj_consume_token(192);
            break;
            }
          default:
            jj_la1[202] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[203] = jj_gen;
          ;
        }
        retval = JdbcNamedParameter();
      } else if (jj_2_75(3)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 179:
        case 192:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 179:{
            sign = jj_consume_token(179);
            break;
            }
          case 192:{
            sign = jj_consume_token(192);
            break;
            }
          default:
            jj_la1[204] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[205] = jj_gen;
          ;
        }
        retval = UserVariable();
      } else if (jj_2_76(3)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 179:
        case 192:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 179:{
            sign = jj_consume_token(179);
            break;
            }
          case 192:{
            sign = jj_consume_token(192);
            break;
            }
          default:
            jj_la1[206] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[207] = jj_gen;
          ;
        }
        retval = NumericBind();
      } else if (jj_2_77(2147483647)) {
        retval = AnalyticExpression();
      } else if (jj_2_78(2147483647)) {
        retval = WithinGroupExpression();
      } else if (jj_2_79(3)) {
        retval = ExtractExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_GROUP_CONCAT:{
          retval = MySQLGroupConcat();
          break;
          }
        default:
          jj_la1[227] = jj_gen;
          if (jj_2_80(2147483647)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 179:
            case 192:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 179:{
                sign = jj_consume_token(179);
                break;
                }
              case 192:{
                sign = jj_consume_token(192);
                break;
                }
              default:
                jj_la1[208] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[209] = jj_gen;
              ;
            }
            retval = JsonExpression();
          } else if (jj_2_81(2147483647)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 179:
            case 192:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 179:{
                sign = jj_consume_token(179);
                break;
                }
              case 192:{
                sign = jj_consume_token(192);
                break;
                }
              default:
                jj_la1[210] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[211] = jj_gen;
              ;
            }
            retval = Function();
          } else if (jj_2_82(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 179:
            case 192:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 179:{
                sign = jj_consume_token(179);
                break;
                }
              case 192:{
                sign = jj_consume_token(192);
                break;
                }
              default:
                jj_la1[212] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[213] = jj_gen;
              ;
            }
            token = jj_consume_token(S_DOUBLE);
retval = new DoubleValue(token.image);
          } else if (jj_2_83(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 179:
            case 192:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 179:{
                sign = jj_consume_token(179);
                break;
                }
              case 192:{
                sign = jj_consume_token(192);
                break;
                }
              default:
                jj_la1[214] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[215] = jj_gen;
              ;
            }
            token = jj_consume_token(S_LONG);
retval = new LongValue(token.image);
          } else if (jj_2_84(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 179:
            case 192:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 179:{
                sign = jj_consume_token(179);
                break;
                }
              case 192:{
                sign = jj_consume_token(192);
                break;
                }
              default:
                jj_la1[216] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[217] = jj_gen;
              ;
            }
            token = jj_consume_token(S_HEX);
retval = new HexValue(token.image);
          } else if (jj_2_85(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 179:
            case 192:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 179:{
                sign = jj_consume_token(179);
                break;
                }
              case 192:{
                sign = jj_consume_token(192);
                break;
                }
              default:
                jj_la1[218] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[219] = jj_gen;
              ;
            }
            retval = CastExpression();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_TIME_KEY_EXPR:{
              token = jj_consume_token(K_TIME_KEY_EXPR);
retval = new TimeKeyExpression(token.image);
              break;
              }
            default:
              jj_la1[228] = jj_gen;
              if (jj_2_86(2)) {
                retval = DateTimeLiteralExpression();
              } else if (jj_2_87(2147483647)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 179:
                case 192:{
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case 179:{
                    sign = jj_consume_token(179);
                    break;
                    }
                  case 192:{
                    sign = jj_consume_token(192);
                    break;
                    }
                  default:
                    jj_la1[220] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                  break;
                  }
                default:
                  jj_la1[221] = jj_gen;
                  ;
                }
                retval = Column();
              } else if (jj_2_88(2147483647)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 179:
                case 192:{
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case 179:{
                    sign = jj_consume_token(179);
                    break;
                    }
                  case 192:{
                    sign = jj_consume_token(192);
                    break;
                    }
                  default:
                    jj_la1[222] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                  break;
                  }
                default:
                  jj_la1[223] = jj_gen;
                  ;
                }
                jj_consume_token(173);
                retval = BitwiseAndOr();
                jj_consume_token(174);
retval = new Parenthesis(retval);
              } else if (jj_2_89(3)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 179:
                case 192:{
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case 179:{
                    sign = jj_consume_token(179);
                    break;
                    }
                  case 192:{
                    sign = jj_consume_token(192);
                    break;
                    }
                  default:
                    jj_la1[224] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                  break;
                  }
                default:
                  jj_la1[225] = jj_gen;
                  ;
                }
                jj_consume_token(173);
                retval = SubSelect();
                jj_consume_token(174);
              } else {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case S_CHAR_LITERAL:{
                  token = jj_consume_token(S_CHAR_LITERAL);
retval = new StringValue(token.image);
                  break;
                  }
                case 199:{
                  jj_consume_token(199);
                  token = jj_consume_token(S_CHAR_LITERAL);
                  jj_consume_token(200);
retval = new DateValue(token.image);
                  break;
                  }
                case 201:{
                  jj_consume_token(201);
                  token = jj_consume_token(S_CHAR_LITERAL);
                  jj_consume_token(200);
retval = new TimeValue(token.image);
                  break;
                  }
                case 202:{
                  jj_consume_token(202);
                  token = jj_consume_token(S_CHAR_LITERAL);
                  jj_consume_token(200);
retval = new TimestampValue(token.image);
                  break;
                  }
                case K_INTERVAL:{
                  retval = IntervalExpression();
                  break;
                  }
                default:
                  jj_la1[229] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 203:{
      jj_consume_token(203);
      type = ColDataType();
castExpr = new CastExpression();
        castExpr.setUseCastKeyword(false);
        castExpr.setLeftExpression(retval);
        castExpr.setType(type);
        retval=castExpr;
      break;
      }
    default:
      jj_la1[230] = jj_gen;
      ;
    }
if (sign != null) {
            retval = new SignedExpression(sign.image.charAt(0), retval);
        }
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public JdbcNamedParameter JdbcNamedParameter() throws ParseException {JdbcNamedParameter parameter = new JdbcNamedParameter();
    Token token;
    jj_consume_token(178);
    token = jj_consume_token(S_IDENTIFIER);
parameter.setName(token.image);
{if ("" != null) return parameter;}
    throw new Error("Missing return statement in function");
}

  final public UserVariable UserVariable() throws ParseException {UserVariable var = new UserVariable();
    String varName;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 204:{
      jj_consume_token(204);
      break;
      }
    case 182:{
      jj_consume_token(182);
var.setDoubleAdd(true);
      break;
      }
    default:
      jj_la1[231] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    varName = RelObjectNameExt2();
var.setName(varName);
        {if ("" != null) return var;}
    throw new Error("Missing return statement in function");
}

  final public NumericBind NumericBind() throws ParseException {NumericBind var = new NumericBind();
    Token token;
    jj_consume_token(178);
    token = jj_consume_token(S_LONG);
var.setBindId(Integer.valueOf(token.image));
        {if ("" != null) return var;}
    throw new Error("Missing return statement in function");
}

  final public DateTimeLiteralExpression DateTimeLiteralExpression() throws ParseException {DateTimeLiteralExpression expr = new DateTimeLiteralExpression();
    Token t;
    t = jj_consume_token(K_DATETIMELITERAL);
expr.setType(DateTimeLiteralExpression.DateTime.valueOf(t.image.toUpperCase()));
    t = jj_consume_token(S_CHAR_LITERAL);
expr.setValue(t.image); {if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public JsonExpression JsonExpression() throws ParseException {JsonExpression result = new JsonExpression();
  Column column;
  Token token;
    column = Column();
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 205:{
        jj_consume_token(205);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"->");
        break;
        }
      case 206:{
        jj_consume_token(206);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"->>");
        break;
        }
      case 207:{
        jj_consume_token(207);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
        break;
        }
      case 208:{
        jj_consume_token(208);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
        break;
        }
      default:
        jj_la1[232] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 205:
      case 206:
      case 207:
      case 208:{
        ;
        break;
        }
      default:
        jj_la1[233] = jj_gen;
        break label_46;
      }
    }
result.setColumn(column);
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public IntervalExpression IntervalExpression() throws ParseException {IntervalExpression interval = new IntervalExpression();
    Token token;
    boolean signed = false;
    jj_consume_token(K_INTERVAL);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 192:{
      jj_consume_token(192);
signed=true;
      break;
      }
    default:
      jj_la1[234] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
      break;
      }
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    default:
      jj_la1[235] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
interval.setParameter((signed?"-":"") + token.image);
    if (jj_2_90(2)) {
      token = jj_consume_token(S_IDENTIFIER);
interval.setIntervalType(token.image);
    } else {
      ;
    }
{if ("" != null) return interval;}
    throw new Error("Missing return statement in function");
}

  final public WithinGroupExpression WithinGroupExpression() throws ParseException {Token token = null;
    List<OrderByElement> orderByElements = null;
    WithinGroupExpression result = new WithinGroupExpression();
    ExpressionList exprList;
    token = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(173);
    exprList = SimpleExpressionList();
    jj_consume_token(174);
    jj_consume_token(K_WITHIN);
    jj_consume_token(K_GROUP);
    jj_consume_token(173);
    orderByElements = OrderByElements();
    jj_consume_token(174);
result.setName(token.image);
        result.setExprList(exprList);
        result.setOrderByElements(orderByElements);
        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public KeepExpression KeepExpression() throws ParseException {KeepExpression keep = new KeepExpression();
    Token token;
    List<OrderByElement> list;
    jj_consume_token(K_KEEP);
    jj_consume_token(173);
    token = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
keep.setFirst(true);
      break;
      }
    case K_LAST:{
      jj_consume_token(K_LAST);
keep.setFirst(false);
      break;
      }
    default:
      jj_la1[236] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list = OrderByElements();
    jj_consume_token(174);
keep.setName(token.image);
        keep.setOrderByElements(list);
        {if ("" != null) return keep;}
    throw new Error("Missing return statement in function");
}

  final public AnalyticExpression AnalyticExpression() throws ParseException {AnalyticExpression retval = new AnalyticExpression();
    ExpressionList expressionList = null;
    List<OrderByElement> olist = null;
    Token token = null;
    Expression expr = null;
    Expression offset = null;
    Expression defaultValue = null;
    WindowElement windowElement = null;
    KeepExpression keep = null;
    token = jj_consume_token(S_IDENTIFIER);
retval.setName(token.image);
    jj_consume_token(173);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_SET:
    case K_PERCENT:
    case K_END:
    case K_NULL:
    case K_LEFT:
    case K_OPEN:
    case K_CASE:
    case K_TABLE:
    case K_XML:
    case K_RIGHT:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_INTERVAL:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_GROUP_CONCAT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_TIME_KEY_EXPR:
    case K_DOUBLE:
    case K_PRECISION:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 173:
    case 175:
    case 177:
    case 178:
    case 179:
    case 182:
    case 192:
    case 199:
    case 201:
    case 202:
    case 204:
    case 209:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        expr = SimpleExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          jj_consume_token(172);
          offset = SimpleExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            jj_consume_token(172);
            defaultValue = SimpleExpression();
            break;
            }
          default:
            jj_la1[237] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[238] = jj_gen;
          ;
        }
        break;
        }
      case 175:{
        jj_consume_token(175);
retval.setAllColumns(true);
        break;
        }
      default:
        jj_la1[239] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[240] = jj_gen;
      ;
    }
    jj_consume_token(174);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_KEEP:{
      keep = KeepExpression();
      break;
      }
    default:
      jj_la1[241] = jj_gen;
      ;
    }
    jj_consume_token(K_OVER);
    jj_consume_token(173);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PARTITION:{
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      expressionList = SimpleExpressionList();
      break;
      }
    default:
      jj_la1[242] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      olist = OrderByElements();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:
      case K_RANGE:{
        windowElement = WindowElement();
        break;
        }
      default:
        jj_la1[243] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[244] = jj_gen;
      ;
    }
retval.setExpression(expr);
        retval.setOffset(offset);
        retval.setDefaultValue(defaultValue);
        retval.setKeep(keep);
        retval.setPartitionExpressionList(expressionList);
        retval.setOrderByElements(olist);
        retval.setWindowElement(windowElement);
    jj_consume_token(174);
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public WindowElement WindowElement() throws ParseException {WindowElement windowElement = new WindowElement();
    WindowRange range = new WindowRange();
    WindowOffset offset = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
windowElement.setType(WindowElement.Type.ROWS);
      break;
      }
    case K_RANGE:{
      jj_consume_token(K_RANGE);
windowElement.setType(WindowElement.Type.RANGE);
      break;
      }
    default:
      jj_la1[245] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:{
      jj_consume_token(K_BETWEEN);
windowElement.setRange(range);
      offset = WindowOffset();
range.setStart(offset);
      jj_consume_token(K_AND);
      offset = WindowOffset();
range.setEnd(offset);
      break;
      }
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_SET:
    case K_PERCENT:
    case K_END:
    case K_NULL:
    case K_LEFT:
    case K_OPEN:
    case K_CASE:
    case K_TABLE:
    case K_XML:
    case K_RIGHT:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_INTERVAL:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_UNBOUNDED:
    case K_FOLLOWING:
    case K_CURRENT:
    case K_ROW:
    case K_COMMIT:
    case K_GROUP_CONCAT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_TIME_KEY_EXPR:
    case K_DOUBLE:
    case K_PRECISION:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 173:
    case 177:
    case 178:
    case 179:
    case 182:
    case 192:
    case 199:
    case 201:
    case 202:
    case 204:
    case 209:{
      offset = WindowOffset();
windowElement.setOffset(offset);
      break;
      }
    default:
      jj_la1[246] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return windowElement;}
    throw new Error("Missing return statement in function");
}

  final public WindowOffset WindowOffset() throws ParseException {WindowOffset offset = new WindowOffset();
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNBOUNDED:{
      jj_consume_token(K_UNBOUNDED);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING); {if ("" != null) return offset;}
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING); {if ("" != null) return offset;}
        break;
        }
      default:
        jj_la1[247] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_CURRENT:{
      jj_consume_token(K_CURRENT);
      jj_consume_token(K_ROW);
offset.setType(WindowOffset.Type.CURRENT); {if ("" != null) return offset;}
      break;
      }
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_SET:
    case K_PERCENT:
    case K_END:
    case K_NULL:
    case K_LEFT:
    case K_OPEN:
    case K_CASE:
    case K_TABLE:
    case K_XML:
    case K_RIGHT:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_INTERVAL:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_GROUP_CONCAT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_TIME_KEY_EXPR:
    case K_DOUBLE:
    case K_PRECISION:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 173:
    case 177:
    case 178:
    case 179:
    case 182:
    case 192:
    case 199:
    case 201:
    case 202:
    case 204:
    case 209:{
      expr = SimpleExpression();
offset.setType(WindowOffset.Type.EXPR);
        offset.setExpression(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[248] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return offset;}
      break;
      }
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public ExtractExpression ExtractExpression() throws ParseException {ExtractExpression retval = new ExtractExpression();
    Token token = null;
    Expression expr = null;
    jj_consume_token(K_EXTRACT);
    jj_consume_token(173);
    token = jj_consume_token(S_IDENTIFIER);
retval.setName(token.image);
    jj_consume_token(K_FROM);
    expr = SimpleExpression();
retval.setExpression(expr);
    jj_consume_token(174);
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public CastExpression CastExpression() throws ParseException {CastExpression retval = new CastExpression();
    ColDataType type = null;
    Expression expression = null;
    boolean    useCastKeyword;
    jj_consume_token(K_CAST);
    jj_consume_token(173);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
    type = ColDataType();
    jj_consume_token(174);
retval.setUseCastKeyword(true);
retval.setLeftExpression(expression);
        retval.setType(type);
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Expression CaseWhenExpression() throws ParseException {/*@bgen(jjtree) CaseWhenExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTCASEWHENEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));CaseExpression caseExp = new CaseExpression();
    Expression switchExp = null;
    WhenClause clause;
    List whenClauses = new ArrayList();
    Expression elseExp = null;
    try {
      jj_consume_token(K_CASE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHEN:{
        label_47:
        while (true) {
          clause = WhenThenSearchCondition();
whenClauses.add(clause);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            ;
            break;
            }
          default:
            jj_la1[250] = jj_gen;
            break label_47;
          }
        }
        break;
        }
      case K_DO:
      case K_ALL:
      case K_ANY:
      case K_KEY:
      case K_NOT:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_SOME:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        if (jj_2_91(2147483647)) {
          switchExp = RegularCondition();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_DO:
          case K_ANY:
          case K_KEY:
          case K_SET:
          case K_PERCENT:
          case K_END:
          case K_NULL:
          case K_LEFT:
          case K_OPEN:
          case K_CASE:
          case K_TABLE:
          case K_XML:
          case K_RIGHT:
          case K_VALUE:
          case K_INSERT:
          case K_VALUES:
          case K_REPLACE:
          case K_TRUNCATE:
          case K_CAST:
          case K_OVER:
          case K_PARTITION:
          case K_EXTRACT:
          case K_MATERIALIZED:
          case K_INTERVAL:
          case K_PRIOR:
          case K_SIBLINGS:
          case K_COLUMN:
          case K_NULLS:
          case K_FIRST:
          case K_LAST:
          case K_ROWS:
          case K_RANGE:
          case K_FOLLOWING:
          case K_ROW:
          case K_COMMIT:
          case K_GROUP_CONCAT:
          case K_SEPARATOR:
          case K_CASCADE:
          case K_NO:
          case K_ACTION:
          case K_DATETIMELITERAL:
          case K_TIME_KEY_EXPR:
          case K_DOUBLE:
          case K_PRECISION:
          case S_DOUBLE:
          case S_LONG:
          case S_HEX:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 173:
          case 177:
          case 178:
          case 179:
          case 182:
          case 192:
          case 199:
          case 201:
          case 202:
          case 204:
          case 209:{
            switchExp = BitwiseAndOr();
            break;
            }
          default:
            jj_la1[251] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        label_48:
        while (true) {
          clause = WhenThenValue();
whenClauses.add(clause);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            ;
            break;
            }
          default:
            jj_la1[252] = jj_gen;
            break label_48;
          }
        }
        break;
        }
      default:
        jj_la1[253] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ELSE:{
        jj_consume_token(K_ELSE);
        elseExp = SimpleExpression();
        break;
        }
      default:
        jj_la1[254] = jj_gen;
        ;
      }
      jj_consume_token(K_END);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
caseExp.setSwitchExpression(switchExp);
        caseExp.setWhenClauses(whenClauses);
        caseExp.setElseExpression(elseExp);
        {if ("" != null) return caseExp;}
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  final public WhenClause WhenThenSearchCondition() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
    jj_consume_token(K_WHEN);
    if (jj_2_92(2147483647)) {
      whenExp = Expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        whenExp = SimpleExpression();
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(K_THEN);
    thenExp = SimpleExpression();
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       {if ("" != null) return whenThen;}
    throw new Error("Missing return statement in function");
}

  final public WhenClause WhenThenValue() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
    jj_consume_token(K_WHEN);
    whenExp = PrimaryExpression();
    jj_consume_token(K_THEN);
    thenExp = SimpleExpression();
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       {if ("" != null) return whenThen;}
    throw new Error("Missing return statement in function");
}

  final public RowConstructor RowConstructor() throws ParseException {ExpressionList list = null;
    RowConstructor rowConstructor = new RowConstructor();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:{
      jj_consume_token(K_ROW);
rowConstructor.setName("ROW");
      break;
      }
    default:
      jj_la1[256] = jj_gen;
      ;
    }
    jj_consume_token(173);
    list = SimpleExpressionList();
    jj_consume_token(174);
rowConstructor.setExprList(list);
        {if ("" != null) return rowConstructor;}
    throw new Error("Missing return statement in function");
}

  final public Execute Execute() throws ParseException {String funcName = null;
    ExpressionList expressionList = null;
    Execute execute = new Execute();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXEC:{
      jj_consume_token(K_EXEC);
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
      break;
      }
    default:
      jj_la1[257] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    funcName = RelObjectName();
execute.setName(funcName);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DO:
    case K_ANY:
    case K_KEY:
    case K_SET:
    case K_PERCENT:
    case K_END:
    case K_NULL:
    case K_LEFT:
    case K_OPEN:
    case K_CASE:
    case K_TABLE:
    case K_XML:
    case K_RIGHT:
    case K_VALUE:
    case K_INSERT:
    case K_VALUES:
    case K_REPLACE:
    case K_TRUNCATE:
    case K_CAST:
    case K_OVER:
    case K_PARTITION:
    case K_EXTRACT:
    case K_MATERIALIZED:
    case K_INTERVAL:
    case K_PRIOR:
    case K_SIBLINGS:
    case K_COLUMN:
    case K_NULLS:
    case K_FIRST:
    case K_LAST:
    case K_ROWS:
    case K_RANGE:
    case K_FOLLOWING:
    case K_ROW:
    case K_COMMIT:
    case K_GROUP_CONCAT:
    case K_SEPARATOR:
    case K_CASCADE:
    case K_NO:
    case K_ACTION:
    case K_DATETIMELITERAL:
    case K_TIME_KEY_EXPR:
    case K_DOUBLE:
    case K_PRECISION:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 173:
    case 177:
    case 178:
    case 179:
    case 182:
    case 192:
    case 199:
    case 201:
    case 202:
    case 204:
    case 209:{
      expressionList = SimpleExpressionList();
      break;
      }
    default:
      jj_la1[258] = jj_gen;
      ;
    }
execute.setExprList(expressionList);
        {if ("" != null) return execute;}
    throw new Error("Missing return statement in function");
}

  final public Function Function() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function retval = new Function();
    String funcName = null;
    String tmp = null;
    ExpressionList expressionList = null;
    KeepExpression keep = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 209:{
        jj_consume_token(209);
retval.setEscaped(true);
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        ;
      }
      funcName = RelObjectNameExt();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 176:{
        jj_consume_token(176);
        tmp = RelObjectNameExt();
funcName+= "." + tmp;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 176:{
          jj_consume_token(176);
          tmp = RelObjectNameExt();
funcName+= "." + tmp;
          break;
          }
        default:
          jj_la1[260] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[261] = jj_gen;
        ;
      }
      jj_consume_token(173);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ALL:
      case K_ANY:
      case K_KEY:
      case K_SET:
      case K_PERCENT:
      case K_END:
      case K_NULL:
      case K_LEFT:
      case K_OPEN:
      case K_CASE:
      case K_TABLE:
      case K_XML:
      case K_RIGHT:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_DISTINCT:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_INTERVAL:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_GROUP_CONCAT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_TIME_KEY_EXPR:
      case K_DOUBLE:
      case K_PRECISION:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 173:
      case 175:
      case 177:
      case 178:
      case 179:
      case 182:
      case 192:
      case 199:
      case 201:
      case 202:
      case 204:
      case 209:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:
        case K_DISTINCT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_DISTINCT:{
            jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
            break;
            }
          case K_ALL:{
            jj_consume_token(K_ALL);
retval.setAllColumns(true);
            break;
            }
          default:
            jj_la1[262] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[263] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DO:
        case K_ANY:
        case K_KEY:
        case K_SET:
        case K_PERCENT:
        case K_END:
        case K_NULL:
        case K_LEFT:
        case K_OPEN:
        case K_CASE:
        case K_TABLE:
        case K_XML:
        case K_RIGHT:
        case K_VALUE:
        case K_INSERT:
        case K_VALUES:
        case K_REPLACE:
        case K_TRUNCATE:
        case K_CAST:
        case K_OVER:
        case K_PARTITION:
        case K_EXTRACT:
        case K_MATERIALIZED:
        case K_INTERVAL:
        case K_PRIOR:
        case K_SIBLINGS:
        case K_COLUMN:
        case K_NULLS:
        case K_FIRST:
        case K_LAST:
        case K_ROWS:
        case K_RANGE:
        case K_FOLLOWING:
        case K_ROW:
        case K_COMMIT:
        case K_GROUP_CONCAT:
        case K_SEPARATOR:
        case K_CASCADE:
        case K_NO:
        case K_ACTION:
        case K_DATETIMELITERAL:
        case K_TIME_KEY_EXPR:
        case K_DOUBLE:
        case K_PRECISION:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 173:
        case 177:
        case 178:
        case 179:
        case 182:
        case 192:
        case 199:
        case 201:
        case 202:
        case 204:
        case 209:{
          expressionList = SimpleExpressionList();
          break;
          }
        case 175:{
          jj_consume_token(175);
retval.setAllColumns(true);
          break;
          }
        default:
          jj_la1[264] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[265] = jj_gen;
        ;
      }
      jj_consume_token(174);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 176:{
        jj_consume_token(176);
        tmp = RelObjectName();
retval.setAttribute(tmp);
        break;
        }
      default:
        jj_la1[266] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEEP:{
        keep = KeepExpression();
        break;
        }
      default:
        jj_la1[267] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 200:{
        jj_consume_token(200);
        break;
        }
      default:
        jj_la1[268] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setParameters(expressionList);
        retval.setName(funcName);
        retval.setKeep(keep);
        {if ("" != null) return retval;}
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  final public MySQLGroupConcat MySQLGroupConcat() throws ParseException {MySQLGroupConcat retval = new MySQLGroupConcat();
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList = null;
    Token t;
    jj_consume_token(K_GROUP_CONCAT);
    jj_consume_token(173);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
      break;
      }
    default:
      jj_la1[269] = jj_gen;
      ;
    }
    expressionList = SimpleExpressionList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
      break;
      }
    default:
      jj_la1[270] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SEPARATOR:{
      jj_consume_token(K_SEPARATOR);
      t = jj_consume_token(S_CHAR_LITERAL);
retval.setSeparator(t.image);
      break;
      }
    default:
      jj_la1[271] = jj_gen;
      ;
    }
    jj_consume_token(174);
retval.setExpressionList(expressionList);
        {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public TableFunction TableFunction() throws ParseException {Alias alias = null;
    Function function;
    TableFunction functionItem;
    function = Function();
functionItem = new TableFunction(); functionItem.setFunction(function);
    if (jj_2_93(2)) {
      alias = Alias();
functionItem.setAlias(alias);
    } else {
      ;
    }
{if ("" != null) return functionItem;}
    throw new Error("Missing return statement in function");
}

  final public SubSelect SubSelect() throws ParseException {/*@bgen(jjtree) SubSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTSUBSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectBody selectBody = null;
    SubSelect subSelect = new SubSelect();
    List<WithItem> with = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        with = WithList();
subSelect.setWithItemsList(with);
        break;
        }
      default:
        jj_la1[272] = jj_gen;
        ;
      }
      selectBody = SelectBody();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
subSelect.setSelectBody(selectBody);
        {if ("" != null) return subSelect;}
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new Error("Missing return statement in function");
}

  final public CreateIndex CreateIndex() throws ParseException {CreateIndex createIndex = new CreateIndex();
    Table table = null;
    List<String> colNames = new ArrayList<String>();
    Token columnName;
    Index index = null;
    String name = null;
    List<String> parameter = new ArrayList<String>();
    jj_consume_token(K_CREATE);
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_WITH:
      case K_WHERE:
      case K_USING:
      case K_DELETE:
      case K_UPDATE:
      case K_PRIMARY:
      case K_FOREIGN:
      case K_CONSTRAINT:
      case K_REFERENCES:
      case K_CHECK:
      case K_ROWS:
      case K_COMMIT:
      case K_UNIQUE:
      case K_CASCADE:
      case K_TIME_KEY_EXPR:
      case K_TABLESPACE:
      case K_EXCLUDE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 171:
      case 173:
      case 179:
      case 192:{
        ;
        break;
        }
      default:
        jj_la1[273] = jj_gen;
        break label_49;
      }
      parameter = CreateParameter();
    }
    jj_consume_token(K_INDEX);
    name = RelObjectName();
index = new Index();
        index.setName(name);
        index.setType(parameter.isEmpty()?null:parameter.get(0));
    jj_consume_token(K_ON);
    table = Table();
    jj_consume_token(173);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      columnName = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      columnName = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[274] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case K_KEY:
      case K_NOT:
      case K_ASC:
      case K_DESC:
      case K_NULL:
      case K_WITH:
      case K_WHERE:
      case K_USING:
      case K_DELETE:
      case K_UPDATE:
      case K_PRIMARY:
      case K_FOREIGN:
      case K_CONSTRAINT:
      case K_REFERENCES:
      case K_CHECK:
      case K_ROWS:
      case K_COMMIT:
      case K_UNIQUE:
      case K_CASCADE:
      case K_TIME_KEY_EXPR:
      case K_TABLESPACE:
      case K_EXCLUDE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 171:
      case 173:
      case 179:
      case 192:{
        ;
        break;
        }
      default:
        jj_la1[275] = jj_gen;
        break label_50;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_WITH:
      case K_WHERE:
      case K_USING:
      case K_DELETE:
      case K_UPDATE:
      case K_PRIMARY:
      case K_FOREIGN:
      case K_CONSTRAINT:
      case K_REFERENCES:
      case K_CHECK:
      case K_ROWS:
      case K_COMMIT:
      case K_UNIQUE:
      case K_CASCADE:
      case K_TIME_KEY_EXPR:
      case K_TABLESPACE:
      case K_EXCLUDE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 171:
      case 173:
      case 179:
      case 192:{
        CreateParameter();
        break;
        }
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
        break;
        }
      default:
        jj_la1[276] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
colNames.add(columnName.image);
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[277] = jj_gen;
        break label_51;
      }
      jj_consume_token(172);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        columnName = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        columnName = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[278] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_52:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:
        case K_KEY:
        case K_NOT:
        case K_ASC:
        case K_DESC:
        case K_NULL:
        case K_WITH:
        case K_WHERE:
        case K_USING:
        case K_DELETE:
        case K_UPDATE:
        case K_PRIMARY:
        case K_FOREIGN:
        case K_CONSTRAINT:
        case K_REFERENCES:
        case K_CHECK:
        case K_ROWS:
        case K_COMMIT:
        case K_UNIQUE:
        case K_CASCADE:
        case K_TIME_KEY_EXPR:
        case K_TABLESPACE:
        case K_EXCLUDE:
        case S_DOUBLE:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case 171:
        case 173:
        case 179:
        case 192:{
          ;
          break;
          }
        default:
          jj_la1[279] = jj_gen;
          break label_52;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:
        case K_KEY:
        case K_NOT:
        case K_NULL:
        case K_WITH:
        case K_WHERE:
        case K_USING:
        case K_DELETE:
        case K_UPDATE:
        case K_PRIMARY:
        case K_FOREIGN:
        case K_CONSTRAINT:
        case K_REFERENCES:
        case K_CHECK:
        case K_ROWS:
        case K_COMMIT:
        case K_UNIQUE:
        case K_CASCADE:
        case K_TIME_KEY_EXPR:
        case K_TABLESPACE:
        case K_EXCLUDE:
        case S_DOUBLE:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case 171:
        case 173:
        case 179:
        case 192:{
          CreateParameter();
          break;
          }
        case K_ASC:{
          jj_consume_token(K_ASC);
          break;
          }
        case K_DESC:{
          jj_consume_token(K_DESC);
          break;
          }
        default:
          jj_la1[280] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
colNames.add(columnName.image);
    }
    jj_consume_token(174);
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_WITH:
      case K_WHERE:
      case K_USING:
      case K_DELETE:
      case K_UPDATE:
      case K_PRIMARY:
      case K_FOREIGN:
      case K_CONSTRAINT:
      case K_REFERENCES:
      case K_CHECK:
      case K_ROWS:
      case K_COMMIT:
      case K_UNIQUE:
      case K_CASCADE:
      case K_TIME_KEY_EXPR:
      case K_TABLESPACE:
      case K_EXCLUDE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 171:
      case 173:
      case 179:
      case 192:{
        ;
        break;
        }
      default:
        jj_la1[281] = jj_gen;
        break label_53;
      }
      CreateParameter();

    }
index.setColumnsNames(colNames);
        createIndex.setIndex(index);
        createIndex.setTable(table);
        {if ("" != null) return createIndex;}
    throw new Error("Missing return statement in function");
}

  final public CreateTable CreateTable() throws ParseException {CreateTable createTable = new CreateTable();
    Table table = null;
    List columnDefinitions = new ArrayList();
    List columnSpecs = null;
    List<String> tableOptions = new ArrayList<String>();
    List<String> createOptions = new ArrayList<String>();
    String columnName;
    Token tk = null;
    Token tk2 = null;
    Token tk3 = null;
    String sk3 = null;
    ColDataType colDataType = null;
    String stringList = null;
    ColumnDefinition coldef = null;
    List indexes = new ArrayList();
    List colNames = null;
    Index index = null;
    ForeignKeyIndex fkIndex = null;
    List<String> parameter = new ArrayList<String>();
    List<String> idxSpec = new ArrayList<String>();
    Table fkTable = null;
    Select select = null;
    CheckConstraint checkCs = null;
    ExcludeConstraint excludeC = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNLOGGED:{
      jj_consume_token(K_UNLOGGED);
createTable.setUnlogged(true);
      break;
      }
    default:
      jj_la1[282] = jj_gen;
      ;
    }
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_WITH:
      case K_WHERE:
      case K_USING:
      case K_DELETE:
      case K_UPDATE:
      case K_PRIMARY:
      case K_FOREIGN:
      case K_CONSTRAINT:
      case K_REFERENCES:
      case K_CHECK:
      case K_ROWS:
      case K_COMMIT:
      case K_UNIQUE:
      case K_CASCADE:
      case K_TIME_KEY_EXPR:
      case K_TABLESPACE:
      case K_EXCLUDE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 171:
      case 173:
      case 179:
      case 192:{
        ;
        break;
        }
      default:
        jj_la1[283] = jj_gen;
        break label_54;
      }
      parameter = CreateParameter();
createOptions.addAll(parameter);
    }
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IF:{
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createTable.setIfNotExists(true);
      break;
      }
    default:
      jj_la1[284] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case 173:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 173:{
        jj_consume_token(173);
        columnName = RelObjectName();
        colDataType = ColDataType();
columnSpecs = new ArrayList();
        label_55:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ON:
          case K_KEY:
          case K_NOT:
          case K_NULL:
          case K_WITH:
          case K_WHERE:
          case K_USING:
          case K_DELETE:
          case K_UPDATE:
          case K_PRIMARY:
          case K_FOREIGN:
          case K_CONSTRAINT:
          case K_REFERENCES:
          case K_CHECK:
          case K_ROWS:
          case K_COMMIT:
          case K_UNIQUE:
          case K_CASCADE:
          case K_TIME_KEY_EXPR:
          case K_TABLESPACE:
          case K_EXCLUDE:
          case S_DOUBLE:
          case S_LONG:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case 171:
          case 173:
          case 179:
          case 192:{
            ;
            break;
            }
          default:
            jj_la1[285] = jj_gen;
            break label_55;
          }
          parameter = CreateParameter();
columnSpecs.addAll(parameter);
        }
coldef = new ColumnDefinition();
            coldef.setColumnName(columnName);
            coldef.setColDataType(colDataType);
            if (columnSpecs.size() > 0)
                coldef.setColumnSpecStrings(columnSpecs);
            columnDefinitions.add(coldef);
        label_56:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[286] = jj_gen;
            break label_56;
          }
          jj_consume_token(172);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INDEX:{
            tk = jj_consume_token(K_INDEX);
            sk3 = RelObjectName();
            colNames = ColumnsNamesList();
index = new Index();
                            index.setType(tk.image);
                            index.setName(sk3);
                            index.setColumnsNames(colNames);
                            indexes.add(index);
            break;
            }
          default:
            jj_la1[300] = jj_gen;
            if (jj_2_96(3)) {
index = new NamedConstraint();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
index.setName(sk3);
                break;
                }
              default:
                jj_la1[287] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_PRIMARY:{
                tk = jj_consume_token(K_PRIMARY);
                tk2 = jj_consume_token(K_KEY);
index.setType(tk.image + " " + tk2.image);
                break;
                }
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_KEY:{
                  tk2 = jj_consume_token(K_KEY);
                  break;
                  }
                default:
                  jj_la1[288] = jj_gen;
                  ;
                }
index.setType(tk.image + (tk2!=null?" " + tk2.image:""));
                break;
                }
              default:
                jj_la1[289] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              colNames = ColumnsNamesList();
              label_57:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ON:
                case K_KEY:
                case K_NOT:
                case K_NULL:
                case K_WITH:
                case K_WHERE:
                case K_USING:
                case K_DELETE:
                case K_UPDATE:
                case K_PRIMARY:
                case K_FOREIGN:
                case K_CONSTRAINT:
                case K_REFERENCES:
                case K_CHECK:
                case K_ROWS:
                case K_COMMIT:
                case K_UNIQUE:
                case K_CASCADE:
                case K_TIME_KEY_EXPR:
                case K_TABLESPACE:
                case K_EXCLUDE:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case 171:
                case 173:
                case 179:
                case 192:{
                  ;
                  break;
                  }
                default:
                  jj_la1[290] = jj_gen;
                  break label_57;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index.setColumnsNames(colNames);
                            index.setIndexSpec(idxSpec);
                            indexes.add(index);
            } else if (jj_2_97(3)) {
tk=null;
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                break;
                }
              default:
                jj_la1[291] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_FULLTEXT:{
                tk3 = jj_consume_token(K_FULLTEXT);
                break;
                }
              default:
                jj_la1[292] = jj_gen;
                ;
              }
              tk2 = jj_consume_token(K_KEY);
              sk3 = RelObjectName();
              colNames = ColumnsNamesList();
index = new Index();
                            index.setType((tk!=null?tk.image + " ":"") + (tk3!=null?tk3.image + " ":"") + tk2.image);
                            index.setName(sk3);
                            index.setColumnsNames(colNames);
                            indexes.add(index);
            } else if (jj_2_98(3)) {
fkIndex = new ForeignKeyIndex();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
fkIndex.setName(sk3);
                break;
                }
              default:
                jj_la1[293] = jj_gen;
                ;
              }
              tk = jj_consume_token(K_FOREIGN);
              tk2 = jj_consume_token(K_KEY);
              colNames = ColumnsNamesList();
fkIndex.setType(tk.image + " " + tk2.image);
                            fkIndex.setColumnsNames(colNames);
              jj_consume_token(K_REFERENCES);
              fkTable = Table();
              colNames = ColumnsNamesList();
fkIndex.setTable(fkTable);
                            fkIndex.setReferencedColumnNames(colNames);
                            indexes.add(fkIndex);
              if (jj_2_94(2)) {
                jj_consume_token(K_ON);
                jj_consume_token(K_DELETE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_CASCADE:{
                  jj_consume_token(K_CASCADE);
fkIndex.setOnDeleteReferenceOption("CASCADE");
                  break;
                  }
                case K_NO:{
                  jj_consume_token(K_NO);
                  jj_consume_token(K_ACTION);
fkIndex.setOnDeleteReferenceOption("NO ACTION");
                  break;
                  }
                case K_SET:{
                  jj_consume_token(K_SET);
                  jj_consume_token(K_NULL);
fkIndex.setOnDeleteReferenceOption("SET NULL");
                  break;
                  }
                default:
                  jj_la1[294] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              } else {
                ;
              }
              if (jj_2_95(2)) {
                jj_consume_token(K_ON);
                jj_consume_token(K_UPDATE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_CASCADE:{
                  jj_consume_token(K_CASCADE);
fkIndex.setOnUpdateReferenceOption("CASCADE");
                  break;
                  }
                case K_NO:{
                  jj_consume_token(K_NO);
                  jj_consume_token(K_ACTION);
fkIndex.setOnUpdateReferenceOption("NO ACTION");
                  break;
                  }
                default:
                  jj_la1[295] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              } else {
                ;
              }
            } else if (jj_2_99(3)) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
                break;
                }
              default:
                jj_la1[296] = jj_gen;
                ;
              }
Expression exp = null;
              jj_consume_token(K_CHECK);
              label_58:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 173:{
                  ;
                  break;
                  }
                default:
                  jj_la1[297] = jj_gen;
                  break label_58;
                }
                jj_consume_token(173);
                exp = Expression();
                jj_consume_token(174);
              }
checkCs = new CheckConstraint();
                       checkCs.setName(sk3);
                       checkCs.setExpression(exp);
                       indexes.add(checkCs);
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_EXCLUDE:{
                tk = jj_consume_token(K_EXCLUDE);
excludeC = new ExcludeConstraint(); Expression exp = null;
                tk2 = jj_consume_token(K_WHERE);
                label_59:
                while (true) {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case 173:{
                    ;
                    break;
                    }
                  default:
                    jj_la1[298] = jj_gen;
                    break label_59;
                  }
                  jj_consume_token(173);
                  exp = Expression();
                  jj_consume_token(174);
                }
excludeC.setExpression(exp);
indexes.add(excludeC);
                break;
                }
              case K_DO:
              case K_ANY:
              case K_KEY:
              case K_PERCENT:
              case K_END:
              case K_OPEN:
              case K_TABLE:
              case K_XML:
              case K_VALUE:
              case K_INSERT:
              case K_VALUES:
              case K_REPLACE:
              case K_TRUNCATE:
              case K_CAST:
              case K_OVER:
              case K_PARTITION:
              case K_EXTRACT:
              case K_MATERIALIZED:
              case K_PRIOR:
              case K_SIBLINGS:
              case K_COLUMN:
              case K_NULLS:
              case K_FIRST:
              case K_LAST:
              case K_ROWS:
              case K_RANGE:
              case K_FOLLOWING:
              case K_ROW:
              case K_COMMIT:
              case K_SEPARATOR:
              case K_CASCADE:
              case K_NO:
              case K_ACTION:
              case K_DATETIMELITERAL:
              case K_PRECISION:
              case S_IDENTIFIER:
              case S_QUOTED_IDENTIFIER:{
                columnName = RelObjectName();
                colDataType = ColDataType();
columnSpecs = new ArrayList();
                label_60:
                while (true) {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case K_ON:
                  case K_KEY:
                  case K_NOT:
                  case K_NULL:
                  case K_WITH:
                  case K_WHERE:
                  case K_USING:
                  case K_DELETE:
                  case K_UPDATE:
                  case K_PRIMARY:
                  case K_FOREIGN:
                  case K_CONSTRAINT:
                  case K_REFERENCES:
                  case K_CHECK:
                  case K_ROWS:
                  case K_COMMIT:
                  case K_UNIQUE:
                  case K_CASCADE:
                  case K_TIME_KEY_EXPR:
                  case K_TABLESPACE:
                  case K_EXCLUDE:
                  case S_DOUBLE:
                  case S_LONG:
                  case S_IDENTIFIER:
                  case S_CHAR_LITERAL:
                  case 171:
                  case 173:
                  case 179:
                  case 192:{
                    ;
                    break;
                    }
                  default:
                    jj_la1[299] = jj_gen;
                    break label_60;
                  }
                  parameter = CreateParameter();
columnSpecs.addAll(parameter);
                }
coldef = new ColumnDefinition();
                        coldef.setColumnName(columnName);
                        coldef.setColDataType(colDataType);
                        if (columnSpecs.size() > 0)
                            coldef.setColumnSpecStrings(columnSpecs);
                        columnDefinitions.add(coldef);
                break;
                }
              default:
                jj_la1[301] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
        jj_consume_token(174);
        label_61:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ON:
          case K_KEY:
          case K_NOT:
          case K_NULL:
          case K_WITH:
          case K_WHERE:
          case K_USING:
          case K_DELETE:
          case K_UPDATE:
          case K_PRIMARY:
          case K_FOREIGN:
          case K_CONSTRAINT:
          case K_REFERENCES:
          case K_CHECK:
          case K_ROWS:
          case K_COMMIT:
          case K_UNIQUE:
          case K_CASCADE:
          case K_TIME_KEY_EXPR:
          case K_TABLESPACE:
          case K_EXCLUDE:
          case S_DOUBLE:
          case S_LONG:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case 171:
          case 173:
          case 179:
          case 192:{
            ;
            break;
            }
          default:
            jj_la1[302] = jj_gen;
            break label_61;
          }
          parameter = CreateParameter();
tableOptions.addAll(parameter);
        }
        break;
        }
      case K_AS:{
        jj_consume_token(K_AS);
        if (jj_2_100(2147483647)) {
          jj_consume_token(173);
          select = Select();
createTable.setSelect(select, true);
          jj_consume_token(174);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WITH:
          case K_SELECT:
          case 173:{
            select = Select();
createTable.setSelect(select, false);
            break;
            }
          default:
            jj_la1[303] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[304] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[305] = jj_gen;
      ;
    }
createTable.setTable(table);
        if (indexes.size() > 0)
            createTable.setIndexes(indexes);
        if (createOptions.size() > 0)
            createTable.setCreateOptionsStrings(createOptions);
        if (tableOptions.size() > 0)
            createTable.setTableOptionsStrings(tableOptions);
        if (columnDefinitions.size() > 0)
            createTable.setColumnDefinitions(columnDefinitions);
        {if ("" != null) return createTable;}
    throw new Error("Missing return statement in function");
}

  final public ColDataType ColDataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token tk = null;
    Token tk2 = null;
    ArrayList argumentsStringList = new ArrayList();
    List<Integer> array = new ArrayList<Integer>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CHARACTER:
    case K_BIT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CHARACTER:{
        tk = jj_consume_token(K_CHARACTER);
        break;
        }
      case K_BIT:{
        tk = jj_consume_token(K_BIT);
        break;
        }
      default:
        jj_la1[306] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VARYING:{
        tk2 = jj_consume_token(K_VARYING);
        break;
        }
      default:
        jj_la1[307] = jj_gen;
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      if (jj_2_101(2)) {
        tk2 = jj_consume_token(K_PRECISION);
      } else {
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_XML:
    case K_INTERVAL:
    case K_DATETIMELITERAL:
    case DT_ZONE:
    case S_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATETIMELITERAL:{
        tk = jj_consume_token(K_DATETIMELITERAL);
        break;
        }
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_INTERVAL:{
        tk = jj_consume_token(K_INTERVAL);
        break;
        }
      case DT_ZONE:{
        tk = jj_consume_token(DT_ZONE);
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
colDataType.setDataType(tk.image);
      break;
      }
    default:
      jj_la1[309] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_102(2)) {
      jj_consume_token(173);
      label_62:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[310] = jj_gen;
          break label_62;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        default:
          jj_la1[311] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
argumentsStringList.add(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          jj_consume_token(172);

          break;
          }
        default:
          jj_la1[312] = jj_gen;
          ;
        }
      }
      jj_consume_token(174);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 210:{
      label_63:
      while (true) {
        jj_consume_token(210);
tk=null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[313] = jj_gen;
          ;
        }
array.add(tk!=null?Integer.valueOf(tk.image):null);
        jj_consume_token(211);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 210:{
          ;
          break;
          }
        default:
          jj_la1[314] = jj_gen;
          break label_63;
        }
      }
colDataType.setArrayData(array);
      break;
      }
    default:
      jj_la1[315] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CHARACTER:{
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      tk = jj_consume_token(S_IDENTIFIER);
colDataType.setCharacterSet(tk.image);
      break;
      }
    default:
      jj_la1[316] = jj_gen;
      ;
    }
if (argumentsStringList.size() > 0)
            colDataType.setArgumentsStringList(argumentsStringList);
        {if ("" != null) return colDataType;}
    throw new Error("Missing return statement in function");
}

  final public CreateView CreateView() throws ParseException {CreateView createView = new CreateView();
    Table view = null;
    SelectBody select = null;
    List<String> columnNames = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
createView.setOrReplace(true);
      break;
      }
    default:
      jj_la1[317] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
createView.setMaterialized(true);
      break;
      }
    default:
      jj_la1[318] = jj_gen;
      ;
    }
    jj_consume_token(K_VIEW);
    view = Table();
createView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 173:{
      columnNames = ColumnsNamesList();
createView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[319] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectBody();
createView.setSelectBody(select);
{if ("" != null) return createView;}
    throw new Error("Missing return statement in function");
}

  final public AlterView AlterView() throws ParseException {AlterView alterView = new AlterView();
    Table view = null;
    SelectBody select = null;
    List<String> columnNames = null;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_VIEW);
    view = Table();
alterView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 173:{
      columnNames = ColumnsNamesList();
alterView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[320] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectBody();
alterView.setSelectBody(select);
{if ("" != null) return alterView;}
    throw new Error("Missing return statement in function");
}

  final public List<String> CreateParameter() throws ParseException {String retval = "";
    Token tk = null;
    Token tk2 = null;
    StringBuilder identifier = new StringBuilder("");
    Expression exp = null;
    List<String> param = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
identifier.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 176:{
        jj_consume_token(176);
        tk2 = jj_consume_token(S_IDENTIFIER);
identifier.append("."); identifier.append(tk2.image);
        break;
        }
      default:
        jj_la1[321] = jj_gen;
        ;
      }
param.add(identifier.toString());
      break;
      }
    case K_NULL:{
      tk = jj_consume_token(K_NULL);
param.add(tk.image);
      break;
      }
    case K_NOT:{
      tk = jj_consume_token(K_NOT);
param.add(tk.image);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
param.add(tk.image);
      break;
      }
    case K_FOREIGN:{
      tk = jj_consume_token(K_FOREIGN);
param.add(tk.image);
      break;
      }
    case K_REFERENCES:{
      tk = jj_consume_token(K_REFERENCES);
param.add(tk.image);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
param.add(tk.image);
      break;
      }
    case S_CHAR_LITERAL:{
      tk = jj_consume_token(S_CHAR_LITERAL);
param.add(tk.image);
      break;
      }
    case S_DOUBLE:
    case S_LONG:
    case 179:
    case 192:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 179:
      case 192:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 179:{
          jj_consume_token(179);
retval = "+";
          break;
          }
        case 192:{
          jj_consume_token(192);
retval = "-";
          break;
          }
        default:
          jj_la1[322] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[323] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
retval += tk.image;
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
retval += tk.image;
        break;
        }
      default:
        jj_la1[324] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
param.add(retval);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
param.add(tk.image);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
param.add(tk.image);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
param.add(tk.image);
      break;
      }
    case K_UNIQUE:{
      tk = jj_consume_token(K_UNIQUE);
param.add(tk.image);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
param.add(tk.image);
      break;
      }
    case K_DELETE:{
      tk = jj_consume_token(K_DELETE);
param.add(tk.image);
      break;
      }
    case K_UPDATE:{
      tk = jj_consume_token(K_UPDATE);
param.add(tk.image);
      break;
      }
    case K_TIME_KEY_EXPR:{
      tk = jj_consume_token(K_TIME_KEY_EXPR);
param.add(new TimeKeyExpression(tk.image).toString());
      break;
      }
    case 171:{
      jj_consume_token(171);
param.add("=");
      break;
      }
    default:
      jj_la1[325] = jj_gen;
      if (jj_2_103(3)) {
        jj_consume_token(K_USING);
        jj_consume_token(K_INDEX);
        jj_consume_token(K_TABLESPACE);
        retval = RelObjectName();
param.add("USING"); param.add("INDEX"); param.add("TABLESPACE"); param.add(retval);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_TABLESPACE:{
          jj_consume_token(K_TABLESPACE);
          retval = RelObjectName();
param.add("TABLESPACE"); param.add(retval);
          break;
          }
        case 173:{
          retval = AList();
param.add(retval);
          break;
          }
        case K_CHECK:{
          jj_consume_token(K_CHECK);
          jj_consume_token(173);
          exp = Expression();
          jj_consume_token(174);
param.add("CHECK"); param.add("(" + exp.toString() + ")");
          break;
          }
        case K_CONSTRAINT:{
          tk = jj_consume_token(K_CONSTRAINT);
param.add(tk.image);
          break;
          }
        case K_WITH:{
          tk = jj_consume_token(K_WITH);
param.add(tk.image);
          break;
          }
        case K_EXCLUDE:{
          tk = jj_consume_token(K_EXCLUDE);
param.add(tk.image);
          break;
          }
        case K_WHERE:{
          tk = jj_consume_token(K_WHERE);
param.add(tk.image);
          break;
          }
        default:
          jj_la1[326] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return param;}
    throw new Error("Missing return statement in function");
}

  final public String AList() throws ParseException {StringBuilder retval = new StringBuilder("(");
    Token tk = null;
    Token tk2 = null;
    jj_consume_token(173);
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:{
        ;
        break;
        }
      default:
        jj_la1[327] = jj_gen;
        break label_64;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
        break;
        }
      case S_CHAR_LITERAL:{
        tk = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      default:
        jj_la1[328] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
retval.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 171:
      case 172:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 172:{
          jj_consume_token(172);
retval.append(",");
          break;
          }
        case 171:{
          jj_consume_token(171);
retval.append("=");
          break;
          }
        default:
          jj_la1[329] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[330] = jj_gen;
        ;
      }
    }
    jj_consume_token(174);
retval.append(")");
        {if ("" != null) return retval.toString();}
    throw new Error("Missing return statement in function");
}

  final public List<String> ColumnsNamesList() throws ParseException {List<String> retval = new ArrayList<String>();
    Token tk = null;
    jj_consume_token(173);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[331] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.add(tk.image);
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[332] = jj_gen;
        break label_65;
      }
      jj_consume_token(172);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[333] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
retval.add(tk.image);
    }
    jj_consume_token(174);
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public Drop Drop() throws ParseException {Drop drop = new Drop();
    Token tk = null;
    Table name;
    List<String> dropArgs = new ArrayList<String>();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    default:
      jj_la1[334] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
drop.setType(tk.image);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IF:{
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
drop.setIfExists(true);
      break;
      }
    default:
      jj_la1[335] = jj_gen;
      ;
    }
    name = Table();
drop.setName(name);
    label_66:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case S_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[336] = jj_gen;
        break label_66;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_CASCADE:{
        tk = jj_consume_token(K_CASCADE);
        break;
        }
      default:
        jj_la1[337] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dropArgs.add(tk.image);
    }
if (dropArgs.size() > 0)
            drop.setParameters(dropArgs);
        {if ("" != null) return drop;}
    throw new Error("Missing return statement in function");
}

  final public Truncate Truncate() throws ParseException {Truncate truncate = new Truncate();
    Table table;
    jj_consume_token(K_TRUNCATE);
    jj_consume_token(K_TABLE);
    table = Table();
truncate.setTable(table);
{if ("" != null) return truncate;}
    throw new Error("Missing return statement in function");
}

  final public AlterExpression.ColumnDataType AlterExpressionColumnDataType() throws ParseException {String columnName = null;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    dataType = ColDataType();
columnSpecs = new ArrayList();
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_WITH:
      case K_WHERE:
      case K_USING:
      case K_DELETE:
      case K_UPDATE:
      case K_PRIMARY:
      case K_FOREIGN:
      case K_CONSTRAINT:
      case K_REFERENCES:
      case K_CHECK:
      case K_ROWS:
      case K_COMMIT:
      case K_UNIQUE:
      case K_CASCADE:
      case K_TIME_KEY_EXPR:
      case K_TABLESPACE:
      case K_EXCLUDE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 171:
      case 173:
      case 179:
      case 192:{
        ;
        break;
        }
      default:
        jj_la1[338] = jj_gen;
        break label_67;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
{if ("" != null) return new AlterExpression.ColumnDataType(columnName, dataType, columnSpecs);}
    throw new Error("Missing return statement in function");
}

  final public List<ConstraintState> AlterExpressionConstraintState() throws ParseException {List<ConstraintState> retval = new ArrayList<ConstraintState>();
    label_68:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case K_DEFERRABLE:
      case K_VALIDATE:
      case K_NOVALIDATE:
      case K_ENABLE:
      case K_DISABLE:{
        ;
        break;
        }
      default:
        jj_la1[339] = jj_gen;
        break label_68;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:{
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(false));
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(true));
        break;
        }
      case K_VALIDATE:{
        jj_consume_token(K_VALIDATE);
retval.add(new ValidateConstraint(false));
        break;
        }
      case K_NOVALIDATE:{
        jj_consume_token(K_NOVALIDATE);
retval.add(new ValidateConstraint(true));
        break;
        }
      case K_ENABLE:{
        jj_consume_token(K_ENABLE);
retval.add(new EnableConstraint(false));
        break;
        }
      case K_DISABLE:{
        jj_consume_token(K_DISABLE);
retval.add(new EnableConstraint(true));
        break;
        }
      default:
        jj_la1[340] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
}

  final public AlterExpression AlterExpression() throws ParseException {AlterExpression alterExp = new AlterExpression();
    Token tk;
    Token tk2 = null;
    String sk3 = null;
    ColDataType dataType;
    List<String> columnNames = null;
    List<ConstraintState> constraints = null;
    ForeignKeyIndex fkIndex = null;
    NamedConstraint index = null;
    Table fkTable = null;
    AlterExpression.ColumnDataType alterExpressionColumnDataType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADD:
    case K_MODIFY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ADD:{
        jj_consume_token(K_ADD);
alterExp.setOperation(AlterOperation.ADD);
        break;
        }
      case K_MODIFY:{
        jj_consume_token(K_MODIFY);
alterExp.setOperation(AlterOperation.MODIFY);
        break;
        }
      default:
        jj_la1[341] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:
      case K_ANY:
      case K_KEY:
      case K_PERCENT:
      case K_END:
      case K_OPEN:
      case K_TABLE:
      case K_XML:
      case K_VALUE:
      case K_INSERT:
      case K_VALUES:
      case K_REPLACE:
      case K_TRUNCATE:
      case K_CAST:
      case K_OVER:
      case K_PARTITION:
      case K_EXTRACT:
      case K_MATERIALIZED:
      case K_PRIOR:
      case K_SIBLINGS:
      case K_COLUMN:
      case K_NULLS:
      case K_FIRST:
      case K_LAST:
      case K_ROWS:
      case K_RANGE:
      case K_FOLLOWING:
      case K_ROW:
      case K_COMMIT:
      case K_SEPARATOR:
      case K_CASCADE:
      case K_NO:
      case K_ACTION:
      case K_DATETIMELITERAL:
      case K_PRECISION:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        if (jj_2_104(2)) {
          jj_consume_token(K_COLUMN);
        } else {
          ;
        }
        alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        break;
        }
      case 173:{
        jj_consume_token(173);
        alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        label_69:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 172:{
            ;
            break;
            }
          default:
            jj_la1[342] = jj_gen;
            break label_69;
          }
          jj_consume_token(172);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        }
        jj_consume_token(174);
        break;
        }
      case K_PRIMARY:{
        jj_consume_token(K_PRIMARY);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        break;
        }
      case K_UNIQUE:{
        jj_consume_token(K_UNIQUE);
        jj_consume_token(K_KEY);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[343] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        columnNames = ColumnsNamesList();
alterExp.setUkName(tk.image); alterExp.setUkColumns(columnNames);
        break;
        }
      case K_FOREIGN:{
        jj_consume_token(K_FOREIGN);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setFkColumns(columnNames);
        jj_consume_token(K_REFERENCES);
        tk = jj_consume_token(S_IDENTIFIER);
        columnNames = ColumnsNamesList();
alterExp.setFkSourceTable(tk.image); alterExp.setFkSourceColumns(columnNames);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:{
          jj_consume_token(K_ON);
          jj_consume_token(K_DELETE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            jj_consume_token(K_CASCADE);
alterExp.setOnDeleteCascade(true);
            break;
            }
          case K_RESTRICT:{
            jj_consume_token(K_RESTRICT);
alterExp.setOnDeleteRestrict(true);
            break;
            }
          case K_SET:{
            jj_consume_token(K_SET);
            jj_consume_token(K_NULL);
alterExp.setOnDeleteSetNull(true);
            break;
            }
          default:
            jj_la1[344] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[345] = jj_gen;
          ;
        }
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        sk3 = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FOREIGN:{
          tk = jj_consume_token(K_FOREIGN);
          tk2 = jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
fkIndex = new ForeignKeyIndex();
                    fkIndex.setName(sk3);
                    fkIndex.setType(tk.image + " " + tk2.image);
                    fkIndex.setColumnsNames(columnNames);
          jj_consume_token(K_REFERENCES);
          fkTable = Table();
          columnNames = ColumnsNamesList();
fkIndex.setTable(fkTable);
                    fkIndex.setReferencedColumnNames(columnNames);
                    alterExp.setIndex(fkIndex);
          break;
          }
        case K_PRIMARY:{
          tk = jj_consume_token(K_PRIMARY);
          tk2 = jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
index = new NamedConstraint();
                    index.setName(sk3);
                    index.setType(tk.image + " " + tk2.image);
                    index.setColumnsNames(columnNames);
                    alterExp.setIndex(index);
          break;
          }
        case K_CHECK:{
          jj_consume_token(K_CHECK);
Expression exp = null;
          label_70:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 173:{
              ;
              break;
              }
            default:
              jj_la1[346] = jj_gen;
              break label_70;
            }
            jj_consume_token(173);
            exp = Expression();
            jj_consume_token(174);
          }
CheckConstraint checkCs = new CheckConstraint();
                checkCs.setName(sk3);
                checkCs.setExpression(exp);
                alterExp.setIndex(checkCs);
          break;
          }
        default:
          jj_la1[347] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[348] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
alterExp.setOperation(AlterOperation.DROP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:{
        jj_consume_token(K_COLUMN);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[349] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColumnName(tk.image);
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[350] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setConstraintName(tk.image);
        break;
        }
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[352] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return alterExp;}
    throw new Error("Missing return statement in function");
}

  final public Alter AlterTable() throws ParseException {Alter alter = new Alter();
    Table table;
    AlterExpression alterExp;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_TABLE);
    table = Table();
alter.setTable(table);
    alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    label_71:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 172:{
        ;
        break;
        }
      default:
        jj_la1[353] = jj_gen;
        break label_71;
      }
      jj_consume_token(172);
      alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    }
{if ("" != null) return alter;}
    throw new Error("Missing return statement in function");
}

  final public Wait Wait() throws ParseException {Wait wait = new Wait();
    Token token = null;
    jj_consume_token(K_WAIT);
    token = jj_consume_token(S_LONG);
wait.setTimeout(Long.parseLong(token.image));
{if ("" != null) return wait;}
    throw new Error("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_3R_512()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_511()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_510()
 {
    if (jj_scan_token(178)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_509()
 {
    if (jj_scan_token(177)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_508()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_467()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_508()) {
    jj_scanpos = xsp;
    if (jj_3R_509()) {
    jj_scanpos = xsp;
    if (jj_3R_510()) {
    jj_scanpos = xsp;
    if (jj_3R_511()) {
    jj_scanpos = xsp;
    if (jj_3R_512()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_scan_token(178)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_480()
 {
    if (jj_scan_token(171)) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_scan_token(178)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_scan_token(177)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_436()
 {
    if (jj_3R_467()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_scan_token(177)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_scan_token(173)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) return true;
    }
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) return true;
    }
    }
    if (jj_scan_token(172)) return true;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_479()
 {
    if (jj_scan_token(172)) return true;
    return false;
  }

  private boolean jj_3R_450()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_479()) {
    jj_scanpos = xsp;
    if (jj_3R_480()) return true;
    }
    return false;
  }

  private boolean jj_3R_399()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3R_436()) return true;
    }
    return false;
  }

  private boolean jj_3R_416()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_450()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_407()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_382()
 {
    if (jj_scan_token(173)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_416()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_339()
 {
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3R_439()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_408()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_438()) {
    jj_scanpos = xsp;
    if (jj_3R_439()) return true;
    }
    return false;
  }

  private boolean jj_3R_438()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_338()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    return false;
  }

  private boolean jj_3R_337()
 {
    if (jj_scan_token(K_WITH)) return true;
    return false;
  }

  private boolean jj_3R_540()
 {
    if (jj_scan_token(172)) return true;
    return false;
  }

  private boolean jj_3R_372()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_3R_407()) return true;
    }
    return false;
  }

  private boolean jj_3R_373()
 {
    if (jj_scan_token(K_NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_408()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_336()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_335()
 {
    if (jj_scan_token(K_CHECK)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_150()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_372()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_334()
 {
    if (jj_3R_382()) return true;
    return false;
  }

  private boolean jj_3R_333()
 {
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_103()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_415()
 {
    if (jj_scan_token(192)) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_305()) return true;
    return false;
  }

  private boolean jj_3R_332()
 {
    if (jj_scan_token(171)) return true;
    return false;
  }

  private boolean jj_3R_331()
 {
    if (jj_scan_token(K_TIME_KEY_EXPR)) return true;
    return false;
  }

  private boolean jj_3R_330()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_scan_token(K_ORDER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(93)) jj_scanpos = xsp;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_305()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_306()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_scan_token(K_DELETE)) return true;
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_327()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_325()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3R_530()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_324()
 {
    if (jj_scan_token(K_ON)) return true;
    return false;
  }

  private boolean jj_3R_381()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_529()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_466()
 {
    if (jj_scan_token(K_HAVING)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_419()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_380()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_379()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) {
    jj_scanpos = xsp;
    if (jj_3R_415()) return true;
    }
    return false;
  }

  private boolean jj_3R_414()
 {
    if (jj_scan_token(179)) return true;
    return false;
  }

  private boolean jj_3R_323()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_379()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_380()) {
    jj_scanpos = xsp;
    if (jj_3R_381()) return true;
    }
    return false;
  }

  private boolean jj_3R_322()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_506()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_321()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_531()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_465()
 {
    if (jj_scan_token(K_GROUP)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_77()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_506()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_320()
 {
    if (jj_scan_token(K_REFERENCES)) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    if (jj_scan_token(K_FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    return false;
  }

  private boolean jj_3R_498()
 {
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_530()) jj_scanpos = xsp;
    if (jj_3R_313()) return true;
    xsp = jj_scanpos;
    if (jj_3R_531()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_378()
 {
    if (jj_scan_token(176)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_497()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_313()) return true;
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_529()) jj_scanpos = xsp;
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_378()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_267()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_315()) {
    jj_scanpos = xsp;
    if (jj_3R_316()) {
    jj_scanpos = xsp;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) {
    jj_scanpos = xsp;
    if (jj_3R_329()) {
    jj_scanpos = xsp;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3_103()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_464()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_497()) {
    jj_scanpos = xsp;
    if (jj_3R_498()) return true;
    }
    return false;
  }

  private boolean jj_3R_388()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_418()) {
    jj_scanpos = xsp;
    if (jj_3R_419()) return true;
    }
    return false;
  }

  private boolean jj_3R_418()
 {
    if (jj_scan_token(K_SEMI)) return true;
    return false;
  }

  private boolean jj_3R_463()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_392()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_scan_token(172)) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_76()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_392()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) return true;
    }
    return false;
  }

  private boolean jj_3R_391()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_390()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_353()
 {
    if (jj_scan_token(K_CROSS)) return true;
    return false;
  }

  private boolean jj_3R_389()
 {
    if (jj_scan_token(K_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_scan_token(K_MATERIALIZED)) return true;
    return false;
  }

  private boolean jj_3R_352()
 {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(K_OR)) return true;
    return false;
  }

  private boolean jj_3R_350()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_391()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_351()
 {
    if (jj_scan_token(K_INNER)) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_540()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) jj_scanpos = xsp;
    if (jj_scan_token(K_VIEW)) return true;
    return false;
  }

  private boolean jj_3R_284()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_349()
 {
    if (jj_scan_token(K_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_101()
 {
    if (jj_scan_token(K_PRECISION)) return true;
    return false;
  }

  private boolean jj_3R_197()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_284()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_3R_285()) return true;
    }
    if (jj_3R_196()) return true;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_537()
 {
    if (jj_scan_token(210)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(159)) jj_scanpos = xsp;
    if (jj_scan_token(211)) return true;
    return false;
  }

  private boolean jj_3R_528()
 {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_527()
 {
    Token xsp;
    if (jj_3R_537()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_537()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_scan_token(173)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_159()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_526()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_525()
 {
    if (jj_scan_token(K_DOUBLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_101()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_524()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(88)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_505()
 {
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_503()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_524()) {
    jj_scanpos = xsp;
    if (jj_3R_525()) {
    jj_scanpos = xsp;
    if (jj_3R_526()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_102()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_527()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_472()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_505()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_80()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_3R_196()) return true;
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_386()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_355()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_84()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_355()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_354()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_387()
 {
    if (jj_3R_417()) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_3R_151()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_scan_token(172)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_77()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_354()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_287()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_99()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_157()) jj_scanpos = xsp;
    if (jj_scan_token(K_CHECK)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_158()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_DELETE)) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_77()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_286()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_scan_token(173)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    if (jj_scan_token(174)) return true;
    xsp = jj_scanpos;
    if (jj_3R_199()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_504()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_348()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_346()
 {
    if (jj_3R_386()) return true;
    return false;
  }

  private boolean jj_3R_347()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3R_387()) return true;
    }
    return false;
  }

  private boolean jj_3R_345()
 {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_385()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_344()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_384()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3_98()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) jj_scanpos = xsp;
    if (jj_scan_token(K_FOREIGN)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_343()
 {
    if (jj_scan_token(173)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_384()) {
    jj_scanpos = xsp;
    if (jj_3R_385()) return true;
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_97()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(118)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(66)) jj_scanpos = xsp;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_84()) return true;
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_283()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) {
    jj_scanpos = xsp;
    if (jj_3R_346()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_347()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) return true;
    }
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_462()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_161()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_504()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_454()
 {
    if (jj_3R_485()) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_453()
 {
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_451()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_452()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(173)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3R_453()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3R_454()) return true;
    }
    }
    }
    if (jj_scan_token(174)) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_455()
 {
    if (jj_3R_485()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_417()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_451()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_452()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(173)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_455()) return true;
    }
    if (jj_scan_token(174)) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(K_UNLOGGED)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_166()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_516()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_515()) return true;
    return false;
  }

  private boolean jj_3R_485()
 {
    if (jj_3R_515()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_516()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_scan_token(175)) return true;
    return false;
  }

  private boolean jj_3R_532()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_515()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(174)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_532()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_194()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_195()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_340()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_482()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_481()) return true;
    return false;
  }

  private boolean jj_3R_451()
 {
    if (jj_3R_481()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_482()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(172)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_270()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_514()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_484()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_483()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_76()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_514()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_513()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_452()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_483()) {
    jj_scanpos = xsp;
    if (jj_3R_484()) return true;
    }
    return false;
  }

  private boolean jj_3R_461()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_460()) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_481()
 {
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_513()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_476()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_160()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_84()) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_161()) return true;
    if (jj_scan_token(173)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_162()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_163()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(174)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_164()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_3R_278()) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_scan_token(176)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_252()) jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_3R_161()) return true;
    if (jj_scan_token(176)) return true;
    if (jj_scan_token(175)) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_360()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_377()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_3R_108()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_93()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_496()
 {
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_442()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_475()) {
    jj_scanpos = xsp;
    if (jj_3R_476()) return true;
    }
    return false;
  }

  private boolean jj_3R_475()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_495()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_494()
 {
    if (jj_scan_token(175)) return true;
    return false;
  }

  private boolean jj_3R_460()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_494()) {
    jj_scanpos = xsp;
    if (jj_3R_495()) {
    jj_scanpos = xsp;
    if (jj_3R_496()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_522()
 {
    if (jj_scan_token(K_SEPARATOR)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_521()
 {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_520()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_413()
 {
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_scan_token(K_GROUP_CONCAT)) return true;
    if (jj_scan_token(173)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_520()) jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    xsp = jj_scanpos;
    if (jj_3R_521()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_522()) jj_scanpos = xsp;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_423()
 {
    if (jj_3R_460()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_461()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_293()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) return true;
    }
    return false;
  }

  private boolean jj_3R_359()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_394()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_423()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_293()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) return true;
    }
    return false;
  }

  private boolean jj_3R_393()
 {
    if (jj_scan_token(K_RECURSIVE)) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_364()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_393()) jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    xsp = jj_scanpos;
    if (jj_3R_394()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_186()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_scan_token(176)) return true;
    if (jj_3R_236()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_292()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_scan_token(209)) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_235()) jj_scanpos = xsp;
    if (jj_3R_236()) return true;
    xsp = jj_scanpos;
    if (jj_3R_237()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    xsp = jj_scanpos;
    if (jj_3R_238()) jj_scanpos = xsp;
    if (jj_scan_token(174)) return true;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_240()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(200)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_364()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_377()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_542()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_535()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_412()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_186()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_369()
 {
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_368()
 {
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_398()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_342()
 {
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3R_367()
 {
    if (jj_3R_399()) return true;
    return false;
  }

  private boolean jj_3R_397()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_366()
 {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_396()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_395()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_365()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_395()) {
    jj_scanpos = xsp;
    if (jj_3R_396()) {
    jj_scanpos = xsp;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3R_398()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_412()) {
    jj_scanpos = xsp;
    if (jj_3R_413()) return true;
    }
    return false;
  }

  private boolean jj_3R_341()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_186()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_363()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_363()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_341()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_365()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_366()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_367()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_368()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_369()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_92()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_539()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_3R_79()) return true;
    if (jj_scan_token(K_THEN)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(K_WAIT)) return true;
    return false;
  }

  private boolean jj_3R_541()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3R_474()
 {
    if (jj_3R_507()) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_473()
 {
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_538()
 {
    if (jj_scan_token(K_WHEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_541()) {
    jj_scanpos = xsp;
    if (jj_3R_542()) return true;
    }
    if (jj_scan_token(K_THEN)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_SIBLINGS)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_435()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_474()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_502()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_434()
 {
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_536()
 {
    if (jj_3R_539()) return true;
    return false;
  }

  private boolean jj_3R_433()
 {
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_432()
 {
    if (jj_3R_399()) return true;
    return false;
  }

  private boolean jj_3R_431()
 {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_534()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_429()
 {
    if (jj_3R_466()) return true;
    return false;
  }

  private boolean jj_3R_430()
 {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_533()
 {
    if (jj_3R_538()) return true;
    return false;
  }

  private boolean jj_3R_518()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_534()) {
    jj_scanpos = xsp;
    if (jj_3R_535()) return true;
    }
    if (jj_3R_536()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_536()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_428()
 {
    if (jj_3R_465()) return true;
    return false;
  }

  private boolean jj_3R_427()
 {
    if (jj_3R_464()) return true;
    return false;
  }

  private boolean jj_3R_517()
 {
    Token xsp;
    if (jj_3R_533()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_533()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_426()
 {
    if (jj_3R_463()) return true;
    return false;
  }

  private boolean jj_3R_489()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_423()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_519()
 {
    if (jj_scan_token(K_ELSE)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_425()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_196()) return true;
    if (jj_3R_472()) return true;
    return false;
  }

  private boolean jj_3R_424()
 {
    if (jj_3R_462()) return true;
    return false;
  }

  private boolean jj_3R_458()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_422()
 {
    if (jj_3R_459()) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_scan_token(K_CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_517()) {
    jj_scanpos = xsp;
    if (jj_3R_518()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_519()) jj_scanpos = xsp;
    if (jj_scan_token(K_END)) return true;
    return false;
  }

  private boolean jj_3R_457()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_489()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_scan_token(175)) return true;
    return false;
  }

  private boolean jj_3R_421()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_3R_457()) {
    jj_scanpos = xsp;
    if (jj_3R_458()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_420()
 {
    if (jj_3R_456()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(K_CAST)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_77()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_503()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_404()
 {
    if (jj_scan_token(K_RANGE)) return true;
    return false;
  }

  private boolean jj_3R_383()
 {
    if (jj_scan_token(K_SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_420()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_421()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_422()) jj_scanpos = xsp;
    if (jj_3R_423()) return true;
    xsp = jj_scanpos;
    if (jj_3R_424()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_425()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_426()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_427()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_428()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_429()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_431()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_432()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_433()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_434()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_435()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_500()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(K_EXTRACT)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_77()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_499()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_501()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_402()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_470()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_501()) {
    jj_scanpos = xsp;
    if (jj_3R_502()) return true;
    }
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_3R_278()) return true;
    return false;
  }

  private boolean jj_3R_469()
 {
    if (jj_scan_token(K_CURRENT)) return true;
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_437()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_468()) {
    jj_scanpos = xsp;
    if (jj_3R_469()) {
    jj_scanpos = xsp;
    if (jj_3R_470()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_468()
 {
    if (jj_scan_token(K_UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_499()) {
    jj_scanpos = xsp;
    if (jj_3R_500()) return true;
    }
    return false;
  }

  private boolean jj_3R_362()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_3R_161()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_406()
 {
    if (jj_3R_437()) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_370()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_402()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_405()
 {
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_437()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_437()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) jj_scanpos = xsp;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_403()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) jj_scanpos = xsp;
    if (jj_scan_token(176)) return true;
    xsp = jj_scanpos;
    if (jj_3R_87()) jj_scanpos = xsp;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_371()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) return true;
    }
    return false;
  }

  private boolean jj_3R_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_361()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) return true;
    }
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_3R_261()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    }
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_370()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(173)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_257()) jj_scanpos = xsp;
    if (jj_scan_token(174)) return true;
    xsp = jj_scanpos;
    if (jj_3R_258()) jj_scanpos = xsp;
    if (jj_scan_token(K_OVER)) return true;
    if (jj_scan_token(173)) return true;
    xsp = jj_scanpos;
    if (jj_3R_259()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_260()) jj_scanpos = xsp;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_296()
 {
    if (jj_scan_token(K_KEEP)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) return true;
    }
    if (jj_3R_261()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    if (jj_scan_token(176)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(174)) return true;
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(K_GROUP)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_523()
 {
    if (jj_scan_token(192)) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_523()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_90()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_scan_token(208)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_scan_token(207)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_scan_token(206)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_scan_token(205)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_3R_76()) return true;
    Token xsp;
    if (jj_3R_262()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_262()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_scan_token(K_MATCHED)) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_scan_token(178)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_scan_token(182)) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_131()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    }
    if (jj_3R_256()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_3R_187()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_188()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_scan_token(178)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_273()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_scan_token(172)) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_149()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_3R_277()) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_471()
 {
    if (jj_scan_token(203)) return true;
    if (jj_3R_503()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_scan_token(202)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(200)) return true;
    return false;
  }

  private boolean jj_3_88()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_147()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(201)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(200)) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_146()) jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_scan_token(199)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(200)) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3_89()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_179()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_276()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_178()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_scan_token(K_TIME_KEY_EXPR)) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3_81()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3_80()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_137()) jj_scanpos = xsp;
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) jj_scanpos = xsp;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_142()) jj_scanpos = xsp;
    if (jj_scan_token(S_HEX)) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_141()) jj_scanpos = xsp;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_140()) jj_scanpos = xsp;
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) jj_scanpos = xsp;
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_3R_272()) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) return true;
    }
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) jj_scanpos = xsp;
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_130()) jj_scanpos = xsp;
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) jj_scanpos = xsp;
    if (jj_scan_token(177)) return true;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    return false;
  }

  private boolean jj_3R_79()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3_76()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3_89()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_471()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_scan_token(197)) return true;
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_scan_token(196)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_440()
 {
    if (jj_scan_token(198)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_3R_79()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_440()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_scan_token(175)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(192)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    }
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_3R_126()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_71()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_scan_token(179)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) return true;
    }
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_70()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_scan_token(195)) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_scan_token(194)) return true;
    return false;
  }

  private boolean jj_3R_264()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) return true;
    }
    if (jj_3R_263()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_3R_263()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_264()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_scan_token(K_SOME)) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(191)) return true;
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_3R_119()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_69()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_76()) return true;
    if (jj_scan_token(171)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    if (jj_scan_token(173)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_scan_token(172)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_scan_token(K_ALL)) return true;
    if (jj_scan_token(173)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_3R_297()) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_250()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_357()
 {
    if (jj_scan_token(K_ILIKE)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_249()) jj_scanpos = xsp;
    if (jj_scan_token(K_EXISTS)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_3R_77()) return true;
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_300()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_scan_token(K_NOT)) return true;
    if (jj_3R_77()) return true;
    if (jj_scan_token(K_IS)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) return true;
    }
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_358()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_356()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_356()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_3R_357()) return true;
    }
    if (jj_3R_77()) return true;
    xsp = jj_scanpos;
    if (jj_3R_358()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_246()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_77()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_scan_token(173)) return true;
    if (jj_scan_token(179)) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(173)) return true;
    if (jj_scan_token(179)) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_299()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_3R_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_scan_token(173)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_244()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(173)) return true;
    xsp = jj_scanpos;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) return true;
    }
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_scan_token(173)) return true;
    if (jj_scan_token(179)) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(193)) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(192)) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_scan_token(191)) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(190)) return true;
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(189)) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(177)) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_scan_token(188)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(187)) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_scan_token(186)) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(184)) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_scan_token(K_REGEXP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_290()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(183)) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_scan_token(182)) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_scan_token(OP_NOTEQUALSBANG)) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_scan_token(OP_NOTEQUALSSTANDARD)) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_scan_token(OP_MINORTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_scan_token(OP_GREATERTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_scan_token(171)) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_scan_token(181)) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_scan_token(180)) return true;
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_scan_token(173)) return true;
    if (jj_scan_token(179)) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) jj_scanpos = xsp;
    if (jj_3R_109()) return true;
    xsp = jj_scanpos;
    if (jj_3R_212()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_234()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_507()
 {
    if (jj_scan_token(K_WAIT)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(K_NOT)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = "0".equals(getToken(1).image) || "1".equals(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_205()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_441()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_411()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_441()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_265()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_410()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_376()
 {
    if (jj_scan_token(K_AND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) {
    jj_scanpos = xsp;
    if (jj_3R_411()) return true;
    }
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_409()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_375()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_409()) jj_scanpos = xsp;
    if (jj_scan_token(173)) return true;
    if (jj_3R_265()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_374()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_313()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_376()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_scan_token(K_OR)) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_314()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_3R_313()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_314()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(177)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_50()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_3R_265()) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_104()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_488()
 {
    if (jj_scan_token(177)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_49()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_487()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_486()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_456()
 {
    if (jj_scan_token(K_SKIP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_486()) {
    jj_scanpos = xsp;
    if (jj_3R_487()) {
    jj_scanpos = xsp;
    if (jj_3R_488()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_478()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_493()
 {
    if (jj_scan_token(173)) return true;
    if (jj_3R_119()) return true;
    if (jj_scan_token(174)) return true;
    return false;
  }

  private boolean jj_3R_491()
 {
    if (jj_scan_token(177)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_492()
 {
    if (jj_scan_token(178)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_490()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_459()
 {
    if (jj_scan_token(K_TOP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_490()) {
    jj_scanpos = xsp;
    if (jj_3R_491()) {
    jj_scanpos = xsp;
    if (jj_3R_492()) {
    jj_scanpos = xsp;
    if (jj_3R_493()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_48()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_448()
 {
    if (jj_scan_token(177)) return true;
    return false;
  }

  private boolean jj_3R_449()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_446()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_447()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_477()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_401()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_446()) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_447()) {
    jj_scanpos = xsp;
    if (jj_3R_448()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_449()) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) return true;
    }
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3R_444()
 {
    if (jj_scan_token(177)) return true;
    return false;
  }

  private boolean jj_3R_445()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_477()) {
    jj_scanpos = xsp;
    if (jj_3R_478()) return true;
    }
    return false;
  }

  private boolean jj_3R_443()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_400()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_443()) {
    jj_scanpos = xsp;
    if (jj_3R_444()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_445()) jj_scanpos = xsp;
    return false;
  }

  /** Generated Token Manager. */
  public CCJSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[354];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x1004000,0x0,0x0,0x1004000,0x0,0x0,0x0,0x0,0x0,0x0,0x20061810,0x10000000,0x0,0x0,0x0,0x64265810,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x64265810,0x0,0x0,0x30061810,0x20061810,0x0,0x0,0x0,0x20061810,0x20061814,0x80000000,0x80000000,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x20061810,0x20061810,0x20061810,0x24065810,0x24075810,0x20061810,0x20061810,0x20061810,0x20061810,0x20061814,0x0,0x0,0x100,0x200,0x200,0x10000,0x100000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20061814,0x0,0x64265810,0x4,0x20061814,0x0,0x20061810,0x0,0x0,0x20061814,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20061810,0x0,0x0,0x20061814,0x24065810,0x0,0x0,0x0,0x0,0x64265810,0x0,0x0,0x20061814,0xe000000,0x0,0x0,0x0,0x0,0xc000000,0xc000000,0x2000000,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x88000,0x88000,0x0,0x0,0x0,0x0,0x0,0x0,0x200200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x400,0x2000,0x2000,0x20063810,0x2000,0x0,0x0,0x0,0x64265a10,0x0,0x64265810,0x0,0x64265810,0x0,0x64265810,0x2000,0x64265810,0x2000,0x2000,0xc00000,0x0,0x2000,0x64267810,0x2000,0x0,0x0,0x0,0x200,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x64265810,0x64265810,0x0,0x0,0x0,0x0,0x0,0x64265810,0x0,0x0,0x64265810,0x80000000,0x64265810,0x80000000,0xe4267a10,0x0,0x64265810,0x0,0x0,0x64265810,0x0,0x0,0x0,0x200,0x200,0x64265810,0x64265a10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x203100,0x0,0x28b100,0x28b100,0x0,0x0,0x28b100,0x28b100,0x203100,0x0,0x203100,0x0,0x203100,0x0,0x0,0x1000,0x0,0x203100,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x203100,0x0,0x20061810,0x203100,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x203100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x203100,0x2000,0x2000,0x0,0x0,0x0,0x4000,0x100,0x0,0x0,0x20061810,0x0,0x0,0x0,0x1000000,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x62800010,0x0,0x0,0x0,0x0,0x63800010,0x0,0x0,0x0,0x0,0x0,0x0,0xa0400840,0x0,0x100,0x100000,0x40000,0xa0600840,0x0,0x0,0x0,0x0,0x80400000,0x80400000,0x0,0x2000010,0x82400010,0x0,0x0,0x0,0x0,0x0,0x0,0x80400000,0x80400000,0x0,0x0,0x0,0x2000010,0x2000010,0x0,0x0,0xa0600840,0x0,0x0,0xa0400840,0xa0400840,0x100,0x100000,0x40000,0xa0400840,0xa0400840,0x0,0x0,0x0,0x0,0x0,0x100,0x800000,0x0,0x0,0xa0400840,0xa0400840,0xa0400840,0xa0600840,0xa0600840,0xa0400840,0xa0400840,0xa0400840,0xa0400840,0xa0400840,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x4000,0x10000000,0x0,0x200,0x2000000,0x2000,0x0,0x0,0x2000,0x2000000,0x100000,0x0,0x0,0x0,0x0,0xa0400840,0x0,0xa0600840,0x0,0xa0400840,0x0,0xa0400840,0x0,0x0,0xa0400840,0x0,0x0,0x2000000,0x0,0x0,0x2000010,0x0,0xa0400840,0x400,0x400,0xa0400840,0xa0600840,0x0,0x0,0x0,0x0,0xa0600840,0x0,0x0,0xa0400840,0x220008,0x80000,0x80000,0x200008,0x80000,0x220008,0x220008,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0xa0400840,0x0,0x0,0x0,0x0,0xa0600844,0x0,0xa0600840,0x0,0xa0600840,0x0,0xa0600840,0x0,0xa0600840,0x0,0x0,0x0,0x0,0x0,0xa0600840,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0600840,0xa0600840,0x0,0x0,0x0,0x100000,0x0,0xa0600840,0x0,0x0,0xa0600840,0x0,0xa0600840,0x0,0xa0600844,0x2,0xa0600840,0x0,0x0,0xa0600840,0x0,0x0,0x0,0x0,0x0,0xa0600840,0xa0600840,0x0,0x0,0x0,0x0,0x100000,0x0,0x10,0x40801110,0x0,0x40801110,0x40801110,0x0,0x0,0x40801110,0x40801110,0x40801110,0x0,0x40801110,0x0,0x40801110,0x0,0x0,0x0,0x0,0x40801110,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40801110,0x10000,0xa0400840,0x40801110,0x2000010,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40800000,0x110,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10040,0x0,0x0,0x0,0x40801110,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0400840,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x10,0x0,0x40000040,0x0,0x0,0x40000050,0x0,0x0,0x0,0x0,0x0,0x0,0x28017250,0x0,0x0,0x0,0x0,0x28037250,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28037250,0x0,0x0,0x28017250,0x28017250,0x0,0x0,0x0,0x28017250,0x28017250,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28017250,0x28017250,0x28017250,0x28017250,0x28017250,0x28017250,0x28017250,0x28017250,0x28017250,0x28017250,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x6000000,0x0,0x0,0x0,0x0,0x0,0xd00,0x80,0x80,0xd00,0x0,0x0,0x0,0x0,0x0,0x0,0x28017250,0x0,0x28037250,0x0,0x28017250,0x0,0x28017250,0x0,0x0,0x28017250,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2801f250,0x0,0x0,0x28017250,0x2801f250,0x0,0x0,0x0,0x0,0x28037250,0x0,0x0,0x28017250,0x8,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x10000000,0x10000000,0x2000000,0x6000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28017250,0x0,0x0,0x0,0x0,0x28037250,0x0,0x28037250,0x0,0x28037250,0x0,0x28037250,0x0,0x28037250,0x0,0x0,0x0,0x1,0x0,0x28037250,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28037250,0x28037250,0x0,0x2000,0x0,0x0,0x0,0x28037270,0x0,0x0,0x28037250,0x0,0x28037250,0x0,0x28037250,0x0,0x28037250,0x0,0x0,0x28037250,0x0,0x0,0x0,0x80,0x80,0x28037250,0x280372d0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x3c0002,0x0,0x3c0002,0x3c0002,0x0,0x0,0x3c0002,0x3c0002,0x3c0002,0x0,0x3c0002,0x0,0x3c0002,0x0,0x80000,0x0,0x2,0x3c0002,0x0,0x4,0x80000,0x0,0x0,0x80000,0x0,0x0,0x3c0002,0x0,0x28017250,0x3c0002,0x0,0x0,0x0,0xc00000,0x1000000,0x20000,0xc20000,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x140002,0x280000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c0002,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x240002,0x280d7252,0x0,0x0,0x80000,0x80000000,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x80000000,0x30000,0x0,0x0,0x80030000,0x0,0x0,0x0,0x0,0x0,0x0,0x20200a7e,0x0,0x0,0x0,0x0,0x30200a7e,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30200a7e,0x1000,0x0,0x20200a7e,0x20200a7e,0x0,0x0,0x0,0x20200a7e,0x20200a7e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20200a7e,0x20200a7e,0x20200a7e,0x20200a7e,0x20200a7e,0x20200a7e,0x20200a7e,0x20200a7e,0x20200a7e,0x20200a7e,0x0,0x40000000,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x20200a7e,0x0,0x30200a7e,0x0,0x20200a7e,0x0,0x20200a7e,0x0,0x0,0x20200a7e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20200a7e,0x0,0x0,0x20200a7e,0x20200a7e,0x0,0x0,0x0,0x0,0x30200a7e,0x0,0x0,0x20200a7e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x18,0x4,0x0,0x0,0x0,0x0,0x0,0x820,0x820,0x80008,0x0,0x820,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x20200a7e,0x0,0x0,0x2000,0x4000,0x30200a7e,0x0,0x30200a7e,0x0,0x30200a7e,0x0,0x30200a7e,0x0,0x30200a7e,0x0,0x0,0x0,0x0,0x0,0x30200a7e,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x0,0x30200a7e,0x30200a7e,0x8000000,0x0,0x60,0x0,0x60,0x30200efe,0x300,0x300,0x30200efe,0x0,0x30200a7e,0x0,0x30200a7e,0x0,0x30200a7e,0x800,0x30000,0x30200a7e,0x0,0x0,0x0,0x0,0x0,0x30200a7e,0x30200a7e,0x0,0x8000000,0x0,0x0,0x0,0x20000000,0x0,0x600020,0x0,0x600020,0x600020,0x0,0x0,0x600020,0x600020,0x600020,0x8000,0x600020,0x1000000,0x600020,0x0,0x0,0x0,0x400000,0x600020,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x600020,0x0,0x20200a7e,0x600020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x600020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x600020,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x20600a7e,0x0,0x0,0x2,0x1,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x1000000,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x881a,0x0,0x0,0x0,0x0,0xc000e81a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0,0x1c0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000e81a,0x0,0x0,0x881a,0x881a,0x0,0x0,0x0,0x881a,0x881a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x881a,0x881a,0x881a,0xc81a,0xc81a,0x881a,0x881a,0x881a,0x881a,0x881a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x881a,0x0,0xc000e81a,0x0,0x881a,0x0,0x881a,0x0,0x0,0x881a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x881a,0x0,0x0,0x881a,0xc81a,0x0,0x0,0x0,0x0,0xc000e81a,0x0,0x0,0x881a,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x881a,0x0,0x0,0x0,0x1e000000,0xc000e81a,0x0,0xc000e81a,0x0,0xc000e81a,0x0,0xc000e81a,0x0,0xc000e81a,0x0,0x0,0x0,0x0,0x0,0xc000e81a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x0,0x0,0xc000e81a,0xc000e81a,0x0,0x0,0x0,0x0,0x0,0xc000e81a,0x0,0x0,0xc000e81a,0x0,0xc000e81a,0x0,0xc000e81a,0x0,0xc000e81a,0x0,0x0,0xc000e81a,0x0,0x0,0x0,0x0,0x0,0xc000e81a,0xc000e81a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0032002,0x0,0xc0032002,0xc0032002,0x0,0x0,0xc0032002,0xc0032002,0xc0032002,0x0,0xc0032002,0x0,0xc0032002,0x0,0x0,0x0,0x0,0xc0032002,0x0,0x0,0x0,0xa,0xa,0x0,0x0,0x0,0xc0032002,0x0,0x2881a,0xc0032002,0x0,0x0,0x0,0x0,0x0,0x20000800,0x20004800,0x80000000,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xc0002002,0x30000,0xc0000000,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0xc0032002,0xf80000,0xf80000,0x0,0x0,0x0,0x6,0x0,0x0,0x0,0x881a,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x0,0x2000,0x0,0x0,0x0,0x0,0x2000,0x800,0x1000,0x1000,0x2000,0x1000,0x4000,0x2220,0x0,0x0,0x0,0x0,0x4ea322,0x0,0x0,0x1000,0x1000,0x0,0x0,0x1000,0x2000,0x2000,0x1000,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x1000,0x1000,0x1000,0x2000,0x2000,0x1000,0x0,0x4ea322,0x0,0x1000,0x220,0x220,0x0,0x0,0x0,0x2220,0x220,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x1000,0x1000,0x220,0x220,0x220,0x220,0x220,0x220,0x220,0x220,0x220,0x220,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x2000,0x0,0x1000,0x0,0x2000,0x1000,0x220,0x8000,0x4e2322,0x0,0x220,0x1000,0x2220,0x1000,0x1000,0x220,0x1000,0x2000,0x2000,0x2000,0x1000,0x2000,0x2000,0x220,0x0,0x0,0x220,0x2220,0x1000,0x1000,0x1000,0x1000,0x4e2322,0x1000,0x2000,0x220,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x60000,0x60000,0x0,0x60000,0x20000,0x0,0x0,0x0,0x20000,0x0,0x62000,0x20020,0x0,0x20020,0x0,0x2000,0x0,0x0,0x2000,0x220,0x0,0x2000,0x0,0xffe20800,0x4e2322,0x2000,0x4e2322,0x2000,0x4e2322,0x2000,0x4e2322,0x0,0x4e2322,0x0,0x0,0x0,0x0,0x0,0x4e2322,0x0,0x1000,0x1000,0x1000,0x0,0x2000,0x0,0x0,0x0,0x80000,0x8000,0x0,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x80000,0x0,0x0,0x0,0x100,0x0,0x400000,0x0,0x0,0x0,0x100,0x0,0x1000,0x1000,0x4ea322,0x4ea322,0x0,0x0,0x0,0x0,0x0,0x4e2322,0x0,0x0,0x4e2322,0x0,0x4e2322,0x0,0x4e2322,0x0,0x4e2322,0x0,0x0,0x4e2322,0x0,0x10000,0x10000,0x0,0x0,0x4ea322,0x4ea322,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x82920,0x220,0x82920,0x82920,0x1000,0x220,0x82920,0x82920,0x82920,0x0,0x82920,0x0,0x82920,0x1000,0x0,0x0,0x0,0x82920,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x82920,0x0,0x220,0x82920,0x2000,0x2000,0x2000,0x0,0x0,0x20,0x20,0x120,0x120,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x10000,0x80000,0x80000,0x0,0x80920,0x2000,0x120,0x120,0x1800,0x1800,0x220,0x1000,0x220,0x20,0x0,0x20,0x20,0x82920,0x0,0x0,0x0,0x1000,0x220,0x0,0x0,0x2000,0x0,0x2220,0x220,0x220,0x0,0x0,0x1000,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21681,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21681,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21681,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x21681,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x21681,0x0,0x21681,0x0,0x21681,0x0,0x21681,0x0,0x21681,0x0,0x0,0x0,0x0,0x0,0x21681,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0xc,0x1,0x30,0x40,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x0,0x0,0x0,0x680,0x800,0x1000,0x1e000,0x1e000,0x1,0x0,0x0,0x0,0x0,0x21681,0x21681,0x0,0x0,0x0,0x0,0x0,0x21681,0x0,0x0,0x21681,0x0,0x21681,0x0,0x21681,0x0,0x21681,0x0,0x0,0x21681,0x20000,0x0,0x0,0x0,0x0,0x21681,0x21681,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x1,0x0,0x0,0x1,0x1,0x1,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[104];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public CCJSqlParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CCJSqlParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 354; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 354; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CCJSqlParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 354; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 354; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CCJSqlParser(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 354; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 354; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[212];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 354; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		   if ((jj_la1_5[i] & (1<<j)) != 0) {
			 la1tokens[160+j] = true;
		   }
		   if ((jj_la1_6[i] & (1<<j)) != 0) {
			 la1tokens[192+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 212; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 104; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			   case 28: jj_3_29(); break;
			   case 29: jj_3_30(); break;
			   case 30: jj_3_31(); break;
			   case 31: jj_3_32(); break;
			   case 32: jj_3_33(); break;
			   case 33: jj_3_34(); break;
			   case 34: jj_3_35(); break;
			   case 35: jj_3_36(); break;
			   case 36: jj_3_37(); break;
			   case 37: jj_3_38(); break;
			   case 38: jj_3_39(); break;
			   case 39: jj_3_40(); break;
			   case 40: jj_3_41(); break;
			   case 41: jj_3_42(); break;
			   case 42: jj_3_43(); break;
			   case 43: jj_3_44(); break;
			   case 44: jj_3_45(); break;
			   case 45: jj_3_46(); break;
			   case 46: jj_3_47(); break;
			   case 47: jj_3_48(); break;
			   case 48: jj_3_49(); break;
			   case 49: jj_3_50(); break;
			   case 50: jj_3_51(); break;
			   case 51: jj_3_52(); break;
			   case 52: jj_3_53(); break;
			   case 53: jj_3_54(); break;
			   case 54: jj_3_55(); break;
			   case 55: jj_3_56(); break;
			   case 56: jj_3_57(); break;
			   case 57: jj_3_58(); break;
			   case 58: jj_3_59(); break;
			   case 59: jj_3_60(); break;
			   case 60: jj_3_61(); break;
			   case 61: jj_3_62(); break;
			   case 62: jj_3_63(); break;
			   case 63: jj_3_64(); break;
			   case 64: jj_3_65(); break;
			   case 65: jj_3_66(); break;
			   case 66: jj_3_67(); break;
			   case 67: jj_3_68(); break;
			   case 68: jj_3_69(); break;
			   case 69: jj_3_70(); break;
			   case 70: jj_3_71(); break;
			   case 71: jj_3_72(); break;
			   case 72: jj_3_73(); break;
			   case 73: jj_3_74(); break;
			   case 74: jj_3_75(); break;
			   case 75: jj_3_76(); break;
			   case 76: jj_3_77(); break;
			   case 77: jj_3_78(); break;
			   case 78: jj_3_79(); break;
			   case 79: jj_3_80(); break;
			   case 80: jj_3_81(); break;
			   case 81: jj_3_82(); break;
			   case 82: jj_3_83(); break;
			   case 83: jj_3_84(); break;
			   case 84: jj_3_85(); break;
			   case 85: jj_3_86(); break;
			   case 86: jj_3_87(); break;
			   case 87: jj_3_88(); break;
			   case 88: jj_3_89(); break;
			   case 89: jj_3_90(); break;
			   case 90: jj_3_91(); break;
			   case 91: jj_3_92(); break;
			   case 92: jj_3_93(); break;
			   case 93: jj_3_94(); break;
			   case 94: jj_3_95(); break;
			   case 95: jj_3_96(); break;
			   case 96: jj_3_97(); break;
			   case 97: jj_3_98(); break;
			   case 98: jj_3_99(); break;
			   case 99: jj_3_100(); break;
			   case 100: jj_3_101(); break;
			   case 101: jj_3_102(); break;
			   case 102: jj_3_103(); break;
			   case 103: jj_3_104(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
