/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.alter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.alter.AlterExpression;

public class Alter
implements Statement {
    private Table table;
    private boolean useOnly = false;
    private List<AlterExpression> alterExpressions;

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUseOnly() {
        return this.useOnly;
    }

    public void setUseOnly(boolean useOnly) {
        this.useOnly = useOnly;
    }

    public void addAlterExpression(AlterExpression alterExpression) {
        if (this.alterExpressions == null) {
            this.alterExpressions = new ArrayList<AlterExpression>();
        }
        this.alterExpressions.add(alterExpression);
    }

    public List<AlterExpression> getAlterExpressions() {
        return this.alterExpressions;
    }

    public void setAlterExpressions(List<AlterExpression> alterExpressions) {
        this.alterExpressions = alterExpressions;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ALTER TABLE ");
        if (this.useOnly) {
            b.append("ONLY ");
        }
        b.append(this.table.getFullyQualifiedName()).append(" ");
        Iterator<AlterExpression> altIter = this.alterExpressions.iterator();
        while (altIter.hasNext()) {
            b.append(altIter.next().toString());
            if (!altIter.hasNext()) continue;
            b.append(", ");
        }
        return b.toString();
    }
}

