/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.statement.grant.Grant;

public class GrantDeParser {
    protected StringBuilder buffer;

    public GrantDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Grant grant) {
        Iterator<String> iter;
        this.buffer.append("GRANT ");
        if (grant.getRole() != null) {
            this.buffer.append(grant.getRole());
        } else {
            iter = grant.getPrivileges().iterator();
            while (iter.hasNext()) {
                String privilege = iter.next();
                this.buffer.append(privilege);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ON ");
            this.buffer.append(grant.getObjectName());
        }
        this.buffer.append(" TO ");
        iter = grant.getUsers().iterator();
        while (iter.hasNext()) {
            String user = iter.next();
            this.buffer.append(user);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

