/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.Async;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@PublicApi
public class FieldValueInfo {
    private final CompleteValueType completeValueType;
    private final Object fieldValueObject;
    private final List<FieldValueInfo> fieldValueInfos;

    public FieldValueInfo(CompleteValueType completeValueType, Object fieldValueObject) {
        this(completeValueType, fieldValueObject, ImmutableList.of());
    }

    public FieldValueInfo(CompleteValueType completeValueType, Object fieldValueObject, List<FieldValueInfo> fieldValueInfos) {
        Assert.assertNotNull(fieldValueInfos, "fieldValueInfos can't be null");
        this.completeValueType = completeValueType;
        this.fieldValueObject = fieldValueObject;
        this.fieldValueInfos = fieldValueInfos;
    }

    public CompleteValueType getCompleteValueType() {
        return this.completeValueType;
    }

    public Object getFieldValueObject() {
        return this.fieldValueObject;
    }

    public CompletableFuture<Object> getFieldValueFuture() {
        return Async.toCompletableFuture(this.fieldValueObject);
    }

    @Deprecated(since="2023-09-11")
    public CompletableFuture<ExecutionResult> getFieldValue() {
        return this.getFieldValueFuture().thenApply(fv -> ((ExecutionResultImpl.Builder)ExecutionResultImpl.newExecutionResult().data(fv)).build());
    }

    public boolean isFutureValue() {
        return this.fieldValueObject instanceof CompletableFuture;
    }

    public List<FieldValueInfo> getFieldValueInfos() {
        return this.fieldValueInfos;
    }

    public String toString() {
        return "FieldValueInfo{completeValueType=" + String.valueOf((Object)this.completeValueType) + ", fieldValueObject=" + String.valueOf(this.fieldValueObject) + ", fieldValueInfos=" + String.valueOf(this.fieldValueInfos) + "}";
    }

    public static enum CompleteValueType {
        OBJECT,
        LIST,
        NULL,
        SCALAR,
        ENUM;

    }
}

