/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.directives;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.execution.ValuesResolver;
import graphql.language.Argument;
import graphql.language.Value;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.InputValueWithState;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class QueryAppliedDirectiveArgument {
    private final String name;
    private final InputValueWithState value;
    private final GraphQLInputType originalType;
    private final Argument definition;

    private QueryAppliedDirectiveArgument(String name, InputValueWithState value, GraphQLInputType type, Argument definition) {
        Assert.assertValidName(name);
        this.name = name;
        this.value = Assert.assertNotNull(value);
        this.originalType = Assert.assertNotNull(type);
        this.definition = definition;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public GraphQLInputType getType() {
        return this.originalType;
    }

    public boolean hasSetValue() {
        return this.value.isSet();
    }

    @NotNull
    public InputValueWithState getArgumentValue() {
        return this.value;
    }

    @Nullable
    public <T> T getValue() {
        return ValuesResolver.getInputValueImpl(this.getType(), this.value, GraphQLContext.getDefault(), Locale.getDefault());
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public Argument getDefinition() {
        return this.definition;
    }

    public QueryAppliedDirectiveArgument transform(Consumer<Builder> builderConsumer) {
        Builder builder = QueryAppliedDirectiveArgument.newArgument(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newArgument() {
        return new Builder();
    }

    public static Builder newArgument(QueryAppliedDirectiveArgument existing) {
        return new Builder(existing);
    }

    public String toString() {
        return "QueryAppliedDirectiveArgument{name='" + this.name + "', type=" + String.valueOf(this.getType()) + ", value=" + String.valueOf(this.value) + "}";
    }

    public static class Builder
    extends GraphqlTypeBuilder<Builder> {
        private InputValueWithState value = InputValueWithState.NOT_SET;
        private Argument definition;
        private GraphQLInputType type;

        public Builder() {
        }

        public Builder(QueryAppliedDirectiveArgument existing) {
            this.name = existing.getName();
            this.value = existing.getArgumentValue();
            this.type = existing.getType();
        }

        public Builder type(GraphQLInputType type) {
            this.type = Assert.assertNotNull(type);
            return this;
        }

        public Builder definition(Argument definition) {
            this.definition = definition;
            return this;
        }

        public Builder valueLiteral(@NotNull Value<?> value) {
            this.value = InputValueWithState.newLiteralValue(value);
            return this;
        }

        public Builder valueProgrammatic(@Nullable Object value) {
            this.value = InputValueWithState.newExternalValue(value);
            return this;
        }

        public Builder inputValueWithState(@NotNull InputValueWithState value) {
            this.value = Assert.assertNotNull(value);
            return this;
        }

        public Builder clearValue() {
            this.value = InputValueWithState.NOT_SET;
            return this;
        }

        public QueryAppliedDirectiveArgument build() {
            return new QueryAppliedDirectiveArgument(this.name, this.value, this.type, this.definition);
        }
    }
}

