/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.NamedNode;
import graphql.language.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

@PublicApi
public class NodeParentTree<T extends Node> {
    private final T node;
    private final NodeParentTree<T> parent;
    private final ImmutableList<String> path;

    @Internal
    public NodeParentTree(Deque<T> nodeStack) {
        Assert.assertNotNull(nodeStack, () -> "You MUST have a non null stack of nodes");
        Assert.assertTrue(!nodeStack.isEmpty(), () -> "You MUST have a non empty stack of nodes");
        ArrayDeque<T> copy = new ArrayDeque<T>(nodeStack);
        this.path = this.mkPath(copy);
        this.node = (Node)copy.pop();
        this.parent = !copy.isEmpty() ? new NodeParentTree<T>(copy) : null;
    }

    private ImmutableList<String> mkPath(Deque<T> copy) {
        return copy.stream().filter(node1 -> node1 instanceof NamedNode).map(node1 -> ((NamedNode)node1).getName()).collect(ImmutableList.toImmutableList());
    }

    public T getNode() {
        return this.node;
    }

    public Optional<NodeParentTree<T>> getParentInfo() {
        return Optional.ofNullable(this.parent);
    }

    public List<String> getPath() {
        return this.path;
    }

    public List<T> toList() {
        ArrayList<T> nodes = new ArrayList<T>();
        nodes.add(this.node);
        Optional<NodeParentTree<T>> parentInfo = this.getParentInfo();
        while (parentInfo.isPresent()) {
            nodes.add(parentInfo.get().getNode());
            parentInfo = parentInfo.get().getParentInfo();
        }
        return nodes;
    }

    public String toString() {
        return String.valueOf(this.node) + " - parent : " + String.valueOf(this.parent);
    }
}

