/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.language.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class InputValueWithState {
    private final State state;
    private final Object value;
    public static final InputValueWithState NOT_SET = new InputValueWithState(State.NOT_SET, null);

    private InputValueWithState(State state, Object value) {
        this.state = state;
        this.value = value;
    }

    public static InputValueWithState newLiteralValue(@NotNull Value value) {
        Assert.assertNotNull(value, () -> "value literal can't be null");
        return new InputValueWithState(State.LITERAL, value);
    }

    public static InputValueWithState newExternalValue(@Nullable Object value) {
        return new InputValueWithState(State.EXTERNAL_VALUE, value);
    }

    public static InputValueWithState newInternalValue(@Nullable Object value) {
        return new InputValueWithState(State.INTERNAL_VALUE, value);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public boolean isNotSet() {
        return this.state == State.NOT_SET;
    }

    public boolean isSet() {
        return this.state != State.NOT_SET;
    }

    public boolean isLiteral() {
        return this.state == State.LITERAL;
    }

    public boolean isExternal() {
        return this.state == State.EXTERNAL_VALUE;
    }

    public boolean isInternal() {
        return this.state == State.INTERNAL_VALUE;
    }

    public String toString() {
        return "InputValueWithState{state=" + String.valueOf((Object)this.state) + ", value=" + String.valueOf(this.value) + "}";
    }

    private static enum State {
        NOT_SET,
        LITERAL,
        EXTERNAL_VALUE,
        INTERNAL_VALUE;

    }
}

