/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core;

import com.huaweicloud.sdk.core.ClientCustomization;
import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.CredentialProviderChain;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.ExceptionHandler;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.impl.DefaultHttpClient;
import com.huaweicloud.sdk.core.region.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class ClientBuilder<T> {
    private final Function<HcClient, T> creator;
    private ICredential credential;
    private HttpConfig httpConfig;
    private Region region;
    private List<String> endpoints;
    private ExceptionHandler exceptionHandler;
    private List<String> credentialType = new ArrayList<String>(Collections.singletonList(BasicCredentials.class.getSimpleName()));
    private String derivedAuthServiceName;

    public ClientBuilder(Function<HcClient, T> creator) {
        this.creator = creator;
    }

    public ClientBuilder(Function<HcClient, T> creator, String credentialType) {
        this.creator = creator;
        this.credentialType = Arrays.asList(credentialType.split(","));
    }

    public ClientBuilder<T> withDerivedAuthServiceName(String derivedAuthServiceName) {
        this.derivedAuthServiceName = derivedAuthServiceName;
        return this;
    }

    public ClientBuilder<T> withCredential(ICredential credential) {
        this.credential = credential;
        return this;
    }

    public ClientBuilder<T> withHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        return this;
    }

    public ClientBuilder<T> withRegion(Region region) {
        this.region = region;
        return this;
    }

    @Deprecated
    public ClientBuilder<T> withEndpoint(String endpoint) {
        return this.withEndpoints(Arrays.asList(endpoint));
    }

    public ClientBuilder<T> withEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public ClientBuilder<T> withExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public T build() {
        T t;
        ClientCustomization clientCustomization;
        if (Objects.isNull(this.httpConfig)) {
            this.httpConfig = HttpConfig.getDefaultHttpConfig();
        }
        DefaultHttpClient httpClient = new DefaultHttpClient(this.httpConfig);
        HcClient hcClient = new HcClient(this.httpConfig, httpClient);
        if (Objects.isNull(this.credential)) {
            CredentialProviderChain providerChain = CredentialProviderChain.getDefaultCredentialProviderChain(this.credentialType.get(0));
            this.credential = providerChain.getCredentials();
        }
        if (Objects.isNull(this.credential)) {
            throw new SdkException("credential can not be null, " + this.credentialType.toString() + "credential objects are required");
        }
        if (!this.credentialType.contains(this.credential.getClass().getSimpleName())) {
            throw new SdkException("credential type error, supported credential type is " + this.credentialType);
        }
        if (Objects.nonNull(this.region)) {
            if (this.region.getEndpoints() != null) {
                this.endpoints = this.region.getEndpoints();
            }
            try {
                hcClient.withCredential(this.credential);
                this.credential = this.credential.processAuthParams(hcClient, this.region.getId()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SdkException(e);
            }
            if (this.credential instanceof AbstractCredentials) {
                ((AbstractCredentials)this.credential).processDerivedAuthParams(this.derivedAuthServiceName, this.region.getId());
            }
        }
        if (this.endpoints.isEmpty()) {
            throw new SdkException("Could not find any endpoints, at least one endpoint is required");
        }
        this.endpoints.replaceAll(endpoint -> endpoint.startsWith("http") ? endpoint : "https://" + endpoint);
        hcClient.withEndpoints(this.endpoints).withCredential(this.credential);
        if (Objects.nonNull(this.exceptionHandler)) {
            hcClient.withExceptionHandler(this.exceptionHandler);
        }
        if (Objects.nonNull(clientCustomization = this.loadClientCustomization(t = this.creator.apply(hcClient)))) {
            clientCustomization.customize(hcClient);
        }
        return t;
    }

    private ClientCustomization loadClientCustomization(T t) {
        String strClientCustomizationClassName = t.getClass().getName() + "Customization";
        try {
            Class<?> customizationClass = Class.forName(strClientCustomizationClassName);
            return (ClientCustomization)customizationClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SdkException(e);
        }
    }

    public Function<HcClient, T> getCreator() {
        return this.creator;
    }

    public ICredential getCredential() {
        return this.credential;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    @Deprecated
    public String getEndpoint() {
        return this.endpoints.isEmpty() ? null : this.endpoints.get(0);
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }
}

