/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractHasher;
import com.huaweicloud.sdk.core.exception.SdkException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SHA256Hasher
extends AbstractHasher {
    SHA256Hasher() {
    }

    @Override
    protected byte[] hash(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SdkException("Unable to compute hash while signing request", e);
        }
    }

    @Override
    protected byte[] hmac(byte[] data, byte[] key) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
            hmac.init(secretKeySpec);
            return hmac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SdkException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }
}

