/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.region;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.utils.PathUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ProfileRegionCache {
    private static final String REGIONS_FILE_REG = "^[a-zA-Z0-9._ -]+\\.(yml|yaml)$";
    private static final String DEFAULT_REGIONS_FILE_NAME = "regions.yaml";
    private static final String REGIONS_FILE_ENV = "HUAWEICLOUD_SDK_REGIONS_FILE";
    private static final Logger logger = LoggerFactory.getLogger(ProfileRegionCache.class);
    private static final ProfileRegionCache INSTANCE = ProfileRegionCache.createInstance();
    protected final Map<String, Region> value;

    private ProfileRegionCache(Map<String, Region> value) {
        this.value = value;
    }

    protected static ProfileRegionCache getInstance() {
        return INSTANCE;
    }

    private static ProfileRegionCache createInstance() {
        String regionsFilePath = ProfileRegionCache.getRegionsFilePath();
        if (Objects.isNull(regionsFilePath) || !PathUtils.isPathExist(regionsFilePath)) {
            return new ProfileRegionCache(Collections.unmodifiableMap(new LinkedHashMap()));
        }
        try {
            File file = new File(regionsFilePath).getCanonicalFile();
            if (!ProfileRegionCache.isValidRegionsFile(file)) {
                String message = String.format("Invalid regions file path: '%s'", regionsFilePath);
                logger.error(message);
                throw new SdkException(message);
            }
            Map<String, Region> result = ProfileRegionCache.resolveRegions(file.getCanonicalPath());
            return new ProfileRegionCache(Collections.unmodifiableMap(result));
        }
        catch (IOException e) {
            String message = String.format("Failed to resolve file '%s'", regionsFilePath);
            logger.error(message, (Throwable)e);
            throw new SdkException(message, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Region> resolveRegions(String filepath) {
        Map map;
        LinkedHashMap<String, Region> result;
        block27: {
            Yaml yaml;
            result = new LinkedHashMap<String, Region>();
            try {
                yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            }
            catch (NoClassDefFoundError | NoSuchMethodError ignore) {
                try {
                    yaml = (Yaml)Yaml.class.newInstance();
                    logger.warn("Initialize Yaml failed due to version conflict, use default construct to reinitialize. It is recommended that you use org.yaml:snakeyaml v2.0+ for better security and compatibility.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    String message222 = "Failed to initialize yaml loader.";
                    logger.error(message222, (Throwable)e);
                    throw new SdkException(message222, e);
                }
            }
            try (FileInputStream inputStream = new FileInputStream(filepath);){
                Object obj = yaml.load((InputStream)inputStream);
                if (obj instanceof Map) {
                    map = (Map)obj;
                    break block27;
                }
                LinkedHashMap<String, Region> linkedHashMap = result;
                return linkedHashMap;
            }
            catch (IOException e) {
                String message = String.format("Failed to resolve file '%s'", filepath);
                logger.error(message, (Throwable)e);
                throw new SdkException(message, e);
            }
        }
        for (Map.Entry next : map.entrySet()) {
            if (!(next.getValue() instanceof List)) continue;
            for (Object o : (List)next.getValue()) {
                if (!(o instanceof Map)) continue;
                try {
                    Map regionMap = (Map)o;
                    String id = (String)regionMap.get("id");
                    if (StringUtils.isEmpty(id)) continue;
                    String endpoint = (String)regionMap.get("endpoint");
                    ArrayList<String> endpoints = (ArrayList<String>)regionMap.get("endpoints");
                    if (Objects.isNull(endpoints)) {
                        endpoints = new ArrayList<String>();
                    }
                    if (!StringUtils.isEmpty(endpoint)) {
                        endpoints.add(endpoint);
                    }
                    if (endpoints.isEmpty()) continue;
                    Region region = new Region(id, endpoints.toArray(new String[0]));
                    result.put(next.getKey().toString().toUpperCase(Locale.ROOT) + id, region);
                }
                catch (ClassCastException e) {
                    String message = String.format("failed to resolve file '%s'", filepath);
                    logger.error(message, (Throwable)e);
                    throw new SdkException(message, e);
                }
            }
        }
        return result;
    }

    private static String getRegionsFilePath() {
        String regionsFile = System.getenv(REGIONS_FILE_ENV);
        if (!StringUtils.isEmpty(regionsFile)) {
            return regionsFile;
        }
        String userHomePath = PathUtils.getUserHomePath();
        return StringUtils.isEmpty(userHomePath) ? null : userHomePath + File.separator + ".huaweicloud" + File.separator + DEFAULT_REGIONS_FILE_NAME;
    }

    private static boolean isValidRegionsFile(File file) {
        if (!file.getName().matches(REGIONS_FILE_REG)) {
            return false;
        }
        return PathUtils.isValidFile(file);
    }
}

