/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.ActivityStats;
import com.jamonapi.FrequencyDist;
import com.jamonapi.FrequencyDistBase;
import com.jamonapi.Monitor;
import com.jamonapi.RangeHolder;
import com.jamonapi.RangeImp;

final class RangeBase
extends RangeImp {
    private static final long serialVersionUID = 278L;
    private double[] rangeValues;

    RangeBase(RangeHolder rangeHolder) {
        this.rangeHolder = rangeHolder;
        this.isLessThan = rangeHolder.isLessThan();
        this.rangeValues = rangeHolder.getEndPoints();
        int len = this.rangeValues.length;
        this.frequencyDist = new FrequencyDistBase[len + 1];
        for (int i = 0; i < len; ++i) {
            RangeHolder.RangeHolderItem item = rangeHolder.get(i);
            this.frequencyDist[i] = new FrequencyDistBase(item.getDisplayHeader(), item.getEndPoint(), this.getFreqDistName(i));
        }
        this.frequencyDist[len] = new FrequencyDistBase(this.getLastHeader(), Double.MAX_VALUE, this.getFreqDistName(len));
    }

    @Override
    public FrequencyDist getFrequencyDist(double value) {
        int last = this.frequencyDist.length - 1;
        if (this.isLessThan) {
            for (int i = 0; i < last; ++i) {
                if (!(value < this.rangeValues[i])) continue;
                return this.frequencyDist[i];
            }
        } else {
            for (int i = 0; i < last; ++i) {
                if (!(value <= this.rangeValues[i])) continue;
                return this.frequencyDist[i];
            }
        }
        return this.frequencyDist[last];
    }

    @Override
    public void add(double value) {
        this.getFrequencyDist(value).add(value);
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.frequencyDist.length; ++i) {
            this.frequencyDist[i].reset();
        }
    }

    @Override
    public RangeImp copy(ActivityStats activityStats) {
        RangeBase rb = new RangeBase(this.rangeHolder);
        rb.setActivityStats(activityStats);
        return rb;
    }

    private void setActivityStats(ActivityStats stats) {
        for (int i = 0; i < this.frequencyDist.length; ++i) {
            this.frequencyDist[i].setActivityStats(stats);
        }
    }

    @Override
    public void processEvent(Monitor mon) {
        double value = mon.getLastValue();
        this.getFrequencyDist(value).add(value);
    }

    @Override
    public String getName() {
        return "Range";
    }

    @Override
    public void setName(String name) {
    }
}

