/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.http;

import com.jamonapi.http.HttpMon;
import com.jamonapi.http.HttpMonFactory;
import com.jamonapi.http.HttpMonManage;
import com.jamonapi.http.JettyHttpMonFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.HandlerWrapper;

public class JAMonJettyHandler
extends HandlerWrapper
implements HttpMonManage {
    private static final String PREFIX = "com.jamonapi.http.JAMonJettyHandler";
    private static final String DEFAULT_SUMMARY = "default, response.getContentCount().bytes, response.getStatus().value.httpStatus, response.getStatus().summary.httpStatus";
    private HttpMonFactory httpMonFactory = new JettyHttpMonFactory("com.jamonapi.http.JAMonJettyHandler");
    private String jamonSummaryLabels = "default";

    public JAMonJettyHandler() {
        this.setSummaryLabels(this.jamonSummaryLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Response baseResponse = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
        HttpMon httpMon = null;
        try {
            httpMon = this.httpMonFactory.start(baseRequest, baseResponse);
            super.handle(target, request, response, dispatch);
        }
        catch (Throwable e) {
            httpMon.throwException(e);
        }
        finally {
            httpMon.stop();
        }
    }

    @Override
    public void setSummaryLabels(String jamonSummaryLabels) {
        this.httpMonFactory.setSummaryLabels(jamonSummaryLabels, DEFAULT_SUMMARY);
    }

    @Override
    public String getSummaryLabels() {
        return this.httpMonFactory.getSummaryLabels();
    }

    @Override
    public void addSummaryLabel(String jamonSummaryLabel) {
        this.httpMonFactory.addSummaryLabel(jamonSummaryLabel);
    }

    @Override
    public boolean getIgnoreHttpParams() {
        return this.httpMonFactory.getIgnoreHttpParams();
    }

    @Override
    public void setIgnoreHttpParams(boolean ignoreHttpParams) {
        this.httpMonFactory.setIgnoreHttpParams(ignoreHttpParams);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.httpMonFactory.setEnabled(enable);
    }

    @Override
    public int getSize() {
        return this.httpMonFactory.getSize();
    }

    @Override
    public boolean getEnabled() {
        return this.httpMonFactory.getEnabled();
    }

    @Override
    public void setSize(int size) {
        this.httpMonFactory.setSize(size);
    }
}

