/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.rs;

import com.qiniu.api.auth.DigestAuthClient;
import com.qiniu.api.auth.digest.Mac;
import com.qiniu.api.config.Config;
import com.qiniu.api.net.CallRet;
import com.qiniu.api.net.Client;
import com.qiniu.api.net.EncodeUtils;
import com.qiniu.api.rs.BatchCallRet;
import com.qiniu.api.rs.BatchStatRet;
import com.qiniu.api.rs.Entry;
import com.qiniu.api.rs.EntryPath;
import com.qiniu.api.rs.EntryPathPair;
import java.util.List;

public class RSClient {
    private Client conn;

    public RSClient(Mac mac) {
        this.conn = new DigestAuthClient(mac);
    }

    public Entry stat(String bucket, String key) {
        String entryURI = bucket + ":" + key;
        String url = Config.RS_HOST + "/stat/" + EncodeUtils.urlsafeEncode(entryURI);
        CallRet ret = this.conn.call(url);
        return new Entry(ret);
    }

    public CallRet delete(String bucket, String key) {
        String entryURI = bucket + ":" + key;
        String url = Config.RS_HOST + "/delete/" + EncodeUtils.urlsafeEncode(entryURI);
        CallRet ret = this.conn.call(url);
        return ret;
    }

    public CallRet move(String bucketSrc, String keySrc, String bucketDest, String keyDest) {
        String entryURISrc = bucketSrc + ":" + keySrc;
        String entryURIDest = bucketDest + ":" + keyDest;
        return this.execute("move", entryURISrc, entryURIDest);
    }

    public CallRet copy(String bucketSrc, String keySrc, String bucketDest, String keyDest) {
        String entryURISrc = bucketSrc + ":" + keySrc;
        String entryURIDest = bucketDest + ":" + keyDest;
        return this.execute("copy", entryURISrc, entryURIDest);
    }

    private CallRet execute(String cmd, String entryURISrc, String entryURIDest) {
        String encodedSrc = EncodeUtils.urlsafeEncode(entryURISrc);
        String encodedDest = EncodeUtils.urlsafeEncode(entryURIDest);
        String url = Config.RS_HOST + "/" + cmd + "/" + encodedSrc + "/" + encodedDest;
        CallRet callRet = this.conn.call(url);
        return callRet;
    }

    public BatchStatRet batchStat(List<EntryPath> entries) {
        BatchCallRet ret = this.batchOp("stat", entries);
        return new BatchStatRet(ret);
    }

    public BatchCallRet batchDelete(List<EntryPath> entries) {
        BatchCallRet ret = this.batchOp("delete", entries);
        return ret;
    }

    private BatchCallRet batchOp(String cmd, List<EntryPath> entries) {
        StringBuilder sbuf = new StringBuilder();
        for (EntryPath entryPath : entries) {
            String entryURI = entryPath.bucket + ":" + entryPath.key;
            String encodedEntryURI = EncodeUtils.urlsafeEncode(entryURI);
            sbuf.append("op=/").append(cmd).append("/").append(encodedEntryURI).append("&");
        }
        return this.batchCall(sbuf);
    }

    private BatchCallRet batchCall(StringBuilder body) {
        body.deleteCharAt(body.length() - 1);
        String url = Config.RS_HOST + "/batch";
        CallRet callRet = this.conn.callWithBinary(url, "application/x-www-form-urlencoded", body.toString().getBytes());
        return new BatchCallRet(callRet);
    }

    public BatchCallRet batchMove(List<EntryPathPair> entries) {
        BatchCallRet ret = this.batchOpPairs("move", entries);
        return ret;
    }

    public BatchCallRet batchCopy(List<EntryPathPair> entries) {
        BatchCallRet ret = this.batchOpPairs("copy", entries);
        return ret;
    }

    private BatchCallRet batchOpPairs(String cmd, List<EntryPathPair> entries) {
        StringBuilder sbuf = new StringBuilder();
        for (EntryPathPair e : entries) {
            String entryURISrc = e.src.bucket + ":" + e.src.key;
            String entryURIDest = e.dest.bucket + ":" + e.dest.key;
            String encodedEntryURISrc = EncodeUtils.urlsafeEncode(entryURISrc);
            String encodedEntryURIDest = EncodeUtils.urlsafeEncode(entryURIDest);
            sbuf.append("op=/").append(cmd).append("/").append(encodedEntryURISrc).append("/").append(encodedEntryURIDest).append("&");
        }
        return this.batchCall(sbuf);
    }
}

