/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Dns;
import com.qiniu.http.ProxyConfiguration;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Region;

public final class Configuration
implements Cloneable {
    public static String defaultRsHost = "rs.qiniu.com";
    public static String defaultApiHost = "api.qiniu.com";
    public static String defaultUcHost = "uc.qbox.me";
    public Region region;
    @Deprecated
    public Zone zone;
    public boolean useHttpsDomains = true;
    public boolean accUpHostFirst = true;
    public boolean useDefaultUpHostIfNone = true;
    public int putThreshold = 0x400000;
    public int connectTimeout = 10;
    public int writeTimeout = 0;
    public int readTimeout = 30;
    public int dispatcherMaxRequests = 64;
    public int dispatcherMaxRequestsPerHost = 16;
    public int connectionPoolMaxIdleCount = 32;
    public int connectionPoolMaxIdleMinutes = 5;
    public int retryMax = 5;
    public Dns dns;
    @Deprecated
    public boolean useDnsHostFirst;
    public ProxyConfiguration proxy;
    private ConfigHelper configHelper;

    public Configuration() {
        this.configHelper = new ConfigHelper(this);
    }

    public Configuration(Region region) {
        this.region = region;
        this.configHelper = new ConfigHelper(this);
    }

    @Deprecated
    public Configuration(Zone zone) {
        this.zone = zone;
        this.configHelper = new ConfigHelper(this);
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public String upHost(String upToken) throws QiniuException {
        return this.configHelper.upHost(upToken);
    }

    @Deprecated
    public String upHostBackup(String upToken) throws QiniuException {
        return this.configHelper.tryChangeUpHost(upToken, null);
    }

    @Deprecated
    public String ioHost(String ak, String bucket) {
        try {
            return this.configHelper.ioHost(ak, bucket);
        }
        catch (QiniuException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String apiHost(String ak, String bucket) {
        try {
            return this.configHelper.apiHost(ak, bucket);
        }
        catch (QiniuException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String rsHost(String ak, String bucket) {
        try {
            return this.configHelper.rsHost(ak, bucket);
        }
        catch (QiniuException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String rsfHost(String ak, String bucket) {
        try {
            return this.configHelper.rsfHost(ak, bucket);
        }
        catch (QiniuException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String rsHost() {
        return this.configHelper.rsHost();
    }

    @Deprecated
    public String apiHost() {
        return this.configHelper.apiHost();
    }

    @Deprecated
    public String ucHost() {
        return this.configHelper.ucHost();
    }
}

