/*
 * Decompiled with CFR 0.152.
 */
package com.tikinou.schedulesdirect.core;

import com.tikinou.schedulesdirect.core.Command;
import com.tikinou.schedulesdirect.core.SchedulesDirectClient;
import com.tikinou.schedulesdirect.core.commands.randhash.RandHashCommand;
import com.tikinou.schedulesdirect.core.commands.randhash.RandHashParameters;
import com.tikinou.schedulesdirect.core.commands.randhash.RandHashResult;
import com.tikinou.schedulesdirect.core.domain.CommandStatus;
import com.tikinou.schedulesdirect.core.domain.Credentials;
import com.tikinou.schedulesdirect.core.domain.SchedulesDirectApiVersion;
import com.tikinou.schedulesdirect.core.exceptions.AuthenticationException;
import com.tikinou.schedulesdirect.core.exceptions.VersionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchedulesDirectClient
implements SchedulesDirectClient {
    private static final String DEFAUlT_BASE_URL = "https://data2.schedulesdirect.org/";
    private static final String DEFAUlT_BETA_BASE_URL = "http://23.21.174.111/";
    private static final String DEFAULT_ENDPOINT = "handleRequest.php";
    private static final Logger LOG = LoggerFactory.getLogger(SchedulesDirectClient.class);
    private SchedulesDirectApiVersion apiVersion;
    private Credentials credentials;
    private String baseUrl;
    private String endPoint;
    private boolean useBetaService;

    @Override
    public void setup(SchedulesDirectApiVersion apiVersion, boolean useBetaService) throws VersionNotSupportedException {
        if (apiVersion == null) {
            throw new VersionNotSupportedException();
        }
        this.apiVersion = apiVersion;
        this.useBetaService = useBetaService;
        this.baseUrl = useBetaService ? DEFAUlT_BETA_BASE_URL : DEFAUlT_BASE_URL;
        this.endPoint = DEFAULT_ENDPOINT;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting up with API version: " + (Object)((Object)apiVersion) + ", baseUrl: '" + this.baseUrl + "', endPoint: " + this.endPoint);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getBaseUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl;
        }
        if (this.useBetaService) {
            return DEFAUlT_BETA_BASE_URL;
        }
        return DEFAUlT_BASE_URL;
    }

    @Override
    public String getEndpoint() {
        if (this.endPoint != null) {
            return this.endPoint;
        }
        return DEFAULT_ENDPOINT;
    }

    @Override
    public String getUrl() {
        StringBuilder builder = new StringBuilder(this.getBaseUrl());
        builder.append(this.getEndpoint());
        return builder.toString();
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void connect(Credentials credentials) throws AuthenticationException {
        this.connect(credentials, null, null, false);
    }

    @Override
    public void connect(Credentials credentials, boolean forceConnect) throws AuthenticationException {
        this.connect(credentials, null, null, forceConnect);
    }

    @Override
    public void connect(Credentials credentials, String baseUrl, boolean forceConnect) throws AuthenticationException {
        this.connect(credentials, baseUrl, null, forceConnect);
    }

    @Override
    public void connect(Credentials credentials, String baseUrl, String endPoint, boolean forceConnect) throws AuthenticationException {
        if (credentials == null) {
            throw new AuthenticationException("credentials object cannot be null");
        }
        if (endPoint != null) {
            this.endPoint = endPoint;
        }
        if (baseUrl != null) {
            String string = this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting with credentials:" + credentials.toString() + " forceConnect: " + forceConnect + ", baseUrl: '" + baseUrl + "', endPoint: " + endPoint);
        }
        if (!forceConnect) {
            if (this.credentials != null) {
                if (this.credentials.sameUserNamePassword(credentials) && !this.credentials.isOlderThan(12)) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("credentials less than 12 hours. No need to get a new randhash");
                    }
                    return;
                }
            } else if (!credentials.isOlderThan(12)) {
                this.credentials = credentials;
                return;
            }
        }
        this.credentials = credentials;
        assert (this.credentials.getUsername() != null);
        assert (this.credentials.getPassword() != null);
        RandHashCommand cmd = this.createCommand(RandHashCommand.class);
        cmd.setParameters(new RandHashParameters(credentials, this.apiVersion));
        this.execute(cmd);
        if (cmd.getStatus() != CommandStatus.SUCCESS) {
            throw new AuthenticationException("Could not login to schedules direct", ((RandHashResult)cmd.getResults()).getCode());
        }
    }

    @Override
    public void execute(Command command) {
        command.execute(this);
    }
}

