/*
 * Decompiled with CFR 0.152.
 */
package com.tikinou.schedulesdirect.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Credentials {
    private String username;
    private String password;
    private String randhash;
    private DateTime randhashDateTime;
    @JsonIgnore
    private String clearPassword;

    public Credentials() {
    }

    public Credentials(String username, String password) {
        this(username, password, null, null);
    }

    public Credentials(String username, String password, String randhash, DateTime randhashDateTime) {
        this.username = username;
        this.clearPassword = password;
        this.randhash = randhash;
        this.randhashDateTime = randhashDateTime;
        if (this.clearPassword != null) {
            this.password = DigestUtils.sha1Hex((String)this.clearPassword);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRandhash() {
        return this.randhash;
    }

    public void setRandhash(String randhash) {
        this.randhash = randhash;
    }

    public DateTime getRandhashDateTime() {
        return this.randhashDateTime;
    }

    public void setRandhashDateTime(DateTime randhashDateTime) {
        this.randhashDateTime = randhashDateTime;
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public void setClearPassword(String clearPassword) {
        this.clearPassword = clearPassword;
        if (clearPassword != null) {
            this.password = DigestUtils.sha1Hex((String)clearPassword);
        }
    }

    public boolean sameUserNamePassword(Credentials credentials) {
        if (credentials == null) {
            return false;
        }
        if (this.username == null) {
            return false;
        }
        if (this.clearPassword == null) {
            return false;
        }
        return this.username.equals(credentials.username) && this.clearPassword.equals(credentials.clearPassword);
    }

    public boolean isOlderThan(int hours) {
        if (this.randhash == null || this.randhashDateTime == null) {
            return true;
        }
        return this.randhashDateTime.isBefore((ReadableInstant)DateTime.now().minusHours(hours));
    }

    public String toString() {
        return "Credentials{username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", randhash='" + this.randhash + '\'' + ", randhashDateTime=" + this.randhashDateTime + ", clearPassword='" + this.clearPassword + '\'' + '}';
    }
}

